/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.FragmentCanvas;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;

public class FragmentEditorPanel
extends JPanel
implements ActionListener,
BaseDocument.DocumentChangeListener,
FragmentCanvas.SelectionChangeListener,
GlycanWorkspace.Listener {
    private static final long serialVersionUID = 0L;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = new GlycanWorkspace((GlycanRenderer)new GlycanRendererAWT());
    protected GlycanDocument theDocument = this.theWorkspace.getStructures();
    protected FragmentCanvas theCanvas;
    protected JToolBar theToolBar;
    protected int current_ind;
    protected Glycan current_structure;
    protected ActionManager theActionManager;

    public FragmentEditorPanel() {
        super(new BorderLayout());
        this.theDocument.addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.theActionManager = new ActionManager();
        this.createActions();
        this.current_ind = 0;
        this.current_structure = null;
        this.theCanvas = new FragmentCanvas();
        this.theCanvas.setGlycanRenderer(this.theWorkspace.getGlycanRenderer());
        JScrollPane sp = new JScrollPane(this.theCanvas);
        this.theCanvas.setScrollPane(sp);
        this.add((Component)sp, "Center");
        this.theToolBar = this.createToolBar();
        this.add((Component)this.theToolBar, "South");
        this.theWorkspace.addDocumentChangeListener(this);
        this.theCanvas.addSelectionChangeListener(this);
        this.setMinimumSize(new Dimension(0, 0));
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.updateActions();
        this.updateView();
    }

    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theWorkspace.addWorkspaceListener(this);
        this.theWorkspace.addDocumentChangeListener(this);
        this.theCanvas.setGlycanRenderer(this.theWorkspace.getGlycanRenderer());
        this.setDocument(workspace.getStructures());
    }

    private void setDocument(GlycanDocument document) {
        this.theDocument.removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.theDocument = document;
        this.theDocument.addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.current_ind = 0;
        this.updateActions();
        this.updateStructure();
        this.updateView();
    }

    private void createActions() {
        this.theActionManager.add("previous", FileUtils.defaultThemeManager.getImageIcon("previous"), "Previous structure", 76, "", (ActionListener)this);
        this.theActionManager.add("next", FileUtils.defaultThemeManager.getImageIcon("next"), "Next structure", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy fragments into canvas", 86, "", (ActionListener)this);
    }

    private void updateActions() {
        this.theActionManager.get("previous").setEnabled(this.current_ind > 0);
        this.theActionManager.get("next").setEnabled(this.current_ind < this.theDocument.getNoStructures() - 1);
        boolean has_selection = this.theCanvas.hasSelection();
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("previous"));
        toolbar.add((Action)this.theActionManager.get("next"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        return toolbar;
    }

    public boolean setStructure(Glycan structure) {
        int ind = this.theDocument.indexOf(structure);
        if (ind != -1) {
            this.current_ind = ind;
            this.updateStructure();
            this.updateActions();
            return true;
        }
        return false;
    }

    public boolean setStructure(Glycan structure, Residue frag_at) {
        int ind = this.theDocument.indexOf(structure);
        if (ind != -1) {
            this.current_ind = ind;
            this.updateStructure(frag_at);
            this.updateActions();
            return true;
        }
        return false;
    }

    public boolean setStructure(Glycan structure, Linkage frag_at) {
        int ind = this.theDocument.indexOf(structure);
        if (ind != -1) {
            this.current_ind = ind;
            this.updateStructure(frag_at);
            this.updateActions();
            return true;
        }
        return false;
    }

    private void updateStructure() {
        this.current_structure = this.theDocument.getNoStructures() == 0 ? null : this.theDocument.getStructure(this.current_ind).clone();
        this.theCanvas.setStructure(this.current_structure);
    }

    private void updateStructure(Residue frag_at) {
        this.current_structure = this.theDocument.getNoStructures() == 0 ? null : this.theDocument.getStructure(this.current_ind).clone();
        this.theCanvas.setStructure(this.current_structure, frag_at);
    }

    private void updateStructure(Linkage frag_at) {
        this.current_structure = this.theDocument.getNoStructures() == 0 ? null : this.theDocument.getStructure(this.current_ind).clone();
        this.theCanvas.setStructure(this.current_structure, frag_at);
    }

    public void updateView() {
        this.theCanvas.repaint();
    }

    public void showPrevious() {
        if (!this.theDocument.isEmpty() && this.current_ind > 0) {
            --this.current_ind;
            this.updateStructure();
        }
    }

    public void showNext() {
        if (!this.theDocument.isEmpty() && this.current_ind < this.theDocument.getNoStructures() - 1) {
            ++this.current_ind;
            this.updateStructure();
        }
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theApplication.getWorkspace().getPrinterJob();
            if (pj != null) {
                pj.setPrintable(this.theCanvas);
                if (pj.printDialog()) {
                    this.theCanvas.print(pj);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void copy() {
        ClipUtils.setContents((Transferable)new GlycanSelection((GlycanRenderer)((GlycanRendererAWT)this.theWorkspace.getGlycanRenderer()), this.theCanvas.getSelectedFragments()));
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("previous")) {
            this.showPrevious();
        } else if (action.equals("next")) {
            this.showNext();
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("transfer")) {
            this.transfer();
        }
        this.updateActions();
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theWorkspace) {
            this.setDocument(this.theWorkspace.getStructures());
        } else {
            this.documentChanged(e);
        }
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (this.current_ind >= this.theDocument.getNoStructures()) {
            this.current_ind = 0;
            this.updateStructure();
        } else if (!this.theDocument.getStructure(this.current_ind).equalsStructure(this.current_structure)) {
            this.updateStructure();
        } else if (!this.theDocument.getStructure(this.current_ind).getMassOptions().equals((Object)this.current_structure.getMassOptions())) {
            this.updateStructure();
        }
        this.updateActions();
    }

    @Override
    public void selectionChanged(FragmentCanvas.SelectionChangeEvent e) {
        this.updateActions();
    }

    @Override
    public void internalDocumentChanged(GlycanWorkspace.Event e) {
    }

    @Override
    public void currentScanChanged(GlycanWorkspace.Event e) {
        this.setDocument(this.theWorkspace.getStructures());
    }

    @Override
    public void scanAdded(GlycanWorkspace.Event e) {
    }

    @Override
    public void scanRemoved(GlycanWorkspace.Event e) {
    }
}

