/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.AnnotationSelection;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class FragmentSummaryPanel
extends SortingTablePanel<FragmentDocument>
implements ActionListener,
FragmentDocument.StructuresChangeListener {
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected boolean update_header = false;

    @Override
    protected void initComponents() {
        super.initComponents();
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
    }

    @Override
    protected FragmentDocument getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getFragments() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((FragmentDocument)this.theDocument).removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            ((FragmentDocument)this.theDocument).removeStructuresChangeListener((FragmentDocument.StructuresChangeListener)this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new FragmentDocument();
        }
        ((FragmentDocument)this.theDocument).addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        ((FragmentDocument)this.theDocument).addStructuresChangeListener((FragmentDocument.StructuresChangeListener)this);
        this.update_header = true;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear all", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", -1, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", -1, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy fragments into canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected annotations", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all annotations", -1, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("save").setEnabled(((FragmentDocument)this.theDocument).hasChanged());
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("transfer"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Double.class;
        }
        return Vector.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Mass to\ncharge";
        }
        return "Structure" + (columnIndex - 1);
    }

    @Override
    public int getColumnCount() {
        return 1 + ((FragmentDocument)this.theDocument).getNoStructures();
    }

    @Override
    public int getRowCount() {
        return ((FragmentDocument)this.theDocument).getNoPeaks();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ((FragmentDocument)this.theDocument).getFragmentMZ(rowIndex);
        }
        return ((FragmentDocument)this.theDocument).getFragments(rowIndex, columnIndex - 1);
    }

    public void clear() {
        ((FragmentDocument)this.theDocument).init();
    }

    @Override
    public void updateView() {
        if (this.update_header) {
            this.fireTableStructureChanged();
            for (int i = 0; i < ((FragmentDocument)this.theDocument).getNoStructures(); ++i) {
                this.theTable.getColumn("Structure" + i).setHeaderValue(((FragmentDocument)this.theDocument).getStructure(i));
            }
            this.update_header = false;
        }
        super.updateView();
    }

    public void onNew() {
        this.clear();
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob());
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        if (((FragmentDocument)this.theDocument).getNoStructures() > 0) {
            int[] sel_inds = this.theTable.getSelectedRows();
            ((FragmentDocument)this.theDocument).clearFragmentsFor(this.theTableSorter.modelIndexes(sel_inds));
            this.fireRowsChanged(sel_inds);
        }
    }

    public void copy() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds.length > 0) {
            Collection cv;
            Object v;
            int focusRow = this.theTable.getSelectionModel().getLeadSelectionIndex();
            int focusColumn = this.theTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            Collection structures = null;
            if (focusRow != -1 && focusColumn != -1 && (v = this.getValueAt(focusRow, focusColumn)) instanceof Collection && (cv = (Collection)v).size() > 0 && cv.iterator().next() instanceof Glycan) {
                structures = cv;
            }
            ClipUtils.setContents((Transferable)((Object)new AnnotationSelection(this.theTable.getSelectedData(), (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures)));
        }
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("delete")) {
            this.cut();
        } else if (action.equals("transfer")) {
            this.transfer();
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        }
        this.updateActions();
    }

    public void structuresChanged(FragmentDocument.StructuresChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            this.updateDocument();
        }
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            super.documentInit(e);
        }
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            this.update_header = true;
            super.documentChanged(e);
        }
    }

    @Override
    protected void updateData() {
    }
}

