/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.Data;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class PeakListPanel
extends SortingTablePanel<PeakList>
implements ActionListener {
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected String shown_mslevel = "msms";
    protected JButton mslevel_button;
    protected GlycanAction ms_action = null;
    protected GlycanAction msms_action = null;
    Double edit_mz = null;
    Double edit_int = null;

    @Override
    protected void initComponents() {
        super.initComponents();
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
        this.theTableSorter.setFixLast(true);
    }

    @Override
    public PeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((PeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new PeakList();
        }
        ((PeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("mslevel=ms", FileUtils.defaultThemeManager.getImageIcon("msms"), "Change current scan level", -1, "", (ActionListener)this);
        this.theActionManager.add("mslevel=msms", FileUtils.defaultThemeManager.getImageIcon("ms"), "Change current scan level", -1, "", (ActionListener)this);
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("undo", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.UNDO, Plugin.DEFAULT_ICON_SIZE), "Undo", 85, "", (ActionListener)this);
        this.theActionManager.add("redo", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REDO, Plugin.DEFAULT_ICON_SIZE), "Redo", 82, "", (ActionListener)this);
        this.theActionManager.add("add", FileUtils.defaultThemeManager.getImageIcon("add"), "Add peak", 68, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", 84, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("paste", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.PASTE, Plugin.DEFAULT_ICON_SIZE), "Paste", 80, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", 127, "", (ActionListener)this);
        this.theActionManager.add("selectall", FileUtils.defaultThemeManager.getImageIcon("selectall"), "Select all", 65, "", (ActionListener)this);
        this.theActionManager.add("annotatepeaks", FileUtils.defaultThemeManager.getImageIcon("annotatepeaks"), "Find possible annotations for selected peaks", -1, "", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected peaks", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all peaks", -1, "", (ActionListener)this);
    }

    private void updatePeakActions() {
        if (this.theApplication != null && this.theApplication.getPluginManager() != null) {
            if (this.ms_action == null && this.theApplication.getPluginManager().getMsPeakActions().size() > 0) {
                this.ms_action = this.theApplication.getPluginManager().getMsPeakActions().iterator().next();
            }
            if (this.msms_action == null && this.theApplication.getPluginManager().getMsMsPeakActions().size() > 0) {
                this.msms_action = this.theApplication.getPluginManager().getMsMsPeakActions().iterator().next();
            }
        }
    }

    @Override
    protected void updateActions() {
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("save").setEnabled(((PeakList)((Object)this.theDocument)).hasChanged());
        this.theActionManager.get("undo").setEnabled(((PeakList)((Object)this.theDocument)).getUndoManager().canUndo());
        this.theActionManager.get("redo").setEnabled(((PeakList)((Object)this.theDocument)).getUndoManager().canRedo());
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("annotatepeaks").setEnabled(has_selection);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
        this.updateMsLevel();
    }

    public void updateMsLevel() {
        if (this.theWorkspace.getCurrentScan() != null) {
            this.onSetMsLevel(this.theWorkspace.getCurrentScan().isMsMs() ? "msms" : "ms", false);
        } else {
            this.onSetMsLevel("msms", false);
        }
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("undo"));
        toolbar.add((Action)this.theActionManager.get("redo"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("add"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("paste"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.addSeparator();
        this.mslevel_button = new JButton((Action)this.theActionManager.get("mslevel=msms"));
        toolbar.add(this.mslevel_button);
        this.mslevel_button.setText(null);
        toolbar.add((Action)this.theActionManager.get("annotatepeaks"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        this.updatePeakActions();
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("paste"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("add"));
        if (this.theApplication != null && this.theApplication.getPluginManager() != null) {
            ButtonGroup group = new ButtonGroup();
            if (this.shown_mslevel.equals("ms")) {
                for (GlycanAction a : this.theApplication.getPluginManager().getMsPeakActions()) {
                    JRadioButtonMenuItem last = new JRadioButtonMenuItem((Action)new GlycanAction(a, "annotatepeaks", -1, "", (ActionListener)this));
                    menu.add(last);
                    last.setSelected(a == this.ms_action);
                    group.add(last);
                }
            } else {
                for (GlycanAction a : this.theApplication.getPluginManager().getMsMsPeakActions()) {
                    JRadioButtonMenuItem last = new JRadioButtonMenuItem((Action)new GlycanAction(a, "annotatepeaks", -1, "", (ActionListener)this));
                    menu.add(last);
                    last.setSelected(a == this.msms_action);
                    group.add(last);
                }
            }
        }
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Double.class;
        }
        if (columnIndex == 1) {
            return Double.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Mass to\ncharge";
        }
        if (columnIndex == 1) {
            return "Intensity";
        }
        if (columnIndex == 2) {
            return "Relative\nIntensity";
        }
        if (columnIndex == 3) {
            return "Charge";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return ((PeakList)((Object)this.theDocument)).size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == ((PeakList)((Object)this.theDocument)).size()) {
            if (columnIndex == 0) {
                return this.edit_mz;
            }
            if (columnIndex == 1) {
                return this.edit_int;
            }
            if (columnIndex == 2) {
                return null;
            }
            if (columnIndex == 3) {
                return null;
            }
        } else {
            if (columnIndex == 0) {
                return ((PeakList)((Object)this.theDocument)).getMZ(rowIndex);
            }
            if (columnIndex == 1) {
                return ((PeakList)((Object)this.theDocument)).getIntensity(rowIndex);
            }
            if (columnIndex == 2) {
                return ((PeakList)((Object)this.theDocument)).getRelativeIntensity(rowIndex);
            }
            if (columnIndex == 3) {
                if (((PeakList)((Object)this.theDocument)).getPeak(rowIndex).getCharge() == Integer.MIN_VALUE) {
                    return "";
                }
                return ((PeakList)((Object)this.theDocument)).getPeak(rowIndex).getCharge();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 2;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex == ((PeakList)((Object)this.theDocument)).size()) {
            if (columnIndex == 0) {
                this.edit_mz = (Double)aValue;
            } else if (columnIndex == 1) {
                this.edit_int = (Double)aValue;
            }
            if (this.edit_mz != null && this.edit_int != null) {
                int ind = ((PeakList)((Object)this.theDocument)).put(this.edit_mz, this.edit_int);
                int new_ind = this.theTableSorter.viewIndex(ind);
                this.theTable.setRowSelectionInterval(new_ind, new_ind);
                this.edit_int = null;
                this.edit_mz = null;
            }
        } else {
            this.edit_int = null;
            this.edit_mz = null;
            if (columnIndex == 0) {
                ((PeakList)((Object)this.theDocument)).setMZ(rowIndex, (Double)aValue);
            } else if (columnIndex == 1) {
                ((PeakList)((Object)this.theDocument)).setIntensity(rowIndex, (Double)aValue);
            } else if (columnIndex == 3) {
                if (aValue == null || aValue.equals("")) {
                    aValue = Integer.MIN_VALUE;
                }
                if (aValue instanceof String) {
                    ((PeakList)((Object)this.theDocument)).setCharge(rowIndex, Integer.valueOf((String)aValue));
                } else {
                    ((PeakList)((Object)this.theDocument)).setCharge(rowIndex, (Integer)aValue);
                }
            }
        }
    }

    public boolean checkDocumentChanges() {
        if (((PeakList)((Object)this.theDocument)).hasChanged() && !((PeakList)((Object)this.theDocument)).isEmpty()) {
            int ret = JOptionPane.showConfirmDialog(this, "Save changes to peak list?", null, 1, 3);
            if (ret == 2) {
                return false;
            }
            if (ret == 0 && !this.theApplication.onSaveAs((BaseDocument)this.theDocument)) {
                return false;
            }
        }
        return true;
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob());
    }

    public void onUndo() {
        try {
            ((PeakList)((Object)this.theDocument)).getUndoManager().undo();
            this.edit_int = null;
            this.edit_mz = null;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onRedo() {
        try {
            ((PeakList)((Object)this.theDocument)).getUndoManager().redo();
            this.edit_int = null;
            this.edit_mz = null;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onAdd() {
        this.edit_int = null;
        this.edit_mz = null;
        ((PeakList)((Object)this.theDocument)).put(0.0, 0.0);
        this.theTable.setRowSelectionInterval(0, 0);
        this.theTable.changeSelection(0, 0, false, true);
        this.theTable.grabFocus();
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void copy() {
        Data rows = new Data();
        int[] sel_ind = this.theTable.getSelectedRows();
        if (sel_ind.length > 0) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                rows.add((Object)this.getColumnName(c));
            }
            rows.newRow();
            for (int i = 0; i < sel_ind.length; ++i) {
                if (sel_ind[i] == this.theTable.getRowCount() - 1) continue;
                int r = this.theTableSorter.modelIndex(sel_ind[i]);
                for (int c = 0; c < this.getColumnCount(); ++c) {
                    Object value = this.getValueAt(r, c);
                    if (value instanceof String) {
                        value = Integer.MIN_VALUE;
                    }
                    rows.add(value);
                }
                rows.newRow();
            }
            ClipUtils.setContents((Transferable)new GlycanSelection(rows));
        }
    }

    public void paste() {
        Transferable t = ClipUtils.getContents();
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                ((PeakList)((Object)this.theDocument)).mergeData(PeakList.parseString(str));
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void delete() {
        int[] sel_ind = this.theTable.getSelectedRows();
        ((PeakList)((Object)this.theDocument)).remove(this.theTableSorter.modelIndexes(sel_ind));
    }

    public void onSetMsLevel(String mslevel, boolean changedoc) {
        this.shown_mslevel = mslevel;
        if (mslevel.equals("ms")) {
            this.mslevel_button.setAction((Action)this.theActionManager.get("mslevel=msms"));
            this.mslevel_button.setText(null);
            if (changedoc) {
                this.theWorkspace.setMsMs(this.theWorkspace.getCurrentScan(), false);
            }
        } else {
            this.mslevel_button.setAction((Action)this.theActionManager.get("mslevel=ms"));
            this.mslevel_button.setText(null);
            if (changedoc) {
                this.theWorkspace.setMsMs(this.theWorkspace.getCurrentScan(), true);
            }
        }
        this.theTable.setPopupMenu(this.createPopupMenu());
    }

    public boolean onAnnotatePeaks(String parent_action) {
        try {
            int[] sel_inds = this.theTable.getSelectedRows();
            if (sel_inds.length > 0) {
                int[] model_inds = this.theTableSorter.modelIndexes(sel_inds);
                Collection<Peak> selected_peaks = ((PeakList)((Object)this.theDocument)).extract(model_inds);
                if (this.shown_mslevel.equals("ms")) {
                    if (parent_action != null) {
                        this.ms_action = this.theApplication.getPluginManager().getMsPeakAction(parent_action);
                    }
                    return this.theApplication.getPluginManager().runAction(this.ms_action, (Object)new PeakList(selected_peaks));
                }
                if (parent_action != null) {
                    this.msms_action = this.theApplication.getPluginManager().getMsMsPeakAction(parent_action);
                }
                return this.theApplication.getPluginManager().runAction(this.msms_action, (Object)new PeakList(selected_peaks));
            }
            return false;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            System.err.println("Trace one");
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, true, true);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("undo")) {
            this.onUndo();
        } else if (action.equals("redo")) {
            this.onRedo();
        } else if (action.equals("add")) {
            this.onAdd();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("paste")) {
            this.paste();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("mslevel")) {
            this.onSetMsLevel(param, true);
        } else if (action.equals("annotatepeaks")) {
            this.onAnnotatePeaks(param);
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        }
        this.updateActions();
    }

    @Override
    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (!this.ignore_document_changes) {
            if (e.getSource() == this.theWorkspace) {
                this.updateWorkspace();
            } else {
                this.theTable.setPopupMenu(this.createPopupMenu());
                this.edit_int = null;
                this.edit_mz = null;
                this.updateDocument();
            }
        }
    }

    @Override
    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.updateActions();
        this.updateView();
    }

    @Override
    protected void updateData() {
    }

    @Override
    public void internalDocumentChanged(GlycanWorkspace.Event e) {
        this.updateMsLevel();
    }
}

