/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.grammar;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.Constraint;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule
implements Comparable {
    private Vector<String> children = new Vector();
    private Constraint root_constraint = null;

    public int compareTo(Object o) {
        return this.toString().compareTo("" + o);
    }

    public static Rule createRule(GrammarTree current, GrammarOptions opt) {
        if (current == null || current.getNoChildren() == 0 || current.hasChildrenTagged()) {
            return null;
        }
        Rule created = new Rule();
        for (GrammarTree child : current.getChildren()) {
            created.children.add(child.getLabel());
        }
        created.root_constraint = Constraint.createConstraint(current, opt);
        return created;
    }

    public GrammarTree generateStructure(GrammarTree current, GrammarOptions opt) {
        if (current != null && current.getNoChildren() != 0) {
            return null;
        }
        if (current == null) {
            current = new GrammarTree("+");
        }
        if (this.root_constraint != null && this.root_constraint.matches(current, opt)) {
            GrammarTree leaf = new GrammarTree(current.getLabel());
            for (String str_child : this.children) {
                leaf.addChild(new GrammarTree(str_child));
            }
            return current.getRoot().clone(current, leaf);
        }
        return null;
    }

    public String leftSide() {
        return this.root_constraint.toString();
    }

    public String rightSide() {
        return TextUtils.toString(this.children, (char)',');
    }

    public String toString() {
        String ret = "";
        ret = this.root_constraint != null ? ret + this.root_constraint.toString() : ret + "*";
        ret = ret + "->" + TextUtils.toString(this.children, (char)',');
        return ret;
    }

    public static Rule fromXML(Node r_node) throws Exception {
        Rule ret = new Rule();
        Vector child_nodes = XMLUtils.findAllChildren((Node)r_node, (String)"Child");
        for (Node c_node : child_nodes) {
            String type = XMLUtils.getAttribute((Node)c_node, (String)"type");
            if (type == null) continue;
            ret.children.add(type);
        }
        Node rc_node = XMLUtils.findChild((Node)r_node, (String)"Constraint");
        if (rc_node != null) {
            ret.root_constraint = Constraint.fromXML(rc_node);
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element r_node = document.createElement("Rule");
        for (String c : this.children) {
            Element c_node = document.createElement("Child");
            c_node.setAttribute("type", c);
            r_node.appendChild(c_node);
        }
        if (this.root_constraint != null) {
            r_node.appendChild(this.root_constraint.toXML(document));
        }
        return r_node;
    }
}

