/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;

public class StructureSelectorDialog
extends EscapeDialog
implements ListSelectionListener,
ActionListener {
    private GlycanRenderer theGlycanRenderer;
    private JList theSelector;
    private JLabel theMessage;
    private JButton ok_button;
    private JButton cancel_button;

    public StructureSelectorDialog(JFrame parent, String title, String message, Vector<Glycan> structures, boolean multiple_sel, GlycanRenderer gr) {
        super((Frame)parent, title, true);
        this.theGlycanRenderer = gr;
        this.getContentPane().setLayout(new BorderLayout());
        this.theMessage = new JLabel(message);
        this.theMessage.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.theMessage, "North");
        this.theSelector = this.createStructureSelector(structures, multiple_sel);
        this.theSelector.setBorder(new BevelBorder(1));
        this.getContentPane().add((Component)new JScrollPane(this.theSelector), "Center");
        JPanel buttons_panel = new JPanel(new FlowLayout());
        this.ok_button = new JButton((Action)new GlycanAction("OK", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "OK", -1, "", (ActionListener)this));
        this.cancel_button = new JButton((Action)new GlycanAction("Cancel", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Cancel", -1, "", (ActionListener)this));
        buttons_panel.add(this.ok_button);
        buttons_panel.add(this.cancel_button);
        this.getContentPane().add((Component)buttons_panel, "South");
        this.getRootPane().setDefaultButton(this.ok_button);
        this.theSelector.addListSelectionListener(this);
        this.updateActions();
        this.setSize(new Dimension(400, 300));
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private JList createStructureSelector(Vector<Glycan> structures, boolean multiple_sel) {
        JList<Object> ret = new JList<Object>();
        ret.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Glycan s = (Glycan)value;
                if (s == null) {
                    this.setIcon(null);
                    this.setText("null");
                } else if (s.isEmpty()) {
                    this.setIcon(null);
                    this.setText("profile " + (index + 1));
                } else {
                    this.setIcon(new ImageIcon(StructureSelectorDialog.this.theGlycanRenderer.getImage((Glycan)value, false, false, true, 0.333)));
                    this.setText("");
                }
                return this;
            }
        });
        if (multiple_sel) {
            ret.setSelectionMode(2);
        } else {
            ret.setSelectionMode(0);
        }
        ret.setListData(structures);
        if (structures.size() > 0) {
            ret.setSelectedIndex(0);
        }
        return ret;
    }

    public boolean isCanceled() {
        return this.return_status.equals("Cancel");
    }

    public Glycan[] getSelectedStructures() {
        return (Glycan[])this.theSelector.getSelectedValues();
    }

    public int[] getSelectedIndices() {
        return this.theSelector.getSelectedIndices();
    }

    public Glycan getSelectedStructure() {
        return (Glycan)this.theSelector.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.theSelector.getSelectedIndex();
    }

    private void updateActions() {
        this.ok_button.getAction().setEnabled(!this.theSelector.isSelectionEmpty());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        if (action.equals("OK")) {
            this.return_status = action;
            this.setVisible(false);
        } else if (action.equals("Cancel")) {
            this.return_status = action;
            this.setVisible(false);
        }
    }
}

