/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnRename.ColumnRenameDialog;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.CreateColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayColumnGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.IColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.OpenCreateColumnGroupDialog;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupColumnCommand;
import org.eclipse.nebula.widgets.nattable.group.event.GroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.group.event.UngroupColumnsEvent;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ColumnGroupsCommandHandler
extends AbstractLayerCommandHandler<IColumnGroupCommand> {
    private final ColumnGroupModel model;
    private final SelectionLayer selectionLayer;
    private final ColumnGroupHeaderLayer contextLayer;
    private Map<Integer, Integer> columnIndexesToPositionsMap;

    public ColumnGroupsCommandHandler(ColumnGroupModel model, SelectionLayer selectionLayer, ColumnGroupHeaderLayer contextLayer) {
        this.model = model;
        this.selectionLayer = selectionLayer;
        this.contextLayer = contextLayer;
    }

    @Override
    public boolean doCommand(IColumnGroupCommand command) {
        if (command instanceof CreateColumnGroupCommand) {
            if (this.columnIndexesToPositionsMap.size() > 0) {
                this.handleGroupColumnsCommand(((CreateColumnGroupCommand)command).getColumnGroupName());
                this.columnIndexesToPositionsMap.clear();
                return true;
            }
        } else {
            if (command instanceof OpenCreateColumnGroupDialog) {
                OpenCreateColumnGroupDialog openDialogCommand = (OpenCreateColumnGroupDialog)command;
                this.loadSelectedColumnsIndexesWithPositions();
                if (this.selectionLayer.getFullySelectedColumnPositions().length > 0 && this.columnIndexesToPositionsMap.size() > 0) {
                    openDialogCommand.openDialog(this.contextLayer);
                } else {
                    openDialogCommand.openErrorBox(Messages.getString("ColumnGroups.selectNonGroupedColumns"));
                }
                return true;
            }
            if (command instanceof UngroupColumnCommand) {
                this.handleUngroupCommand();
                return true;
            }
            if (command instanceof RemoveColumnGroupCommand) {
                RemoveColumnGroupCommand removeColumnGroupCommand = (RemoveColumnGroupCommand)command;
                int columnIndex = removeColumnGroupCommand.getColumnIndex();
                this.handleRemoveColumnGroupCommand(columnIndex);
                return true;
            }
            if (command instanceof DisplayColumnGroupRenameDialogCommand) {
                return this.displayColumnGroupRenameDialog((DisplayColumnGroupRenameDialogCommand)command);
            }
        }
        return false;
    }

    private boolean displayColumnGroupRenameDialog(DisplayColumnGroupRenameDialogCommand command) {
        int columnPosition = command.getColumnPosition();
        ColumnRenameDialog dialog = new ColumnRenameDialog(Display.getDefault().getActiveShell(), null, null);
        Rectangle colHeaderBounds = this.contextLayer.getBoundsByPosition(columnPosition, 0);
        Point point = new Point(colHeaderBounds.x, colHeaderBounds.y + colHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (!dialog.isCancelPressed()) {
            int columnIndex = this.contextLayer.getColumnIndexByPosition(columnPosition);
            ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
            columnGroup.setName(dialog.getNewColumnLabel());
        }
        return true;
    }

    @Override
    public Class<IColumnGroupCommand> getCommandClass() {
        return IColumnGroupCommand.class;
    }

    protected void loadSelectedColumnsIndexesWithPositions() {
        this.columnIndexesToPositionsMap = new LinkedHashMap<Integer, Integer>();
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        if (fullySelectedColumns.length > 0) {
            int index = 0;
            while (index < fullySelectedColumns.length) {
                int columnPosition = fullySelectedColumns[index];
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(columnPosition);
                if (this.model.isPartOfAGroup(columnIndex)) {
                    this.columnIndexesToPositionsMap.clear();
                    break;
                }
                this.columnIndexesToPositionsMap.put(columnIndex, columnPosition);
                ++index;
            }
        }
    }

    public void handleGroupColumnsCommand(String columnGroupName) {
        try {
            ArrayList<Integer> selectedPositions = new ArrayList<Integer>();
            int[] fullySelectedColumns = new int[this.columnIndexesToPositionsMap.size()];
            int count = 0;
            for (Integer columnIndex : this.columnIndexesToPositionsMap.keySet()) {
                fullySelectedColumns[count++] = columnIndex;
                selectedPositions.add(this.columnIndexesToPositionsMap.get(columnIndex));
            }
            this.model.addColumnsIndexesToGroup(columnGroupName, fullySelectedColumns);
            this.selectionLayer.doCommand(new MultiColumnReorderCommand(this.selectionLayer, selectedPositions, (Integer)selectedPositions.get(0)));
            this.selectionLayer.clear();
        }
        catch (Throwable throwable) {}
        this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
    }

    public void handleUngroupCommand() {
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        HashMap<String, Integer> toColumnPositions = new HashMap<String, Integer>();
        if (fullySelectedColumns.length > 0) {
            int index = 0;
            while (index < fullySelectedColumns.length) {
                int columnPosition = fullySelectedColumns[index];
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(columnPosition);
                if (this.model.isPartOfAGroup(columnIndex) && !this.model.isPartOfAnUnbreakableGroup(columnIndex)) {
                    this.handleRemovalFromGroup(toColumnPositions, columnIndex);
                }
                ++index;
            }
            Collection values = toColumnPositions.values();
            for (Integer toColumnPosition : values) {
                this.selectionLayer.doCommand(new ReorderColumnGroupCommand(this.selectionLayer, toColumnPosition, toColumnPosition));
            }
            this.selectionLayer.clear();
        }
        this.contextLayer.fireLayerEvent(new UngroupColumnsEvent(this.contextLayer));
    }

    private void handleRemovalFromGroup(Map<String, Integer> toColumnPositions, int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        String columnGroupName = columnGroup.getName();
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int columnGroupSize = columnIndexesInGroup.size();
        if (!toColumnPositions.containsKey(columnGroupName)) {
            for (int colGroupIndex : columnIndexesInGroup) {
                if (!ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(colGroupIndex, this.contextLayer, this.selectionLayer, this.model)) continue;
                int toPosition = this.selectionLayer.getColumnPositionByIndex(colGroupIndex);
                if (colGroupIndex == columnIndex) {
                    if (columnGroupSize == 1) break;
                    ++toPosition;
                }
                toColumnPositions.put(columnGroupName, toPosition);
                break;
            }
        } else if (columnGroupSize - 1 <= 0) {
            toColumnPositions.remove(columnGroupName);
        }
        columnGroup.removeColumn(columnIndex);
    }

    private void handleRemoveColumnGroupCommand(int columnIndex) {
        ColumnGroupModel.ColumnGroup columnGroup = this.model.getColumnGroupByIndex(columnIndex);
        this.model.removeColumnGroup(columnGroup);
    }
}

