/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.annotation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.utilShare.FileSelectionAdapter;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.DatabaseUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabase;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabaseIndex;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.Filtering;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerFileSystem;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.LipidDatabase;
import org.grits.toolbox.ms.om.data.LipidSettings;
import org.grits.toolbox.tools.gsl.database.LipidDatabaseIndex;
import org.grits.toolbox.tools.gsl.database.LipidDatabaseList;
import org.grits.toolbox.tools.gsl.util.DatabaseUtilsForGSL;
import org.grits.toolbox.tools.gsl.util.io.lipid.LipidDatabaseFileHandler;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;

public class GlycolipidSettingsDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(GlycolipidSettingsDialog.class);
    private static final String GLYCAN = "Glycan";
    private static final String LIPID = "Lipid";
    private static final String NONE = "None";
    private AnalyteSettings analSettings;
    private FilterSetting filterSetting;
    private Filtering filtering;
    private FilterSettingLibrary preferenceFilterLibrary;
    private Category preferredFilterCategory;
    private String m_strGDBVersion;
    private String m_strDBPath;
    private HashMap<String, GlycanStructureDatabase> m_mapGlycanDBIndex = new HashMap();
    private HashMap<String, LipidDatabaseIndex> m_mapLipidDBIndex = new HashMap();
    private Combo m_cmbGlycanDBs;
    private Text m_txtNewGlycanDB;
    private Combo m_cmbLipidDBs;
    private Text m_txtNewLipidDB;
    private Combo m_cmbPerDeriv;
    private boolean m_bEditingMode;

    public GlycolipidSettingsDialog(Shell parentShell, FiltersLibrary filterLibrary) {
        super(parentShell);
        this.analSettings = new AnalyteSettings();
        this.analSettings.setGlycanSettings(new GlycanSettings());
        this.loadFilterPreferences();
        this.filtering = new Filtering(this.getShell(), filterLibrary, this.preferredFilterCategory, null);
    }

    public GlycolipidSettingsDialog(Shell parentShell, FiltersLibrary filterLibrary, AnalyteSettings aSettings) {
        super(parentShell);
        this.analSettings = aSettings;
        if (this.analSettings.getGlycanSettings() == null) {
            aSettings.setGlycanSettings(new GlycanSettings());
        }
        this.loadFilterPreferences();
        this.filtering = new Filtering(this.getShell(), filterLibrary, this.preferredFilterCategory, null);
        this.m_bEditingMode = true;
    }

    public AnalyteSettings getAnalyteSettings() {
        return this.analSettings;
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadFilterPreferences() {
        try {
            MSGlycanFilterCateogoryPreference categoryPreferences;
            MSGlycanFilterPreference preferences = MSGlycanFilterPreference.getMSGlycanFilterPreferences((PreferenceEntity)MSGlycanFilterPreference.getPreferenceEntity());
            if (preferences != null) {
                this.preferenceFilterLibrary = preferences.getFilterSettings();
            }
            if ((categoryPreferences = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences((PreferenceEntity)MSGlycanFilterCateogoryPreference.getPreferenceEntity())) != null) {
                this.preferredFilterCategory = categoryPreferences.getCategoryPreference();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        return lable;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Glycolipid Database Settings");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(1808));
        this.addDatabaseControls(container, GLYCAN);
        this.addSelectGlycanFilterItem(container);
        this.addDatabaseControls(container, LIPID);
        this.addPerDerivTypeControls(container);
        return container;
    }

    protected void addDatabaseControls(Composite container, String a_strDBType) {
        Label lblDatabase = new Label(container, 0);
        String t_strDBLabel = "Database";
        if (a_strDBType != null) {
            t_strDBLabel = String.valueOf(a_strDBType) + " " + t_strDBLabel;
        }
        lblDatabase.setText(t_strDBLabel);
        lblDatabase = this.setMandatoryLabel(lblDatabase);
        final Combo cmbDatabases = new Combo(container, 0);
        GridData gd_cmbDatabases = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_cmbDatabases.widthHint = 131;
        cmbDatabases.setLayoutData((Object)gd_cmbDatabases);
        new Label(container, 0);
        final Text txtNewDb = new Text(container, 2048);
        txtNewDb.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        final Button btnBrowse = new Button(container, 8);
        btnBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnBrowse.setText("Browse");
        FileSelectionAdapter rawFileBrowserSelectionAdapter = new FileSelectionAdapter();
        rawFileBrowserSelectionAdapter.setShell(container.getShell());
        rawFileBrowserSelectionAdapter.setText(txtNewDb);
        btnBrowse.addSelectionListener((SelectionListener)rawFileBrowserSelectionAdapter);
        this.setDatabaseItems(cmbDatabases, txtNewDb, a_strDBType);
        if (!cmbDatabases.getItem(cmbDatabases.getSelectionIndex()).equals(GlycanPreDefinedOptions.OTHER)) {
            btnBrowse.setEnabled(false);
            txtNewDb.setEnabled(false);
        }
        if (this.m_bEditingMode) {
            this.setDefaultDatabaseItems(cmbDatabases, txtNewDb, a_strDBType);
        }
        cmbDatabases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (cmbDatabases.getItem(cmbDatabases.getSelectionIndex()).equals("other")) {
                    txtNewDb.setEnabled(true);
                    btnBrowse.setEnabled(true);
                    GlycolipidSettingsDialog.this.getButton(0).setEnabled(GlycolipidSettingsDialog.this.validateInput());
                } else {
                    txtNewDb.setEnabled(false);
                    btnBrowse.setEnabled(false);
                    GlycolipidSettingsDialog.this.getButton(0).setEnabled(GlycolipidSettingsDialog.this.validateInput());
                }
            }
        });
        txtNewDb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GlycolipidSettingsDialog.this.getButton(0).setEnabled(GlycolipidSettingsDialog.this.validateInput());
            }
        });
        if (a_strDBType.equals(GLYCAN)) {
            this.m_cmbGlycanDBs = cmbDatabases;
            this.m_txtNewGlycanDB = txtNewDb;
        }
        if (a_strDBType.equals(LIPID)) {
            this.m_cmbLipidDBs = cmbDatabases;
            this.m_txtNewLipidDB = txtNewDb;
        }
    }

    private void setDatabaseItems(Combo a_cmbDB, Text a_txtNewDB, String a_strDBType) {
        List<String> t_lDBs = this.loadDatabases(a_strDBType);
        t_lDBs.add(GlycanPreDefinedOptions.OTHER);
        String[] cmbDBs = t_lDBs.toArray(new String[t_lDBs.size()]);
        int inx = 0;
        a_cmbDB.setItems(cmbDBs);
        a_cmbDB.select(inx);
    }

    protected List<String> loadDatabases(String a_strDBType) {
        if (a_strDBType.equals(GLYCAN)) {
            return this.loadGlycanDatabases();
        }
        if (a_strDBType.equals(LIPID)) {
            return this.loadLipidDatabases();
        }
        return new ArrayList<String>();
    }

    private List<String> loadGlycanDatabases() {
        ArrayList<String> t_lGlycanDatabases = new ArrayList<String>();
        try {
            GlycanStructureDatabaseIndex t_databaseIndex = DatabaseUtilsForGSL.getGelatoDatabases();
            for (GlycanStructureDatabase t_db : t_databaseIndex.getDatabase()) {
                String t_nameString = String.valueOf(t_db.getName()) + " - " + t_db.getNumberOfStructures().toString() + " glycans";
                t_lGlycanDatabases.add(t_nameString);
                this.m_mapGlycanDBIndex.put(t_nameString, t_db);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Unable to find GELATO database index", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"XML format problem in GELATO database index", (Throwable)e);
        }
        return t_lGlycanDatabases;
    }

    private List<String> loadLipidDatabases() {
        ArrayList<String> t_lLipidDatabases = new ArrayList<String>();
        try {
            LipidDatabaseList t_databaseList = DatabaseUtilsForGSL.getLipidDatabases();
            for (LipidDatabaseIndex t_dbIndex : t_databaseList.getIndices()) {
                String t_nameString = String.valueOf(t_dbIndex.getName()) + " - " + t_dbIndex.getNumberOfStructures().toString() + " lipids";
                t_lLipidDatabases.add(t_nameString);
                this.m_mapLipidDBIndex.put(t_nameString, t_dbIndex);
            }
            t_lLipidDatabases.add("None (Glycans will be annotated)");
            this.m_strDBPath = DatabaseUtilsForGSL.getDatabasePath();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to find lipid database list", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"XML format problem in lipid database list", (Throwable)e);
        }
        return t_lLipidDatabases;
    }

    private void setDefaultDatabaseItems(Combo a_cmbDB, Text a_txtNewDB, String a_strDBType) {
        String[] strDBInfo = this.getDBNameAndURI(a_strDBType);
        String strDBName = strDBInfo[0];
        String strDBURI = strDBInfo[1];
        if (strDBName == null) {
            if (strDBURI != null) {
                a_cmbDB.select(a_cmbDB.getItemCount() - 1);
                a_txtNewDB.setText(strDBURI);
            } else {
                a_cmbDB.select(a_cmbDB.getItemCount() - 2);
            }
            return;
        }
        int selected = -1;
        int i = 0;
        String[] stringArray = a_cmbDB.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (strDBName.equals(item)) {
                selected = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (selected != -1) {
            a_cmbDB.select(selected);
        }
    }

    protected String[] getDBNameAndURI(String a_strDBType) {
        if (a_strDBType.equals(GLYCAN) && this.getAnalyteSettings().getGlycanSettings() != null) {
            return this.getGlycanDBNameAndURI();
        }
        if (a_strDBType.equals(LIPID) && this.getAnalyteSettings().getLipidSettings() != null) {
            return this.getLipidDBNameAndURI();
        }
        return new String[2];
    }

    private String[] getGlycanDBNameAndURI() {
        GlycanFilter filter = this.analSettings.getGlycanSettings().getFilter();
        if (filter == null || filter.getDatabase() == null) {
            return new String[2];
        }
        String dbNameString = null;
        for (GlycanStructureDatabase t_db : this.m_mapGlycanDBIndex.values()) {
            if (!t_db.getPath().contains(filter.getDatabase())) continue;
            dbNameString = String.valueOf(t_db.getName()) + " - " + t_db.getNumberOfStructures().toString() + " glycans";
            break;
        }
        return new String[]{dbNameString, filter.getDatabase()};
    }

    private String[] getLipidDBNameAndURI() {
        LipidDatabase lDB = this.analSettings.getLipidSettings().getDatabase();
        if (lDB == null || lDB.getDatabase() == null) {
            return new String[2];
        }
        String strDBName = null;
        for (String t_strLDBName : this.m_mapLipidDBIndex.keySet()) {
            LipidDatabaseIndex t_lDBInx = this.m_mapLipidDBIndex.get(t_strLDBName);
            if (!lDB.getURI().contains(t_lDBInx.getFileName())) continue;
            strDBName = t_strLDBName;
            break;
        }
        return new String[]{strDBName, lDB.getURI()};
    }

    private void addSelectGlycanFilterItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(parent, 0);
        lblSelectFilter.setText("Glycan Database Filter");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        final Combo cmbSelectFilter = new Combo(parent, 8);
        cmbSelectFilter.setLayoutData((Object)gd2);
        this.initStoredFiltersList(cmbSelectFilter);
        if (this.m_bEditingMode) {
            GlycanSettings gSettings = this.analSettings.getGlycanSettings();
            if (gSettings.getFilterSetting() != null && gSettings.getFilterSetting().getName() != null) {
                int selected = -1;
                int i = 0;
                String[] stringArray = cmbSelectFilter.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    if (gSettings.getFilterSetting().getName().equals(filter)) {
                        selected = i;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                if (selected != -1) {
                    cmbSelectFilter.select(selected);
                }
            } else if (gSettings.getFilterSetting() != null) {
                cmbSelectFilter.select(cmbSelectFilter.getItemCount() - 1);
            }
        }
        cmbSelectFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GlycolipidSettingsDialog.this.processSelection(cmbSelectFilter);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void initStoredFiltersList(Combo cmbSelectFilter) {
        cmbSelectFilter.removeAll();
        if (this.preferenceFilterLibrary != null && this.preferenceFilterLibrary.getFilterSettings() != null) {
            for (FilterSetting filter : this.preferenceFilterLibrary.getFilterSettings()) {
                cmbSelectFilter.add(filter.getName());
            }
        }
        cmbSelectFilter.add(GlycanPreDefinedOptions.OTHER);
        cmbSelectFilter.add("", 0);
    }

    private void processSelection(Combo cmbSelectFilter) {
        if (cmbSelectFilter.getText().trim().equals("")) {
            this.filterSetting = null;
            return;
        }
        if (!cmbSelectFilter.getText().equals(GlycanPreDefinedOptions.OTHER)) {
            this.filterSetting = this.getCurrentFilter(cmbSelectFilter.getText().trim());
            return;
        }
        if (this.filtering != null && this.filtering.open() == 0) {
            this.filterSetting = this.filtering.getFilterSetting();
            this.filtering.setFilterSetting(this.filterSetting);
        }
    }

    private FilterSetting getCurrentFilter(String selFilter) {
        if (this.preferenceFilterLibrary == null || this.preferenceFilterLibrary.getFilterSettings() == null) {
            return null;
        }
        int i = 0;
        while (i < this.preferenceFilterLibrary.getFilterSettings().size()) {
            FilterSetting curFilter = (FilterSetting)this.preferenceFilterLibrary.getFilterSettings().get(i);
            if (curFilter.getName().equals(selFilter)) {
                return curFilter;
            }
            ++i;
        }
        return null;
    }

    private void addPerDerivTypeControls(Composite container) {
        Label lblPerdrivType = new Label(container, 0);
        lblPerdrivType.setText("PerDeriv Type");
        lblPerdrivType = this.setMandatoryLabel(lblPerdrivType);
        this.m_cmbPerDeriv = new Combo(container, 0);
        this.m_cmbPerDeriv.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.m_cmbPerDeriv.setItems(GlycanPreDefinedOptions.getAllDerivitizationTypes());
        this.m_cmbPerDeriv.select(0);
        if (this.m_bEditingMode) {
            int selected = -1;
            int i = 0;
            String[] stringArray = this.m_cmbPerDeriv.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (this.analSettings.getGlycanSettings().getPerDerivatisationType().equals(item)) {
                    selected = i;
                    break;
                }
                ++i;
                ++n2;
            }
            if (selected != -1) {
                this.m_cmbPerDeriv.select(selected);
            }
        }
    }

    public boolean validateInput() {
        if (this.m_txtNewGlycanDB != null && this.m_txtNewGlycanDB.getEnabled() && (TextFieldUtils.isEmpty((Text)this.m_txtNewGlycanDB) || !this.isValidGlycanDatabase(this.m_txtNewGlycanDB.getText()))) {
            this.setErrorMessage("Please select a valid glycan database");
            return false;
        }
        if (this.m_txtNewLipidDB != null && this.m_txtNewLipidDB.getEnabled() && (TextFieldUtils.isEmpty((Text)this.m_txtNewLipidDB) || !this.isValidLipidDatabase(this.m_txtNewLipidDB.getText()))) {
            this.setErrorMessage("Please select a valid lipid database");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isValidGlycanDatabase(String dbName) {
        GlycanFilter filter;
        block7: {
            try {
                filter = new GlycanFilter();
                if (dbName.indexOf(File.separator) == -1) {
                    try {
                        filter.setDatabase(String.valueOf(DatabaseUtils.getDatabasePath()) + File.separator + dbName);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Database path cannot be determined", (Throwable)e);
                    }
                } else {
                    filter.setDatabase(dbName);
                }
                StructureHandlerFileSystem handler = new StructureHandlerFileSystem();
                if (handler.getStructures(filter) != null) break block7;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.m_strGDBVersion = filter.getVersion();
        return true;
    }

    private boolean isValidLipidDatabase(String a_strLDBFileName) {
        try {
            LipidDatabaseFileHandler.importXML(a_strLDBFileName);
        }
        catch (Exception exception) {
            logger.info((Object)("Unable to read lipid database file " + a_strLDBFileName));
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.validateInput()) {
            return;
        }
        this.saveGlycanSettings();
        this.saveLipidSettings();
        super.okPressed();
    }

    private void saveGlycanSettings() {
        String sSelectedDb = this.m_cmbGlycanDBs.getText();
        String sSelectedPerDerivType = this.m_cmbPerDeriv.getText();
        this.analSettings.getGlycanSettings().setPerDerivatisationType(sSelectedPerDerivType);
        GlycanStructureDatabase selectedDatabase = this.m_mapGlycanDBIndex.get(sSelectedDb);
        GlycanFilter filter = new GlycanFilter();
        if (selectedDatabase == null) {
            filter.setDatabase(this.m_txtNewGlycanDB.getText());
        } else {
            filter.setDatabase(selectedDatabase.getFileName());
        }
        filter.setVersion(this.m_strGDBVersion != null ? this.m_strGDBVersion : "1.0");
        this.analSettings.getGlycanSettings().setFilter(filter);
        this.analSettings.getGlycanSettings().setFilterSetting(this.filterSetting);
    }

    private void saveLipidSettings() {
        String sSelectedDb = this.m_cmbLipidDBs.getText();
        if (sSelectedDb.startsWith(NONE)) {
            this.analSettings.setLipidSettings(null);
            return;
        }
        if (this.analSettings.getLipidSettings() == null) {
            this.analSettings.setLipidSettings(new LipidSettings());
        }
        String sSelectedPerDerivType = this.m_cmbPerDeriv.getText();
        this.analSettings.getLipidSettings().setPerDerivatisationType(sSelectedPerDerivType);
        LipidDatabaseIndex t_lDBInx = this.m_mapLipidDBIndex.get(sSelectedDb);
        LipidDatabase t_lDB = new LipidDatabase();
        if (t_lDBInx == null) {
            t_lDB.setDatabase("");
            t_lDB.setURI(this.m_txtNewLipidDB.getText());
        } else {
            t_lDB.setDatabase(t_lDBInx.getName());
            t_lDB.setURI(String.valueOf(this.m_strDBPath) + File.separator + t_lDBInx.getFileName());
        }
        this.analSettings.getLipidSettings().setDatabase(t_lDB);
    }
}

