/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.analyze.glycan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingle;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;
import org.grits.toolbox.tools.gsl.util.analyze.glycan.SubstComparator;

public class GlycoVisitorComposition
implements GlycoVisitor {
    private HashMap<String, Integer> m_composition = new HashMap();
    private HashMap<GlycoNode, Boolean> m_handledResidues = new HashMap();

    public HashMap<String, Integer> getComposition() {
        return this.m_composition;
    }

    public void setComposition(HashMap<String, Integer> a_composition) {
        this.m_composition = a_composition;
    }

    public void clear() {
        this.m_composition.clear();
        this.m_handledResidues.clear();
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_visitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingle(a_visitor);
    }

    public void start(Sugar a_sugar) throws GlycoVisitorException {
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_sugar);
        for (UnderdeterminedSubTree t_tree : a_sugar.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(NonMonosaccharide a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("NonMonosaccharide are not supported.");
    }

    public void visit(SugarUnitRepeat a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitRepeat are not supported.");
    }

    public void visit(SugarUnitCyclic a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitCyclic are not supported.");
    }

    public void visit(SugarUnitAlternative a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative are not supported.");
    }

    public void visit(UnvalidatedGlycoNode a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode are not supported.");
    }

    public void visit(GlycoEdge a_arg0) throws GlycoVisitorException {
    }

    public void visit(Monosaccharide a_ms) throws GlycoVisitorException {
        if (this.m_handledResidues.get(a_ms) == null) {
            boolean t_alditol = false;
            String t_ulop = "";
            String t_name = a_ms.getSuperclass().getName();
            for (Modification t_modi : a_ms.getModification()) {
                if (t_modi.getModificationType().equals((Object)ModificationType.ACID)) {
                    t_name = String.valueOf(t_name) + "A";
                    continue;
                }
                if (t_modi.getModificationType().equals((Object)ModificationType.ALDI)) {
                    t_alditol = true;
                    continue;
                }
                if (t_modi.getModificationType().equals((Object)ModificationType.DEOXY)) {
                    t_name = "d" + t_name;
                    continue;
                }
                if (t_modi.getModificationType().equals((Object)ModificationType.KETO)) {
                    t_ulop = String.valueOf(t_ulop) + "-ulop";
                    continue;
                }
                throw new GlycoVisitorException("Unsupported modification type:" + t_modi.getModificationType());
            }
            t_name = String.valueOf(t_name) + t_ulop;
            if (t_alditol) {
                t_name = String.valueOf(t_name) + "-ol";
            }
            HashMap<SubstituentType, Integer> t_substMap = new HashMap<SubstituentType, Integer>();
            ArrayList<SubstituentType> t_substList = new ArrayList<SubstituentType>();
            Iterator iterator = a_ms.getChildNodes().iterator();
            while (iterator.hasNext()) {
                GlycoVisitorNodeType t_nodeType = new GlycoVisitorNodeType();
                GlycoNode t_node = (GlycoNode)iterator.next();
                Substituent t_subst = t_nodeType.getSubstituent(t_node);
                if (t_subst == null || t_subst.getChildEdges().size() != 0) continue;
                Integer t_int = (Integer)t_substMap.get(t_subst.getSubstituentType());
                if (t_int == null) {
                    t_substMap.put(t_subst.getSubstituentType(), 1);
                    t_substList.add(t_subst.getSubstituentType());
                } else {
                    t_substMap.put(t_subst.getSubstituentType(), t_int + 1);
                }
                this.m_handledResidues.put(t_node, true);
            }
            Collections.sort(t_substList, new SubstComparator());
            for (SubstituentType t_substituentType : t_substList) {
                Integer t_int = (Integer)t_substMap.get(t_substituentType);
                t_name = t_int > 1 ? String.valueOf(t_name) + "-(" + t_int.toString() + ")" + t_substituentType.getName() : String.valueOf(t_name) + "-" + t_substituentType.getName();
            }
            Integer t_int = this.m_composition.get(t_name);
            if (t_int == null) {
                this.m_composition.put(t_name, 1);
            } else {
                this.m_composition.put(t_name, t_int + 1);
            }
            this.m_handledResidues.put((GlycoNode)a_ms, true);
        }
    }

    public void visit(Substituent a_subst) throws GlycoVisitorException {
        if (this.m_handledResidues.get(a_subst) == null) {
            Integer t_int = this.m_composition.get(a_subst.getSubstituentType().getName());
            if (t_int == null) {
                this.m_composition.put(a_subst.getSubstituentType().getName(), 1);
            } else {
                this.m_composition.put(a_subst.getSubstituentType().getName(), 1 + t_int);
            }
            this.m_handledResidues.put((GlycoNode)a_subst, true);
        }
    }
}

