/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.annotation;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddAdductsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddIonExchangeForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddNeutralLossForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GeneralInformationMulti;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.tools.gsl.annotation.preference.MSGlycolipidAnnotationSettingsPreference;
import org.grits.toolbox.tools.gsl.wizard.annotation.GlycolipidSettingsForm;
import org.grits.toolbox.tools.gsl.wizard.annotation.LipidFragmentSettingsForm;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycolipidAnnotationWizard
extends MSGlycanAnnotationWizard {
    private static final Logger logger = Logger.getLogger(MSGlycolipidAnnotationWizard.class);
    protected GlycolipidSettingsForm glycolipidSettingsForm = null;
    protected LipidFragmentSettingsForm lipidFragmentSettingsForm = null;

    public MSGlycolipidAnnotationWizard() {
        this.setWindowTitle("MS Annotation");
        this.method = new Method();
        try {
            this.filterLibrary = FilterUtils.readFilters((String)this.getDefaultFiltersPath());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error getting the filters", (Throwable)e);
        }
    }

    public GlycolipidSettingsForm getGlycolipidSettingsForm() {
        return this.glycolipidSettingsForm;
    }

    public void setGlycolipidSettingsForm(GlycolipidSettingsForm one) {
        this.glycolipidSettingsForm = one;
    }

    public void addPages() {
        this.initial = new GeneralInformationMulti(this.msEntries, "New MS Glycolipid Annotation", "Identify Glycolipids using DANGO.", "DANGO");
        try {
            this.initial.loadPreferences(MSGlycolipidAnnotationSettingsPreference.class, MSGlycolipidAnnotationSettingsPreference.getPreferenceEntity());
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Could not load preferences", (Throwable)e);
        }
        this.glycolipidSettingsForm = new GlycolipidSettingsForm(this.method, this, this.filterLibrary);
        this.fragmentSettingsForm = new FragmentSettingsForm(this.method);
        this.ionSettingsForm = new AddAdductsForm(this.method);
        this.ionExchangeForm = new AddIonExchangeForm(this.method);
        this.neutralLossForm = new AddNeutralLossForm(this.method);
        this.addPage((IWizardPage)this.initial);
        this.addPage((IWizardPage)this.glycolipidSettingsForm);
        this.addPage((IWizardPage)this.fragmentSettingsForm);
        this.addPage((IWizardPage)this.ionSettingsForm);
        this.addPage((IWizardPage)this.ionExchangeForm);
        this.addPage((IWizardPage)this.neutralLossForm);
    }

    public void setPreferences(MSGlycanAnnotationPreference preferences) {
        this.preferences = preferences;
        this.glycolipidSettingsForm.updateControlsFromPreferences();
        this.fragmentSettingsForm.updateControlsFromPreferences();
        this.ionSettingsForm.updateControlsFromPreferences();
        this.ionExchangeForm.updateControlsFromPreferences();
        this.neutralLossForm.updateControlsFromPreferences();
    }

    public boolean canFinish() {
        if (!this.glycolipidSettingsForm.canFlipToNextPage()) {
            return false;
        }
        this.glycolipidSettingsForm.save();
        if (!this.fragmentSettingsForm.canFlipToNextPage()) {
            return false;
        }
        this.fragmentSettingsForm.save();
        if (!this.ionSettingsForm.canFlipToNextPage()) {
            return false;
        }
        this.ionSettingsForm.save();
        if (!this.ionExchangeForm.canFlipToNextPage()) {
            return false;
        }
        this.ionExchangeForm.save();
        if (!this.neutralLossForm.isPageComplete()) {
            return false;
        }
        this.neutralLossForm.save();
        return this.ionSettingsForm.isPageComplete() && this.initial.canFlipToNextPage() && this.glycolipidSettingsForm.canFlipToNextPage() && this.fragmentSettingsForm.canFinish() && this.ionExchangeForm.isPageComplete() && this.neutralLossForm.isPageComplete();
    }
}

