/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.atom.Composition;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentation;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationFormat;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentationType;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MolecularEntity
extends ResourcesDbObject {
    private String name;
    private Composition composition;
    private Double monoMass;
    private Double avgMass;
    private String formula;
    private String smiles;
    private String inchi;
    private List<Atom> atoms;
    private Double charge;
    private List<ResidueRepresentation> representations;

    public MolecularEntity() {
        this.init();
    }

    public MolecularEntity(TemplateContainer container) {
        this.init();
        this.setTemplateContainer(container);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Composition getComposition() {
        return this.composition;
    }

    public void setComposition(Composition composition) {
        this.composition = composition;
    }

    public Double getAvgMass() {
        if (this.avgMass == null && this.getComposition() != null) {
            this.setAvgMass(this.getComposition().getAvgMass());
        }
        return this.avgMass;
    }

    public double getAvgMassValue() {
        if (this.getAvgMass() == null) {
            return 0.0;
        }
        return this.getAvgMass();
    }

    public void setAvgMass(Double avgMass) {
        this.avgMass = avgMass;
    }

    public void setAvgMass(double mass) {
        this.avgMass = new Double(mass);
    }

    public Double getMonoMass() {
        if (this.monoMass == null && this.getComposition() != null) {
            this.setMonoMass(this.getComposition().getMonoMass());
        }
        return this.monoMass;
    }

    public double getMonoMassValue() {
        if (this.getMonoMass() == null) {
            return 0.0;
        }
        return this.getMonoMass();
    }

    public void setMonoMass(Double monoMass) {
        this.monoMass = monoMass;
    }

    public void setMonoMass(double mass) {
        this.monoMass = new Double(mass);
    }

    public String getInchi() {
        return this.inchi;
    }

    public void setInchi(String inchi) {
        this.inchi = inchi;
    }

    public String getSmiles() {
        return this.smiles;
    }

    public void setSmiles(String smiles) {
        this.smiles = smiles;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formulaStr) {
        this.formula = formulaStr;
    }

    public List<Atom> getAtoms() {
        return this.atoms;
    }

    public void setAtoms(List<Atom> atoms) {
        this.atoms = atoms;
    }

    public void addAtom(Atom a) {
        if (this.atoms == null) {
            this.atoms = new ArrayList<Atom>();
        }
        this.atoms.add(a);
    }

    public void addAtom(Atom newAtom, Atom existingAtom, double bo) throws MonosaccharideException {
        this.addAtom(newAtom);
        if (!this.getAtoms().contains(existingAtom)) {
            throw new MonosaccharideException("Cannot establish bond to atom " + existingAtom.toString() + " (not present in atom list).");
        }
        newAtom.addConnection(existingAtom, bo);
        existingAtom.addConnection(newAtom, bo);
    }

    public void addBond(Atom a, Atom b, double bo) throws MonosaccharideException {
        if (!this.getAtoms().contains(a)) {
            throw new MonosaccharideException("Cannot establish bond from atom " + a.toString() + " (not present in atom list).");
        }
        if (!this.getAtoms().contains(b)) {
            throw new MonosaccharideException("Cannot establish bond to atom " + b.toString() + " (not present in atom list).");
        }
        a.addConnection(b, bo);
        b.addConnection(a, bo);
    }

    public Atom getAtomById(int atomId) {
        for (Atom a : this.getAtoms()) {
            if (a.getId() != atomId) continue;
            return a;
        }
        return null;
    }

    public Atom getAtomByName(String atomName) {
        for (Atom a : this.getAtoms()) {
            if (!a.getName().equals(atomName)) continue;
            return a;
        }
        return null;
    }

    public void removeAtom(Atom a, boolean removeHydrogens) {
        if (a != null) {
            this.getAtoms().remove(a);
            for (AtomConnection ac : a.getConnections()) {
                Atom b = ac.getToAtom();
                if (b == a) {
                    b = ac.getFromAtom();
                }
                if (removeHydrogens && b.getElement().getSymbol().equals("H")) {
                    this.getAtoms().remove(b);
                    continue;
                }
                b.removeConnection(a);
            }
        }
    }

    public List<Atom> getAtomListClone() {
        ArrayList<Atom> retList = new ArrayList<Atom>();
        for (Atom a : this.getAtoms()) {
            retList.add(a.clone());
        }
        for (Atom a : retList) {
            for (AtomConnection ac : a.getConnections()) {
                ac.setFromAtom(a);
                int toAtomIndex = this.getAtoms().indexOf(ac.getToAtom());
                if (toAtomIndex == -1) continue;
                ac.setToAtom((Atom)retList.get(toAtomIndex));
            }
        }
        return retList;
    }

    public Double getCharge() {
        if (this.charge == null && this.getAtoms() != null && this.getAtoms().size() > 0) {
            this.setChargeFromAtoms();
        }
        return this.charge;
    }

    public double getChargeValue() {
        if (this.getCharge() == null) {
            return 0.0;
        }
        return this.getCharge();
    }

    public void setCharge(Double charge) {
        this.charge = charge;
    }

    public void setCharge(double charge) {
        this.charge = new Double(charge);
    }

    public void setChargeFromAtoms() {
        if (this.getAtoms() != null) {
            double chargeSum = 0.0;
            for (Atom a : this.getAtoms()) {
                chargeSum += a.getChargeValue();
            }
            this.setCharge(chargeSum);
        }
    }

    public List<ResidueRepresentation> getRepresentations() {
        return this.representations;
    }

    public ResidueRepresentation getRepresentation(ResidueRepresentationType type, ResidueRepresentationFormat format) {
        try {
            if (this.getRepresentations() != null) {
                for (ResidueRepresentation resRep : this.getRepresentations()) {
                    if (!resRep.getType().equals((Object)type) || format != null && !resRep.getFormat().equals((Object)format)) continue;
                    return resRep;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in MolecularEntity.getRepresentation:" + ex);
        }
        return null;
    }

    public void setRepresentations(List<ResidueRepresentation> representationsList) {
        this.representations = representationsList;
    }

    public void addRepresentation(ResidueRepresentation resRepr) {
        if (this.getRepresentations() == null) {
            this.setRepresentations(new ArrayList<ResidueRepresentation>());
        }
        this.getRepresentations().add(resRepr);
    }

    public void addRepresentations(List<ResidueRepresentation> repList) {
        if (repList != null) {
            for (ResidueRepresentation rep : repList) {
                if (rep == null) continue;
                this.addRepresentation(rep);
            }
        }
    }

    public int getCoordinatesId(ResidueRepresentationFormat format) {
        ResidueRepresentation monoRep = this.getRepresentation(ResidueRepresentationType.COORDINATES, format);
        if (monoRep != null) {
            return monoRep.getDbId();
        }
        return 0;
    }

    public int getPdbCoordinatesId() {
        return this.getCoordinatesId(ResidueRepresentationFormat.PDB);
    }

    public int getMol2CoordinatesId() {
        return this.getCoordinatesId(ResidueRepresentationFormat.MOL2);
    }

    public int getChemCompId() {
        return this.getCoordinatesId(ResidueRepresentationFormat.CHEM_COMP);
    }

    public int getImageId(ResidueRepresentationFormat format) {
        for (ResidueRepresentation rep : this.getRepresentations()) {
            if (!rep.getType().getFormatType().equals("graphic") || format != null && !format.equals((Object)rep.getFormat())) continue;
            return rep.getDbId();
        }
        return 0;
    }

    public void init() {
        this.setName("");
        this.setAtoms(null);
        this.setComposition(null);
        this.setMonoMass(null);
        this.setAvgMass(null);
        this.setSmiles(null);
        this.setInchi(null);
        this.setFormula(null);
        this.setRepresentations(new ArrayList<ResidueRepresentation>());
    }
}

