/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import org.eurocarbdb.resourcesdb.MolecularEntity;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.jdom.Element;

public class AtomConnection
implements Cloneable {
    private Atom fromAtom = null;
    private Atom toAtom = null;
    private Double bondOrder = null;
    private int dbId;

    public AtomConnection(Atom from, Atom to, Double bo) {
        this.setFromAtom(from);
        this.setToAtom(to);
        this.setBondOrder(bo);
    }

    public AtomConnection() {
        this.init();
    }

    public Atom getFromAtom() {
        return this.fromAtom;
    }

    public void setFromAtom(Atom fromAtom) {
        this.fromAtom = fromAtom;
    }

    public Atom getToAtom() {
        return this.toAtom;
    }

    public void setToAtom(Atom toAtom) {
        this.toAtom = toAtom;
    }

    public Double getBondOrder() {
        return this.bondOrder;
    }

    public void setBondOrder(Double bondOrder) {
        this.bondOrder = bondOrder;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public static void parseXmlAtomConnectionTag(Element acTag, MolecularEntity molec) throws MonosaccharideException {
        if (acTag.getName().equalsIgnoreCase("connection")) {
            Double bo = null;
            Atom fromAtom = null;
            Atom toAtom = null;
            String toAtomIdStr = acTag.getAttributeValue("to");
            String fromAtomIdStr = acTag.getAttributeValue("from");
            try {
                int toAtomId = Integer.parseInt(toAtomIdStr);
                toAtom = molec.getAtomById(toAtomId);
                int fromAtomId = Integer.parseInt(fromAtomIdStr);
                fromAtom = molec.getAtomById(fromAtomId);
                String boStr = acTag.getAttributeValue("bond_order");
                if (boStr != null && boStr.length() > 0) {
                    bo = Double.parseDouble(boStr);
                }
            }
            catch (NumberFormatException ne) {
                MonosaccharideException me = new MonosaccharideException("XmlAtomConnection: Exception occurred when parsing numerical parameter.");
                me.initCause(ne);
                throw me;
            }
            if (toAtom == null || fromAtom == null) {
                throw new MonosaccharideException("XmlAtomConnection: could not get atom from xml tag (IDs: from " + fromAtomIdStr + " / to " + toAtomIdStr + ").");
            }
            fromAtom.addConnection(toAtom, bo);
            toAtom.addConnection(fromAtom, bo);
        }
    }

    public void init() {
        this.setBondOrder(null);
        this.setFromAtom(null);
        this.setToAtom(null);
    }

    public String toString() {
        String outStr = "AtomConnection from " + this.getFromAtom().getId() + " (" + this.getFromAtom().getName() + ") to " + this.getToAtom().getId() + " (" + this.getToAtom().getName() + ") BondOrder " + this.getBondOrder();
        return outStr;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtomConnection)) {
            return false;
        }
        AtomConnection conect = (AtomConnection)obj;
        return conect.getFromAtom() == this.getFromAtom() && conect.getToAtom() == this.getToAtom() && conect.getBondOrder() == this.getBondOrder();
    }

    public AtomConnection clone() {
        return new AtomConnection(this.getFromAtom(), this.getToAtom(), this.getBondOrder());
    }
}

