/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstituentExchangeObject
extends ResourcesDbObject {
    private String name = null;
    private String originalName = null;
    private ArrayList<Integer> position1;
    private ArrayList<Integer> position2;
    private ArrayList<Integer> position3;
    private LinkageType linkagetype1 = null;
    private LinkageType linkagetype2 = null;
    private LinkageType linkagetype3 = null;
    private LinkageType originalLinkagetype1 = null;
    private LinkageType originalLinkagetype2 = null;
    private LinkageType originalLinkagetype3 = null;
    private ArrayList<Integer> substituentPosition1;
    private ArrayList<Integer> substituentPosition2;
    private ArrayList<Integer> substituentPosition3;
    private GlycanNamescheme namescheme = null;

    public SubstituentExchangeObject(String name, int position1, GlycanNamescheme scheme) {
        this(name, position1, scheme, null, null);
    }

    public SubstituentExchangeObject(String name, int position1, GlycanNamescheme scheme, Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
        this.setNamescheme(scheme);
        this.setName(name);
        this.addPosition1(position1);
    }

    public SubstituentExchangeObject(String name, int position1, int position2, GlycanNamescheme scheme) {
        this(name, position1, position2, scheme, null, null);
    }

    public SubstituentExchangeObject(String name, int position1, int position2, GlycanNamescheme scheme, Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
        this.setNamescheme(scheme);
        this.setName(name);
        this.addPosition1(position1);
        this.addPosition2(position2);
    }

    public SubstituentExchangeObject(Substitution msdbSubst, GlycanNamescheme scheme) {
        this.setConfig(msdbSubst.getConfig());
        this.setTemplateContainer(msdbSubst.getTemplateContainer());
        this.init();
        this.setNamescheme(scheme);
        this.setName(msdbSubst.getName());
        this.setPosition1(msdbSubst.getPosition1());
        this.setPosition2(msdbSubst.getPosition2());
        this.setLinkagetype1(msdbSubst.getLinkagetype1());
        this.setLinkagetype2(msdbSubst.getLinkagetype2());
        this.setSubstituentPosition1(msdbSubst.getSubstituentPosition1());
        this.setSubstituentPosition2(msdbSubst.getSubstituentPosition2());
        this.setOriginalName(msdbSubst.getSourceName());
        this.setOriginalLinkagetype1(msdbSubst.getSourceLinkagetype1());
        this.setOriginalLinkagetype2(msdbSubst.getSourceLinkagetype2());
    }

    public SubstituentExchangeObject(GlycanNamescheme scheme) {
        this(scheme, null, null);
    }

    public SubstituentExchangeObject(GlycanNamescheme scheme, Config conf, TemplateContainer container) {
        this.init();
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.setNamescheme(scheme);
    }

    public void setDefaultDataFromTemplate(GlycanNamescheme scheme, SubstituentTemplate template) {
        this.setNamescheme(scheme);
        this.setLinkagetype1(template.getDefaultLinkagetype1());
        this.setLinkagetype2(template.getDefaultLinkagetype2());
        this.getSubstituentPosition1().clear();
        this.addSubstituentPosition1(template.getDefaultLinkingPosition1());
        this.getSubstituentPosition2().clear();
        this.addSubstituentPosition2(template.getDefaultLinkingPosition2());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public ArrayList<Integer> getPosition1() {
        return this.position1;
    }

    public void setPosition1(ArrayList<Integer> position) {
        this.position1 = position;
    }

    public void addPosition1(int pos) {
        if (this.getPosition1() == null) {
            this.setPosition1(new ArrayList<Integer>());
        }
        this.getPosition1().add(new Integer(pos));
    }

    public ArrayList<Integer> getPosition2() {
        return this.position2;
    }

    public void setPosition2(ArrayList<Integer> position2) {
        this.position2 = position2;
    }

    public void addPosition2(int pos) {
        if (this.getPosition2() == null) {
            this.setPosition2(new ArrayList<Integer>());
        }
        this.getPosition2().add(new Integer(pos));
    }

    public ArrayList<Integer> getPosition3() {
        return this.position3;
    }

    public void setPosition3(ArrayList<Integer> position) {
        this.position3 = position;
    }

    public void addPosition3(int pos) {
        if (this.getPosition3() == null) {
            this.setPosition3(new ArrayList<Integer>());
        }
        this.getPosition3().add(new Integer(pos));
    }

    public LinkageType getLinkagetype1() {
        return this.linkagetype1;
    }

    public void setLinkagetype1(LinkageType linkagetype) {
        this.linkagetype1 = linkagetype;
    }

    public LinkageType getLinkagetype2() {
        return this.linkagetype2;
    }

    public void setLinkagetype2(LinkageType linkagetype) {
        this.linkagetype2 = linkagetype;
    }

    public LinkageType getLinkagetype3() {
        return this.linkagetype3;
    }

    public void setLinkagetype3(LinkageType linkagetype) {
        this.linkagetype3 = linkagetype;
    }

    public LinkageType getOriginalLinkagetype1() {
        return this.originalLinkagetype1;
    }

    public void setOriginalLinkagetype1(LinkageType origlinkagetype1) {
        this.originalLinkagetype1 = origlinkagetype1;
    }

    public LinkageType getOriginalLinkagetype2() {
        return this.originalLinkagetype2;
    }

    public void setOriginalLinkagetype2(LinkageType origlinkagetype2) {
        this.originalLinkagetype2 = origlinkagetype2;
    }

    public LinkageType getOriginalLinkagetype3() {
        return this.originalLinkagetype3;
    }

    public void setOriginalLinkagetype3(LinkageType origlinkagetype3) {
        this.originalLinkagetype3 = origlinkagetype3;
    }

    public ArrayList<Integer> getSubstituentPosition1() {
        if (this.substituentPosition1 == null) {
            this.substituentPosition1 = new ArrayList();
        }
        return this.substituentPosition1;
    }

    public void setSubstituentPosition1(ArrayList<Integer> substituentPosition) {
        this.substituentPosition1 = substituentPosition;
    }

    public void setSubstituentPosition1(int substPos1) {
        this.substituentPosition1 = new ArrayList();
        this.substituentPosition1.add(substPos1);
    }

    public void addSubstituentPosition1(int position) {
        if (this.getSubstituentPosition1() == null) {
            this.setSubstituentPosition1(new ArrayList<Integer>());
        }
        this.getSubstituentPosition1().add(new Integer(position));
    }

    public ArrayList<Integer> getSubstituentPosition2() {
        if (this.substituentPosition2 == null) {
            this.substituentPosition2 = new ArrayList();
        }
        return this.substituentPosition2;
    }

    public void setSubstituentPosition2(ArrayList<Integer> substituentPosition) {
        this.substituentPosition2 = substituentPosition;
    }

    public void setSubstituentPosition2(int substPos2) {
        this.substituentPosition2 = new ArrayList();
        this.substituentPosition2.add(substPos2);
    }

    public void addSubstituentPosition2(int position) {
        if (this.getSubstituentPosition2() == null) {
            this.setSubstituentPosition2(new ArrayList<Integer>());
        }
        this.getSubstituentPosition2().add(new Integer(position));
    }

    public ArrayList<Integer> getSubstituentPosition3() {
        if (this.substituentPosition3 == null) {
            this.substituentPosition3 = new ArrayList();
        }
        return this.substituentPosition3;
    }

    public void setSubstituentPosition3(ArrayList<Integer> substituentPosition) {
        this.substituentPosition3 = substituentPosition;
    }

    public void addSubstituentPosition3(int position) {
        if (this.getSubstituentPosition3() == null) {
            this.setSubstituentPosition3(new ArrayList<Integer>());
        }
        this.getSubstituentPosition3().add(new Integer(position));
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public void setNamescheme(GlycanNamescheme namescheme) {
        this.namescheme = namescheme;
    }

    public void init() {
        this.setName(null);
        this.setOriginalName(null);
        this.setPosition1(new ArrayList<Integer>());
        this.setPosition2(new ArrayList<Integer>());
        this.setPosition3(new ArrayList<Integer>());
        this.setSubstituentPosition1(new ArrayList<Integer>());
        this.setSubstituentPosition2(new ArrayList<Integer>());
        this.setSubstituentPosition3(new ArrayList<Integer>());
        this.setLinkagetype1(null);
        this.setLinkagetype2(null);
        this.setLinkagetype3(null);
    }

    public String toString() {
        String outStr = "";
        outStr = outStr + this.getPosition1().toString();
        outStr = outStr + ":";
        outStr = outStr + this.getSubstituentPosition1().toString();
        outStr = outStr + "(" + (Object)((Object)this.getLinkagetype1()) + ")";
        if (this.getPosition2() != null && this.getPosition2().size() > 0) {
            outStr = outStr + ",";
            outStr = outStr + this.getPosition2().toString();
            outStr = outStr + ":";
            outStr = outStr + this.getSubstituentPosition2().toString();
            outStr = outStr + "(" + (Object)((Object)this.getLinkagetype2()) + ")";
        }
        outStr = outStr + " ";
        outStr = outStr + this.getName();
        if (this.getOriginalName() != null) {
            outStr = outStr + " (orig: " + this.getOriginalName() + ")";
        }
        return outStr;
    }
}

