/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.representation.SvgFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Haworth
extends SvgFactory {
    private static int[] pyranoseX = new int[]{100, 80, 40, 20, 40, 80};
    private static int[] pyranoseY = new int[]{60, 90, 90, 60, 30, 30};
    private static int[] furanoseX = new int[]{100, 85, 35, 20, 60};
    private static int[] furanoseY = new int[]{50, 80, 80, 50, 30};
    private ArrayList<Point> basepoints;
    private Point baseCenter;
    private static final String OH = "OH";
    private static final String HO = "HO";
    private static final String CH3 = "CH3";
    private static final String H3C = "H3C";
    private static final String COOH = "COOH";
    private static final String HOOC = "HOOC";
    private static final String COO = "COO";
    private static final String OOC = "OOC";
    private static int defaultWidth = 120;
    private static int defaultHeight = 120;
    private int lineLength = 15;

    public Haworth() {
        this.setSvgWidth(defaultWidth);
        this.setSvgHeight(defaultHeight);
        this.getSVGGraph2D().setSVGCanvasSize(new Dimension(defaultWidth, defaultHeight));
    }

    public Haworth(int width, int height) {
        this.setSvgWidth(width);
        this.setSvgHeight(height);
        this.getSVGGraph2D().setSVGCanvasSize(new Dimension(width, height));
    }

    private ArrayList<Point> getBasepoints() {
        return this.basepoints;
    }

    private Point getBasepoint(int index) {
        return this.getBasepoints().get(index - 1);
    }

    private void setBasepoints(ArrayList<Point> pointList) {
        this.basepoints = pointList;
    }

    private Point getBaseCenter() {
        return this.baseCenter;
    }

    private void setBaseCenter(Point baseCenter) {
        this.baseCenter = baseCenter;
    }

    private void setPyranoseBasepoints() {
        this.setBasepoints(new ArrayList<Point>());
        for (int i = 0; i < 6; ++i) {
            this.getBasepoints().add(new Point(pyranoseX[i], pyranoseY[i]));
        }
    }

    private void setFuranoseBasepoints() {
        this.setBasepoints(new ArrayList<Point>());
        for (int i = 0; i < 5; ++i) {
            this.getBasepoints().add(new Point(furanoseX[i], furanoseY[i]));
        }
    }

    private void drawPyranoseRingTemplate() {
        Substitution ringOSubst;
        String ringOStr = "O";
        if (this.getMonosacc().getRingEnd() > 0 && (ringOSubst = this.getMonosacc().getSubstitution(null, this.getMonosacc().getRingEnd(), LinkageType.DEOXY)) != null) {
            Atom ringAtom;
            try {
                ringAtom = ringOSubst.getTemplate().getLinkingAtom(ringOSubst.getIntValueSubstituentPosition1());
            }
            catch (ResourcesDbException rEx) {
                ringAtom = null;
            }
            ringOStr = ringAtom == null ? "X" : ringAtom.getElementSymbol();
        }
        int oOffset = this.getCharacterCenterXOffset(ringOStr, true);
        this.drawLine(this.getBasepoint((int)4).x, this.getBasepoint((int)4).y, this.getBasepoint((int)5).x, this.getBasepoint((int)5).y);
        this.drawLineWithOffset(this.getBasepoint((int)6).x, this.getBasepoint((int)6).y, this.getBasepoint((int)5).x, this.getBasepoint((int)5).y, this.getStringWidth(ringOStr));
        this.drawLineWithOffset(this.getBasepoint((int)6).x, this.getBasepoint((int)6).y, this.getBasepoint((int)1).x, this.getBasepoint((int)1).y, (double)this.getTextSize() * 0.6);
        Polygon pg = new Polygon();
        int dp = Math.abs(this.getBasepoint((int)1).y - this.getBasepoint((int)2).y) / 10;
        pg.addPoint(this.getBasepoint((int)1).x, this.getBasepoint((int)1).y);
        pg.addPoint(this.getBasepoint((int)2).x, this.getBasepoint((int)2).y - dp);
        pg.addPoint(this.getBasepoint((int)3).x, this.getBasepoint((int)3).y - dp);
        pg.addPoint(this.getBasepoint((int)4).x, this.getBasepoint((int)4).y);
        pg.addPoint(this.getBasepoint((int)3).x, this.getBasepoint((int)3).y + dp);
        pg.addPoint(this.getBasepoint((int)2).x, this.getBasepoint((int)2).y + dp);
        this.fillShape(pg);
        this.drawString(ringOStr, this.getBasepoint((int)6).x + oOffset, this.getBasepoint((int)6).y + this.getTextSize() / 2);
    }

    private void drawFuranoseRingTemplate() {
        String ringOStr = "O";
        int oOffset = this.getCharacterCenterXOffset(ringOStr, false);
        this.drawLineWithOffset(this.getBasepoint((int)5).x, this.getBasepoint((int)5).y, this.getBasepoint((int)4).x, this.getBasepoint((int)4).y, (double)this.getTextSize() * 0.6);
        this.drawLineWithOffset(this.getBasepoint((int)5).x, this.getBasepoint((int)5).y, this.getBasepoint((int)1).x, this.getBasepoint((int)1).y, (double)this.getTextSize() * 0.6);
        Polygon pg = new Polygon();
        int dp = Math.abs(this.getBasepoint((int)1).y - this.getBasepoint((int)2).y) / 10;
        pg.addPoint(this.getBasepoint((int)1).x, this.getBasepoint((int)1).y);
        pg.addPoint(this.getBasepoint((int)2).x, this.getBasepoint((int)2).y - dp);
        pg.addPoint(this.getBasepoint((int)3).x, this.getBasepoint((int)3).y - dp);
        pg.addPoint(this.getBasepoint((int)4).x, this.getBasepoint((int)4).y);
        pg.addPoint(this.getBasepoint((int)3).x, this.getBasepoint((int)3).y + dp);
        pg.addPoint(this.getBasepoint((int)2).x, this.getBasepoint((int)2).y + dp);
        this.fillShape(pg);
        this.drawString(ringOStr, this.getBasepoint((int)5).x + oOffset, this.getBasepoint((int)5).y + (int)Math.floor((double)this.getTextSize() * 0.6));
    }

    private void drawPyranose() throws ResourcesDbException {
        this.setPyranoseBasepoints();
        this.calculateBasecenter();
        this.drawPyranoseRingTemplate();
        for (int i = 1; i < 6; ++i) {
            this.drawPyranoseRingPosition(i);
        }
    }

    private void drawPyranoseRingPosition(int i) throws ResourcesDbException {
        this.drawRingPosition(i);
    }

    private void drawRingPosition(int ringPos) throws ResourcesDbException {
        Monosaccharide ms = this.getMonosacc();
        int msPos = ringPos - 1 + ms.getRingStart();
        StereoConfiguration sConf = ms.getStereocode().getPositionConfiguration(msPos);
        if (msPos == ms.getRingEnd()) {
            sConf = StereoConfiguration.invert(sConf);
        }
        Point p = this.getBasepoint(ringPos);
        int x1 = p.x;
        int y1 = p.y;
        int x2 = x1;
        int y2 = y1;
        int yt = y1;
        int xt = x1;
        int x2_c = x1;
        int y2_c = y1;
        int xt_c = xt;
        int yt_c = yt;
        boolean alignLabelRight = false;
        boolean alignLabelRight_c = false;
        String substLabel = "";
        String substLabel_c = null;
        int bo = 1;
        if (sConf.equals((Object)StereoConfiguration.Dexter)) {
            x2 = p.x;
            y2 = p.y + this.lineLength;
            yt = y2 + this.getTextSize();
            bo = 1;
            x2_c = p.x;
            y2_c = p.y - this.lineLength;
            yt_c = y2_c - 2;
        } else if (sConf.equals((Object)StereoConfiguration.Laevus)) {
            x2 = p.x;
            y2 = p.y - this.lineLength;
            yt = y2 - 2;
            x2_c = p.x;
            y2_c = p.y + this.lineLength;
            yt_c = y2_c + this.getTextSize();
            bo = 1;
        } else if (sConf.equals((Object)StereoConfiguration.Nonchiral)) {
            for (CoreModification mod : ms.getCoreModificationsByPosition(msPos)) {
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) {
                    bo = 0;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.EN)) {
                    if (mod.getIntValuePosition1() == msPos) {
                        this.drawRingDoubleBond(ringPos);
                    }
                    int xc = this.getBaseCenter().x;
                    int yc = this.getBaseCenter().y;
                    x2 = x1 - xc;
                    y2 = y1 - yc;
                    double len = 15.0 / (double)Math.round((float)Math.sqrt(x2 * x2 + y2 * y2));
                    x2 = (int)((double)x1 + len * (double)x2);
                    y2 = (int)((double)y1 + len * (double)y2);
                    if (x2 > x1) {
                        xt = x2;
                    } else {
                        xt = x2;
                        alignLabelRight = true;
                    }
                    yt = y2 > y1 ? y2 + this.getSVGGraph2D().getFontMetrics().getHeight() : (y2 == y1 ? y2 + this.getSVGGraph2D().getFontMetrics().getHeight() / 2 : y2 - 2);
                }
                if (!mod.getTemplate().equals((Object)CoreModificationTemplate.SP2)) continue;
                bo = 2;
            }
        } else {
            throw new MonosaccharideException("Unsupported stereochemistry in Haworth formula: " + sConf.getFullname());
        }
        if (bo > 0) {
            ArrayList<Substitution> substList;
            if (ringPos == 4) {
                alignLabelRight = true;
            } else if (ringPos == 2 && sConf.equals((Object)StereoConfiguration.Laevus)) {
                alignLabelRight = true;
            }
            if (msPos != ms.getRingEnd()) {
                substList = ms.getSubstitutionsByPosition(msPos);
                if (substList != null && substList.size() > 0) {
                    for (Substitution subst : substList) {
                        if (!subst.getLinkagetype1().equals((Object)LinkageType.H_LOSE)) {
                            if (alignLabelRight) {
                                substLabel = subst.getTemplate().getMirroredHaworthName();
                                if (!subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) continue;
                                substLabel = substLabel + "O";
                                continue;
                            }
                            substLabel = subst.getTemplate().getHaworthName();
                            if (!subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) continue;
                            substLabel = "O" + substLabel;
                            continue;
                        }
                        if (alignLabelRight_c) {
                            substLabel_c = subst.getTemplate().getMirroredHaworthName();
                            continue;
                        }
                        substLabel_c = subst.getTemplate().getHaworthName();
                    }
                }
                if (substLabel.equals("")) {
                    substLabel = alignLabelRight ? HO : OH;
                }
            }
            if (msPos == ms.getRingEnd()) {
                if (msPos == ms.getSize()) {
                    return;
                }
                if (ms.getSize() - msPos == 1) {
                    if (ms.isAldaric() || ms.isUronic()) {
                        substList = ms.getSubstitutionsByPosition(ms.getSize());
                        Substitution subst = null;
                        if (substList != null && substList.size() > 0 && !(subst = substList.get(0)).getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                            throw new ResourcesDbException("cannot draw haworth projection for monosaccharide with substitution at acid group and linkage type " + subst.getLinkagetypeStr1());
                        }
                        if (sConf.equals((Object)StereoConfiguration.Laevus) || sConf.equals((Object)StereoConfiguration.Nonchiral) || ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
                            substLabel = subst == null ? HOOC : subst.getTemplate().getHaworthName() + "-" + OOC;
                            alignLabelRight = true;
                        } else {
                            substLabel = subst == null ? COOH : "COO-" + subst.getTemplate().getHaworthName();
                        }
                    } else if (!ms.hasCoreModification(CoreModificationTemplate.DEOXY, msPos + 1)) {
                        ArrayList<Substitution> substList2;
                        String c6label;
                        if (sConf.equals((Object)StereoConfiguration.Laevus) || sConf.equals((Object)StereoConfiguration.Nonchiral) || ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
                            this.drawLine(x2, y2, x2 - this.lineLength, y2);
                            c6label = HO;
                            substList2 = ms.getSubstitutionsByPosition(msPos + 1);
                            if (substList2 != null && substList2.size() > 0) {
                                Substitution subst = substList2.get(0);
                                c6label = subst.getTemplate().getMirroredHaworthName();
                                if (subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                                    c6label = c6label + "O";
                                }
                            }
                            this.drawString(c6label, x2 - this.lineLength - 2 - this.getSVGGraph2D().getFontMetrics().stringWidth(c6label), y2 - 2 + this.getSVGGraph2D().getFontMetrics().getHeight() / 2);
                        } else {
                            this.drawLine(x2, y2, x2 + this.lineLength, y2);
                            c6label = OH;
                            substList2 = ms.getSubstitutionsByPosition(msPos + 1);
                            if (substList2 != null && substList2.size() > 0) {
                                Substitution subst = substList2.get(0);
                                c6label = subst.getTemplate().getHaworthName();
                                if (subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                                    c6label = "O" + c6label;
                                }
                            }
                            this.drawString(c6label, x2 + this.lineLength + 2, y2 - 2 + this.getSVGGraph2D().getFontMetrics().getHeight() / 2);
                        }
                    } else if (sConf.equals((Object)StereoConfiguration.Laevus) || sConf.equals((Object)StereoConfiguration.Nonchiral) || ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
                        substLabel = H3C;
                        alignLabelRight = true;
                    } else {
                        substLabel = CH3;
                    }
                } else {
                    substLabel = ms.getRingStart() > 2 ? "R2" : "R";
                }
            }
            if (bo == 1) {
                this.drawLine(x1, y1, x2, y2);
                if (!substLabel.equals("")) {
                    if (xt == x1) {
                        xt += this.getCharacterCenterXOffset(substLabel, alignLabelRight);
                    } else if (xt == x2 && alignLabelRight) {
                        xt -= this.getSVGGraph2D().getFontMetrics().stringWidth(substLabel);
                    }
                    this.drawString(substLabel, xt, yt);
                }
                if (substLabel_c != null) {
                    this.drawLine(x1, y1, x2_c, y2_c);
                    if (xt_c == x1) {
                        xt_c += this.getCharacterCenterXOffset(substLabel, alignLabelRight);
                    } else if (xt_c == x2_c && alignLabelRight) {
                        xt_c -= this.getSVGGraph2D().getFontMetrics().stringWidth(substLabel);
                    }
                    if (!substLabel_c.equals("")) {
                        this.drawString(substLabel_c, xt_c, yt_c);
                    }
                }
            } else if (bo == 2) {
                throw new MonosaccharideException("Double bonds outside the ring are not supported yet.");
            }
        }
        if (ringPos == 1 && msPos > 1) {
            int x2b = x1;
            int y2b = y1;
            int xt2 = x1;
            int yt2 = y1;
            String substLabelC1 = null;
            if (sConf.equals((Object)StereoConfiguration.Dexter)) {
                y2b = y1 - this.lineLength;
                yt2 = y2b - 2;
            } else if (sConf.equals((Object)StereoConfiguration.Laevus)) {
                y2b = y1 + this.lineLength;
                yt2 = y2b + this.getTextSize();
            } else if (sConf.equals((Object)StereoConfiguration.Nonchiral)) {
                y2b = y1;
                yt2 = y2b + this.getTextSize() / 2;
                x2b = x1 + this.lineLength;
                xt2 = x2b + 2;
            }
            this.drawLine(x1, y1, x2b, y2b);
            if (msPos == 2) {
                if (ms.isAldaric() || ms.isAldonic()) {
                    ArrayList<Substitution> substList = ms.getSubstitutionsByPosition(1);
                    Substitution subst = null;
                    if (substList != null && substList.size() > 0 && !(subst = substList.get(0)).getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                        throw new ResourcesDbException("cannot draw haworth projection for monosaccharide with substitution at acid group and linkage type " + subst.getLinkagetypeStr1());
                    }
                    substLabelC1 = subst == null ? COOH : "COO-" + subst.getTemplate().getHaworthName();
                } else if (!ms.hasCoreModification(CoreModificationTemplate.DEOXY, 1)) {
                    if (sConf.equals((Object)StereoConfiguration.Nonchiral)) {
                        this.drawLine(x2b, y2b, x2b, y2b - this.lineLength);
                        xt2 = x2b + this.getCharacterCenterXOffset(substLabelC1, false);
                        yt2 = y2b - this.lineLength - 2;
                    } else {
                        this.drawLine(x1, y2b, x1 + this.lineLength, y2b);
                        xt2 = x1 + this.lineLength + 2;
                        if (sConf.equals((Object)StereoConfiguration.Dexter)) {
                            yt2 = yt2 + this.getTextSize() / 2 + 2;
                        } else if (sConf.equals((Object)StereoConfiguration.Laevus)) {
                            yt2 = yt2 - this.getTextSize() / 2 - 2;
                        }
                    }
                    substLabelC1 = OH;
                    ArrayList<Substitution> substList = ms.getSubstitutionsByPosition(1);
                    if (substList != null && substList.size() > 0) {
                        substLabelC1 = substList.get(0).getTemplate().getHaworthName();
                    }
                }
            } else {
                substLabelC1 = ms.getSize() - ms.getRingEnd() > 1 ? "R1" : "R";
            }
            if (substLabelC1 != null) {
                if (xt2 == x1) {
                    xt2 += this.getCharacterCenterXOffset(substLabelC1, false);
                }
                this.drawString(substLabelC1, xt2, yt2);
            }
        }
    }

    private void drawFuranose() throws ResourcesDbException {
        this.setFuranoseBasepoints();
        this.calculateBasecenter();
        this.drawFuranoseRingTemplate();
        for (int i = 1; i < 5; ++i) {
            this.drawFuranoseRingPosition(i);
        }
    }

    private void drawFuranoseRingPosition(int rPos) throws ResourcesDbException {
        this.drawRingPosition(rPos);
    }

    private void drawRingDoubleBond(int pos) {
        int xc = this.getBaseCenter().x;
        int yc = this.getBaseCenter().y;
        int lx1 = this.getBasepoint((int)pos).x;
        int ly1 = this.getBasepoint((int)pos).y;
        int lx2 = this.getBasepoint((int)(pos + 1)).x;
        int ly2 = this.getBasepoint((int)(pos + 1)).y;
        int dx1 = Math.abs(lx1 - xc);
        int dy1 = Math.abs(ly1 - yc);
        int dx2 = Math.abs(lx2 - xc);
        int dy2 = Math.abs(ly2 - yc);
        if (lx1 < xc) {
            lx1 = (int)((double)lx1 + 0.2 * (double)dx1);
        }
        if (lx1 > xc) {
            lx1 = (int)((double)lx1 - 0.2 * (double)dx1);
        }
        if (ly1 < yc) {
            ly1 = (int)((double)ly1 + 0.2 * (double)dy1);
        }
        if (ly1 > yc) {
            ly1 = (int)((double)ly1 - 0.2 * (double)dy1);
        }
        if (lx2 < xc) {
            lx2 = (int)((double)lx2 + 0.2 * (double)dx2);
        }
        if (lx2 > xc) {
            lx2 = (int)((double)lx2 - 0.2 * (double)dx2);
        }
        if (ly2 < yc) {
            ly2 = (int)((double)ly2 + 0.2 * (double)dy2);
        }
        if (ly2 > yc) {
            ly2 = (int)((double)ly2 - 0.2 * (double)dy2);
        }
        this.drawLine(lx1, ly1, lx2, ly2);
    }

    private void addRests() {
        String rLabel;
        SvgFactory r1 = null;
        SvgFactory r2 = null;
        if (this.getMonosacc().getRingStart() > 2) {
            r1 = this.drawRest(this.getMonosacc().getRingStart(), 1);
        }
        if (this.getMonosacc().getSize() - this.getMonosacc().getRingEnd() > 1) {
            r2 = this.drawRest(this.getMonosacc().getRingEnd(), this.getMonosacc().getSize());
        }
        int rx = this.getXMax() + 5;
        int ry = 0;
        if (r1 != null) {
            int ry1;
            int rx1;
            if (r2 == null) {
                rLabel = "R=";
                rx1 = rx;
                ry1 = ry + this.getTextSize();
            } else {
                rLabel = "R1=";
                rx1 = rx + this.getStringWidth(rLabel);
                ry1 = ry;
            }
            this.drawString(rLabel, rx, ry + this.getTextSize());
            this.addSubGraphic(r1, rx1, ry1);
            ry = r1.getYMax() + 5;
        }
        if (r2 != null) {
            int ry2;
            int rx2;
            if (r1 == null) {
                rLabel = "R=";
                rx2 = rx;
                ry2 = ry + this.getTextSize();
            } else {
                rLabel = "R2=";
                rx2 = rx + this.getStringWidth(rLabel);
                ry2 = ry;
            }
            this.drawString(rLabel, rx2, ry2);
            this.addSubGraphic(r2, rx2, ry2);
        }
    }

    private SvgFactory drawRest(int msStartPos, int msEndPos) {
        SvgFactory rest = new SvgFactory();
        Monosaccharide ms = this.getMonosacc();
        int currentY = 0;
        if (msStartPos > msEndPos) {
            int msPos = msStartPos;
            while (msPos >= msEndPos) {
                rest.drawLine(0, currentY, 0, currentY + this.lineLength);
                currentY += this.lineLength;
                if (ms.hasCoreModification(CoreModificationTemplate.DEOXY, --msPos)) continue;
            }
        } else {
            int msPos = msStartPos;
            while (msPos <= msEndPos) {
                rest.drawLine(0, currentY, 0, currentY + this.lineLength);
                currentY += this.lineLength;
                if (ms.hasCoreModification(CoreModificationTemplate.DEOXY, ++msPos)) continue;
            }
        }
        return rest;
    }

    public void drawMonosaccharide(Monosaccharide ms) throws ResourcesDbException {
        if (MonosaccharideValidation.checkFuzziness(ms)) {
            throw new ResourcesDbException("Cannot draw Haworth projection for monosaccharide with uncertain / fuzzy properties.");
        }
        if (ms.hasCoreModification(CoreModificationTemplate.ANHYDRO)) {
            throw new ResourcesDbException("Cannot draw Haworth projection for monosaccharide with anhydro modification.");
        }
        this.setMonosacc(ms);
        if (ms.getRingtype().equals((Object)Ringtype.PYRANOSE)) {
            this.drawPyranose();
        } else if (ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
            this.drawFuranose();
        } else {
            throw new ResourcesDbException("Cannot draw Haworth projection for monosaccharide with ring type " + ms.getRingtype().getName());
        }
        this.addRests();
        this.checkSize();
    }

    private void calculateBasecenter() throws MonosaccharideException {
        if (this.getBasepoints() == null) {
            throw new MonosaccharideException("Cannot calculate basecenter: basepoints not set");
        }
        int size = this.getBasepoints().size();
        if (size == 0) {
            throw new MonosaccharideException("Cannot calculate basecenter: basepoints not set");
        }
        int xSum = 0;
        int ySum = 0;
        for (Point p : this.getBasepoints()) {
            xSum = (int)((double)xSum + p.getX());
            ySum = (int)((double)ySum + p.getY());
        }
        this.setBaseCenter(new Point(xSum / size, ySum / size));
    }
}

