/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.util.ArrayList;
import java.util.HashMap;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrivialnameTemplate
extends BasetypeTemplate {
    private ArrayList<CoreModification> coreModifications;
    private ArrayList<Substitution> substitutions;
    private int substitutionCount;
    private boolean defaultConfigIsCompulsory;
    private ArrayList<GlycanNamescheme> nameschemes;
    private HashMap<String, HashMap<GlycanNamescheme, Boolean>> namesMap;
    private HashMap<GlycanNamescheme, ArrayList<String>> schemesMap;

    public TrivialnameTemplate() {
        this.init();
    }

    public ArrayList<CoreModification> getCoreModifications() {
        return this.coreModifications;
    }

    public void setCoreModifications(ArrayList<CoreModification> modifications) {
        this.coreModifications = modifications;
    }

    public void addCoreModification(CoreModification mod) throws MonosaccharideException {
        if (this.coreModifications == null) {
            this.setCoreModifications(new ArrayList<CoreModification>());
        }
        for (int i = 0; i < mod.getPositions().size(); ++i) {
            for (int m = 0; m < this.coreModifications.size(); ++m) {
                CoreModification exstMod = this.coreModifications.get(m);
                if (exstMod.equals(mod)) {
                    return;
                }
                if (mod.isSubstitutable() || exstMod.isSubstitutable() || !exstMod.getPositions().contains(mod.getPositions().get(i))) continue;
                throw new MonosaccharideException("Trivialname Template " + this.getLongName() + " modified twice at position " + mod.getPositions().get(i));
            }
        }
        this.coreModifications.add(mod);
    }

    public boolean hasCoreModification(CoreModification mod) {
        for (CoreModification presentMod : this.getCoreModifications()) {
            if (!presentMod.equals(mod)) continue;
            return true;
        }
        return false;
    }

    public int countCoreModifications(CoreModificationTemplate tmpl) {
        int count = 0;
        for (CoreModification tmplMod : this.getCoreModifications()) {
            if (!tmplMod.getTemplate().equals((Object)tmpl)) continue;
            ++count;
        }
        return count;
    }

    public int getCoreModificationCount() {
        return this.getCoreModifications().size();
    }

    public int getSubstitutionCount() {
        return this.substitutionCount;
    }

    public void setSubstitutionCount(int substCount) {
        this.substitutionCount = substCount;
    }

    public ArrayList<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public ArrayList<Substitution> getSubstitutionsClone() {
        ArrayList<Substitution> listClone = new ArrayList<Substitution>();
        for (Substitution subst : this.substitutions) {
            listClone.add(subst.clone());
        }
        return listClone;
    }

    public Substitution getSubstitutionByPosition(int position) {
        for (Substitution subst : this.getSubstitutions()) {
            if (subst.getIntValuePosition1() != position) continue;
            return subst;
        }
        return null;
    }

    public Substitution getSubstitutionByPosition(int position, LinkageType linktype) {
        for (Substitution subst : this.getSubstitutions()) {
            if (subst.getIntValuePosition1() != position || !subst.getLinkagetype1().equals((Object)linktype)) continue;
            return subst;
        }
        return null;
    }

    public void setSubstitutions(ArrayList<Substitution> substList) {
        this.substitutions = substList;
        this.setSubstitutionCount(this.substitutions.size());
    }

    public void addSubstitution(Substitution subst) throws MonosaccharideException {
        if (this.getSubstitutions() == null) {
            this.setSubstitutions(new ArrayList<Substitution>());
        }
        for (int i = 0; i < subst.getPositions().size(); ++i) {
            for (int m = 0; m < this.getSubstitutions().size(); ++m) {
                Substitution exstSubst = this.getSubstitutions().get(m);
                if (exstSubst.equals(subst)) {
                    return;
                }
                if (!exstSubst.getPositions().contains(subst.getPositions().get(i))) continue;
                throw new MonosaccharideException("Trivialname Template " + this.getLongName() + " modified twice at position " + subst.getPositions().get(i));
            }
        }
        this.getSubstitutions().add(subst);
        this.setSubstitutionCount(this.getSubstitutionCount() + 1);
    }

    public boolean hasSubstitution(Substitution subst) {
        for (Substitution presentSubst : this.getSubstitutions()) {
            if (!presentSubst.equals(subst)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultConfigIsCompulsory() {
        return this.defaultConfigIsCompulsory;
    }

    public void setDefaultConfigIsCompulsory(boolean flag) {
        this.defaultConfigIsCompulsory = flag;
    }

    public ArrayList<GlycanNamescheme> getNameschemes() {
        if (this.nameschemes == null) {
            this.nameschemes = new ArrayList();
        }
        return this.nameschemes;
    }

    public HashMap<GlycanNamescheme, ArrayList<String>> getSchemesMap() {
        if (this.schemesMap == null) {
            this.schemesMap = new HashMap();
        }
        return this.schemesMap;
    }

    private HashMap<String, HashMap<GlycanNamescheme, Boolean>> getNamesMap() {
        if (this.namesMap == null) {
            this.namesMap = new HashMap();
        }
        return this.namesMap;
    }

    public void addName(String name, GlycanNamescheme scheme, Boolean isPrimary) {
        HashMap<String, HashMap<GlycanNamescheme, Boolean>> namesMap;
        HashMap<GlycanNamescheme, Boolean> nameStringMap;
        ArrayList<String> namesList;
        ArrayList<GlycanNamescheme> schemesList = this.getNameschemes();
        if (!schemesList.contains((Object)scheme)) {
            schemesList.add(scheme);
        }
        if ((namesList = this.getSchemesMap().get((Object)scheme)) == null) {
            namesList = new ArrayList();
            this.getSchemesMap().put(scheme, namesList);
        }
        if (!namesList.contains(name)) {
            namesList.add(name);
        }
        if ((nameStringMap = (namesMap = this.getNamesMap()).get(name)) == null) {
            nameStringMap = new HashMap();
            namesMap.put(name, nameStringMap);
        }
        nameStringMap.put(scheme, isPrimary);
    }

    public boolean isPrimaryName(GlycanNamescheme scheme, String name) {
        Boolean flagObj;
        HashMap<GlycanNamescheme, Boolean> primaryMap = this.getNamesMap().get(name);
        if (primaryMap != null && (flagObj = primaryMap.get((Object)scheme)) != null) {
            return flagObj;
        }
        return false;
    }

    public String getPrimaryName(GlycanNamescheme scheme) {
        ArrayList<String> namesList = this.getNamesList(scheme);
        if (namesList != null) {
            for (String name : namesList) {
                if (!this.isPrimaryName(scheme, name)) continue;
                return name;
            }
        }
        return null;
    }

    public boolean isTrivialName(GlycanNamescheme scheme, String name) {
        HashMap<GlycanNamescheme, Boolean> primaryMap = this.getNamesMap().get(name);
        if (primaryMap != null) {
            Boolean flagObj = primaryMap.get((Object)scheme);
            return flagObj != null;
        }
        return false;
    }

    public ArrayList<String> getNamesList(GlycanNamescheme scheme) {
        return this.getSchemesMap().get((Object)scheme);
    }

    @Override
    public void init() {
        super.init();
        this.setCoreModifications(new ArrayList<CoreModification>());
        this.setSubstitutions(new ArrayList<Substitution>());
        this.setIsSuperclass(false);
    }

    @Override
    public String toString() {
        String outStr = "";
        outStr = outStr + this.getLongName();
        outStr = outStr + " [" + this.getSize() + "|" + this.getStereocode() + "|" + (Object)((Object)this.getDefaultConfiguration()) + "|" + this.getDefaultRingend() + "]";
        String modStr = "";
        if (this.getCoreModifications() != null) {
            for (int i = 0; i < this.getCoreModifications().size(); ++i) {
                modStr = modStr + this.getCoreModifications().get(i).toString();
            }
        }
        String substStr = "";
        if (this.getSubstitutions() != null) {
            for (Substitution subst : this.getSubstitutions()) {
                substStr = substStr + subst.toString();
            }
        }
        if (this.getCoreModificationCount() > 0) {
            outStr = outStr + " CoreModifications: " + modStr;
        }
        if (this.getSubstitutionCount() > 0) {
            outStr = outStr + " Substitutions: " + substStr;
        }
        return outStr;
    }
}

