/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.config;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ImageRegistry {
    private static Logger logger = Logger.getLogger(ImageRegistry.class);
    private static final String IMAGE_PATH = "icons" + File.separator;
    private static Map<ExperimentDesignerImage, ImageDescriptor> imageCache = new HashMap<ExperimentDesignerImage, ImageDescriptor>();

    public static ImageDescriptor getImageDescriptor(ExperimentDesignerImage sampleImage) {
        logger.debug((Object)("Get image from experiment designer plugin : " + (Object)((Object)sampleImage)));
        ImageDescriptor imageDescriptor = null;
        if (sampleImage != null) {
            imageDescriptor = imageCache.get((Object)sampleImage);
            if (imageDescriptor == null) {
                logger.debug((Object)"ImageDescriptor not found in cache");
                URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.editor.experimentdesigner"), (IPath)new Path(String.valueOf(IMAGE_PATH) + sampleImage.iconName), null);
                logger.debug((Object)("Loading image from url : " + fullPathString));
                if (fullPathString != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                    imageCache.put(sampleImage, imageDescriptor);
                }
            }
        } else {
            logger.error((Object)"Cannot load image from experiment designer plugin (image name is null)");
        }
        return imageDescriptor;
    }

    public static ImageDescriptor getSmallIcon(String iconName) {
        URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.editor.experimentdesigner"), (IPath)new Path(String.valueOf(IMAGE_PATH) + "16" + File.separator + iconName), null);
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    public static ImageDescriptor getLargeIcon(String iconName) {
        URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.editor.experimentdesigner"), (IPath)new Path(String.valueOf(IMAGE_PATH) + "24" + File.separator + iconName), null);
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    public static enum ExperimentDesignerImage {
        EXPERIMENTDESIGNICON("experimentdesign.png"),
        SAVEASTEMPLATE("saveas-template16.png"),
        PRINTICON("printer-icon.png"),
        SAVEASTEMPLATEBIG("saveas-template.png"),
        SAVEASEMPLATEBIGDISABLED("saveas-template-disabled.png"),
        CONNECTION16("connection_s16.gif"),
        CONNECTION24("connection_s24.gif"),
        WORDICON("page-white-word-icon.png"),
        PDFICON("pdf-icon.png"),
        ELLIPSEICON("ellipse16.gif");

        private String iconName = null;

        private ExperimentDesignerImage(String iconName) {
            this.iconName = iconName;
        }
    }
}

