/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileHistory;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.NotesDocument;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.SpectraDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ReportingPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ScanPropertiesDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;

public class WorkspacePanel
extends JPanel
implements TreeModel,
ActionListener,
TreeSelectionListener,
BaseDocument.DocumentChangeListener,
GlycanWorkspace.Listener,
MouseListener {
    private static boolean PAINT_BOX_ON_NONROOT_ITEMS = false;
    private static final long serialVersionUID = 0L;
    protected GlycoWorkbench theApplication;
    protected JTree theTree;
    protected JScrollPane theScrollPane;
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected GlycanWorkspace theWorkspace;
    protected ActionManager theActionManager;
    protected Vector<TreeModelListener> tm_listeners;
    Double edit_mz = null;
    Double edit_int = null;

    public WorkspacePanel(GlycoWorkbench application) {
        super(new BorderLayout());
        this.theApplication = application;
        this.theWorkspace = new GlycanWorkspace((GlycanRenderer)new GlycanRendererAWT());
        this.theActionManager = new ActionManager();
        this.createActions();
        this.tm_listeners = new Vector();
        this.theTree = new JTree();
        this.theTree.setEditable(false);
        this.theTree.setDragEnabled(false);
        this.theTree.setRootVisible(true);
        this.theTree.setToggleClickCount(3);
        this.theTree.setCellRenderer(new WorkspaceTreeCellRenderer());
        this.theTree.getSelectionModel().setSelectionMode(1);
        this.theTree.setModel(this);
        this.theScrollPane = new JScrollPane(this.theTree);
        this.add((Component)this.theScrollPane, "Center");
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        this.add((Component)theToolBarPanel, "South");
        this.theWorkspace.addDocumentChangeListener(this);
        this.theWorkspace.addWorkspaceListener(this);
        this.theTree.addTreeSelectionListener(this);
        this.theTree.addMouseListener(this);
        this.expandAll();
        this.setMinimumSize(new Dimension(0, 0));
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.updateActions();
        this.updateView();
    }

    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theWorkspace.addWorkspaceListener(this);
        this.theWorkspace.addDocumentChangeListener(this);
        this.updateActions();
        this.updateView();
    }

    private void createActions() {
        this.theActionManager.add("new", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear selected document", 78, "", (ActionListener)this);
        this.theActionManager.add("open", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open selected document", 79, "", (ActionListener)this);
        this.theActionManager.add("save", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save selected document", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save selected document as...", 65, "", (ActionListener)this);
        this.theActionManager.add("newall", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear the workspace", -1, "", (ActionListener)this);
        this.theActionManager.add("openall", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open a workspace", -1, "", (ActionListener)this);
        this.theActionManager.add("saveall", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save the workspace", -1, "", (ActionListener)this);
        this.theActionManager.add("saveallas", this.theApplication.getThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save the workspace as...", -1, "", (ActionListener)this);
        this.theActionManager.add("add", this.theApplication.getThemeManager().getResizableIcon("addscan", Plugin.DEFAULT_ICON_SIZE), "Attach new scan", 68, "", (ActionListener)this);
        this.theActionManager.add("delete", this.theApplication.getThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", 69, "", (ActionListener)this);
        this.theActionManager.add("select", this.theApplication.getThemeManager().getResizableIcon("select", Plugin.DEFAULT_ICON_SIZE), "Activate", 76, "", (ActionListener)this);
        this.theActionManager.add("sync", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Pull annotated structures from parent", -1, "", (ActionListener)this);
        this.theActionManager.add("properties", this.theApplication.getThemeManager().getResizableIcon("properties", Plugin.DEFAULT_ICON_SIZE), "Properties", 80, "", (ActionListener)this);
    }

    private void updateActions() {
        this.theActionManager.get("new").setEnabled(this.hasSelectedDocument() && !this.hasSelectedAnnotationReport());
        this.theActionManager.get("open").setEnabled(this.hasSelectedDocument());
        this.theActionManager.get("save").setEnabled(this.hasSelectedDocument() && !this.hasSelectedSpectra());
        this.theActionManager.get("saveas").setEnabled(this.hasSelectedDocument() && !this.hasSelectedSpectra());
        this.theActionManager.get("delete").setEnabled(this.hasSelectedScan() || this.hasSelectedAnnotationReport());
        this.theActionManager.get("select").setEnabled(this.hasSelection());
        this.theActionManager.get("properties").setEnabled(this.hasSelectedScan());
        this.theActionManager.get("sync").setEnabled(this.hasSelectedScan());
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("add"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("properties"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        return null;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("open"));
        menu.add((Action)this.theActionManager.get("save"));
        menu.add((Action)this.theActionManager.get("saveas"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("add"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("sync"));
        menu.add((Action)this.theActionManager.get("properties"));
        return menu;
    }

    private void showPopup(MouseEvent e) {
        this.theTree.setSelectionPath(this.theTree.getClosestPathForLocation(e.getX(), e.getY()));
        this.createPopupMenu().show(this, e.getX(), e.getY());
    }

    public boolean hasSelection() {
        return this.theTree.getSelectionPath() != null;
    }

    public boolean hasSelectedWorkspace() {
        return this.getSelectedObject() instanceof GlycanWorkspace;
    }

    public boolean hasSelectedSpectra() {
        return this.getSelectedObject() instanceof SpectraDocument;
    }

    public boolean hasSelectedScan() {
        return this.getSelectedObject() instanceof Scan;
    }

    public boolean hasSelectedAnnotationReport() {
        return this.getSelectedObject() instanceof AnnotationReportDocument;
    }

    public boolean hasSelectedDocument() {
        return this.getSelectedObject() instanceof BaseDocument;
    }

    public Object getSelectedObject() {
        TreePath sel = this.theTree.getSelectionPath();
        if (sel != null) {
            return sel.getLastPathComponent();
        }
        return null;
    }

    public Scan getSelectedScan() {
        Object node = this.getSelectedObject();
        if (node != null && node instanceof Scan) {
            return (Scan)node;
        }
        return null;
    }

    public AnnotationReportDocument getSelectedAnnotationReport() {
        Object node = this.getSelectedObject();
        if (node != null && node instanceof AnnotationReportDocument) {
            return (AnnotationReportDocument)((Object)node);
        }
        return null;
    }

    public BaseDocument getSelectedDocument() {
        Object node = this.getSelectedObject();
        if (node != null && node instanceof BaseDocument) {
            return (BaseDocument)node;
        }
        return null;
    }

    public Scan getSelectedObjectOrParentScan() {
        TreePath sel = this.theTree.getSelectionPath();
        if (sel != null) {
            Object node = sel.getLastPathComponent();
            if (node instanceof Scan) {
                return (Scan)node;
            }
            if (node instanceof GlycanDocument || node instanceof FragmentDocument || node instanceof SpectraDocument || node instanceof PeakList || node instanceof AnnotatedPeakList || node instanceof NotesDocument || node instanceof AnnotationReportDocument) {
                return (Scan)sel.getParentPath().getLastPathComponent();
            }
        }
        return null;
    }

    public void expandAll() {
        for (Scan s : this.theWorkspace.getScanList()) {
            this.expandSubTree(s);
        }
    }

    public void expandSubTree(Scan s) {
        this.expand(s);
        for (Scan c : s.getChildren()) {
            this.expandSubTree(c);
        }
    }

    public void expand(Object node) {
        this.theTree.expandPath(this.getTreePath(node));
    }

    @Override
    public Object getRoot() {
        return this.theWorkspace;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.theWorkspace) {
            return this.theWorkspace.scanAt(index);
        }
        if (parent instanceof Scan) {
            if (index == 0) {
                return ((Scan)parent).getStructures();
            }
            if (index == 1) {
                return ((Scan)parent).getFragments();
            }
            if (index == 2) {
                return ((Scan)parent).getSpectra();
            }
            if (index == 3) {
                return ((Scan)parent).getPeakList();
            }
            if (index == 4) {
                return ((Scan)parent).getAnnotatedPeakList();
            }
            if (index == 5) {
                return ((Scan)parent).getNotes();
            }
            if (index >= 6 && index <= 5 + ((Scan)parent).getAnnotationReports().size()) {
                return ((Scan)parent).getAnnotationReports().get(index - 6);
            }
            return ((Scan)parent).childAt(index - ((Scan)parent).getAnnotationReports().size() - 6);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.theWorkspace) {
            return this.theWorkspace.indexOf((Scan)child);
        }
        if (parent instanceof Scan) {
            if (child == ((Scan)parent).getStructures()) {
                return 0;
            }
            if (child == ((Scan)parent).getFragments()) {
                return 1;
            }
            if (child == ((Scan)parent).getSpectra()) {
                return 2;
            }
            if (child == ((Scan)parent).getPeakList()) {
                return 3;
            }
            if (child == ((Scan)parent).getAnnotatedPeakList()) {
                return 4;
            }
            if (child == ((Scan)parent).getNotes()) {
                return 5;
            }
            if (((Scan)parent).getAnnotationReports().contains(child)) {
                return 6 + ((Scan)parent).getAnnotationReports().indexOf(child);
            }
            if (child instanceof Scan) {
                return 6 + ((Scan)parent).getAnnotationReports().size() + ((Scan)parent).indexOf((Scan)child);
            }
        }
        return -1;
    }

    public TreePath getTreePath(Object node) {
        if (node == this.theWorkspace) {
            return new TreePath((Object)this.theWorkspace);
        }
        for (Scan s : this.theWorkspace.getScanList()) {
            TreePath ret = this.getTreePath((Union<Object>)new Union((Object)this.theWorkspace), s, node);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private TreePath getTreePath(Union<Object> path, Scan cur_node, Object node) {
        if (cur_node == node) {
            return new TreePath(path.and((Object)cur_node).toArray());
        }
        if (node == cur_node.getStructures()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (node == cur_node.getFragments()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (node == cur_node.getSpectra()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (node == cur_node.getPeakList()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (node == cur_node.getAnnotatedPeakList()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (node == cur_node.getNotes()) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        if (cur_node.getAnnotationReports().contains(node)) {
            return new TreePath(path.and((Object)cur_node).and(node).toArray());
        }
        for (Scan s : cur_node.getChildren()) {
            TreePath ret = this.getTreePath((Union<Object>)path.and((Object)cur_node), s, node);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.theWorkspace) {
            return this.theWorkspace.getNoScans();
        }
        if (parent instanceof Scan) {
            return 6 + ((Scan)parent).getAnnotationReports().size() + ((Scan)parent).getNoChildren();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node != this.theWorkspace && !(node instanceof Scan);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l != null) {
            this.tm_listeners.add(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.tm_listeners.remove(l);
    }

    public boolean checkDocumentChanges() {
        return true;
    }

    public void updateView() {
        this.fireTreeStructureChanged((Object)this.theWorkspace);
        this.expandAll();
    }

    public void onPrint() {
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void copy() {
    }

    public void paste() {
    }

    public boolean sync() {
        Scan scan;
        if (this.hasSelectedScan() && (scan = this.getSelectedScan()) != null) {
            return this.theWorkspace.syncScan(scan);
        }
        return false;
    }

    public void delete() {
        if (this.hasSelectedScan()) {
            Scan s = this.getSelectedScan();
            if (s != null && JOptionPane.showConfirmDialog(this, "Are you sure to remove the selected scan, its children, and all the data associated?") == 0) {
                this.theWorkspace.removeScan(s.getParent(), s);
            }
        } else {
            AnnotationReportDocument ard = this.getSelectedAnnotationReport();
            if (ard != null && JOptionPane.showConfirmDialog(this, "Are you sure to remove the selected annotation report?") == 0) {
                this.theWorkspace.removeAnnotationReport(ard);
            }
        }
    }

    public void onAdd() {
        Scan s = this.getSelectedObjectOrParentScan();
        Scan childScan = new Scan(this.theWorkspace);
        childScan.setMsMs(true);
        this.theWorkspace.addScan(s, childScan);
    }

    public void onSelect() {
        try {
            Object sel = this.getSelectedObject();
            if (sel instanceof Scan) {
                this.select((Scan)sel);
            } else if (sel instanceof GlycanDocument) {
                this.select(this.getSelectedObjectOrParentScan());
            } else if (sel instanceof FragmentDocument) {
                this.select(this.getSelectedObjectOrParentScan());
                this.theApplication.getPluginManager().show("Fragments", "Summary");
            } else if (sel instanceof SpectraDocument) {
                this.select(this.getSelectedObjectOrParentScan());
                this.theApplication.getPluginManager().show("Spectra", "Spectra");
            } else if (sel instanceof PeakList) {
                this.select(this.getSelectedObjectOrParentScan());
                this.theApplication.getPluginManager().show("PeakList", "PeakList");
            } else if (sel instanceof AnnotatedPeakList) {
                this.select(this.getSelectedObjectOrParentScan());
                this.theApplication.getPluginManager().show("Annotation", "Summary");
            } else if (sel instanceof NotesDocument) {
                this.select(this.getSelectedObjectOrParentScan());
                this.theApplication.getPluginManager().show("Notes", "Notes");
            } else if (sel instanceof AnnotationReportDocument) {
                this.select(this.getSelectedObjectOrParentScan());
                ((ReportingPlugin)this.theApplication.getPluginManager().get("Reporting")).showAnnotationsReport((AnnotationReportDocument)((Object)sel), false);
            }
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    public void select(Scan s) {
        if (s != null) {
            this.theWorkspace.setCurrentScan(s);
        }
    }

    public void onProperties() {
        Scan s = this.getSelectedScan();
        if (s != null) {
            new ScanPropertiesDialog((Frame)((Object)this.theApplication), s, this.theWorkspace).setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("newall")) {
            this.theApplication.onNew((BaseDocument)this.theWorkspace);
        } else if (action.equals("openall")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theWorkspace, false);
        } else if (action.equals("saveall")) {
            this.theApplication.onSave((BaseDocument)this.theWorkspace);
        } else if (action.equals("saveallas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theWorkspace);
        } else if (action.equals("new")) {
            this.theApplication.onNew(this.getSelectedDocument());
        } else if (action.equals("open")) {
            if (this.theApplication.onOpen(null, this.getSelectedDocument(), false)) {
                this.onSelect();
            }
        } else if (action.equals("save")) {
            this.theApplication.onSave(this.getSelectedDocument());
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs(this.getSelectedDocument());
        }
        if (action.equals("add")) {
            this.onAdd();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("select")) {
            this.onSelect();
        } else if (action.equals("properties")) {
            this.onProperties();
        } else if (action.equals("sync")) {
            this.sync();
        }
        this.updateActions();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateActions();
    }

    @Override
    public void currentScanChanged(GlycanWorkspace.Event e) {
        this.fireTreeNodesChanged(e.getChildScan());
        this.fireTreeNodesChanged(e.getCurrentScan());
        this.updateActions();
    }

    @Override
    public void scanAdded(GlycanWorkspace.Event e) {
        this.fireTreeNodesInserted(e.getParentScan(), e.getChildScan(), e.getIndex());
        this.expand(e.getChildScan());
        this.updateActions();
    }

    @Override
    public void scanRemoved(GlycanWorkspace.Event e) {
        this.fireTreeNodesRemoved(e.getParentScan(), e.getChildScan(), e.getIndex());
        this.updateActions();
    }

    @Override
    public void internalDocumentChanged(GlycanWorkspace.Event e) {
        this.fireTreeNodesChanged(e.getSource());
        this.updateActions();
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.fireTreeStructureChanged(e.getSource());
        this.updateActions();
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theWorkspace) {
            this.fireTreeStructureChanged(e.getSource());
        } else {
            this.fireTreeNodesChanged(e.getSource());
        }
        this.updateActions();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (MouseUtils.isSelectTrigger((MouseEvent)e)) {
            this.onSelect();
        }
    }

    public void fireTreeNodesChanged(Object node) {
        for (TreeModelListener tml : this.tm_listeners) {
            tml.treeNodesChanged(new TreeModelEvent((Object)this, this.getTreePath(node)));
        }
    }

    public void fireTreeNodesInserted(Object parent, Object child, int index) {
        TreePath par_path = parent == null ? this.getTreePath((Object)this.theWorkspace) : this.getTreePath(parent);
        for (TreeModelListener tml : this.tm_listeners) {
            tml.treeNodesInserted(new TreeModelEvent((Object)this, par_path, new int[]{index}, new Object[]{child}));
        }
    }

    public void fireTreeNodesRemoved(Object parent, Object child, int index) {
        TreePath par_path = parent == null ? this.getTreePath((Object)this.theWorkspace) : this.getTreePath(parent);
        for (TreeModelListener tml : this.tm_listeners) {
            tml.treeNodesRemoved(new TreeModelEvent((Object)this, par_path, new int[]{index}, new Object[]{child}));
        }
    }

    public void fireTreeStructureChanged(Object node) {
        TreePath path = node == null ? this.getTreePath((Object)this.theWorkspace) : this.getTreePath(node);
        for (TreeModelListener tml : this.tm_listeners) {
            tml.treeStructureChanged(new TreeModelEvent((Object)this, path));
        }
        this.expandAll();
    }

    class WorkspaceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        WorkspaceTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (GlycoWorkbench.SUBSTANCE_ENABLED) {
                Component component = super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, hasFocus);
                this.setFont(this.getFont().deriveFont(0));
                super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, hasFocus);
                this.setFont(this.getFont().deriveFont(0));
                if (value instanceof BaseDocument) {
                    CustomJLabel master;
                    BaseDocument doc = (BaseDocument)value;
                    if (doc.getRegisteredComponent("treeView") != null) {
                        master = (CustomJLabel)doc.getRegisteredComponent("treeView");
                    } else {
                        master = new CustomJLabel();
                        master.setUI(this.getUI());
                        if (leaf) {
                            master.setIcon(doc.getIcon());
                        }
                    }
                    String text = doc.getName();
                    if (doc.wasSaved()) {
                        text = text + " - " + FileHistory.getAbbreviatedName((String)doc.getFileName());
                    }
                    if (doc.hasChanged()) {
                        text = text + "*";
                    }
                    master.setText(text);
                    if (!PAINT_BOX_ON_NONROOT_ITEMS) {
                        if (this.selected) {
                            master.setBackground(this.backgroundSelectionColor);
                        } else {
                            master.setBackground(this.backgroundNonSelectionColor);
                        }
                    }
                    doc.registerComponent("treeView", (Component)master);
                    return master;
                }
                if (value instanceof Scan) {
                    String text;
                    Scan scan = (Scan)value;
                    String string = text = scan.getName() != null && scan.getName().length() > 0 ? scan.getName() : "Scan";
                    if (scan.getPrecursorMZ() != null) {
                        text = text + " [precursor m/z= " + new DecimalFormat("0.0000").format(scan.getPrecursorMZ()) + " Da]";
                    }
                    this.setText(text);
                    if (WorkspacePanel.this.theWorkspace.isCurrent(scan)) {
                        this.setFont(this.getFont().deriveFont(1));
                    }
                }
                return this;
            }
            super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, hasFocus);
            this.setFont(this.getFont().deriveFont(0));
            if (value instanceof BaseDocument) {
                BaseDocument doc = (BaseDocument)value;
                String text = doc.getName();
                if (doc.wasSaved()) {
                    text = text + " - " + FileHistory.getAbbreviatedName((String)doc.getFileName());
                }
                if (doc.hasChanged()) {
                    text = text + "*";
                }
                this.setText(text);
                if (leaf) {
                    this.setIcon(doc.getIcon());
                }
            } else if (value instanceof Scan) {
                String text;
                Scan scan = (Scan)value;
                String string = text = scan.getName() != null && scan.getName().length() > 0 ? scan.getName() : "Scan";
                if (scan.getPrecursorMZ() != null) {
                    text = text + " [precursor m/z= " + new DecimalFormat("0.0000").format(scan.getPrecursorMZ()) + " Da]";
                }
                this.setText(text);
                if (WorkspacePanel.this.theWorkspace.isCurrent(scan)) {
                    this.setFont(this.getFont().deriveFont(1));
                }
            }
            return this;
        }

        class CustomJLabel
        extends JLabel {
            CustomJLabel() {
            }

            @Override
            public void paint(Graphics g) {
                if (PAINT_BOX_ON_NONROOT_ITEMS) {
                    if (WorkspaceTreeCellRenderer.this.selected) {
                        g.setColor(WorkspaceTreeCellRenderer.this.backgroundSelectionColor);
                    } else {
                        g.setColor(WorkspaceTreeCellRenderer.this.backgroundNonSelectionColor);
                    }
                    g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
                super.paint(g);
            }
        }
    }
}

