/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class MyListDialog
extends TrayDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private int widthInChars = 55;
    private int heightInChars = 15;
    private List initialSelections;
    private Object[] result;
    private String message = "";

    public MyListDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setContentProvider(IStructuredContentProvider sp) {
        this.fContentProvider = sp;
    }

    public void setLabelProvider(ILabelProvider lp) {
        this.fLabelProvider = lp;
    }

    public void setAddCancelButton(boolean addCancelButton) {
        this.fAddCancelButton = addCancelButton;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fAddCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fTableViewer = new TableViewer(parent, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setInput(this.fInput);
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (MyListDialog.this.fAddCancelButton) {
                    MyListDialog.this.okPressed();
                }
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        return parent;
    }

    private List getInitialElementSelections() {
        return this.initialSelections;
    }

    private Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    public void setInitialElementSelections(List selectedElements) {
        this.initialSelections = selectedElements;
    }

    protected int getTableStyle() {
        return 2820;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }

    private void setResult(List newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    public int getHeightInChars() {
        return this.heightInChars;
    }

    public int getWidthInChars() {
        return this.widthInChars;
    }

    public void setHeightInChars(int heightInChars) {
        this.heightInChars = heightInChars;
    }

    public void setWidthInChars(int widthInChars) {
        this.widthInChars = widthInChars;
    }

    public List getInitialSelections() {
        if (this.initialSelections.isEmpty()) {
            return null;
        }
        return this.getInitialElementSelections();
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.initialSelections.add(selectedElements[i]);
            ++i;
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    public void setResult(Object[] result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

