/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.entry.sample.handler.NewAnalyteHandler;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.utilities.UtilityFile;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.BatchOfAnalytesWizard;

public class NewBatchOfAnalytesHandler {
    private static final Logger logger = Logger.getLogger(NewBatchOfAnalytesHandler.class);
    @Inject
    static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell) {
        logger.info((Object)"- START   COMMAND : Create batch of new Analytes. ");
        try {
            List<Entry> analyteEntries;
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.project".equals(selectedEntry.getProperty().getType()))) {
                selectedEntry = null;
            }
            if (!(analyteEntries = this.createNewAnalytes(shell, selectedEntry)).isEmpty()) {
                Entry firstEntry = analyteEntries.iterator().next();
                logger.info((Object)("Opening one of the created new Analytes : " + firstEntry.getDisplayName()));
                eventBroker.post("grits_entry_selected", (Object)firstEntry);
                gritsUIService.openEntryInPart(firstEntry);
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error creating batch of new Analytes : " + ex.getMessage()), (Throwable)ex);
            MessageDialog.openError((Shell)shell, (String)"Error Creating Analytes", (String)("Unable to create batch of new Analytes.\n" + ex.getMessage()));
        }
        logger.info((Object)"- END   COMMAND : Create batch of new Analytes. ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Entry> createNewAnalytes(Shell shell, Entry projectEntry) {
        logger.info((Object)"Opening wizard for creating batch of analytes");
        ArrayList<Entry> analyteEntries = new ArrayList<Entry>();
        BatchOfAnalytesWizard wizard = new BatchOfAnalytesWizard();
        wizard.setWindowTitle("Analytes Wizard");
        wizard.setProjectEntry(projectEntry);
        WizardDialog dialog = new WizardDialog(PropertyHandler.getModalDialog((Shell)shell), (IWizard)wizard);
        if (dialog.open() != 0) return analyteEntries;
        Entry selectedProjectEntry = wizard.getProjectEntry();
        logger.info((Object)("Retrieving sample folder for the selected project \"" + selectedProjectEntry.getDisplayName() + "\""));
        File sampleFolder = UtilityFile.getSampleGroupDirectory(selectedProjectEntry.getDisplayName());
        try {
            Iterator iterator;
            IOException e2;
            Entry newAnalyteEntry = null;
            String newSampleFileName = null;
            Iterator<Sample> iterator2 = wizard.getSamples().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    try {
                        ProjectFileHandler.saveProject((Entry)selectedProjectEntry);
                        return analyteEntries;
                    }
                    catch (IOException e2) {
                        logger.fatal((Object)("Something went wrong while saving project entry \"" + selectedProjectEntry.getDisplayName() + "\" Removing all new analyte entries from the project.\n" + e2.getMessage()), (Throwable)e2);
                        iterator = analyteEntries.iterator();
                        break;
                    }
                }
                Sample sample = iterator2.next();
                try {
                    newAnalyteEntry = null;
                    newSampleFileName = UtilityFile.generateFileName(sampleFolder.list());
                    logger.info((Object)("Creating sample file \"" + newSampleFileName + "\" for sample \"" + sample.getName() + "\""));
                    UtilityFile.writeToFile(sample, String.valueOf(sampleFolder.getAbsolutePath()) + File.separator + newSampleFileName);
                    logger.info((Object)("Create analyte entry \"" + sample.getName() + "and add it to the project entry \"" + selectedProjectEntry.getDisplayName() + "\""));
                    newAnalyteEntry = NewAnalyteHandler.createEntry(sample.getName(), newSampleFileName);
                    gritsDataModelService.addEntry(selectedProjectEntry, newAnalyteEntry);
                    analyteEntries.add(newAnalyteEntry);
                }
                catch (Exception e3) {
                    logger.error((Object)e3.getMessage(), (Throwable)e3);
                    if (newAnalyteEntry == null) continue;
                    logger.error((Object)("Something went wrong creating this analyte \"" + newAnalyteEntry.getDisplayName() + "\" in this project \"" + selectedProjectEntry.getDisplayName() + "\". Removing this entry from project."));
                    gritsDataModelService.removeEntry(selectedProjectEntry, newAnalyteEntry);
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    logger.fatal((Object)("Closing project entry \"" + selectedProjectEntry.getDisplayName() + "\""));
                    gritsDataModelService.closeProject(selectedProjectEntry);
                    analyteEntries.clear();
                    throw e2;
                }
                Entry analyteEntry = (Entry)iterator.next();
                gritsDataModelService.removeEntry(selectedProjectEntry, analyteEntry);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)shell, (String)"Error Creating Analytes", (String)("Something went wrong while creating new analyte entries.\n" + e.getMessage()));
        }
        return analyteEntries;
    }
}

