/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.ontologymanager;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.ontologymanager.SampleOntologyManager;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.UtilityOntologyLocation;

public class SampleOntologyApi
implements ISampleOntologyApi {
    private Logger logger = Logger.getLogger(SampleOntologyApi.class);
    protected SampleOntologyManager ontologyManager = null;
    protected File standardOntologyFile = null;
    protected File localOntologyFile = null;
    protected OntModel localOntModel = null;

    public SampleOntologyApi() throws IOException, Exception {
        this.logger.info((Object)"loading sample ontologies");
        try {
            this.logger.info((Object)"loading standard sample ontology");
            this.standardOntologyFile = new File(UtilityOntologyLocation.getStandardOntologyLocation());
            FileInputStream fileInputStream = new FileInputStream(this.standardOntologyFile);
            OntModel standardOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
            standardOntModel.read((InputStream)fileInputStream, "http://www.grits-toolbox.org/ontology/sample#");
            this.ontologyManager = new SampleOntologyManager(standardOntModel);
            this.logger.info((Object)"loading local sample ontology");
            this.localOntologyFile = new File(UtilityOntologyLocation.getLocalOntologyLocation());
            fileInputStream = new FileInputStream(this.localOntologyFile);
            this.localOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
            this.localOntModel.read((InputStream)fileInputStream, "http://www.grits-toolbox.org/ontology/sample#");
        }
        catch (IOException ex) {
            this.logger.error((Object)("error reading ontologies\n" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.fatal((Object)("something went wrong while loading ontologies\n" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        this.logger.info((Object)"sample ontologies loaded");
    }

    protected OntModel getStandardOntModel() {
        return this.ontologyManager.getStandardOntModel();
    }

    @Override
    public List<Descriptor> getAllDescriptors() {
        this.logger.info((Object)"loading all descriptors");
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        this.logger.info((Object)"loading all descriptors from standard ontology");
        List<Individual> standardDescriptorIndivs = this.ontologyManager.getIndividualsForClass(this.ontologyManager.standardOntModel, "http://www.grits-toolbox.org/ontology/sample#descriptor");
        HashSet<String> descriptorUris = new HashSet<String>();
        for (Individual descriptorIndiv : standardDescriptorIndivs) {
            try {
                descriptors.add(this.ontologyManager.getDescriptor(descriptorIndiv));
                descriptorUris.add(descriptorIndiv.getURI());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        this.logger.info((Object)"loading all other descriptors from local ontology");
        List<Individual> localDescriptorIndivs = this.ontologyManager.getIndividualsForClass(this.localOntModel, "http://www.grits-toolbox.org/ontology/sample#descriptor");
        for (Individual descriptorIndiv : localDescriptorIndivs) {
            if (descriptorUris.contains(descriptorIndiv.getURI())) continue;
            try {
                descriptors.add(this.ontologyManager.getDescriptor(descriptorIndiv));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return descriptors;
    }

    @Override
    public List<Descriptor> getCategoryDescriptors(String categoryUri) {
        this.logger.info((Object)("loading all descriptors for category " + categoryUri));
        if (categoryUri == null) {
            return null;
        }
        Individual categoryIndiv = this.ontologyManager.standardOntModel.getIndividual(categoryUri);
        if (categoryIndiv == null) {
            this.logger.error((Object)("category not found in standard ontology : " + categoryUri));
            return null;
        }
        String indivType = this.getCategoryIndivType(categoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryUri + "\" in standard ontology has error verfying its type. " + indivType));
            return null;
        }
        Individual localCategoryIndiv = this.localOntModel.getIndividual(categoryUri);
        if (localCategoryIndiv == null) {
            this.logger.error((Object)("category not found in local ontology : " + categoryUri));
            return null;
        }
        indivType = this.getCategoryIndivType(localCategoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryUri + "\" in local ontology has error verfying its type. " + indivType));
            return null;
        }
        ArrayList<Descriptor> descriptors = new ArrayList();
        try {
            descriptors = this.ontologyManager.getDescriptorsForCategory(categoryIndiv);
            HashSet<String> uriSet = new HashSet<String>();
            for (Descriptor descriptor : descriptors) {
                if (uriSet.contains(descriptor.getUri())) {
                    this.logger.error((Object)("duplicate descriptor in standard ontology : " + descriptor.getUri()));
                    continue;
                }
                uriSet.add(descriptor.getUri());
            }
            for (Descriptor descriptor : this.ontologyManager.getDescriptorsForCategory(localCategoryIndiv)) {
                if (uriSet.contains(descriptor.getUri())) {
                    this.logger.error((Object)("duplicate descriptor in local ontology : " + descriptor.getUri()));
                    continue;
                }
                descriptors.add(descriptor);
                uriSet.add(descriptor.getUri());
            }
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        return descriptors;
    }

    @Override
    public List<DescriptorGroup> getAllDescriptorGroups() {
        this.logger.info((Object)"loading all descriptor groups");
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();
        this.logger.info((Object)"loading all descriptor groups from standard ontology");
        List<Individual> standardDescriptorGroupIndivs = this.ontologyManager.getIndividualsForClass(this.ontologyManager.standardOntModel, "http://www.grits-toolbox.org/ontology/sample#descriptor_group");
        HashSet<String> descriptorGroupUris = new HashSet<String>();
        for (Individual descriptorGroupIndiv : standardDescriptorGroupIndivs) {
            try {
                descriptorGroups.add(this.ontologyManager.getDescriptorGroup(descriptorGroupIndiv));
                descriptorGroupUris.add(descriptorGroupIndiv.getURI());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        this.logger.info((Object)"loading all other descriptor groups from local ontology");
        List<Individual> localDescriptorGroupIndivs = this.ontologyManager.getIndividualsForClass(this.localOntModel, "http://www.grits-toolbox.org/ontology/sample#descriptor_group");
        for (Individual descriptorGroupIndiv : localDescriptorGroupIndivs) {
            if (descriptorGroupUris.contains(descriptorGroupIndiv.getURI())) continue;
            try {
                descriptorGroups.add(this.ontologyManager.getDescriptorGroup(descriptorGroupIndiv));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return descriptorGroups;
    }

    @Override
    public List<DescriptorGroup> getCategoryDescriptorGroups(String categoryUri) {
        this.logger.info((Object)("loading all descriptor groups for category " + categoryUri));
        if (categoryUri == null) {
            return null;
        }
        Individual categoryIndiv = this.ontologyManager.standardOntModel.getIndividual(categoryUri);
        if (categoryIndiv == null) {
            this.logger.error((Object)("category not found in standard ontology : " + categoryUri));
            return null;
        }
        String indivType = this.getCategoryIndivType(categoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryUri + "\" in standard ontology has error verfying its type. " + indivType));
            return null;
        }
        Individual localCategoryIndiv = this.localOntModel.getIndividual(categoryUri);
        if (localCategoryIndiv == null) {
            this.logger.error((Object)("category not found in local ontology : " + categoryUri));
            return null;
        }
        indivType = this.getCategoryIndivType(localCategoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryUri + "\" in local ontology has error verfying its type. " + indivType));
            return null;
        }
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList();
        try {
            descriptorGroups = this.ontologyManager.getDescriptorGroupsForCategory(categoryIndiv);
            HashSet<String> uriSet = new HashSet<String>();
            for (DescriptorGroup descriptorGroup : descriptorGroups) {
                if (uriSet.contains(descriptorGroup.getUri())) {
                    this.logger.error((Object)("duplicate descriptor group in standard ontology : " + descriptorGroup.getUri()));
                    continue;
                }
                uriSet.add(descriptorGroup.getUri());
            }
            for (DescriptorGroup descriptorGroup : this.ontologyManager.getDescriptorGroupsForCategory(localCategoryIndiv)) {
                if (uriSet.contains(descriptorGroup.getUri())) {
                    this.logger.error((Object)("duplicate descriptor group in local ontology : " + descriptorGroup.getUri()));
                    continue;
                }
                descriptorGroups.add(descriptorGroup);
                uriSet.add(descriptorGroup.getUri());
            }
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        return descriptorGroups;
    }

    @Override
    public List<Template> getAllTemplates() {
        this.logger.info((Object)"loading all templates");
        ArrayList<Template> templates = new ArrayList<Template>();
        this.logger.info((Object)"loading all templates from standard ontology");
        List<Individual> standardTemplateIndivs = this.ontologyManager.getIndividualsForClass(this.ontologyManager.standardOntModel, "http://www.grits-toolbox.org/ontology/sample#template");
        HashSet<String> templateUris = new HashSet<String>();
        for (Individual templateIndiv : standardTemplateIndivs) {
            try {
                templates.add(this.ontologyManager.getTemplate(templateIndiv));
                templateUris.add(templateIndiv.getURI());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        this.logger.info((Object)"loading all other templates from local ontology");
        List<Individual> localTemplateIndivs = this.ontologyManager.getIndividualsForClass(this.localOntModel, "http://www.grits-toolbox.org/ontology/sample#template");
        for (Individual templateIndiv : localTemplateIndivs) {
            try {
                if (templateUris.contains(templateIndiv.getURI())) continue;
                templates.add(this.ontologyManager.getTemplate(templateIndiv));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return templates;
    }

    @Override
    public List<Category> getAllCategories() {
        this.logger.info((Object)"loading all categories");
        ArrayList<Category> categories = new ArrayList<Category>();
        this.logger.info((Object)"loading all categories from standard ontology");
        Category category = null;
        for (OntResource categoryResource : this.ontologyManager.standardOntModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#category").listInstances().toList()) {
            try {
                category = this.getCategory(categoryResource.getURI());
                if (category == null) {
                    this.logger.error((Object)("error getting category : " + categoryResource.getURI()));
                    continue;
                }
                categories.add(category);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return categories;
    }

    @Override
    public List<Namespace> getAllNamespaces() {
        this.logger.info((Object)"loading all namespaces");
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        this.logger.info((Object)"loading all namespaces from standard ontology");
        List standardNamespaceIndivs = this.ontologyManager.standardOntModel.listResourcesWithProperty(RDF.type, (RDFNode)this.ontologyManager.standardOntModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#namespace")).toList();
        Namespace namespace = null;
        for (Resource namespaceIndiv : standardNamespaceIndivs) {
            try {
                namespace = this.getNamespace(namespaceIndiv.getURI());
                if (namespace == null) {
                    this.logger.error((Object)("error getting namespace : " + namespaceIndiv.getURI()));
                    continue;
                }
                namespaces.add(namespace);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return namespaces;
    }

    @Override
    public Descriptor getDescriptor(String descriptorUri) {
        this.logger.info((Object)("loading descriptor : " + descriptorUri));
        if (descriptorUri == null) {
            return null;
        }
        Individual descriptorIndiv = this.ontologyManager.standardOntModel.getIndividual(descriptorUri);
        if (descriptorIndiv == null) {
            this.logger.info((Object)("loading descriptor from local ontology : " + descriptorUri));
            descriptorIndiv = this.localOntModel.getIndividual(descriptorUri);
        }
        try {
            if (descriptorIndiv != null) {
                return this.ontologyManager.getDescriptor(descriptorIndiv);
            }
            this.logger.error((Object)("descriptor not found : " + descriptorUri));
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public DescriptorGroup getDescriptorGroup(String descriptorGroupUri) {
        this.logger.info((Object)("loading descriptor group : " + descriptorGroupUri));
        if (descriptorGroupUri == null) {
            return null;
        }
        Individual descriptorGroupIndiv = this.ontologyManager.standardOntModel.getIndividual(descriptorGroupUri);
        if (descriptorGroupIndiv == null) {
            this.logger.info((Object)("loading descriptor group from local ontology : " + descriptorGroupUri));
            descriptorGroupIndiv = this.localOntModel.getIndividual(descriptorGroupUri);
        }
        try {
            if (descriptorGroupIndiv != null) {
                return this.ontologyManager.getDescriptorGroup(descriptorGroupIndiv);
            }
            this.logger.error((Object)("descriptor group not found : " + descriptorGroupUri));
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public Template getTemplate(String templateUri) {
        this.logger.info((Object)("loading template : " + templateUri));
        if (templateUri == null) {
            return null;
        }
        Individual templateIndiv = this.ontologyManager.standardOntModel.getIndividual(templateUri);
        if (templateIndiv == null) {
            this.logger.info((Object)("loading template from local ontology : " + templateUri));
            templateIndiv = this.localOntModel.getIndividual(templateUri);
        }
        try {
            if (templateIndiv != null) {
                return this.ontologyManager.getTemplate(templateIndiv);
            }
            this.logger.error((Object)("template not found : " + templateUri));
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public Category getCategory(String categoryUri) {
        this.logger.info((Object)("loading category " + categoryUri));
        if (categoryUri == null) {
            return null;
        }
        Individual categoryIndiv = this.ontologyManager.standardOntModel.getIndividual(categoryUri);
        if (categoryIndiv == null) {
            this.logger.fatal((Object)("category missing in standard ontology : " + categoryUri));
            return null;
        }
        String indivType = this.getCategoryIndivType(categoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryIndiv.getURI() + "\" in standard ontology has error verfying its type. " + indivType));
            return null;
        }
        Individual localCategoryIndiv = this.localOntModel.getIndividual(categoryUri);
        if (localCategoryIndiv == null) {
            this.logger.fatal((Object)("category missing in local ontology : " + categoryUri));
            return null;
        }
        indivType = this.getCategoryIndivType(localCategoryIndiv);
        if (!"http://www.grits-toolbox.org/ontology/sample#category".equals(indivType)) {
            this.logger.fatal((Object)("The given category uri \"" + categoryIndiv.getURI() + "\" in local ontology has error verfying its type. " + indivType));
            return null;
        }
        try {
            Category category = new Category(categoryUri);
            if (!categoryIndiv.getLabel(null).equals(localCategoryIndiv.getLabel(null))) {
                this.logger.error((Object)("This category \"" + categoryUri + "\" has a different label in " + " local ontology : " + localCategoryIndiv.getLabel(null)));
            }
            category.setLabel(categoryIndiv.getLabel(null));
            this.logger.info((Object)("loading descriptors from standard ontology for this category : " + categoryUri));
            List<Descriptor> standardDescriptors = this.ontologyManager.getDescriptorsForCategory(categoryIndiv);
            category.getDescriptors().addAll(standardDescriptors);
            this.logger.info((Object)("loading descriptor groups from standard ontology for this category : " + categoryUri));
            List<DescriptorGroup> standardDescriptorGroups = this.ontologyManager.getDescriptorGroupsForCategory(categoryIndiv);
            category.getDescriptorGroups().addAll(standardDescriptorGroups);
            List<String> standardDescriptorUris = UtilityDescriptorDescriptorGroup.getDescriptorURIs(standardDescriptors);
            this.logger.info((Object)("loading descriptors from local ontology for this category : " + categoryUri));
            for (Descriptor descriptor : this.ontologyManager.getDescriptorsForCategory(localCategoryIndiv)) {
                if (standardDescriptorUris.contains(descriptor.getUri())) continue;
                category.getDescriptors().add(descriptor);
            }
            List<String> standardDescriptorGroupUris = UtilityDescriptorDescriptorGroup.getDescriptorGroupURIs(standardDescriptorGroups);
            this.logger.info((Object)("loading descriptor groups from local ontology for this category : " + categoryUri));
            for (DescriptorGroup descriptorGroup : this.ontologyManager.getDescriptorGroupsForCategory(localCategoryIndiv)) {
                if (standardDescriptorGroupUris.contains(descriptorGroup.getUri())) continue;
                category.getDescriptorGroups().add(descriptorGroup);
            }
            return category;
        }
        catch (Exception ex) {
            this.logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private String getCategoryIndivType(Individual categoryIndiv) {
        List ontClasses = categoryIndiv.listOntClasses(true).filterDrop((Filter)new Filter<OntClass>(){

            public boolean accept(OntClass ontClass) {
                return ontClass.getURI().equals("http://www.w3.org/2002/07/owl#NamedIndividual");
            }
        }).toList();
        if (ontClasses.isEmpty()) {
            return null;
        }
        return ontClasses.size() == 1 && "http://www.grits-toolbox.org/ontology/sample#category".equals(((OntClass)ontClasses.iterator().next()).getURI()) ? "http://www.grits-toolbox.org/ontology/sample#category" : "more than 1 type (number of types : " + ontClasses.size() + ") or not category type (type : " + ((OntClass)ontClasses.iterator().next()).getURI() + ")";
    }

    @Override
    public Namespace getNamespace(String namespaceUri) {
        this.logger.info((Object)("loading namespace " + namespaceUri));
        if (namespaceUri == null) {
            return null;
        }
        this.logger.info((Object)("loading namespace " + namespaceUri));
        try {
            return this.ontologyManager.getNamespace((RDFNode)this.ontologyManager.standardOntModel.getOntResource(namespaceUri));
        }
        catch (Exception ex) {
            this.logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String createNewTemplate(Template template) throws AlreadyExistsException {
        this.logger.info((Object)"creating template in local ontology");
        String templateUri = this.ontologyManager.createTemplate(this.localOntModel, template);
        if (templateUri != null) {
            this.saveLocalOntology();
        }
        return templateUri;
    }

    protected void saveLocalOntology() {
        try (FileWriter fileWriter = new FileWriter(this.localOntologyFile);){
            this.localOntModel.write((Writer)fileWriter, null);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

