/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.Internal;

@Internal
public final class UnhandledDataStructure {
    byte[] _buf;

    public UnhandledDataStructure(byte[] buf, int offset, int length) {
        int offsetEnd = offset + length;
        if (offsetEnd > buf.length || offsetEnd < 0) {
            throw new IndexOutOfBoundsException("Buffer Length is " + buf.length + " " + "but code is tried to read " + length + " " + "from offset " + offset + " to " + offsetEnd);
        }
        if (offset < 0 || length < 0) {
            throw new IndexOutOfBoundsException("Offset and Length must both be >= 0, negative indicies are not permitted - code is tried to read " + length + " from offset " + offset);
        }
        this._buf = UnhandledDataStructure.copyOfRange(buf, offset, offsetEnd);
    }

    static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    byte[] getBuf() {
        return this._buf;
    }
}

