/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.SearchBrokenNLSKeysUtil;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBrokenNLSKeysAction
extends SelectionDispatchAction {
    public static final String FIND_BROKEN_NLS_KEYS_ACTION_ID = "org.eclipse.jdt.ui.edit.text.java.find.broken.nls.keys";
    public static final String ACTION_HANDLER_ID = "org.eclipse.jdt.ui.actions.FindNLSProblems";
    private static final String JAVA_LANG_STRING = "QString;";
    private JavaEditor fEditor;

    public FindBrokenNLSKeysAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindNLSProblemsAction_Name);
        this.setToolTipText(ActionMessages.FindNLSProblemsAction_ToolTip);
        this.setDescription(ActionMessages.FindNLSProblemsAction_Description);
    }

    public FindBrokenNLSKeysAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindBrokenNLSKeysAction.getCompilationUnit(editor) != null);
    }

    @Override
    public void run(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        this.run((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
    }

    @Override
    public void run(IStructuredSelection selection) {
        SearchPatternData[] data;
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)firstElement;
            if (!ActionUtil.isProcessable(this.getShell(), javaElement)) {
                return;
            }
        }
        if ((data = this.getNLSFiles(selection)) == null || data.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FindNLSProblemsAction_ErrorDialogTitle, (String)ActionMessages.FindNLSProblemsAction_NoPropertieFilesFoundErrorDescription);
            return;
        }
        String scope = "workspace";
        if (selection.size() == 1) {
            Object firstElement2 = selection.getFirstElement();
            if (firstElement2 instanceof IJavaElement) {
                scope = ((IJavaElement)firstElement2).getElementName();
            } else if (firstElement2 instanceof IFile) {
                scope = ((IFile)firstElement2).getName();
            } else if (firstElement2 instanceof IFolder) {
                scope = ((IFolder)firstElement2).getName();
            }
        }
        this.run(data, scope);
    }

    private void run(SearchPatternData[] data, String scope) {
        ArrayList<IType> wrappers = new ArrayList<IType>();
        ArrayList<IFile> properties = new ArrayList<IFile>();
        int i = 0;
        while (i < data.length) {
            SearchPatternData current = data[i];
            if (current.getWrapperClass() != null || current.getPropertyFile() != null) {
                wrappers.add(current.getWrapperClass());
                properties.add(current.getPropertyFile());
            }
            ++i;
        }
        IType[] accessorClasses = wrappers.toArray(new IType[wrappers.size()]);
        IFile[] propertieFiles = properties.toArray(new IFile[properties.size()]);
        SearchBrokenNLSKeysUtil.search(scope, accessorClasses, propertieFiles);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            this.setEnabled(false);
        } else {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private SearchPatternData[] getNLSFiles(IStructuredSelection selection) {
        Object[] selectedElements = selection.toArray();
        HashMap<IType, SearchPatternData> result = new HashMap<IType, SearchPatternData>();
        this.collectNLSFilesFromResources(selectedElements, result);
        this.collectNLSFilesFromJavaElements(selectedElements, result);
        Collection<SearchPatternData> values = result.values();
        return values.toArray(new SearchPatternData[values.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canEnable(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block17: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return false;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block17;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                    if (selected[i] instanceof IFile) {
                        IFile file = (IFile)selected[i];
                        if ("properties".equalsIgnoreCase(file.getFileExtension())) {
                            return true;
                        }
                    } else if (selected[i] instanceof IWorkingSet) {
                        IWorkingSet workingSet = (IWorkingSet)selected[i];
                        return "org.eclipse.jdt.ui.JavaWorkingSetPage".equals(workingSet.getId());
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block17;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    private void collectNLSFilesFromResources(Object[] objects, HashMap<IType, SearchPatternData> result) {
        try {
            int i = 0;
            while (i < objects.length) {
                SearchPatternData data;
                Object object = objects[i];
                IResource resource = null;
                if (object instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)object;
                    this.collectNLSFilesFromResources(workingSet.getElements(), result);
                } else if (object instanceof IJavaElement) {
                    resource = ((IJavaElement)object).getCorrespondingResource();
                } else if (object instanceof IResource) {
                    resource = (IResource)object;
                } else if (object instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
                    resource = logicalPackage.getJavaProject().getProject();
                }
                if (resource instanceof IContainer) {
                    this.collectNLSFilesFromResources(((IContainer)resource).members(), result);
                } else if (resource instanceof IFile && (data = this.tryIfPropertyFileSelected((IFile)resource)) != null && !result.containsKey(data.fAccessorType)) {
                    result.put(data.fAccessorType, data);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectNLSFilesFromJavaElements(Object[] objects, HashMap<IType, SearchPatternData> result) {
        try {
            int i = 0;
            while (true) {
                if (i >= objects.length) {
                    return;
                }
                if (objects[i] instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)objects[i];
                    if (elem.exists()) {
                        switch (elem.getElementType()) {
                            case 7: {
                                SearchPatternData data;
                                ICompilationUnit unit;
                                IType[] types;
                                if (elem.getParent().getElementType() != 5 || (types = (unit = (ICompilationUnit)elem.getParent()).getTypes()).length <= 0 || result.containsKey(types[0]) || (data = this.tryIfPropertyCuSelected(unit)) == null) break;
                                result.put(data.fAccessorType, data);
                                break;
                            }
                            case 5: {
                                SearchPatternData data;
                                ICompilationUnit unit = (ICompilationUnit)elem;
                                IType[] types = unit.getTypes();
                                if (types.length <= 0 || result.containsKey(types[0]) || (data = this.tryIfPropertyCuSelected(unit)) == null) break;
                                result.put(data.fAccessorType, data);
                                break;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)elem;
                                if (fragment.getKind() != 1) break;
                                this.collectNLSFilesFromJavaElements(fragment.getChildren(), result);
                                break;
                            }
                            case 3: {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                                if (root.getKind() != 1) break;
                                this.collectNLSFilesFromJavaElements(root.getChildren(), result);
                                break;
                            }
                            case 2: {
                                IJavaProject javaProject = (IJavaProject)elem;
                                IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                                int j = 0;
                                while (j < allPackageFragmentRoots.length) {
                                    IPackageFragmentRoot root = allPackageFragmentRoots[j];
                                    if (root.getKind() == 1 && javaProject.equals(root.getJavaProject())) {
                                        this.collectNLSFilesFromJavaElements(new Object[]{root}, result);
                                    }
                                    ++j;
                                }
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (objects[i] instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)objects[i]);
                    this.collectNLSFilesFromJavaElements(new Object[]{logicalPackage.getJavaProject()}, result);
                } else if (objects[i] instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)objects[i];
                    this.collectNLSFilesFromJavaElements(workingSet.getElements(), result);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) return;
            JavaPlugin.log(e);
        }
    }

    private SearchPatternData tryIfPropertyCuSelected(ICompilationUnit compilationUnit) throws JavaModelException {
        IStorage bundle = FindBrokenNLSKeysAction.getResourceBundle(compilationUnit);
        if (!(bundle instanceof IFile)) {
            return null;
        }
        return new SearchPatternData(compilationUnit.getTypes()[0], (IFile)bundle);
    }

    public static IStorage getResourceBundle(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit == null) {
            return null;
        }
        if (!ActionUtil.isOnBuildPath((IJavaElement)compilationUnit)) {
            return null;
        }
        IType[] types = compilationUnit.getTypes();
        if (types.length != 1) {
            return null;
        }
        if (!FindBrokenNLSKeysAction.isPotentialNLSAccessor(compilationUnit)) {
            return null;
        }
        return NLSHintHelper.getResourceBundle(compilationUnit);
    }

    private static boolean isPotentialNLSAccessor(ICompilationUnit unit) throws JavaModelException {
        IType type = unit.getTypes()[0];
        if (!type.exists()) {
            return false;
        }
        IField bundleNameField = FindBrokenNLSKeysAction.getBundleNameField(type.getFields());
        if (bundleNameField == null) {
            return false;
        }
        if (FindBrokenNLSKeysAction.importsOSGIUtil(unit)) {
            IInitializer[] initializers = type.getInitializers();
            int i = 0;
            while (i < initializers.length) {
                if (Modifier.isStatic((int)initializers[0].getFlags())) {
                    return true;
                }
                ++i;
            }
        } else {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (FindBrokenNLSKeysAction.isValueAccessor(method)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean importsOSGIUtil(ICompilationUnit unit) throws JavaModelException {
        IImportDeclaration[] imports = unit.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().startsWith("org.eclipse.osgi.util.")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isValueAccessor(IMethod method) throws JavaModelException {
        if (!"getString".equals(method.getElementName())) {
            return false;
        }
        int flags = method.getFlags();
        if (!Modifier.isStatic((int)flags) || !Modifier.isPublic((int)flags)) {
            return false;
        }
        String returnType = method.getReturnType();
        if (!JAVA_LANG_STRING.equals(returnType)) {
            return false;
        }
        String[] parameters = method.getParameterTypes();
        return parameters.length == 1 && JAVA_LANG_STRING.equals(parameters[0]);
    }

    private static IField getBundleNameField(IField[] fields) {
        int i = 0;
        while (i < fields.length) {
            if ("BUNDLE_NAME".equals(fields[i].getElementName())) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private SearchPatternData tryIfPropertyFileSelected(IFile file) {
        IType accessorType = FindBrokenNLSKeysAction.getAccessorType(file);
        return accessorType != null ? new SearchPatternData(accessorType, file) : null;
    }

    public static IType getAccessorType(IFile file) {
        if (!"properties".equalsIgnoreCase(file.getFileExtension())) {
            return null;
        }
        IPath propertyFullPath = file.getFullPath();
        String[] javaExtensions = JavaCore.getJavaLikeExtensions();
        int i = 0;
        while (i < javaExtensions.length) {
            String name;
            String resourceName;
            String resourceBundleName;
            ICompilationUnit compilationUnit;
            IType type;
            IJavaElement element;
            String filename;
            String extension = javaExtensions[i];
            IPath cuPath = propertyFullPath.removeFileExtension().addFileExtension(extension);
            IFile cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            if (cuFile == null && (filename = cuPath.removeFileExtension().lastSegment()) != null && filename.length() > 0) {
                filename = String.valueOf(Character.toUpperCase(filename.charAt(0))) + filename.substring(1);
                IPath dirPath = propertyFullPath.removeLastSegments(1).addTrailingSeparator();
                cuPath = dirPath.append(filename).addFileExtension(extension);
                cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            }
            if (cuFile != null && cuFile.exists() && (element = JavaCore.create((IFile)cuFile)) != null && element.exists() && element.getElementType() == 5 && ActionUtil.isOnBuildPath(element) && (type = (compilationUnit = (ICompilationUnit)element).findPrimaryType()) != null && (resourceBundleName = NLSHintHelper.getResourceBundleName((ITypeRoot)compilationUnit)) != null && (resourceName = String.valueOf(resourceBundleName) + ".properties").endsWith(name = file.getName())) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    private static class SearchPatternData {
        private final IType fAccessorType;
        private final IFile fPropertyFile;

        public SearchPatternData(IType accessorType, IFile propertyFile) {
            this.fAccessorType = accessorType;
            this.fPropertyFile = propertyFile;
        }

        public IFile getPropertyFile() {
            return this.fPropertyFile;
        }

        public IType getWrapperClass() {
            return this.fAccessorType;
        }
    }
}

