/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.examples;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.io.Linucs.SugarImporterLinucs;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorToGlycoCT;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.analytical.MonosaccharideScalableName.MonosaccharideScalableName;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;

public class MonosaccharideScalableNameExport {
    public static void main(String[] args) {
        SugarImporterLinucs t_objImporter = new SugarImporterLinucs();
        String t_strCode = "[][D-MAN-ol]{[(2+1)][A-D-GLCPN]{[(2+1)][A-D-GALPNAC]{}}}";
        Config t_objConf = new Config();
        try {
            MonosaccharideConverter t_objTrans = new MonosaccharideConverter(t_objConf);
            Sugar t_objSugar = ((SugarImporter)t_objImporter).parse(t_strCode);
            GlycoVisitorToGlycoCT t_objTo = new GlycoVisitorToGlycoCT((MonosaccharideConversion)t_objTrans);
            t_objTo.start(t_objSugar);
            t_objSugar = t_objTo.getNormalizedSugar();
            ArrayList<GlycoNode> t_aNodes = t_objSugar.getNodes();
            MonosaccharideScalableName t_oName = new MonosaccharideScalableName();
            GlycoVisitorNodeType t_oType = new GlycoVisitorNodeType();
            for (GlycoNode t_Node : t_aNodes) {
                if (t_oType.isMonosaccharide(t_Node)) {
                    t_oName.reset();
                    t_oName.displaySuperclass(false);
                    t_oName.displayAllModifications(false);
                    t_oName.displayConfiguration(false);
                    System.out.print(t_oName.getName((Monosaccharide)t_Node) + "\n");
                }
                if (!t_oType.isMonosaccharide(t_Node)) continue;
                t_oName.reset();
                t_oName.displayAnomer(false);
                t_oName.displayRingsize(false);
                t_oName.displaySuperclass(false);
                System.out.print(t_oName.getName((Monosaccharide)t_Node) + "\n");
            }
        }
        catch (SugarImporterException e) {
            e.printStackTrace();
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
    }
}

