/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.Linucs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.Linucs.GlycoVisitorExportRepeat;
import org.eurocarbdb.MolecularFramework.io.Linucs.LinucsComparatorEdges;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoTraverserLinucs
extends GlycoTraverser {
    private GlycoNode m_objRepeatEnd = null;
    private GlycoEdge m_objRepeatLinkage = null;
    private GlycoVisitorExportRepeat m_objRepeatVisitor = null;

    public GlycoTraverserLinucs(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        super(a_objVisitor);
    }

    public void traverse(GlycoNode a_objNode) throws GlycoVisitorException {
        this.m_iState = 0;
        a_objNode.accept(this.m_objVisitor);
        for (GlycoEdge t_objEdge : a_objNode.getChildEdges()) {
            if (t_objEdge.getGlycosidicLinkages().size() != 1) {
                throw new GlycoVisitorException("Linucs does not support multiple connected residues.");
            }
            if (t_objEdge.getGlycosidicLinkages().get(0).getChildLinkages().size() > 1) {
                Collections.sort(t_objEdge.getGlycosidicLinkages().get(0).getChildLinkages());
            }
            if (t_objEdge.getGlycosidicLinkages().get(0).getParentLinkages().size() <= 1) continue;
            Collections.sort(t_objEdge.getGlycosidicLinkages().get(0).getParentLinkages());
        }
        LinucsComparatorEdges t_objComperator = new LinucsComparatorEdges();
        if (a_objNode == this.m_objRepeatEnd) {
            ArrayList<GlycoEdge> t_objEdgesOriginal = a_objNode.getChildEdges();
            ArrayList<GlycoEdge> t_objEdges = new ArrayList<GlycoEdge>();
            Iterator<GlycoEdge> t_iterEdges = t_objEdgesOriginal.iterator();
            while (t_iterEdges.hasNext()) {
                t_objEdges.add(t_iterEdges.next());
            }
            t_objEdges.add(this.m_objRepeatLinkage);
            Collections.sort(t_objEdges, t_objComperator);
            for (int t_iPosition = 0; t_iPosition < t_objEdges.size(); ++t_iPosition) {
                GlycoEdge t_objEdge = (GlycoEdge)t_objEdges.get(t_iPosition);
                if (t_objEdge != this.m_objRepeatLinkage) {
                    this.traverse(t_objEdge);
                    continue;
                }
                this.m_objRepeatVisitor.switchStrings();
            }
        } else {
            ArrayList<GlycoEdge> t_objEdges = a_objNode.getChildEdges();
            Collections.sort(t_objEdges, t_objComperator);
            for (int t_iPosition = 0; t_iPosition < t_objEdges.size(); ++t_iPosition) {
                this.traverse(t_objEdges.get(t_iPosition));
            }
        }
        this.m_iState = 1;
        a_objNode.accept(this.m_objVisitor);
    }

    public void traverse(GlycoEdge a_objEdge) throws GlycoVisitorException {
        a_objEdge.accept(this.m_objVisitor);
        this.traverse(a_objEdge.getChild());
    }

    public void traverseGraph(GlycoGraph a_objSugar) throws GlycoVisitorException {
        try {
            ArrayList<GlycoNode> t_aRoots = a_objSugar.getRootNodes();
            if (t_aRoots.size() != 1) {
                throw new GlycoVisitorException("LINUCS can only store connected sugars.");
            }
            this.traverse(t_aRoots.get(0));
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    public void traverseGraph(SugarUnitRepeat a_objRepeat, GlycoEdge a_objLinkage, GlycoVisitorExportRepeat a_objVisitor) throws GlycoVisitorException {
        this.m_objRepeatEnd = a_objRepeat.getRepeatLinkage().getParent();
        this.m_objRepeatLinkage = a_objLinkage;
        this.m_objRepeatVisitor = a_objVisitor;
        this.traverseGraph(a_objRepeat);
    }
}

