/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.glycobase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.glycobase.GlycobaseResidue;
import org.eurocarbdb.MolecularFramework.io.glycobase.GlycobaseResidueComparator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugarImporterGlycobase {
    private String m_strReducingType = null;
    private ArrayList<String> m_aIncrements = new ArrayList();
    private Sugar m_objSugar = null;
    private ArrayList<GlycobaseResidue> m_aResidues = new ArrayList();
    private HashMap<String, GlycoNode> m_hashResidue = new HashMap();
    private String m_strParseString = null;
    private char m_cToken = '\u0000';
    private int m_iPosition = -1;

    protected void nextToken() throws SugarImporterException {
        ++this.m_iPosition;
        try {
            this.m_cToken = this.m_strParseString.charAt(this.m_iPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SugarImporterException("COMMON000");
        }
    }

    protected int number() throws SugarImporterException {
        int t_iResult = 0;
        char t_iDigit = '\u0000';
        if (this.m_cToken == '0') {
            this.nextToken();
            return t_iResult;
        }
        t_iDigit = this.m_cToken;
        if (t_iDigit < '1' || t_iDigit > '9') {
            throw new SugarImporterException("COMMON004", this.m_iPosition);
        }
        t_iResult = t_iDigit - 48;
        this.nextToken();
        t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            t_iResult = t_iResult * 10 + (t_iDigit - 48);
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        return t_iResult;
    }

    public void setReducingType(String a_strReducingType) {
        this.m_strReducingType = a_strReducingType;
    }

    public void setIncrements(ArrayList<String> a_aIncrements) {
        this.m_aIncrements = a_aIncrements;
    }

    public Sugar parse() throws SugarImporterException {
        this.clear();
        if (this.m_strReducingType == null) {
            throw new SugarImporterException("GLYCOBASE002");
        }
        try {
            this.buildCoreStructure();
            Iterator<String> t_iterIncrements = this.m_aIncrements.iterator();
            while (t_iterIncrements.hasNext()) {
                this.m_aResidues.add(this.createResidue(t_iterIncrements.next()));
            }
            GlycobaseResidueComparator t_compResidues = new GlycobaseResidueComparator();
            Collections.sort(this.m_aResidues, t_compResidues);
            Iterator<GlycobaseResidue> t_itreResidues = this.m_aResidues.iterator();
            while (t_itreResidues.hasNext()) {
                this.addResidue(t_itreResidues.next());
            }
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013");
        }
        return this.m_objSugar;
    }

    private void addResidue(GlycobaseResidue a_objGlycobaseResidue) throws SugarImporterException, GlycoconjugateException {
        int t_iPosition = a_objGlycobaseResidue.m_strPosition.indexOf(",");
        GlycoNode t_objParent = null;
        if (t_iPosition == -1) {
            t_objParent = this.m_hashResidue.get("");
        } else {
            String t_Str = a_objGlycobaseResidue.m_strPosition.substring(t_iPosition + 1);
            t_objParent = this.m_hashResidue.get(t_Str);
        }
        if (t_objParent == null) {
            throw new SugarImporterException("GLYCOBASE011");
        }
        UnvalidatedGlycoNode t_objNode = new UnvalidatedGlycoNode();
        t_objNode.setName(a_objGlycobaseResidue.m_strResidue);
        this.m_objSugar.addNode(t_objNode);
        GlycoEdge t_objEdge = new GlycoEdge();
        Linkage t_objLinkage = new Linkage();
        t_objLinkage.addChildLinkage(a_objGlycobaseResidue.m_iLinkageChild);
        t_objLinkage.addParentLinkage(a_objGlycobaseResidue.m_iLinkageParent);
        t_objEdge.addGlycosidicLinkage(t_objLinkage);
        this.m_objSugar.addEdge(t_objParent, t_objNode, t_objEdge);
        this.m_hashResidue.put(a_objGlycobaseResidue.m_strPosition, t_objNode);
        if (a_objGlycobaseResidue.m_strWith != null) {
            String t_strSubst = "";
            this.m_strParseString = a_objGlycobaseResidue.m_strWith.trim() + "$";
            this.m_iPosition = -1;
            this.nextToken();
            this.with();
            while (this.m_cToken != '(') {
                t_strSubst = t_strSubst + this.m_cToken;
                this.nextToken();
            }
            this.nextToken();
            t_iPosition = this.number();
            if (this.m_cToken != ')') {
                throw new SugarImporterException("GLYCOBASE012");
            }
            UnvalidatedGlycoNode t_objNodeSubst = new UnvalidatedGlycoNode();
            t_objNodeSubst.setName(t_strSubst.trim());
            this.m_objSugar.addNode(t_objNodeSubst);
            t_objEdge = new GlycoEdge();
            t_objLinkage = new Linkage();
            t_objLinkage.addChildLinkage(1);
            t_objLinkage.addParentLinkage(t_iPosition);
            t_objEdge.addGlycosidicLinkage(t_objLinkage);
            this.m_objSugar.addEdge(t_objNode, t_objNodeSubst, t_objEdge);
        }
    }

    private void with() throws SugarImporterException {
        if (this.m_cToken != 'w') {
            throw new SugarImporterException("GLYCOBASE013");
        }
        this.nextToken();
        if (this.m_cToken != 'i') {
            throw new SugarImporterException("GLYCOBASE013");
        }
        this.nextToken();
        if (this.m_cToken != 't') {
            throw new SugarImporterException("GLYCOBASE013");
        }
        this.nextToken();
        if (this.m_cToken != 'h') {
            throw new SugarImporterException("GLYCOBASE013");
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
    }

    private void buildCoreStructure() throws GlycoconjugateException {
        UnvalidatedGlycoNode t_objResidue = new UnvalidatedGlycoNode();
        t_objResidue.setName(this.m_strReducingType);
        this.m_objSugar.addNode(t_objResidue);
        this.m_hashResidue.put("", t_objResidue);
    }

    public void clear() {
        this.m_objSugar = new Sugar();
        this.m_aResidues.clear();
        this.m_hashResidue.clear();
    }

    private GlycobaseResidue createResidue(String a_strIncrement) throws SugarImporterException {
        GlycobaseResidue t_objResidue = new GlycobaseResidue();
        this.m_strParseString = a_strIncrement.trim() + "$";
        this.m_iPosition = -1;
        this.nextToken();
        if (this.m_cToken != '[') {
            throw new SugarImporterException("GLYCOBASE006");
        }
        this.nextToken();
        this.increment();
        int t_iPosition = this.m_iPosition;
        this.number();
        while (this.m_cToken == ',') {
            this.nextToken();
            this.number();
        }
        t_objResidue.m_strPosition = this.m_strParseString.substring(t_iPosition, this.m_iPosition).trim();
        if (this.m_cToken != ']') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_objResidue.m_strResidue = this.residuename();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.linkage(t_objResidue);
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        if (this.m_cToken == '(') {
            while (this.m_cToken != ')') {
                this.nextToken();
            }
            this.nextToken();
        }
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        if (this.m_cToken != '$') {
            t_objResidue.m_strWith = this.m_strParseString.substring(this.m_iPosition);
        }
        return t_objResidue;
    }

    private void linkage(GlycobaseResidue a_objResidue) throws SugarImporterException {
        if (this.m_cToken != '(') {
            throw new SugarImporterException("GLYCOBASE010");
        }
        this.nextToken();
        a_objResidue.m_iLinkageChild = this.number();
        if (this.m_cToken != '-') {
            throw new SugarImporterException("GLYCOBASE010");
        }
        this.nextToken();
        a_objResidue.m_iLinkageParent = this.number();
        if (this.m_cToken != ')') {
            throw new SugarImporterException("GLYCOBASE010");
        }
        this.nextToken();
    }

    private String residuename() throws SugarImporterException {
        String t_strResult = "";
        if (this.m_cToken == '&') {
            int t_iMax;
            String t_strTemp = "";
            this.nextToken();
            if (this.m_cToken == 'b') {
                t_strTemp = t_strTemp + this.m_cToken;
                t_iMax = this.m_iPosition + 3;
                while (this.m_iPosition < t_iMax) {
                    this.nextToken();
                    t_strTemp = t_strTemp + this.m_cToken;
                }
                if (!t_strTemp.equalsIgnoreCase("beta")) {
                    throw new SugarImporterException("GLYCOBASE008");
                }
                this.nextToken();
                if (this.m_cToken != ';') {
                    throw new SugarImporterException("GLYCOBASE008");
                }
                this.nextToken();
                t_strResult = "b";
            } else if (this.m_cToken == 'a') {
                t_strTemp = t_strTemp + this.m_cToken;
                t_iMax = this.m_iPosition + 4;
                while (this.m_iPosition < t_iMax) {
                    this.nextToken();
                    t_strTemp = t_strTemp + this.m_cToken;
                }
                if (!t_strTemp.equalsIgnoreCase("alpha")) {
                    throw new SugarImporterException("GLYCOBASE008");
                }
                this.nextToken();
                if (this.m_cToken != ';') {
                    throw new SugarImporterException("GLYCOBASE008");
                }
                this.nextToken();
                t_strResult = "a";
            } else {
                throw new SugarImporterException("GLYCOBASE008");
            }
        }
        while (this.m_cToken != '<' && this.m_cToken != ' ' && this.m_cToken != '$') {
            t_strResult = t_strResult + this.m_cToken;
            this.nextToken();
        }
        if (this.m_cToken == '<') {
            this.nextToken();
            if (this.m_cToken != 'i') {
                throw new SugarImporterException("GLYCOBASE009");
            }
            this.nextToken();
            if (this.m_cToken != '>') {
                throw new SugarImporterException("GLYCOBASE009");
            }
            this.nextToken();
            while (this.m_cToken != '<') {
                t_strResult = t_strResult + this.m_cToken;
                this.nextToken();
            }
            this.nextToken();
            if (this.m_cToken != '/') {
                throw new SugarImporterException("GLYCOBASE009");
            }
            this.nextToken();
            if (this.m_cToken != 'i') {
                throw new SugarImporterException("GLYCOBASE009");
            }
            this.nextToken();
            if (this.m_cToken != '>') {
                throw new SugarImporterException("GLYCOBASE009");
            }
            this.nextToken();
            while (this.m_cToken != ' ' && this.m_cToken != '$') {
                t_strResult = t_strResult + this.m_cToken;
                this.nextToken();
            }
        }
        return t_strResult;
    }

    private void increment() throws SugarImporterException {
        if (this.m_cToken != 'i') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        if (this.m_cToken != 'n') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        if (this.m_cToken != 'c') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        if (this.m_cToken != 'r') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        if (this.m_cToken != '.') {
            throw new SugarImporterException("GLYCOBASE007");
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
    }
}

