/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.namespace.AlternativeMapping;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbAnomer;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbBaseType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbSuperclass;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoVisitorFromGlycoCT
implements GlycoVisitor {
    private Sugar m_objNewSugar = null;
    private MonosaccharideConversion m_objConverter = null;
    private GlycoGraph m_objUnit = null;
    private HashMap<GlycoNode, GlycoNode> m_hashResidues = new HashMap();
    private GlycanNamescheme m_strSchema = GlycanNamescheme.GLYCOSCIENCES;
    private GlycoTraverser m_objTraverser = null;
    private SugarUnitRepeat m_objRepeat = null;
    private UnderdeterminedSubTree m_objSubTree = null;
    private ArrayList<AlternativeMapping> m_aAlternative = new ArrayList();
    private GlycoGraphAlternative m_objAlternative = null;

    public GlycoVisitorFromGlycoCT(MonosaccharideConversion a_objTranslator) {
        this.m_objConverter = a_objTranslator;
    }

    public GlycoVisitorFromGlycoCT(MonosaccharideConversion a_objTranslator, GlycanNamescheme a_strSchema) {
        this.m_objConverter = a_objTranslator;
        this.m_strSchema = a_strSchema;
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_objNewSugar = null;
        this.m_objUnit = null;
        this.m_hashResidues.clear();
        this.m_objRepeat = null;
        this.m_objSubTree = null;
        this.m_aAlternative.clear();
        this.m_objAlternative = null;
    }

    public Sugar getNormalizedSugar() {
        return this.m_objNewSugar;
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            try {
                GlycoNode t_objStart = this.m_hashResidues.get(a_objCyclic.getCyclicStart());
                GlycoEdge t_objEdge = a_objCyclic.getParentEdge();
                if (t_objEdge == null) {
                    throw new GlycoVisitorException("Critical error in cyclic unit, no parent edge.");
                }
                GlycoNode t_objParent = this.m_hashResidues.get(a_objCyclic.getParentNode());
                if (t_objStart == null || t_objParent == null) {
                    throw new GlycoVisitorException("Critical error in cyclic unit.");
                }
                t_objEdge = t_objEdge.copy();
                for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
                    t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
                    t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
                }
                this.m_objUnit.addEdge(t_objParent, t_objStart, t_objEdge);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException("Could not create cyclic residue : " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode are not allowed for this visitor.");
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            GlycoVisitorFromGlycoCT t_objVisitor = new GlycoVisitorFromGlycoCT(this.m_objConverter, this.m_strSchema);
            SugarUnitRepeat t_objUnit = t_objVisitor.start(a_objRepeate);
            this.m_hashResidues.put(a_objRepeate, t_objUnit);
            try {
                this.m_objUnit.addNode(t_objUnit);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException("Could not create Repeat : ", e);
            }
            this.copyParentLinkage(a_objRepeate.getParentEdge(), t_objUnit);
        }
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            SugarUnitAlternative t_objCopy = new SugarUnitAlternative();
            this.copyParentLinkage(a_objAlternative.getParentEdge(), t_objCopy);
            for (GlycoGraphAlternative t_objGraph : a_objAlternative.getAlternatives()) {
                GlycoVisitorFromGlycoCT t_objVisitor = new GlycoVisitorFromGlycoCT(this.m_objConverter, this.m_strSchema);
                GlycoGraphAlternative t_objGraphCopy = t_objVisitor.start(t_objGraph, t_objCopy);
                this.m_aAlternative.add(new AlternativeMapping(a_objAlternative, t_objGraph, t_objCopy, t_objGraphCopy, t_objVisitor.getResidueMapping()));
            }
            this.m_hashResidues.put(a_objAlternative, t_objCopy);
            try {
                this.m_objUnit.addNode(t_objCopy);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException("Could not create alternative : ", e);
            }
        }
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            UnvalidatedGlycoNode t_objNode = new UnvalidatedGlycoNode();
            try {
                t_objNode.setName(a_objResidue.getName());
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
            this.m_hashResidues.put(a_objResidue, t_objNode);
            try {
                this.m_objUnit.addNode(t_objNode);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
            this.copyParentLinkage(a_objResidue.getParentEdge(), t_objNode);
        }
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            try {
                MonosaccharideExchangeObject t_objData = new MonosaccharideExchangeObject();
                t_objData.setBasetype(this.createBaseType(a_objMonosaccharid));
                for (GlycoEdge t_objEdge : a_objMonosaccharid.getChildEdges()) {
                    Substituent t_objNonMS;
                    GlycoNode t_objResidue = t_objEdge.getChild();
                    if (t_objResidue.getClass() != Substituent.class || (t_objNonMS = (Substituent)t_objResidue).getChildEdges().size() != 0) continue;
                    SubstituentExchangeObject t_objSubst = new SubstituentExchangeObject(GlycanNamescheme.GLYCOCT);
                    t_objSubst.setName(t_objNonMS.getSubstituentType().getName());
                    int t_iCounter = 0;
                    for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
                        if (++t_iCounter == 1) {
                            t_objSubst.setLinkagetype1(this.createLinkageType(t_objLinkage.getParentLinkageType()));
                            t_objSubst.setPosition1(this.createExchangeLinkagePosition(t_objLinkage.getParentLinkages()));
                            t_objSubst.setSubstituentPosition1(this.createExchangeLinkagePosition(t_objLinkage.getChildLinkages()));
                            continue;
                        }
                        if (t_iCounter == 2) {
                            t_objSubst.setLinkagetype2(this.createLinkageType(t_objLinkage.getParentLinkageType()));
                            t_objSubst.setPosition2(this.createExchangeLinkagePosition(t_objLinkage.getParentLinkages()));
                            t_objSubst.setSubstituentPosition2(this.createExchangeLinkagePosition(t_objLinkage.getChildLinkages()));
                            continue;
                        }
                        if (t_iCounter == 3) {
                            t_objSubst.setLinkagetype3(this.createLinkageType(t_objLinkage.getParentLinkageType()));
                            t_objSubst.setPosition3(this.createExchangeLinkagePosition(t_objLinkage.getParentLinkages()));
                            t_objSubst.setSubstituentPosition3(this.createExchangeLinkagePosition(t_objLinkage.getChildLinkages()));
                            continue;
                        }
                        throw new GlycoVisitorException("Substitutent " + t_objNonMS.getSubstituentType().getName() + " links to often to monosaccharide " + a_objMonosaccharid.getGlycoCTName());
                    }
                    t_objData.addSubstituent(t_objSubst);
                }
                t_objData = this.m_objConverter.convertMonosaccharide(t_objData, GlycanNamescheme.GLYCOCT, this.m_strSchema);
                UnvalidatedGlycoNode t_objNonMS = new UnvalidatedGlycoNode();
                t_objNonMS.setName(t_objData.getMonosaccharideName());
                this.m_hashResidues.put(a_objMonosaccharid, t_objNonMS);
                this.m_objUnit.addNode(t_objNonMS);
                ArrayList t_aSubsListe = t_objData.getSubstituents();
                for (GlycoEdge t_objSubLinkage : a_objMonosaccharid.getChildEdges()) {
                    GlycoNode t_objResidue = t_objSubLinkage.getChild();
                    if (t_objResidue.getClass() != Substituent.class || !this.isCollapsed(t_objSubLinkage, (Substituent)t_objResidue, t_aSubsListe)) continue;
                    this.m_hashResidues.put(t_objResidue, t_objNonMS);
                }
                this.copyParentLinkage(a_objMonosaccharid.getParentEdge(), t_objNonMS);
            }
            catch (ResourcesDbException e) {
                throw new GlycoVisitorException("Unable to translate " + a_objMonosaccharid.getGlycoCTName() + " : " + e.getMessage(), e);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
            catch (org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0 && !this.m_hashResidues.containsKey(a_objSubstituent)) {
            SubstituentExchangeObject t_objSubst = new SubstituentExchangeObject(GlycanNamescheme.GLYCOCT);
            t_objSubst.setName(a_objSubstituent.getSubstituentType().getName());
            int t_iCounter = 0;
            if (a_objSubstituent.getParentEdge() != null) {
                for (Linkage t_objElement : a_objSubstituent.getParentEdge().getGlycosidicLinkages()) {
                    if (++t_iCounter == 1) {
                        t_objSubst.setLinkagetype1(this.createLinkageType(t_objElement.getParentLinkageType()));
                        t_objSubst.setSubstituentPosition1(t_objElement.getChildLinkages());
                        continue;
                    }
                    if (t_iCounter == 2) {
                        t_objSubst.setLinkagetype2(this.createLinkageType(t_objElement.getParentLinkageType()));
                        t_objSubst.setSubstituentPosition2(t_objElement.getChildLinkages());
                        continue;
                    }
                    if (t_iCounter == 3) {
                        t_objSubst.setLinkagetype3(this.createLinkageType(t_objElement.getParentLinkageType()));
                        t_objSubst.setSubstituentPosition3(t_objElement.getChildLinkages());
                        continue;
                    }
                    throw new GlycoVisitorException("Substitutent " + a_objSubstituent.getSubstituentType().getName() + " has too many connections.");
                }
            }
            Iterator<GlycoEdge> t_iterChilds = a_objSubstituent.getChildEdges().iterator();
            while (t_iterChilds.hasNext()) {
                for (Linkage t_objElement : t_iterChilds.next().getGlycosidicLinkages()) {
                    if (++t_iCounter == 1) {
                        t_objSubst.setLinkagetype1(this.createLinkageType(t_objElement.getChildLinkageType()));
                        t_objSubst.setSubstituentPosition1(t_objElement.getChildLinkages());
                        continue;
                    }
                    if (t_iCounter == 2) {
                        t_objSubst.setLinkagetype2(this.createLinkageType(t_objElement.getChildLinkageType()));
                        t_objSubst.setSubstituentPosition2(t_objElement.getChildLinkages());
                        continue;
                    }
                    if (t_iCounter == 3) {
                        t_objSubst.setLinkagetype3(this.createLinkageType(t_objElement.getChildLinkageType()));
                        t_objSubst.setSubstituentPosition3(t_objElement.getChildLinkages());
                        continue;
                    }
                    throw new GlycoVisitorException("Substitutent " + a_objSubstituent.getSubstituentType().getName() + " has too many connections.");
                }
            }
            try {
                t_objSubst = this.m_objConverter.convertSubstituent(t_objSubst, GlycanNamescheme.GLYCOCT, this.m_strSchema);
                UnvalidatedGlycoNode t_objNew = new UnvalidatedGlycoNode();
                t_objNew.setName(t_objSubst.getName());
                this.m_hashResidues.put(a_objSubstituent, t_objNew);
                this.m_objUnit.addNode(t_objNew);
                this.copyParentLinkage(a_objSubstituent.getParentEdge(), t_objNew);
            }
            catch (ResourcesDbException e) {
                throw new GlycoVisitorException("Unable to translate " + a_objSubstituent.getSubstituentType().getName() + " : " + e.getMessage(), e);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    private org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType createLinkageType(LinkageType a_objLinkageType) throws GlycoVisitorException {
        try {
            return org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType.forName((char)a_objLinkageType.getType());
        }
        catch (org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    private boolean isCollapsed(GlycoEdge a_objSubLinakge, Substituent a_objResidue, ArrayList<SubstituentExchangeObject> a_aSubstitutents) {
        for (SubstituentExchangeObject t_objSubst : a_aSubstitutents) {
            if (!this.isSubstituten(a_objResidue, a_objSubLinakge, t_objSubst)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubstituten(Substituent a_objSubst, GlycoEdge a_objEdge, SubstituentExchangeObject a_objSubstExchange) {
        if (a_objSubstExchange.getOriginalName().equals(a_objSubst.getSubstituentType().getName())) {
            int t_iCounter = 0;
            if (a_objSubstExchange.getLinkagetype1() != null) {
                ++t_iCounter;
            }
            if (a_objSubstExchange.getLinkagetype2() != null) {
                ++t_iCounter;
            }
            if (a_objSubstExchange.getLinkagetype3() != null) {
                ++t_iCounter;
            }
            if (t_iCounter != a_objEdge.getGlycosidicLinkages().size()) {
                return false;
            }
            for (Linkage t_objLinkage : a_objEdge.getGlycosidicLinkages()) {
                if (this.isLinkage(t_objLinkage, a_objSubstExchange.getLinkagetype1(), this.createNormalLinkagePosition(a_objSubstExchange.getPosition1()), this.createNormalLinkagePosition(a_objSubstExchange.getSubstituentPosition1())) || this.isLinkage(t_objLinkage, a_objSubstExchange.getLinkagetype2(), this.createNormalLinkagePosition(a_objSubstExchange.getPosition2()), this.createNormalLinkagePosition(a_objSubstExchange.getSubstituentPosition2())) || this.isLinkage(t_objLinkage, a_objSubstExchange.getLinkagetype3(), this.createNormalLinkagePosition(a_objSubstExchange.getPosition3()), this.createNormalLinkagePosition(a_objSubstExchange.getSubstituentPosition3()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isLinkage(Linkage a_objLinkage, org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType a_objLinkageType, ArrayList<Integer> a_aPositionsParent, ArrayList<Integer> a_aPositionsSubst) {
        if (a_objLinkageType == null) {
            return false;
        }
        if (a_objLinkageType.getType() != a_objLinkage.getParentLinkageType().getType()) {
            return false;
        }
        if (a_aPositionsParent.size() != a_objLinkage.getParentLinkages().size()) {
            return false;
        }
        if (a_aPositionsSubst.size() != a_objLinkage.getChildLinkages().size()) {
            return false;
        }
        for (Integer t_iPosition : a_objLinkage.getParentLinkages()) {
            if (!(t_iPosition == -1 ? !a_aPositionsParent.contains(-1) : !a_aPositionsParent.contains(t_iPosition))) continue;
            return false;
        }
        for (Integer t_iPosition : a_objLinkage.getChildLinkages()) {
            if (!(t_iPosition == -1 ? !a_aPositionsSubst.contains(-1) : !a_aPositionsSubst.contains(t_iPosition))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            this.m_objNewSugar = new Sugar();
            this.m_objUnit = this.m_objNewSugar;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objSugar);
            try {
                Iterator<UnderdeterminedSubTree> t_iterSpezialTrees = a_objSugar.getUndeterminedSubTrees().iterator();
                while (t_iterSpezialTrees.hasNext()) {
                    GlycoVisitorFromGlycoCT t_objVisitor = new GlycoVisitorFromGlycoCT(this.m_objConverter, this.m_strSchema);
                    UnderdeterminedSubTree t_objSubtreeOriginal = t_iterSpezialTrees.next();
                    UnderdeterminedSubTree t_objSubtree = t_objVisitor.start(t_objSubtreeOriginal);
                    this.m_objNewSugar.addUndeterminedSubTree(t_objSubtree);
                    GlycoEdge t_objEdge = t_objSubtreeOriginal.getConnection().copy();
                    for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
                        t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
                        t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
                    }
                    t_objSubtree.setConnection(t_objEdge);
                    t_objSubtree.setProbability(t_objSubtreeOriginal.getProbabilityLower(), t_objSubtreeOriginal.getProbabilityUpper());
                    Iterator<GlycoNode> t_iterParents = t_objSubtreeOriginal.getParents().iterator();
                    while (t_iterParents.hasNext()) {
                        GlycoNode t_objParent = this.m_hashResidues.get(t_iterParents.next());
                        if (t_objParent == null) {
                            throw new GlycoVisitorException("Crictial error by adding null as a parent of a UnderdeterminedSubTree.");
                        }
                        this.m_objNewSugar.addUndeterminedSubTreeParent(t_objSubtree, t_objParent);
                    }
                }
                for (AlternativeMapping t_objAlternative : this.m_aAlternative) {
                    HashMap<GlycoNode, GlycoNode> t_hMapNew = new HashMap<GlycoNode, GlycoNode>();
                    HashMap<GlycoNode, GlycoNode> t_hMapOld = t_objAlternative.getGraphOriginal().getLeadOutNodeToNode();
                    HashMap<GlycoNode, GlycoNode> t_hIntern = t_objAlternative.getMapping();
                    for (GlycoNode t_objOuterOld : t_hMapOld.keySet()) {
                        GlycoNode t_objOuterNew = this.m_hashResidues.get(t_objOuterOld);
                        if (t_objOuterNew == null) {
                            throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                        }
                        GlycoNode t_objInnerOld = t_hMapOld.get(t_objOuterOld);
                        GlycoNode t_objInnerNew = t_hIntern.get(t_objInnerOld);
                        if (t_objInnerNew == null) {
                            throw new GlycoconjugateException("Error child inner attache position of alternative graph was not translated.");
                        }
                        t_hMapNew.put(t_objOuterNew, t_objInnerNew);
                    }
                    t_objAlternative.getCopy().setLeadOutNodeToNode(t_hMapNew, t_objAlternative.getGraphCopy());
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    private SugarUnitRepeat start(SugarUnitRepeat a_objSugar) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            this.m_objRepeat = new SugarUnitRepeat();
            this.m_objUnit = this.m_objRepeat;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objSugar);
            this.m_objRepeat.setMinRepeatCount(a_objSugar.getMinRepeatCount());
            this.m_objRepeat.setMaxRepeatCount(a_objSugar.getMaxRepeatCount());
            try {
                GlycoEdge t_objOringal = a_objSugar.getRepeatLinkage();
                GlycoEdge t_objInternal = t_objOringal.copy();
                for (Linkage t_objLinkage : t_objInternal.getGlycosidicLinkages()) {
                    t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
                    t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
                }
                this.m_objRepeat.setRepeatLinkage(t_objInternal, this.m_hashResidues.get(t_objOringal.getParent()), this.m_hashResidues.get(t_objOringal.getChild()));
                Iterator<UnderdeterminedSubTree> t_iterSpezialTrees = a_objSugar.getUndeterminedSubTrees().iterator();
                while (t_iterSpezialTrees.hasNext()) {
                    GlycoVisitorFromGlycoCT t_objVisitor = new GlycoVisitorFromGlycoCT(this.m_objConverter, this.m_strSchema);
                    UnderdeterminedSubTree t_objSubtreeOriginal = t_iterSpezialTrees.next();
                    UnderdeterminedSubTree t_objSubtree = t_objVisitor.start(t_objSubtreeOriginal);
                    this.m_objRepeat.addUndeterminedSubTree(t_objSubtree);
                    GlycoEdge t_objEdge = t_objSubtreeOriginal.getConnection().copy();
                    for (Linkage t_objLinkage : t_objEdge.getGlycosidicLinkages()) {
                        t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
                        t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
                    }
                    t_objSubtree.setConnection(t_objEdge);
                    t_objSubtree.setProbability(t_objSubtreeOriginal.getProbabilityLower(), t_objSubtreeOriginal.getProbabilityUpper());
                    Iterator<GlycoNode> t_iterParents = t_objSubtreeOriginal.getParents().iterator();
                    while (t_iterParents.hasNext()) {
                        GlycoNode t_objParent = this.m_hashResidues.get(t_iterParents.next());
                        if (t_objParent == null) {
                            throw new GlycoVisitorException("Crictial error by adding null as a parent of a UnderdeterminedSubTree.");
                        }
                        this.m_objRepeat.addUndeterminedSubTreeParent(t_objSubtree, t_objParent);
                    }
                }
                for (AlternativeMapping t_objAlternative : this.m_aAlternative) {
                    HashMap<GlycoNode, GlycoNode> t_hMapNew = new HashMap<GlycoNode, GlycoNode>();
                    HashMap<GlycoNode, GlycoNode> t_hMapOld = t_objAlternative.getGraphOriginal().getLeadOutNodeToNode();
                    HashMap<GlycoNode, GlycoNode> t_hIntern = t_objAlternative.getMapping();
                    for (GlycoNode t_objOuterOld : t_hMapOld.keySet()) {
                        GlycoNode t_objOuterNew = this.m_hashResidues.get(t_objOuterOld);
                        if (t_objOuterNew == null) {
                            throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                        }
                        GlycoNode t_objInnerOld = t_hMapOld.get(t_objOuterOld);
                        GlycoNode t_objInnerNew = t_hIntern.get(t_objInnerOld);
                        if (t_objInnerNew == null) {
                            throw new GlycoconjugateException("Error child inner attache position of alternative graph was not translated.");
                        }
                        t_hMapNew.put(t_objOuterNew, t_objInnerNew);
                    }
                    t_objAlternative.getCopy().setLeadOutNodeToNode(t_hMapNew, t_objAlternative.getGraphCopy());
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
        return this.m_objRepeat;
    }

    private UnderdeterminedSubTree start(UnderdeterminedSubTree a_objSubtree) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            this.m_objSubTree = new UnderdeterminedSubTree();
            this.m_objUnit = this.m_objSubTree;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objSubtree);
        }
        return this.m_objSubTree;
    }

    private void copyParentLinkage(GlycoEdge a_objOrigin, GlycoNode a_objNode) throws GlycoVisitorException {
        if (a_objOrigin != null) {
            GlycoNode t_objParent = this.m_hashResidues.get(a_objOrigin.getParent());
            if (t_objParent == null) {
                throw new GlycoVisitorException("Critical error while translating: could not found a parent residue.");
            }
            try {
                GlycoEdge t_objNewLinkage = a_objOrigin.copy();
                for (Linkage t_objLinkage : t_objNewLinkage.getGlycosidicLinkages()) {
                    t_objLinkage.setParentLinkageType(LinkageType.UNVALIDATED);
                    t_objLinkage.setChildLinkageType(LinkageType.UNVALIDATED);
                }
                this.m_objUnit.addEdge(t_objParent, a_objNode, t_objNewLinkage);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    private EcdbMonosaccharide createBaseType(Monosaccharide a_objMS) throws org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException, GlycoconjugateException {
        EcdbMonosaccharide t_objMS = new EcdbMonosaccharide(EcdbAnomer.forName((char)a_objMS.getAnomer().getSymbol().charAt(0)), EcdbSuperclass.forCAtoms((int)a_objMS.getSuperclass().getCAtomCount()));
        Integer t_objEnd = a_objMS.getRingEnd() == -1 ? Integer.valueOf(-1) : (a_objMS.getRingEnd() == 0 ? Integer.valueOf(0) : Integer.valueOf(a_objMS.getRingEnd()));
        Integer t_objStart = a_objMS.getRingStart() == -1 ? Integer.valueOf(-1) : (a_objMS.getRingStart() == 0 ? Integer.valueOf(0) : Integer.valueOf(a_objMS.getRingStart()));
        t_objMS.setRing(t_objStart.intValue(), t_objEnd.intValue());
        Iterator<BaseType> t_iterBasetype = a_objMS.getBaseType().iterator();
        while (t_iterBasetype.hasNext()) {
            t_objMS.addBaseType(EcdbBaseType.forName((String)t_iterBasetype.next().getName()));
        }
        Iterator<Modification> t_iterModification = a_objMS.getModification().iterator();
        while (t_iterModification.hasNext()) {
            t_objMS.addModification(this.createModification(t_iterModification.next()));
        }
        return t_objMS;
    }

    private EcdbModification createModification(Modification a_objModification) throws org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException {
        if (a_objModification.hasPositionTwo()) {
            return new EcdbModification(a_objModification.getName(), Integer.valueOf(a_objModification.getPositionOne()), a_objModification.getPositionTwo());
        }
        return new EcdbModification(a_objModification.getName(), Integer.valueOf(a_objModification.getPositionOne()));
    }

    private GlycoGraphAlternative start(GlycoGraphAlternative a_objAlternative, SugarUnitAlternative a_objAlternativeUnit) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            try {
                this.m_objAlternative = new GlycoGraphAlternative();
                this.m_objUnit = this.m_objAlternative;
                a_objAlternativeUnit.addAlternative(this.m_objAlternative);
                this.m_objTraverser = this.getTraverser(this);
                this.m_objTraverser.traverseGraph(a_objAlternative);
                GlycoNode t_objNode = a_objAlternative.getLeadInNode();
                if (t_objNode != null) {
                    if ((t_objNode = this.m_hashResidues.get(t_objNode)) == null) {
                        throw new GlycoVisitorException("Error translating alternative parent attach node.");
                    }
                    a_objAlternativeUnit.setLeadInNode(t_objNode, this.m_objAlternative);
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
        return this.m_objAlternative;
    }

    private HashMap<GlycoNode, GlycoNode> getResidueMapping() {
        return this.m_hashResidues;
    }

    public void setNameScheme(GlycanNamescheme a_strSchema) {
        this.m_strSchema = a_strSchema;
    }

    private ArrayList<Integer> createExchangeLinkagePosition(ArrayList<Integer> a_aPositions) {
        ArrayList<Integer> t_aPositions = new ArrayList<Integer>();
        for (Integer t_iPos : a_aPositions) {
            if (t_iPos == -1) {
                t_aPositions.add(0);
                continue;
            }
            t_aPositions.add(t_iPos);
        }
        return t_aPositions;
    }

    private ArrayList<Integer> createNormalLinkagePosition(ArrayList<Integer> a_aPositions) {
        ArrayList<Integer> t_aPositions = new ArrayList<Integer>();
        for (Integer t_iPos : a_aPositions) {
            if (t_iPos == 0) {
                t_aPositions.add(-1);
                continue;
            }
            t_aPositions.add(t_iPos);
        }
        return t_aPositions;
    }
}

