/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.util.visitor.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlycoNode
implements Visitable {
    protected GlycoEdge m_objParentLinkage = null;
    protected ArrayList<GlycoEdge> m_aChildLinkages = new ArrayList();

    public abstract GlycoNode copy() throws GlycoconjugateException;

    protected void setChildEdge(ArrayList<GlycoEdge> a_aChilds) throws GlycoconjugateException {
        if (a_aChilds == null) {
            throw new GlycoconjugateException("Null is not a valid set of edges.");
        }
        this.m_aChildLinkages.clear();
        Iterator<GlycoEdge> t_iterEdge = a_aChilds.iterator();
        while (t_iterEdge.hasNext()) {
            this.addChildEdge(t_iterEdge.next());
        }
    }

    public ArrayList<GlycoEdge> getChildEdges() {
        return this.m_aChildLinkages;
    }

    protected void setParentEdge(GlycoEdge a_objLinkage) {
        this.m_objParentLinkage = a_objLinkage;
    }

    public GlycoEdge getParentEdge() {
        return this.m_objParentLinkage;
    }

    public ArrayList<GlycoNode> getChildNodes() {
        ArrayList<GlycoNode> t_aResult = new ArrayList<GlycoNode>();
        Iterator<GlycoEdge> t_iterLinakges = this.m_aChildLinkages.iterator();
        while (t_iterLinakges.hasNext()) {
            GlycoNode t_objResidue = t_iterLinakges.next().getChild();
            if (t_aResult.contains(t_objResidue)) continue;
            t_aResult.add(t_objResidue);
        }
        return t_aResult;
    }

    public GlycoNode getParentNode() {
        if (this.m_objParentLinkage == null) {
            return null;
        }
        return this.m_objParentLinkage.getParent();
    }

    protected boolean addChildEdge(GlycoEdge a_linkSubStructure) throws GlycoconjugateException {
        if (a_linkSubStructure == null) {
            throw new GlycoconjugateException("null edge is not allowed.");
        }
        if (!this.m_aChildLinkages.contains(a_linkSubStructure)) {
            return this.m_aChildLinkages.add(a_linkSubStructure);
        }
        return false;
    }

    protected boolean removeParentEdge(GlycoEdge a_objLinkage) throws GlycoconjugateException {
        if (a_objLinkage != this.m_objParentLinkage) {
            throw new GlycoconjugateException("Cant delete invalid parent edge.");
        }
        this.m_objParentLinkage = null;
        return true;
    }

    protected boolean removeChildEdge(GlycoEdge a_objLinkage) throws GlycoconjugateException {
        if (a_objLinkage == null) {
            throw new GlycoconjugateException("Cant delete null linkage.");
        }
        if (!this.m_aChildLinkages.contains(a_objLinkage)) {
            return false;
        }
        return this.m_aChildLinkages.remove(a_objLinkage);
    }

    public void removeAllEdges() {
        this.m_objParentLinkage = null;
        this.m_aChildLinkages = new ArrayList();
    }
}

