/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.GraphFragmenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.analytical.GraphFragmenter.CombinationGenerator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.MatrixDataObject;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugarFragmenter {
    private Vector<MatrixDataObject> v_SugarGraphFlat = new Vector();
    private ArrayList<Sugar> result = new ArrayList();
    private ArrayList<MDOList> connectedEntitiesMDO = new ArrayList();
    private Integer upperBound = 3;
    private Integer lowerBound = 0;
    private HashMap<GlycoNode, GlycoNode> lookupHash = new HashMap();
    private ArrayList<GlycoNode> sugArray = new ArrayList();

    public ArrayList<Sugar> fragment(Sugar sugar) {
        this.clear();
        SearchVisitor sv = new SearchVisitor();
        try {
            sv.start(sugar);
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        this.v_SugarGraphFlat = sv.getVector();
        this.FragmentationRoutine();
        ArrayList<MDOList> temp = new ArrayList<MDOList>();
        for (MDOList m : this.connectedEntitiesMDO) {
            if (m.getMSCount() >= this.upperBound || m.getMSCount() <= this.lowerBound) continue;
            temp.add(m);
        }
        this.connectedEntitiesMDO = temp;
        this.GenerateSugars();
        return this.result;
    }

    private void clear() {
        this.connectedEntitiesMDO.clear();
        this.lookupHash.clear();
        this.result.clear();
        this.sugArray.clear();
        this.v_SugarGraphFlat.clear();
    }

    private void GenerateSugars() {
        for (MDOList MDOSugar : this.connectedEntitiesMDO) {
            if (MDOSugar.MDOList.size() == 0) continue;
            ArrayList<MatrixDataObject> connectedEntities = MDOSugar.MDOList;
            Sugar sug = new Sugar();
            this.lookupHash.clear();
            this.sugArray.clear();
            for (MatrixDataObject t_mdo : connectedEntities) {
                try {
                    GlycoNode t_node = t_mdo.getNode().copy();
                    sug.addNode(t_node);
                    this.lookupHash.put(t_node, t_mdo.getNode());
                    this.sugArray.add(t_node);
                }
                catch (GlycoconjugateException e) {
                    e.printStackTrace();
                }
            }
            HashSet<GlycoNode> usedParents = new HashSet<GlycoNode>();
            HashSet<GlycoNode> usedChildren = new HashSet<GlycoNode>();
            usedChildren.add(this.sugArray.get(0));
            for (GlycoNode nodeProcessed : this.sugArray) {
                MatrixDataObject t_corresponding = new MatrixDataObject();
                for (MatrixDataObject t_mdo : connectedEntities) {
                    if (t_mdo.getNode() != this.lookupHash.get(nodeProcessed)) continue;
                    t_corresponding = t_mdo;
                    break;
                }
                for (GlycoEdge t_edgeConnectedEntities : t_corresponding.getChildren()) {
                    ArrayList<Linkage> lin = t_edgeConnectedEntities.getGlycosidicLinkages();
                    GlycoEdge t_edge = new GlycoEdge();
                    GlycoNode t_sugChild = null;
                    block9: for (GlycoNode g : this.sugArray) {
                        for (Map.Entry<GlycoNode, GlycoNode> t_node : this.lookupHash.entrySet()) {
                            if (t_node.getKey() != g || t_node.getValue() != t_edgeConnectedEntities.getChild() || t_node.getKey() == nodeProcessed || usedChildren.contains(t_node.getKey())) continue;
                            t_sugChild = t_node.getKey();
                            usedChildren.add(t_sugChild);
                            break block9;
                        }
                    }
                    try {
                        t_edge.setGlycosidicLinkages(lin);
                        t_edge.setChild(t_sugChild);
                        t_edge.setParent(nodeProcessed);
                        if (t_sugChild == null || t_edge == null) continue;
                        sug.addEdge(nodeProcessed, t_sugChild, t_edge);
                        usedParents.add(nodeProcessed);
                    }
                    catch (GlycoconjugateException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.result.add(sug);
        }
    }

    private void FragmentationRoutine() {
        for (MatrixDataObject startingPoint : this.v_SugarGraphFlat) {
            MDOList t_resultListMDO = new MDOList();
            t_resultListMDO.addMDO(startingPoint);
            ArrayList<GlycoNode> children = new ArrayList<GlycoNode>();
            for (GlycoEdge edge : startingPoint.getChildren()) {
                children.add(edge.getChild());
            }
            this.permutate(t_resultListMDO, children);
        }
    }

    private void permutate(MDOList startingListWithParent, ArrayList<GlycoNode> startingNodes) {
        ArrayList<GlycoNode> ChildNodesCombinatorics = new ArrayList<GlycoNode>();
        for (int a = 1; a <= startingNodes.size(); ++a) {
            CombinationGenerator x = new CombinationGenerator(startingNodes.size(), a);
            while (x.hasMore()) {
                int[] indices;
                ChildNodesCombinatorics.clear();
                for (int element : indices = x.getNext()) {
                    ChildNodesCombinatorics.add(startingNodes.get(element));
                }
                ArrayList<MDOList> t_result = new ArrayList<MDOList>();
                t_result.add(startingListWithParent.copy());
                ArrayList<GlycoNode> history = new ArrayList<GlycoNode>();
                ArrayList<MatrixDataObject> altVerzweigung = new ArrayList<MatrixDataObject>();
                for (MatrixDataObject t_mdo : this.v_SugarGraphFlat) {
                    for (GlycoNode node : ChildNodesCombinatorics) {
                        if (t_mdo.getNode() != node) continue;
                        if (!history.contains(t_mdo.getNode())) {
                            for (MDOList t_element : t_result) {
                                t_element.addMDO(t_mdo);
                                history.add(t_mdo.getNode());
                                for (GlycoEdge t_edge : t_mdo.getChildren()) {
                                    t_element.NodeList.add(t_edge.getChild());
                                }
                            }
                            continue;
                        }
                        altVerzweigung.add(t_mdo);
                    }
                }
                for (MDOList t_element : t_result) {
                    this.connectedEntitiesMDO.add(t_element);
                    if (t_element.getMSCount() >= this.upperBound) continue;
                    this.permutate(t_element, t_element.NodeList);
                }
                for (MatrixDataObject altMdo : altVerzweigung) {
                    MDOList temp = ((MDOList)t_result.get(0)).clone();
                    for (MatrixDataObject mdo : ((MDOList)t_result.get((int)0)).MDOList) {
                        if (mdo.getNode() != altMdo.getNode() || !history.contains(mdo.getNode())) continue;
                        temp.remove(mdo);
                        for (GlycoEdge edge : mdo.getChildren()) {
                            temp.remove(edge.getChild());
                        }
                    }
                    for (GlycoEdge edge : altMdo.getChildren()) {
                        ((MDOList)t_result.get((int)0)).NodeList.add(edge.getChild());
                    }
                    ((MDOList)t_result.get((int)0)).MDOList.add(altMdo);
                    for (MDOList t_element : t_result) {
                        this.connectedEntitiesMDO.add(t_element);
                        if (t_element.getMSCount() >= this.upperBound) continue;
                        this.permutate(t_element, t_element.NodeList);
                    }
                }
            }
        }
    }

    public void setSize(Integer size) {
        this.lowerBound = 0;
        this.upperBound = size;
    }

    public void setUpperSizeLimit(Integer size) {
        this.upperBound = size;
    }

    public void setLowerSizeLimit(Integer size) {
        this.lowerBound = size;
    }

    public class MDOList
    implements Cloneable {
        public ArrayList<MatrixDataObject> MDOList = new ArrayList();
        public ArrayList<GlycoNode> NodeList = new ArrayList();

        public MDOList clone() {
            try {
                super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            MDOList temp = new MDOList();
            temp.MDOList = (ArrayList)this.MDOList.clone();
            temp.NodeList = (ArrayList)this.NodeList.clone();
            return temp;
        }

        public void addMDO(MatrixDataObject mdo) {
            this.MDOList.add(mdo);
        }

        public void remove(MatrixDataObject mdo) {
            this.MDOList.remove(mdo);
        }

        public void remove(GlycoNode node) {
            ArrayList<MatrixDataObject> candidates = new ArrayList<MatrixDataObject>();
            for (MatrixDataObject object : this.MDOList) {
                if (object.getNode() != node) continue;
                candidates.add(object);
            }
            this.MDOList.removeAll(candidates);
        }

        public Integer getMSCount() {
            Integer counter = 0;
            GlycoVisitorNodeType gType = new GlycoVisitorNodeType();
            for (MatrixDataObject m : this.MDOList) {
                gType.clear();
                try {
                    if (!gType.isMonosaccharide(m.getNode())) continue;
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                }
                catch (GlycoVisitorException e) {
                    e.printStackTrace();
                }
            }
            return counter;
        }

        public MatrixDataObject getMDO(GlycoNode node) {
            for (MatrixDataObject mdo : this.MDOList) {
                if (mdo.getNode() != node) continue;
                return mdo;
            }
            return null;
        }

        public MDOList copy() {
            MDOList copy = new MDOList();
            for (MatrixDataObject m : this.MDOList) {
                copy.MDOList.add(m.copy());
            }
            for (GlycoNode node : this.NodeList) {
                copy.NodeList.add(node);
            }
            return copy;
        }
    }
}

