/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.validation.GlycoVisitorContainsNode;
import org.eurocarbdb.MolecularFramework.util.validation.GlycoVisitorContainsNodeBelow;
import org.eurocarbdb.MolecularFramework.util.validation.GlycoVisitorSugarGraphRepeatCopy;
import org.eurocarbdb.MolecularFramework.util.validation.GlycoVisitorSugarGraphUndCopy;
import org.eurocarbdb.MolecularFramework.util.validation.SugarGraphAglycon;
import org.eurocarbdb.MolecularFramework.util.validation.SugarGraphInformation;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoVisitorSugarGraph
implements GlycoVisitor {
    private HashMap<GlycoNode, GlycoNode> m_hashResidues = new HashMap();
    private ArrayList<SugarGraphInformation> m_aSugarGraphs = new ArrayList();
    private GlycoNode m_objStartResidue = null;
    private GlycoTraverser m_objTraverser = null;
    private GlycoGraph m_objSugarUnit;
    private SugarGraphInformation m_objCurrentSugarGraph = null;
    private GlycoNode m_objLastResidue = null;
    private GlycoEdge m_objLastEdge = null;
    private GlycoNode m_objTerminalAglyca = null;
    private boolean m_bAllowFragmented = false;

    public void setAllowFragmented(boolean a_bValue) {
        this.m_bAllowFragmented = a_bValue;
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharide) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            if (this.m_objStartResidue != null) {
                try {
                    Monosaccharide t_objMs = a_objMonosaccharide.copy();
                    this.m_objLastResidue = a_objMonosaccharide;
                    this.m_objSugarUnit.addNode(t_objMs);
                    this.m_hashResidues.put(a_objMonosaccharide, t_objMs);
                    this.m_objCurrentSugarGraph.addTopLevelNode(a_objMonosaccharide, t_objMs);
                    GlycoEdge t_objEdgeOriginal = a_objMonosaccharide.getParentEdge();
                    GlycoEdge t_objEdgeNew = t_objEdgeOriginal.copy();
                    GlycoNode t_objParent = this.m_hashResidues.get(t_objEdgeOriginal.getParent());
                    if (t_objParent == null) {
                        throw new GlycoVisitorException("Unable to copy monosaccharide : " + a_objMonosaccharide.getGlycoCTName() + " parent was not translated.");
                    }
                    this.m_objSugarUnit.addEdge(t_objParent, t_objMs, t_objEdgeNew);
                }
                catch (GlycoconjugateException e) {
                    throw new GlycoVisitorException(e.getMessage(), e);
                }
            }
            Sugar t_objSugar = new Sugar();
            this.m_hashResidues.clear();
            this.m_objCurrentSugarGraph = a_objMonosaccharide.getParentEdge() != null ? new SugarGraphInformation(t_objSugar, a_objMonosaccharide.getParentNode(), a_objMonosaccharide, a_objMonosaccharide.getParentEdge()) : new SugarGraphInformation(t_objSugar, null, a_objMonosaccharide, a_objMonosaccharide.getParentEdge());
            this.m_aSugarGraphs.add(this.m_objCurrentSugarGraph);
            this.m_objSugarUnit = t_objSugar;
            this.m_objStartResidue = a_objMonosaccharide;
            try {
                Monosaccharide t_objMs = a_objMonosaccharide.copy();
                this.m_objLastResidue = a_objMonosaccharide;
                this.m_objSugarUnit.addNode(t_objMs);
                this.m_hashResidues.put(a_objMonosaccharide, t_objMs);
                this.m_objCurrentSugarGraph.addTopLevelNode(a_objMonosaccharide, t_objMs);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
        if (this.m_objTraverser.getState() == 1 && a_objMonosaccharide == this.m_objStartResidue) {
            this.m_objStartResidue = null;
        }
    }

    @Override
    public void visit(Substituent a_objSubst) throws GlycoVisitorException {
        if (this.m_objTerminalAglyca != null) {
            return;
        }
        if (this.m_objTraverser.getState() == 0 && this.m_objStartResidue != null) {
            try {
                Substituent t_objSubst = a_objSubst.copy();
                this.m_objLastResidue = a_objSubst;
                this.m_objSugarUnit.addNode(t_objSubst);
                this.m_hashResidues.put(a_objSubst, t_objSubst);
                this.m_objCurrentSugarGraph.addTopLevelNode(a_objSubst, t_objSubst);
                GlycoEdge t_objEdgeOriginal = a_objSubst.getParentEdge();
                GlycoEdge t_objEdgeNew = t_objEdgeOriginal.copy();
                GlycoNode t_objParent = this.m_hashResidues.get(t_objEdgeOriginal.getParent());
                if (t_objParent == null) {
                    throw new GlycoVisitorException("Unable to copy monosaccharide : " + a_objSubst.getSubstituentType().getName() + " parent was not translated.");
                }
                this.m_objSugarUnit.addEdge(t_objParent, t_objSubst, t_objEdgeNew);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void visit(GlycoEdge arg0) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            this.m_objLastEdge = arg0;
        }
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (this.m_objTerminalAglyca != null) {
            return;
        }
        if (this.m_objTraverser.getState() == 0 && this.m_objStartResidue != null) {
            GlycoNode t_objTarget = this.m_hashResidues.get(a_objCyclic.getCyclicStart());
            if (t_objTarget == null) {
                throw new GlycoVisitorException("Start point of a cyclic unit is not part of the new sugar.");
            }
            GlycoEdge t_objEdgeOriginal = a_objCyclic.getParentEdge();
            try {
                GlycoEdge t_objEdgeNew = t_objEdgeOriginal.copy();
                GlycoNode t_objParent = this.m_hashResidues.get(t_objEdgeOriginal.getParent());
                if (t_objParent == null) {
                    throw new GlycoVisitorException("Unable to copy cylic unit : parent was not translated.");
                }
                this.m_objSugarUnit.addEdge(t_objParent, t_objTarget, t_objEdgeNew);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objTerminalAglyca != null) {
            return;
        }
        if (this.m_objTraverser.getState() == 0) {
            if (this.m_objStartResidue == null) {
                GlycoVisitorContainsNode t_objVisitor = new GlycoVisitorContainsNode();
                t_objVisitor.start(a_objAlternative);
                if (t_objVisitor.getMonosaccharideCount() > 0) {
                    if (t_objVisitor.getNonMonosaccharideCount() > 0) {
                        throw new GlycoVisitorException("GlycoVisitorSugarGraph can not handle alternative sugar units that consist of monosaccharides and aglyca.");
                    }
                    Sugar t_objSugar = new Sugar();
                    this.m_hashResidues.clear();
                    this.m_objCurrentSugarGraph = a_objAlternative.getParentEdge() != null ? new SugarGraphInformation(t_objSugar, a_objAlternative.getParentNode(), a_objAlternative, a_objAlternative.getParentEdge()) : new SugarGraphInformation(t_objSugar, null, a_objAlternative, a_objAlternative.getParentEdge());
                    this.m_aSugarGraphs.add(this.m_objCurrentSugarGraph);
                    this.m_objSugarUnit = t_objSugar;
                    this.m_objStartResidue = a_objAlternative;
                    try {
                        SugarUnitAlternative t_objMs = a_objAlternative.copy();
                        this.m_objLastResidue = a_objAlternative;
                        this.m_objSugarUnit.addNode(t_objMs);
                        this.m_hashResidues.put(a_objAlternative, t_objMs);
                        this.m_objCurrentSugarGraph.addTopLevelNode(a_objAlternative, t_objMs);
                    }
                    catch (GlycoconjugateException e) {
                        throw new GlycoVisitorException(e.getMessage(), e);
                    }
                }
            } else {
                GlycoVisitorContainsNode t_objVisitor = new GlycoVisitorContainsNode();
                t_objVisitor.start(a_objAlternative);
                if (t_objVisitor.getMonosaccharideCount() > 0) {
                    if (t_objVisitor.getNonMonosaccharideCount() > 0) {
                        throw new GlycoVisitorException("GlycoVisitorSugarGraph can not handle alternative sugar units that consist of monosaccharides and aglyca.");
                    }
                    try {
                        SugarUnitAlternative t_objMs = a_objAlternative.copy();
                        this.m_objLastResidue = a_objAlternative;
                        this.m_objSugarUnit.addNode(t_objMs);
                        this.m_hashResidues.put(a_objAlternative, t_objMs);
                        this.m_objCurrentSugarGraph.addTopLevelNode(a_objAlternative, t_objMs);
                    }
                    catch (GlycoconjugateException e) {
                        throw new GlycoVisitorException(e.getMessage(), e);
                    }
                }
            }
        }
        if (this.m_objTraverser.getState() == 1) {
            throw new GlycoVisitorException("GlycoVisitorSugarGraph can not handle alternative residues.");
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNodes are not allowed for Visitor GlycoVisitorSugarGraph.");
    }

    @Override
    public void visit(NonMonosaccharide a_objNonMonosaccharide) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            if (this.m_objStartResidue != null) {
                if (this.m_objTerminalAglyca != null) {
                    return;
                }
                SugarGraphAglycon t_objTerminalAglycon = new SugarGraphAglycon(a_objNonMonosaccharide, this.m_objLastResidue, this.m_objLastEdge);
                this.m_objCurrentSugarGraph.addTerminalInformation(t_objTerminalAglycon);
                if (a_objNonMonosaccharide.getChildEdges().size() > 0) {
                    GlycoVisitorContainsNodeBelow t_visNodes = new GlycoVisitorContainsNodeBelow();
                    t_visNodes.setDescent(true);
                    t_visNodes.start(a_objNonMonosaccharide);
                    if (t_visNodes.getMonosaccharideCount() != 0) {
                        throw new GlycoVisitorException("Unable to handle terminal aglyca with child residues : " + a_objNonMonosaccharide.getName());
                    }
                }
                this.m_objTerminalAglyca = a_objNonMonosaccharide;
            }
        } else if (this.m_objTraverser.getState() == 1 && this.m_objTerminalAglyca == a_objNonMonosaccharide) {
            this.m_objTerminalAglyca = null;
        }
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_aSugarGraphs.clear();
        this.m_hashResidues.clear();
        this.m_objStartResidue = null;
        this.m_objCurrentSugarGraph = null;
        this.m_objTerminalAglyca = null;
        this.m_objTraverser = null;
        this.m_objLastEdge = null;
        this.m_objLastResidue = null;
        this.m_objSugarUnit = null;
    }

    public ArrayList<SugarGraphInformation> getSugarGraphs() {
        return this.m_aSugarGraphs;
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        if (this.m_objTerminalAglyca != null) {
            return;
        }
        if (this.m_objTraverser.getState() == 0) {
            if (this.m_objStartResidue == null) {
                GlycoVisitorContainsNode t_objVisitor = new GlycoVisitorContainsNode();
                t_objVisitor.start(a_objRepeat);
                if (t_objVisitor.getMonosaccharideCount() > 0) {
                    t_objVisitor.setDescent(false);
                    t_objVisitor.start(a_objRepeat);
                    if (t_objVisitor.getMonosaccharideCount() > 0) {
                        Sugar t_objSugar = new Sugar();
                        this.m_hashResidues.clear();
                        this.m_objCurrentSugarGraph = a_objRepeat.getParentEdge() != null ? new SugarGraphInformation(t_objSugar, a_objRepeat.getParentNode(), a_objRepeat, a_objRepeat.getParentEdge()) : new SugarGraphInformation(t_objSugar, null, a_objRepeat, a_objRepeat.getParentEdge());
                        this.m_aSugarGraphs.add(this.m_objCurrentSugarGraph);
                        this.m_objSugarUnit = t_objSugar;
                        this.m_objStartResidue = a_objRepeat;
                        try {
                            SugarUnitRepeat t_objMs = null;
                            GlycoVisitorSugarGraphRepeatCopy t_visCopy = new GlycoVisitorSugarGraphRepeatCopy();
                            t_visCopy.setSugarGraphInfo(this.m_objCurrentSugarGraph);
                            t_objMs = t_visCopy.start(a_objRepeat);
                            this.m_objLastResidue = a_objRepeat;
                            this.m_objSugarUnit.addNode(t_objMs);
                            this.m_hashResidues.put(a_objRepeat, t_objMs);
                            this.m_objCurrentSugarGraph.addTopLevelNode(a_objRepeat, t_objMs);
                        }
                        catch (GlycoconjugateException e) {
                            throw new GlycoVisitorException(e.getMessage(), e);
                        }
                    } else {
                        GlycoVisitorContainsNodeBelow t_objVisitorBelow = new GlycoVisitorContainsNodeBelow();
                        t_objVisitorBelow.setDescent(true);
                        t_objVisitorBelow.start(a_objRepeat);
                        if (t_objVisitorBelow.getMonosaccharideCount() > 0) {
                            throw new GlycoVisitorException("Unable to handle repeat units that contains NonMonosaccharide Units and have Monosaccharide childs.");
                        }
                        GlycoVisitorSugarGraph t_objVisitorGraph = new GlycoVisitorSugarGraph();
                        t_objVisitorGraph.start(a_objRepeat);
                        this.m_aSugarGraphs.addAll(t_objVisitorGraph.getSugarGraphs());
                    }
                }
            } else {
                GlycoVisitorContainsNode t_objVisitor = new GlycoVisitorContainsNode();
                t_objVisitor.start(a_objRepeat);
                if (t_objVisitor.getNonTerminalNonMonosaccharideCount() > 0) {
                    throw new GlycoVisitorException("Unable to handle repeat units that contains NonMonosaccharide Units.");
                }
                try {
                    SugarUnitRepeat t_objUnit = null;
                    GlycoVisitorSugarGraphRepeatCopy t_visCopy = new GlycoVisitorSugarGraphRepeatCopy();
                    t_visCopy.setSugarGraphInfo(this.m_objCurrentSugarGraph);
                    t_objUnit = t_visCopy.start(a_objRepeat);
                    this.m_hashResidues.put(a_objRepeat, t_objUnit);
                    this.m_objCurrentSugarGraph.addTopLevelNode(a_objRepeat, t_objUnit);
                    this.m_objSugarUnit.addNode(t_objUnit);
                    this.m_objLastResidue = a_objRepeat;
                    GlycoEdge t_objEdgeOriginal = a_objRepeat.getParentEdge();
                    GlycoEdge t_objEdgeNew = t_objEdgeOriginal.copy();
                    GlycoNode t_objParent = this.m_hashResidues.get(t_objEdgeOriginal.getParent());
                    if (t_objParent == null) {
                        throw new GlycoVisitorException("Unable to copy monosaccharide : repeat unit's parent was not translated.");
                    }
                    this.m_objSugarUnit.addEdge(t_objParent, t_objUnit, t_objEdgeNew);
                }
                catch (GlycoconjugateException e) {
                    throw new GlycoVisitorException(e.getMessage(), e);
                }
            }
        }
        if (this.m_objTraverser.getState() == 1 && a_objRepeat == this.m_objStartResidue) {
            this.m_objStartResidue = null;
        }
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        try {
            this.clear();
            ArrayList<GlycoNode> t_aRoots = a_objSugar.getRootNodes();
            if (t_aRoots.size() > 1 && !this.m_bAllowFragmented) {
                throw new GlycoVisitorException("Unable to create sugar graphs from fragmented sugars.");
            }
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objSugar);
            for (SugarGraphInformation t_objInfo : this.m_aSugarGraphs) {
                HashMap<GlycoNode, GlycoNode> t_hMapping = t_objInfo.getTopLevelNodes();
                Sugar t_objSugar = t_objInfo.getSugar();
                for (UnderdeterminedSubTree t_objUnder : a_objSugar.getUndeterminedSubTrees()) {
                    int t_iCount = 0;
                    Iterator<GlycoNode> t_iterParent = t_objUnder.getParents().iterator();
                    while (t_iterParent.hasNext()) {
                        if (t_hMapping.get(t_iterParent.next()) == null) continue;
                        ++t_iCount;
                    }
                    if (t_iCount <= 0) continue;
                    if (t_iCount != t_objUnder.getParents().size()) {
                        throw new GlycoVisitorException("There is at least one UnderdetermindedSubtree that is only partially connected to a SugarGraph.");
                    }
                    GlycoVisitorSugarGraphUndCopy t_visCopyUND = new GlycoVisitorSugarGraphUndCopy();
                    t_visCopyUND.setSugarGraphInfo(t_objInfo);
                    UnderdeterminedSubTree t_objTreeNew = t_visCopyUND.start(t_objUnder);
                    t_objSugar.addUndeterminedSubTree(t_objTreeNew);
                    GlycoNode t_objNodeNew = null;
                    for (GlycoNode t_objNode : t_objUnder.getParents()) {
                        t_objNodeNew = t_hMapping.get(t_objNode);
                        if (t_objNodeNew == null) {
                            throw new GlycoVisitorException("Parent of UnderdeterminedSubTree is not part of the repeat unit.");
                        }
                        t_objSugar.addUndeterminedSubTreeParent(t_objTreeNew, t_objNodeNew);
                    }
                }
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    public void start(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        try {
            ArrayList<GlycoNode> t_aRoots = a_objRepeat.getRootNodes();
            if (t_aRoots.size() > 1 && !this.m_bAllowFragmented) {
                throw new GlycoVisitorException("Unable to create sugar graphs from fragmented sugars.");
            }
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objRepeat);
            for (SugarGraphInformation t_objInfo : this.m_aSugarGraphs) {
                HashMap<GlycoNode, GlycoNode> t_hMapping = t_objInfo.getTopLevelNodes();
                Sugar t_objSugar = t_objInfo.getSugar();
                GlycoVisitorSugarGraphUndCopy t_visCopyUND = new GlycoVisitorSugarGraphUndCopy();
                t_visCopyUND.setSugarGraphInfo(t_objInfo);
                for (UnderdeterminedSubTree t_objUnder : a_objRepeat.getUndeterminedSubTrees()) {
                    int t_iCount = 0;
                    Iterator<GlycoNode> t_iterParent = t_objUnder.getParents().iterator();
                    while (t_iterParent.hasNext()) {
                        if (t_hMapping.get(t_iterParent.next()) == null) continue;
                        ++t_iCount;
                    }
                    if (t_iCount <= 0) continue;
                    if (t_iCount != t_objUnder.getParents().size()) {
                        throw new GlycoVisitorException("There is at least one UnderdetermindedSubtree that is only partially connected to a SugarGraph.");
                    }
                    UnderdeterminedSubTree t_objTreeNew = t_visCopyUND.start(t_objUnder);
                    t_objSugar.addUndeterminedSubTree(t_objTreeNew);
                    GlycoNode t_objNodeNew = null;
                    for (GlycoNode t_objNode : t_objUnder.getParents()) {
                        t_objNodeNew = t_hMapping.get(t_objNode);
                        if (t_objNodeNew == null) {
                            throw new GlycoVisitorException("Parent of UnderdeterminedSubTree is not part of the repeat unit.");
                        }
                        t_objSugar.addUndeterminedSubTreeParent(t_objTreeNew, t_objNodeNew);
                    }
                }
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }
}

