/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerData;
import org.grits.toolbox.display.control.spectrum.datamodel.MSIonData;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.spectrum.chart.MSAnnotationSpectralViewerChart;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSpectraControlPanelView;
import org.grits.toolbox.entry.ms.exceptions.MSException;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraControlPanelView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.ms.om.data.Feature;

public class MSAnnotationSpectraView
extends MassSpecSpectraView {
    private static final Logger logger = Logger.getLogger(MSAnnotationSpectraView.class);
    protected String sID = null;

    @Inject
    public MSAnnotationSpectraView(Entry entry) {
        super(entry);
    }

    public void setGlycanID(String sGlycanID) {
        this.sID = sGlycanID;
    }

    protected GRITSSpectralViewerData initSpectralViewerData() throws MSException {
        GRITSSpectralViewerData svd = super.initSpectralViewerData();
        try {
            GRITSListDataRow alRow;
            ArrayList alAnnotatedPeaks = svd.getAnnotatedPeaks();
            HashMap htAnnotatedLabels = svd.getAnnotatedPeakLabels();
            ArrayList<MSIonData> alUnAnnotatedPeaks = new ArrayList<MSIonData>();
            HashMap<Double, List<Object>> htUnAnnotatedLabels = new HashMap<Double, List<Object>>();
            svd.setUnAnnotatedPeaks(alUnAnnotatedPeaks);
            svd.setUnAnnotatedPeakLabels(htUnAnnotatedLabels);
            if (this.getPeakListTableProcessor() == null) {
                return svd;
            }
            MSAnnotationTableDataObject msTable = (MSAnnotationTableDataObject)this.getPeakListTableProcessor().getSimianTableDataObject();
            if (msTable.getMzCols() == null || msTable.getMzCols().isEmpty()) {
                return svd;
            }
            int i = 0;
            while (i < msTable.getTableData().size()) {
                alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Object iId = null;
                Double dMz = null;
                Double dIntensity = null;
                String sSequence = null;
                Integer iPeakId = null;
                Integer iScanNum = -1;
                Integer iParentScan = -1;
                String iRowId = null;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                    if (msTable.getFeatureIdCols() != null && !msTable.getFeatureIdCols().isEmpty()) {
                        iId = alRow.getDataRow().get((Integer)msTable.getFeatureIdCols().get(0));
                    }
                    if (msTable.getSequenceCols() != null && !msTable.getSequenceCols().isEmpty()) {
                        sSequence = (String)alRow.getDataRow().get((Integer)msTable.getSequenceCols().get(0));
                    }
                    iPeakId = (Integer)alRow.getDataRow().get((Integer)msTable.getPeakIdCols().get(0));
                    iScanNum = null;
                    if (msTable.getScanNoCols() != null && !msTable.getScanNoCols().isEmpty() && alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0)) != null) {
                        iScanNum = (Integer)alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0));
                    }
                    if (iPeakId != null) {
                        iRowId = Feature.getRowId((Integer)iPeakId, (Integer)iScanNum);
                    }
                    if (msTable.getParentNoCol() != null && !msTable.getParentNoCol().isEmpty() && alRow.getDataRow().get((Integer)msTable.getParentNoCol().get(0)) != null) {
                        iParentScan = (Integer)alRow.getDataRow().get((Integer)msTable.getParentNoCol().get(0));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null) {
                    int iPScan = iParentScan;
                    MSAnnotationTableDataProcessor msap = (MSAnnotationTableDataProcessor)this.getPeakListTableProcessor();
                    if (msap.getMethod().getMsType().equals("Direct Infusion")) {
                        iPScan = msap.getGRITSdata().getFirstMS1Scan();
                    }
                    if (iId != null && iPeakId != null && iRowId != null && !msTable.isHiddenRow(Integer.valueOf(iPScan), iRowId, iId.toString()) && !msTable.isInvisibleRow(Integer.valueOf(iPScan), iRowId)) {
                        MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                        ArrayList alPeaks = alAnnotatedPeaks;
                        HashMap htPeakLabels = htAnnotatedLabels;
                        alPeaks.add(msData);
                        List<Object> al = null;
                        if (htPeakLabels.containsKey(dMz)) {
                            al = (List)htPeakLabels.get(dMz);
                        } else {
                            al = new ArrayList();
                            htPeakLabels.put(dMz, al);
                        }
                        Object sStartLabel = null;
                        Object sLabel = this.getPeakLabel(dMz, iId, sStartLabel, sSequence);
                        if (!al.contains(sLabel)) {
                            al.add(sLabel);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < msTable.getTableData().size()) {
                alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Double dMz = null;
                Double dIntensity = null;
                Object iId = null;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                    if (msTable.getFeatureIdCols() != null && !msTable.getFeatureIdCols().isEmpty()) {
                        iId = alRow.getDataRow().get((Integer)msTable.getFeatureIdCols().get(0));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null && !htAnnotatedLabels.containsKey(dMz) && !htUnAnnotatedLabels.containsKey(dMz)) {
                    MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                    ArrayList<MSIonData> alPeaks = alUnAnnotatedPeaks;
                    HashMap<Double, List<Object>> htPeakLabels = htUnAnnotatedLabels;
                    if (!alPeaks.contains(msData)) {
                        alPeaks.add(msData);
                        List<Object> al = null;
                        if (htPeakLabels.containsKey(dMz)) {
                            al = (List)htPeakLabels.get(dMz);
                        } else {
                            al = new ArrayList();
                            htPeakLabels.put(dMz, al);
                        }
                        Object sStartLabel = null;
                        Object sLabel = this.getPeakLabel(dMz, null, sStartLabel, null);
                        if (iId != null) {
                            sLabel = "User de-selected: " + sLabel;
                        }
                        if (!al.contains(sLabel)) {
                            al.add(sLabel);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return svd;
    }

    protected Object getPeakLabel(Double dMz, Object oFeatureId, Object oPrevLabel, String sFeatureSeq) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (oFeatureId == null) {
            return df.format(dMz);
        }
        String sLabel = String.valueOf(df.format(dMz)) + ", ID: " + oFeatureId.toString();
        return sLabel;
    }

    protected GRITSSpectralViewerChart getNewSpectralViewerChart() {
        return new MSAnnotationSpectralViewerChart(this.sDescription, this.iScanNum, this.iMSLevel, this.bIsCentroid == false, true, this.sID, this.dMz);
    }

    protected void initializeChartPlot() {
        super.initializeChartPlot();
        MSAnnotationViewerPreference pref = (MSAnnotationViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        MSAnnotationSpectraControlPanelView mscp = (MSAnnotationSpectraControlPanelView)this.controlPanel;
        mscp.getUnAnnotatedPeaks().setSelection(pref.isShowUnannotated());
        if (mscp.getUnAnnotatedPeaks().getSelection()) {
            mscp.getUnAnnotatedPeaks().setEnabled(true);
            mscp.getUnAnnotatedPeakLabels().setEnabled(true);
            mscp.getUnAnnotatedPeakLabels().setSelection(pref.isShowUnannotatedLabels());
        }
    }

    public void updateChartPlot() {
        MSAnnotationSpectraControlPanelView cp = (MSAnnotationSpectraControlPanelView)this.controlPanel;
        this.svChart.updateChart(cp.showRaw(), cp.showPickedPeaks(), cp.showPickedPeakLabels(), cp.showAnnotatedPeaks(), cp.showAnnotatedPeakLabels(), cp.showUnAnnotatedPeaks(), cp.showUnAnnotatedPeakLabels());
        this.updatePrefs();
    }

    protected void updatePrefs() {
        super.updatePrefs();
        MSAnnotationViewerPreference pref = (MSAnnotationViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        pref.setShowUnannotated(((MSAnnotationSpectraControlPanelView)this.controlPanel).getUnAnnotatedPeaks().getSelection());
        pref.setShowUnannotatedLabels(((MSAnnotationSpectraControlPanelView)this.controlPanel).getUnAnnotatedPeakLabels().getSelection());
        pref.writePreference();
    }

    protected MassSpecSpectraControlPanelView getNewSpectraControlPanel() {
        return new MSAnnotationSpectraControlPanelView(this);
    }

    public void createChart(Composite parent) throws MSException {
        super.createChart(parent);
    }

    public void createView() throws MSException {
        this.createChart(this.parent);
    }

    @Optional
    @Inject
    void refreshCheckboxes(@UIEventTopic(value="Value_Modified_for_Checkboxes") Entry parentEntry) {
        if (this.getEntry().getParent() != null && this.getEntry().getParent().equals(parentEntry)) {
            MSAnnotationSpectraControlPanelView cp = (MSAnnotationSpectraControlPanelView)this.getControlPanel();
            cp.updateView();
        }
    }
}

