/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.entry.qrtpcr.editor.content.GeneContentProvider;
import org.grits.toolbox.entry.qrtpcr.editor.content.PlateTableViewerSorter;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;

public class DataReviewDialog
extends Dialog {
    QrtPCRData data;
    private boolean changed = false;
    private Tree tree;
    TreeViewer treeViewer;
    List<Gene> toBeRemoved;
    private PlateTableViewerSorter sorter;
    private Double lowerThreshold;
    private Double stDevCutOff;

    public QrtPCRData getData() {
        return this.data;
    }

    public void setData(QrtPCRData data) {
        this.data = data;
    }

    public DataReviewDialog(Shell parent) {
        super(parent);
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        this.sorter = new PlateTableViewerSorter(true);
        this.sorter.setLowerThreshold(this.lowerThreshold);
        this.sorter.setStDevCutOff(this.stDevCutOff);
        this.treeViewer = new TreeViewer(container, 67586);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new GeneContentProvider());
        TreeViewerColumn geneIdColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn tblclmnGeneIdentifier = geneIdColumn.getColumn();
        tblclmnGeneIdentifier.setWidth(200);
        tblclmnGeneIdentifier.setText("Gene Identifier");
        geneIdColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneIdentifier();
                }
                return null;
            }
        });
        TreeViewerColumn positionColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn tblclmnLocation = positionColumn.getColumn();
        tblclmnLocation.setWidth(100);
        tblclmnLocation.setText("Position");
        positionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneData) {
                    return ((GeneData)element).getPosition().toString();
                }
                return null;
            }
        });
        tblclmnLocation.addSelectionListener((SelectionListener)this.getSelectionAdapter(tblclmnLocation, 0));
        this.toBeRemoved = new ArrayList<Gene>();
        Button deleteButton = new Button(container, 0);
        deleteButton.setText("Delete");
        deleteButton.setToolTipText("Remove selected rows");
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selections = DataReviewDialog.this.tree.getSelection();
                int i = 0;
                while (i < selections.length) {
                    TreeItem item = selections[i];
                    Object element = item.getData();
                    if (element instanceof Gene) {
                        DataReviewDialog.this.toBeRemoved.add((Gene)element);
                    }
                    ++i;
                }
                if (DataReviewDialog.this.toBeRemoved.size() > 0) {
                    ArrayList<Gene> oldList = new ArrayList<Gene>(DataReviewDialog.this.data.getGenes());
                    List<Gene> newList = DataReviewDialog.this.removeGenes(oldList, DataReviewDialog.this.toBeRemoved);
                    DataReviewDialog.this.changed = true;
                    DataReviewDialog.this.treeViewer.setInput(newList);
                    DataReviewDialog.this.treeViewer.refresh();
                    DataReviewDialog.this.treeViewer.expandAll();
                }
            }
        });
        this.treeViewer.setInput(this.data.getGenes());
        this.treeViewer.expandAll();
        this.treeViewer.setSorter((ViewerSorter)this.sorter);
        this.treeViewer.getTree().setSortColumn(tblclmnLocation);
        this.treeViewer.getTree().setSortDirection(128);
        return container;
    }

    protected void okPressed() {
        List<Gene> newList = this.removeGenes(this.data.getGenes(), this.toBeRemoved);
        this.changed = true;
        this.data.setGenes(newList);
        super.okPressed();
    }

    protected List<Gene> removeGenes(List<Gene> genes, List<Gene> toBeRemoved) {
        ArrayList<Gene> newGenes = new ArrayList<Gene>();
        for (Gene gene : genes) {
            if (toBeRemoved.contains(gene)) continue;
            newGenes.add(gene);
        }
        return newGenes;
    }

    private SelectionAdapter getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataReviewDialog.this.sorter.setColumn(index);
                int dir = DataReviewDialog.this.sorter.getDirection();
                DataReviewDialog.this.treeViewer.getTree().setSortDirection(dir);
                DataReviewDialog.this.treeViewer.getTree().setSortColumn(column);
                DataReviewDialog.this.treeViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Review dialog");
    }

    protected Point getInitialSize() {
        return new Point(350, 300);
    }

    public boolean isChanged() {
        return this.changed;
    }
}

