/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.manager.pages.MasterGeneListPage;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.view.GeneView;
import org.grits.toolbox.entry.qrtpcr.ncbi.NCBIGeneUtil;

public class UpdateGenesAction
extends Action {
    private static final Logger logger = Logger.getLogger(UpdateGenesAction.class);
    MasterGeneListPage page;
    private GeneList masterList;
    private List<Gene> tableGeneList;

    public UpdateGenesAction(MasterGeneListPage page) {
        this.page = page;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.UPDATE_ICON);
    }

    public String getText() {
        return "Update";
    }

    public String getToolTipText() {
        return "Update genes' data from NCBI";
    }

    public void run() {
        Shell shell = Display.getCurrent().getActiveShell();
        if (this.page == null) {
            return;
        }
        this.masterList = this.page.getSelectedGeneList();
        List<TableData> input = this.page.getDataFromTable();
        if (input == null) {
            return;
        }
        this.tableGeneList = new ArrayList<Gene>();
        for (TableData gene : input) {
            this.tableGeneList.add((Gene)gene);
        }
        if (this.masterList == null || this.masterList.getGenes() == null || this.masterList.getGenes().isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"No Selection", (String)"Please make sure to select genes to update!");
            return;
        }
        ArrayList<Gene> removedGenes = new ArrayList<Gene>();
        ProcessGenes update = new ProcessGenes(removedGenes);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
        try {
            monitor.run(true, true, (IRunnableWithProgress)update);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"Error getting gene data from NCBI", (Throwable)e);
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error getting gene data from NCBI");
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted", (Throwable)e);
        }
        if (monitor.getReturnCode() != 1) {
            this.page.clearSelection();
            this.page.refresh(this.tableGeneList);
            if (!removedGenes.isEmpty()) {
                LabelProvider labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof Gene) {
                            return ((Gene)element).getGeneIdentifier();
                        }
                        return null;
                    }
                };
                ListSelectionDialog selectionDialog = new ListSelectionDialog(shell, removedGenes, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, "These genes no longer exist in NCBI.\nDe-select the genes you want to keep anyway.\nOtherwise, they will be removed from the list");
                selectionDialog.setInitialElementSelections(removedGenes);
                if (selectionDialog.open() == 0) {
                    Object[] remove;
                    Object[] objectArray = remove = selectionDialog.getResult();
                    int n = remove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        this.tableGeneList.remove((Gene)object);
                        ++n2;
                    }
                    if (remove.length > 0) {
                        this.page.refresh(this.tableGeneList);
                        this.page.getEditor().markDirty();
                    }
                }
            }
        }
    }

    public GeneView markUpdated(Gene gene, Gene newGene) {
        boolean updated = false;
        GeneView geneView = new GeneView(newGene);
        if (!gene.getGeneSymbol().equals(newGene.getGeneSymbol())) {
            geneView.addUpdatedField("Gene Symbol");
            updated = true;
        }
        if (!gene.getLocationString().equals(newGene.getLocationString())) {
            geneView.addUpdatedField("Genomic Location");
            updated = true;
        }
        if (!gene.getAliasString().equals(newGene.getAliasString())) {
            geneView.addUpdatedField("Aliases");
            updated = true;
        }
        if (gene.getFullName() != null && !gene.getFullName().equals(newGene.getFullName())) {
            geneView.addUpdatedField("Name");
            updated = true;
        }
        if (!gene.getRefSeqString().equals(newGene.getRefSeqString())) {
            geneView.addUpdatedField("RefSeq");
            updated = true;
        }
        if (!gene.getSecondaryRefSeqString().equals(newGene.getSecondaryRefSeqString())) {
            geneView.addUpdatedField("Protein RefSeq");
            updated = true;
        }
        if (updated) {
            geneView.setUpdated(true);
            return geneView;
        }
        return null;
    }

    class ProcessGenes
    implements IRunnableWithProgress {
        List<Gene> missingGenes;

        public ProcessGenes(List<Gene> removedGenes) {
            this.missingGenes = removedGenes;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            NCBIGeneUtil ncbiSearch = new NCBIGeneUtil();
            monitor.beginTask("Retrieving updates from NCBI", UpdateGenesAction.this.masterList.getGenes().size());
            int i = 0;
            for (Gene gene : UpdateGenesAction.this.masterList.getGenes()) {
                monitor.subTask("Retrieving " + i + " of " + UpdateGenesAction.this.masterList.getGenes().size());
                List<Integer> geneIds = gene.getGeneIds();
                if (geneIds != null && !geneIds.isEmpty()) {
                    try {
                        Gene newGene = ncbiSearch.getDetailsFromNCBI(geneIds.get(0));
                        if (newGene == null) {
                            this.missingGenes.add(gene);
                            monitor.worked(1);
                            ++i;
                            continue;
                        }
                        newGene.setGeneIdentifier(gene.getGeneIdentifier());
                        newGene.setDescription(gene.getDescription());
                        newGene.setForwardPrimer(gene.getForwardPrimer());
                        newGene.setReversePrimer(gene.getReversePrimer());
                        newGene.setGroup(gene.getGroup());
                        newGene.setGeneIds(gene.getGeneIds());
                        newGene.setIsCommon(gene.getIsCommon());
                        newGene.setIsControl(gene.getIsControl());
                        newGene.setNotes(gene.getNotes());
                        GeneView geneView = UpdateGenesAction.this.markUpdated(gene, newGene);
                        if (geneView == null) {
                            monitor.worked(1);
                            ++i;
                            continue;
                        }
                        ListIterator<GeneView> listIterator = UpdateGenesAction.this.tableGeneList.listIterator();
                        while (listIterator.hasNext()) {
                            Gene gene2 = (Gene)listIterator.next();
                            if (!gene2.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
                            listIterator.set(geneView);
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error getting gene data from NCBI for " + i + "th gene"), (Throwable)e);
                    }
                }
                monitor.worked(1);
                ++i;
                if (!monitor.isCanceled()) continue;
                monitor.done();
                return;
            }
            monitor.done();
        }
    }
}

