/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.Range;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.compress.CompressConfig;
import org.swtchart.internal.compress.ICompress;
import org.swtchart.internal.series.BarSeries;
import org.swtchart.internal.series.LineSeries;
import org.swtchart.internal.series.Series;

public class SeriesSet
implements ISeriesSet {
    private final Chart chart;
    private LinkedHashMap<String, Series> seriesMap;

    public SeriesSet(Chart chart) {
        this.chart = chart;
        this.seriesMap = new LinkedHashMap();
    }

    @Override
    public ISeries createSeries(ISeries.SeriesType type, String id) {
        if (id == null) {
            SWT.error((int)4);
            return null;
        }
        String identifier = id.trim();
        if ("".equals(identifier)) {
            SWT.error((int)5);
        }
        Series series = null;
        if (type == ISeries.SeriesType.BAR) {
            series = new BarSeries(this.chart, identifier);
        } else if (type == ISeries.SeriesType.LINE) {
            series = new LineSeries(this.chart, identifier);
        } else {
            SWT.error((int)5);
            return null;
        }
        Series oldSeries = this.seriesMap.get(identifier);
        if (oldSeries != null) {
            oldSeries.dispose();
        }
        int[] xAxisIds = this.chart.getAxisSet().getXAxisIds();
        int[] yAxisIds = this.chart.getAxisSet().getYAxisIds();
        series.setXAxisId(xAxisIds[0]);
        series.setYAxisId(yAxisIds[0]);
        this.seriesMap.put(identifier, series);
        Axis axis = (Axis)this.chart.getAxisSet().getXAxis(xAxisIds[0]);
        if (axis != null) {
            this.updateStackAndRiserData();
        }
        this.chart.updateLayout();
        return series;
    }

    @Override
    public ISeries getSeries(String id) {
        if (id == null) {
            SWT.error((int)4);
        }
        return this.seriesMap.get(id);
    }

    @Override
    public ISeries[] getSeries() {
        Set<String> keys = this.seriesMap.keySet();
        ISeries[] series = new ISeries[keys.size()];
        int i = 0;
        for (String key : keys) {
            series[i++] = this.seriesMap.get(key);
        }
        return series;
    }

    @Override
    public void deleteSeries(String id) {
        this.validateSeriesId(id);
        this.seriesMap.get(id).dispose();
        this.seriesMap.remove(id);
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void bringForward(String id) {
        this.validateSeriesId(id);
        String seriesId = null;
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (entry.getKey().equals(id)) {
                seriesId = id;
                continue;
            }
            newSeriesMap.put(entry.getKey(), entry.getValue());
            if (seriesId == null) continue;
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
            seriesId = null;
        }
        if (seriesId != null) {
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void bringToFront(String id) {
        this.validateSeriesId(id);
        Series series = this.seriesMap.get(id);
        this.seriesMap.remove(id);
        this.seriesMap.put(series.getId(), series);
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void sendBackward(String id) {
        this.validateSeriesId(id);
        String seriesId = null;
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (!entry.getKey().equals(id) || seriesId == null) {
                newSeriesMap.put(entry.getKey(), entry.getValue());
                seriesId = entry.getKey();
                continue;
            }
            newSeriesMap.remove(seriesId);
            newSeriesMap.put(entry.getKey(), entry.getValue());
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void sendToBack(String id) {
        this.validateSeriesId(id);
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        newSeriesMap.put(id, this.seriesMap.get(id));
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (entry.getKey().equals(id)) continue;
            newSeriesMap.put(entry.getKey(), entry.getValue());
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    public void dispose() {
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            entry.getValue().dispose();
        }
    }

    private void validateSeriesId(String id) {
        if (id == null) {
            SWT.error((int)4);
        }
        if (this.seriesMap.get(id) == null) {
            throw new IllegalArgumentException("Given series id doesn't exist");
        }
    }

    public void compressAllSeries() {
        if (!this.chart.isCompressEnabled()) {
            return;
        }
        CompressConfig config = new CompressConfig();
        int PRECISION = 2;
        Point p = this.chart.getPlotArea().getSize();
        int width = p.x * 2;
        int height = p.y * 2;
        config.setSizeInPixel(width, height);
        for (ISeries series : this.getSeries()) {
            int xAxisId = series.getXAxisId();
            int yAxisId = series.getYAxisId();
            IAxis xAxis = this.chart.getAxisSet().getXAxis(xAxisId);
            IAxis yAxis = this.chart.getAxisSet().getYAxis(yAxisId);
            if (xAxis == null || yAxis == null) continue;
            Range xRange = xAxis.getRange();
            Range yRange = yAxis.getRange();
            if (xRange == null || yRange == null) continue;
            double xMin = xRange.lower;
            double xMax = xRange.upper;
            double yMin = yRange.lower;
            double yMax = yRange.upper;
            config.setXLogScale(xAxis.isLogScaleEnabled());
            config.setYLogScale(yAxis.isLogScaleEnabled());
            double lower = xMin - (xMax - xMin) * 0.015;
            double upper = xMax + (xMax - xMin) * 0.015;
            if (xAxis.isLogScaleEnabled()) {
                lower = ((Series)series).getXRange().lower;
            }
            config.setXRange(lower, upper);
            lower = yMin - (yMax - yMin) * 0.015;
            upper = yMax + (yMax - yMin) * 0.015;
            if (yAxis.isLogScaleEnabled()) {
                lower = ((Series)series).getYRange().lower;
            }
            config.setYRange(lower, upper);
            ICompress compressor = ((Series)series).getCompressor();
            compressor.compress(config);
        }
    }

    public void updateCompressor(Axis axis) {
        for (ISeries series : this.getSeries()) {
            int axisId;
            int n = axisId = axis.getDirection() == IAxis.Direction.X ? series.getXAxisId() : series.getYAxisId();
            if (axisId != axis.getId()) continue;
            ICompress compressor = ((Series)series).getCompressor();
            if (axis.isValidCategoryAxis()) {
                String[] categorySeries = axis.getCategorySeries();
                if (categorySeries == null) continue;
                double[] xSeries = new double[categorySeries.length];
                for (int i = 0; i < xSeries.length; ++i) {
                    xSeries[i] = i;
                }
                compressor.setXSeries(xSeries);
                continue;
            }
            if (((Series)series).getXSeries() == null) continue;
            compressor.setXSeries(((Series)series).getXSeries());
        }
        this.compressAllSeries();
    }

    public void updateStackAndRiserData() {
        if (this.chart.isUpdateSuspended()) {
            return;
        }
        for (IAxis xAxis : this.chart.getAxisSet().getXAxes()) {
            ((Axis)xAxis).setNumRisers(0);
            for (IAxis yAxis : this.chart.getAxisSet().getYAxes()) {
                this.updateStackAndRiserData(xAxis, yAxis);
            }
        }
    }

    private void updateStackAndRiserData(IAxis xAxis, IAxis yAxis) {
        String[] categorySeries;
        int riserCnt = 0;
        int stackRiserPosition = -1;
        double[] stackBarSeries = null;
        double[] stackLineSeries = null;
        if (((Axis)xAxis).isValidCategoryAxis() && (categorySeries = xAxis.getCategorySeries()) != null) {
            int size = categorySeries.length;
            stackBarSeries = new double[size];
            stackLineSeries = new double[size];
        }
        for (ISeries series : this.getSeries()) {
            if (series.getXAxisId() != xAxis.getId() || series.getYAxisId() != yAxis.getId() || !series.isVisible()) continue;
            if (series.isStackEnabled() && !this.chart.getAxisSet().getYAxis(series.getYAxisId()).isLogScaleEnabled() && ((Axis)xAxis).isValidCategoryAxis()) {
                if (series.getType() == ISeries.SeriesType.BAR) {
                    if (stackRiserPosition == -1) {
                        stackRiserPosition = riserCnt++;
                    }
                    ((BarSeries)series).setRiserIndex(((Axis)xAxis).getNumRisers() + stackRiserPosition);
                    SeriesSet.setStackSeries(stackBarSeries, series);
                    continue;
                }
                if (series.getType() != ISeries.SeriesType.LINE) continue;
                SeriesSet.setStackSeries(stackLineSeries, series);
                continue;
            }
            if (series.getType() != ISeries.SeriesType.BAR) continue;
            ((BarSeries)series).setRiserIndex(((Axis)xAxis).getNumRisers() + riserCnt++);
        }
        ((Axis)xAxis).setNumRisers(((Axis)xAxis).getNumRisers() + riserCnt);
    }

    private static void setStackSeries(double[] stackSeries, ISeries series) {
        double[] ySeries = series.getYSeries();
        if (ySeries == null || stackSeries == null) {
            return;
        }
        for (int i = 0; i < stackSeries.length && i < ySeries.length; ++i) {
            stackSeries[i] = BigDecimal.valueOf(stackSeries[i]).add(BigDecimal.valueOf(ySeries[i])).doubleValue();
        }
        double[] copiedStackSeries = new double[stackSeries.length];
        System.arraycopy(stackSeries, 0, copiedStackSeries, 0, stackSeries.length);
        ((Series)series).setStackSeries(copiedStackSeries);
    }
}

