/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SelectionAggregator {
    static final String OUT_SELECTION = "org.eclipse.ui.output.selection";
    static final String OUT_POST_SELECTION = "org.eclipse.ui.output.postSelection";
    private ListenerList genericListeners = new ListenerList();
    private ListenerList genericPostListeners = new ListenerList();
    private Map<String, ListenerList> targetedListeners = new HashMap<String, ListenerList>();
    private Map<String, ListenerList> targetedPostListeners = new HashMap<String, ListenerList>();
    private Set<IEclipseContext> tracked = new HashSet<IEclipseContext>();
    private EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPart) {
                MPart part = (MPart)element;
                String partId = part.getElementId();
                if (SelectionAggregator.this.targetedListeners.containsKey(partId) || SelectionAggregator.this.targetedPostListeners.containsKey(partId)) {
                    SelectionAggregator.this.track(part);
                }
            }
        }
    };
    private MPart activePart;
    private IEclipseContext context;
    private EPartService partService;
    private IEventBroker eventBroker;
    private Logger logger;

    @Inject
    SelectionAggregator(IEclipseContext context, EPartService partService, IEventBroker eventBroker, Logger logger) {
        this.context = context;
        this.partService = partService;
        this.eventBroker = eventBroker;
        this.logger = logger;
    }

    @PreDestroy
    void preDestroy() {
        this.genericListeners.clear();
        this.genericPostListeners.clear();
        this.targetedListeners.clear();
        this.targetedPostListeners.clear();
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", this.eventHandler);
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        if (part == null) {
            this.activePart = null;
            this.context.set("org.eclipse.ui.selection", null);
        } else if (this.activePart != part) {
            this.activePart = part;
            IEclipseContext partContext = part.getContext();
            if (partContext.containsKey(OUT_POST_SELECTION)) {
                Object selection = partContext.get(OUT_POST_SELECTION);
                this.context.set("org.eclipse.ui.selection", selection);
            } else if (partContext.containsKey(OUT_SELECTION)) {
                Object selection = partContext.get(OUT_SELECTION);
                this.context.set("org.eclipse.ui.selection", selection);
            }
            this.track(part);
        }
    }

    private void notifyListeners(final MPart part, final Object selection) {
        Object[] objectArray = this.genericListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionListener myListener = (ISelectionListener)listener;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    myListener.selectionChanged(part, selection);
                }

                public void handleException(Throwable exception) {
                    SelectionAggregator.this.logger.error(exception);
                }
            });
            ++n2;
        }
        this.notifyTargetedListeners(part, selection);
    }

    private void notifyTargetedListeners(final MPart part, final Object selection) {
        ListenerList listenerList;
        String id = part.getElementId();
        if (id != null && (listenerList = this.targetedListeners.get(id)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                final ISelectionListener myListener = (ISelectionListener)listener;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        myListener.selectionChanged(part, selection);
                    }

                    public void handleException(Throwable exception) {
                        SelectionAggregator.this.logger.error(exception);
                    }
                });
                ++n2;
            }
        }
    }

    private void notifyPostListeners(final MPart part, final Object selection) {
        Object[] objectArray = this.genericPostListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionListener myListener = (ISelectionListener)listener;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    myListener.selectionChanged(part, selection);
                }

                public void handleException(Throwable exception) {
                    SelectionAggregator.this.logger.error(exception);
                }
            });
            ++n2;
        }
        this.notifyTargetedPostListeners(part, selection);
    }

    private void notifyTargetedPostListeners(final MPart part, final Object selection) {
        ListenerList listenerList;
        String id = part.getElementId();
        if (id != null && (listenerList = this.targetedPostListeners.get(id)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                final ISelectionListener myListener = (ISelectionListener)listener;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        myListener.selectionChanged(part, selection);
                    }

                    public void handleException(Throwable exception) {
                        SelectionAggregator.this.logger.error(exception);
                    }
                });
                ++n2;
            }
        }
    }

    private void track(final MPart part) {
        final IEclipseContext myContext = this.context;
        IEclipseContext context = part.getContext();
        if (context != null && this.tracked.add(context)) {
            if (context instanceof EclipseContext) {
                ((EclipseContext)context).notifyOnDisposal(new IContextDisposalListener(){

                    public void disposed(IEclipseContext context) {
                        SelectionAggregator.this.tracked.remove(context);
                    }
                });
            }
            context.runAndTrack(new RunAndTrack(){
                private boolean initial = true;

                public boolean changed(IEclipseContext context) {
                    final Object selection = context.get(SelectionAggregator.OUT_SELECTION);
                    if (this.initial) {
                        this.initial = false;
                        if (selection == null) {
                            return true;
                        }
                    }
                    if (SelectionAggregator.this.activePart != part) {
                        boolean continueTracking;
                        this.runExternalCode(new Runnable(){

                            @Override
                            public void run() {
                                SelectionAggregator.this.notifyTargetedListeners(part, selection);
                            }
                        });
                        String partId = part.getElementId();
                        boolean bl = continueTracking = SelectionAggregator.this.targetedListeners.containsKey(partId) || SelectionAggregator.this.targetedPostListeners.containsKey(partId);
                        if (!continueTracking) {
                            SelectionAggregator.this.tracked.remove(part.getContext());
                        }
                        return continueTracking;
                    }
                    myContext.set("org.eclipse.ui.selection", selection);
                    this.runExternalCode(new Runnable(){

                        @Override
                        public void run() {
                            SelectionAggregator.this.notifyListeners(part, selection);
                        }
                    });
                    return true;
                }
            });
            context.runAndTrack(new RunAndTrack(){
                private boolean initial = true;

                public boolean changed(IEclipseContext context) {
                    final Object postSelection = context.get(SelectionAggregator.OUT_POST_SELECTION);
                    if (this.initial) {
                        this.initial = false;
                        if (postSelection == null) {
                            return true;
                        }
                    }
                    if (SelectionAggregator.this.activePart != part) {
                        boolean continueTracking;
                        this.runExternalCode(new Runnable(){

                            @Override
                            public void run() {
                                SelectionAggregator.this.notifyTargetedPostListeners(part, postSelection);
                            }
                        });
                        String partId = part.getElementId();
                        boolean bl = continueTracking = SelectionAggregator.this.targetedListeners.containsKey(partId) || SelectionAggregator.this.targetedPostListeners.containsKey(partId);
                        if (!continueTracking) {
                            SelectionAggregator.this.tracked.remove(part.getContext());
                        }
                        return continueTracking;
                    }
                    this.runExternalCode(new Runnable(){

                        @Override
                        public void run() {
                            SelectionAggregator.this.notifyPostListeners(part, postSelection);
                        }
                    });
                    return true;
                }
            });
        }
    }

    public Object getSelection() {
        return this.context.get("org.eclipse.ui.selection");
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.genericListeners.add((Object)listener);
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        this.genericPostListeners.add((Object)listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        if (this.context != null) {
            this.genericListeners.remove((Object)listener);
        }
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        if (this.context != null) {
            this.genericPostListeners.remove((Object)listener);
        }
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new ListenerList();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add((Object)listener);
        MPart part = this.partService.findPart(partId);
        if (part != null) {
            this.track(part);
        }
    }

    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners = this.targetedPostListeners.get(partId);
        if (listeners == null) {
            listeners = new ListenerList();
            this.targetedPostListeners.put(partId, listeners);
        }
        listeners.add((Object)listener);
        MPart part = this.partService.findPart(partId);
        if (part != null) {
            this.track(part);
        }
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners;
        if (this.context != null && (listeners = this.targetedListeners.get(partId)) != null) {
            listeners.remove((Object)listener);
        }
    }

    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners;
        if (this.context != null && (listeners = this.targetedPostListeners.get(partId)) != null) {
            listeners.remove((Object)listener);
        }
    }

    public Object getSelection(String partId) {
        MPart part = this.partService.findPart(partId);
        if (part == null) {
            return null;
        }
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            return null;
        }
        return partContext.get(OUT_SELECTION);
    }
}

