/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;

public enum StereoConfiguration {
    Dexter("dexter", "D", 'D', '2'),
    Laevus("laevus", "L", 'L', '1'),
    Unknown("unknown", "X", '?', 'x'),
    Nonchiral("non-chiral", "N", 'X', '0'),
    XDexter("relative_dexter", "XD", '?', '4'),
    XLaevus("relative_laevus", "XL", '?', '3');

    private String fullname;
    private String symbol;
    private char stereoSymbol;
    private char bcsdbSymbol;

    private StereoConfiguration(String fullnameStr, String symbolStr, char bcsdbSymbolStr, char stereosymbolChar) {
        this.fullname = fullnameStr;
        this.symbol = symbolStr;
        this.stereoSymbol = stereosymbolChar;
        this.bcsdbSymbol = bcsdbSymbolStr;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public char getStereosymbol() {
        return this.stereoSymbol;
    }

    public char getBcsdbSymbol() {
        return this.bcsdbSymbol;
    }

    public static StereoConfiguration forNameOrSymbol(String config) throws MonosaccharideException {
        for (StereoConfiguration c : StereoConfiguration.values()) {
            if (config.equalsIgnoreCase(c.symbol)) {
                return c;
            }
            if (!config.equalsIgnoreCase(c.fullname)) continue;
            return c;
        }
        throw new MonosaccharideException("Invalid value for absolute configuration: " + config);
    }

    public static StereoConfiguration forStereosymbol(char stereosymbol) throws ResourcesDbException {
        for (StereoConfiguration c : StereoConfiguration.values()) {
            if (stereosymbol != c.stereoSymbol) continue;
            return c;
        }
        throw new ResourcesDbException("Invalid stereosymbol for configuration: " + stereosymbol);
    }

    public static StereoConfiguration forBcsdbSymbol(char bcsdbsym) {
        for (StereoConfiguration c : StereoConfiguration.values()) {
            if (c.bcsdbSymbol != bcsdbsym) continue;
            return c;
        }
        return null;
    }

    public static char stereosymbolAbsoluteToRelative(char absoluteSymbol) throws ResourcesDbException {
        StereoConfiguration c = StereoConfiguration.forStereosymbol(absoluteSymbol);
        if (c.equals((Object)Dexter)) {
            return StereoConfiguration.XDexter.stereoSymbol;
        }
        if (c.equals((Object)Laevus)) {
            return StereoConfiguration.XLaevus.stereoSymbol;
        }
        if (c.equals((Object)Nonchiral) || c.equals((Object)Unknown)) {
            return c.stereoSymbol;
        }
        throw new MonosaccharideException("Invalid stereosymbol for absolute configuration: " + absoluteSymbol);
    }

    public static char stereosymbolRelativeToAbsolute(char relativeSymbol) throws ResourcesDbException {
        StereoConfiguration c = StereoConfiguration.forStereosymbol(relativeSymbol);
        if (c.equals((Object)XDexter)) {
            return StereoConfiguration.Dexter.stereoSymbol;
        }
        if (c.equals((Object)XLaevus)) {
            return StereoConfiguration.Laevus.stereoSymbol;
        }
        return c.stereoSymbol;
    }

    public static StereoConfiguration invert(StereoConfiguration sConf) {
        if (sConf.equals((Object)Dexter)) {
            return Laevus;
        }
        if (sConf.equals((Object)Laevus)) {
            return Dexter;
        }
        if (sConf.equals((Object)XDexter)) {
            return XLaevus;
        }
        if (sConf.equals((Object)XLaevus)) {
            return XDexter;
        }
        return sConf;
    }
}

