/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JFrame;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SvgFactory {
    private int textSize = 11;
    private boolean resizeIfOutOfBounds = true;
    private boolean rescaleIfOutOfBounds = false;
    private SVGGraphics2D graph2D;
    private SVGDocument svgDoc;
    private int svgWidth = 0;
    private int svgHeight = 0;
    private Monosaccharide monosacc;
    private int xMin = Integer.MAX_VALUE;
    private int xMax = Integer.MIN_VALUE;
    private int yMin = Integer.MAX_VALUE;
    private int yMax = Integer.MIN_VALUE;
    private int currentGroupXShift = 0;
    private int currentGroupYShift = 0;

    public SvgFactory() {
        this.setupFactory();
    }

    public SvgFactory(boolean rescale, boolean resize) {
        this.setupFactory();
        this.setRescaleIfOutOfBounds(rescale);
        this.setResizeIfOutOfBounds(resize);
    }

    private void setupFactory() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.setSvgDoc((SVGDocument)impl.createDocument(svgNS, "svg", null));
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)this.getSvgDoc());
        ctx.setComment("Generated by MonosaccharideDB (www.monosaccharidedb.org) with Batik SVG Generator");
        this.setSVGGraph2D(new SVGGraphics2D(ctx, false));
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        if (this.getSVGGraph2D() != null) {
            this.getSVGGraph2D().setFont(this.getSVGGraph2D().getFont().deriveFont((float)textSize));
        }
    }

    public int getSvgHeight() {
        return this.svgHeight;
    }

    public void setSvgHeight(int svgHeight) {
        this.svgHeight = svgHeight;
    }

    public int getSvgWidth() {
        return this.svgWidth;
    }

    public void setSvgWidth(int svgWidth) {
        this.svgWidth = svgWidth;
    }

    public boolean isRescaleIfOutOfBounds() {
        return this.rescaleIfOutOfBounds;
    }

    public void setRescaleIfOutOfBounds(boolean rescaleIfOutOfBounds) {
        this.rescaleIfOutOfBounds = rescaleIfOutOfBounds;
    }

    public boolean isResizeIfOutOfBounds() {
        return this.resizeIfOutOfBounds;
    }

    public void setResizeIfOutOfBounds(boolean resizeIfOutOfBounds) {
        this.resizeIfOutOfBounds = resizeIfOutOfBounds;
    }

    public SVGGraphics2D getSVGGraph2D() {
        return this.graph2D;
    }

    public void setSVGGraph2D(SVGGraphics2D graph2d) {
        this.setSVGGraph2D(graph2d, true);
    }

    public void setSVGGraph2D(SVGGraphics2D graph2d, boolean setFontSize) {
        if (setFontSize && this.getTextSize() > 0) {
            graph2d.setFont(graph2d.getFont().deriveFont((float)this.getTextSize()));
        }
        this.graph2D = graph2d;
    }

    public SVGDocument getSvgDoc() {
        return this.svgDoc;
    }

    public void setSvgDoc(SVGDocument svgdoc) {
        this.svgDoc = svgdoc;
    }

    public Monosaccharide getMonosacc() {
        return this.monosacc;
    }

    public void setMonosacc(Monosaccharide ms) {
        this.monosacc = ms;
    }

    public int getXMax() {
        return this.xMax;
    }

    public int getXMin() {
        return this.xMin;
    }

    public int getYMax() {
        return this.yMax;
    }

    public int getYMin() {
        return this.yMin;
    }

    public int getCurrentGroupXShift() {
        return this.currentGroupXShift;
    }

    public void setCurrentGroupXShift(int xShift) {
        this.currentGroupXShift = xShift;
    }

    public int getCurrentGroupYShift() {
        return this.currentGroupYShift;
    }

    public void setCurrentGroupYShift(int yShift) {
        this.currentGroupYShift = yShift;
    }

    protected Element getTopLevelGroup() {
        if (this.getSVGGraph2D() == null) {
            return null;
        }
        Element tlg = this.getSVGGraph2D().getTopLevelGroup();
        this.getSVGGraph2D().setTopLevelGroup(tlg);
        return tlg;
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element svgElem) {
        if (this.getSVGGraph2D() == null) {
            return null;
        }
        Element tlg = this.getTopLevelGroup();
        Element root = this.getSVGGraph2D().getRoot(svgElem);
        this.getSVGGraph2D().setTopLevelGroup(tlg);
        return root;
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this.getSVGGraph2D().drawLine(x1, y1, x2, y2);
        this.checkMinMax(x1, y1);
        this.checkMinMax(x2, y2);
    }

    protected void drawLineWithOffset(int x1, int y1, int x2, int y2, double offset) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int lineLength = (int)Math.floor(Math.sqrt(dx * dx + dy * dy) + 0.5);
        this.getSVGGraph2D().drawLine(x1 += (int)Math.floor((double)dx * (offset / (double)lineLength) + 0.5), y1 += (int)Math.floor((double)dy * (offset / (double)lineLength) + 0.5), x2, y2);
    }

    protected void drawShape(Shape s) {
        this.getSVGGraph2D().draw(s);
        this.checkMinMax((int)s.getBounds2D().getMaxX(), (int)s.getBounds2D().getMaxY());
        this.checkMinMax((int)s.getBounds2D().getMinX(), (int)s.getBounds2D().getMinY());
    }

    protected void fillShape(Shape s) {
        this.getSVGGraph2D().fill(s);
        this.checkMinMax((int)s.getBounds2D().getMaxX(), (int)s.getBounds2D().getMaxY());
        this.checkMinMax((int)s.getBounds2D().getMinX(), (int)s.getBounds2D().getMinY());
    }

    protected void drawString(String str, int x, int y) {
        this.getSVGGraph2D().drawString(str, x, y);
        this.checkMinMax(x, y);
        this.checkMinMax(x + this.getSVGGraph2D().getFontMetrics().stringWidth(str), y - this.getSVGGraph2D().getFontMetrics().getHeight());
    }

    protected void addSubGraphic(SvgFactory subSvg, int x, int y) {
    }

    protected void translate(int translateX, int translateY) {
        this.xMin += translateX;
        this.xMax += translateX;
        this.yMin += translateY;
        this.yMax += translateY;
        Element g = this.getSVGGraph2D().getTopLevelGroup();
        Element tlg = this.getTopLevelGroup();
        tlg.setAttribute("transform", "translate(" + translateX + "," + translateY + ")");
        tlg.appendChild(g);
    }

    protected void scale(double scaleFactor) {
        if (scaleFactor == 0.0) {
            return;
        }
        this.xMin = (int)((double)this.xMin * scaleFactor);
        this.xMax = (int)((double)this.xMax * scaleFactor);
        this.yMin = (int)((double)this.yMin * scaleFactor);
        this.yMax = (int)((double)this.yMax * scaleFactor);
        Element g = this.getSVGGraph2D().getTopLevelGroup();
        Element tlg = this.getTopLevelGroup();
        tlg.setAttribute("transform", "scale(" + String.valueOf(Math.floor(scaleFactor * 10.0) / 10.0) + ")");
        tlg.appendChild(g);
    }

    protected int getCharacterCenterXOffset(String text, boolean alignRight) {
        int offset = 0;
        if (text == null || text.length() == 0) {
            return 0;
        }
        SVGGraphics2D g2d = this.getSVGGraph2D();
        char centeredChar = text.charAt(0);
        centeredChar = alignRight ? text.charAt(text.length() - 1) : text.charAt(0);
        int ccWidth = g2d.getFontMetrics().charWidth(centeredChar);
        offset = alignRight ? -g2d.getFontMetrics().stringWidth(text) + ccWidth / 2 : -ccWidth / 2;
        return offset;
    }

    protected int getStringWidth(String str) {
        return this.getSVGGraph2D().getFontMetrics().stringWidth(str);
    }

    private void checkMinMax(int x, int y) {
        if (x + this.currentGroupXShift < this.xMin) {
            this.xMin = x + this.currentGroupXShift;
        }
        if (x + this.currentGroupXShift > this.xMax) {
            this.xMax = x + this.currentGroupXShift;
        }
        if (y + this.currentGroupYShift < this.yMin) {
            this.yMin = y + this.currentGroupYShift;
        }
        if (y + this.currentGroupYShift > this.yMax) {
            this.yMax = y + this.currentGroupYShift;
        }
    }

    protected boolean isOutOfBounds() {
        return this.isOutOfXBounds() || this.isOutOfYBounds();
    }

    protected boolean isOutOfXBounds() {
        return this.xMin < 0 || this.xMax >= this.getSvgWidth();
    }

    protected boolean isOutOfYBounds() {
        return this.yMin < 0 || this.yMax >= this.getSvgHeight();
    }

    public boolean checkSize() {
        if (this.getSvgWidth() == 0) {
            if (this.isResizeIfOutOfBounds()) {
                this.setSvgWidth(this.xMax - this.xMin + 1);
            } else {
                return false;
            }
        }
        if (this.getSvgHeight() == 0) {
            if (this.isResizeIfOutOfBounds()) {
                this.setSvgHeight(this.yMax - this.yMin + 1);
            } else {
                return false;
            }
        }
        int translateX = 0;
        int translateY = 0;
        if (this.isOutOfXBounds() && (this.isRescaleIfOutOfBounds() || this.isResizeIfOutOfBounds() || this.xMax - this.xMin < this.svgWidth)) {
            translateX = 0 - this.xMin;
        }
        if (this.isOutOfYBounds() && (this.isRescaleIfOutOfBounds() || this.isResizeIfOutOfBounds() || this.yMax - this.yMin < this.svgHeight)) {
            translateY = 0 - this.yMin;
        }
        if (translateX != 0 || translateY != 0) {
            this.translate(translateX, translateY);
        }
        if (this.isOutOfBounds()) {
            if (this.isResizeIfOutOfBounds()) {
                if (this.xMax >= this.svgWidth) {
                    this.svgWidth = this.xMax + 1;
                }
                if (this.yMax >= this.svgHeight) {
                    this.svgHeight = this.yMax + 1;
                }
                this.getSVGGraph2D().setSVGCanvasSize(new Dimension(this.svgWidth, this.svgHeight));
            } else if (this.isRescaleIfOutOfBounds()) {
                double scaleFactorX = (double)this.svgWidth / (double)this.xMax;
                double scaleFactorY = (double)this.svgHeight / (double)this.yMax;
                double scaleFactor = Math.min(scaleFactorX, scaleFactorY);
                this.scale(scaleFactor);
                this.translate(translateX, translateY);
            } else {
                return false;
            }
        }
        return true;
    }

    public void stream(Writer out, boolean useCss) throws SVGGraphics2DIOException {
        SVGGraphics2D g = this.getSVGGraph2D();
        Element root = this.getRoot();
        g.stream(root, out, useCss, false);
    }

    public void stream(Writer out) throws SVGGraphics2DIOException {
        this.stream(out, false);
    }

    public String getSvgString() {
        String outStr = null;
        StringWriter outWriter = new StringWriter();
        try {
            this.stream(outWriter);
            outStr = outWriter.getBuffer().toString();
        }
        catch (SVGGraphics2DIOException sgio) {
            System.out.println("Exception: " + (Object)((Object)sgio));
        }
        return outStr;
    }

    public byte[] getSvgByteArr() {
        String svgStr = this.getSvgString();
        if (svgStr == null) {
            return null;
        }
        return svgStr.getBytes();
    }

    public void display() {
        SVGDocument doc = this.getSvgDoc();
        JSVGCanvas canvas = new JSVGCanvas();
        Element root = doc.getDocumentElement();
        this.getRoot(root);
        JFrame f = new JFrame();
        f.getContentPane().add((Component)canvas);
        canvas.setSVGDocument(doc);
        f.pack();
        f.setVisible(true);
    }

    public byte[] createJpgImage() throws Exception {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        return this.createImage((ImageTranscoder)t);
    }

    public byte[] createPngImage() throws Exception {
        PNGTranscoder t = new PNGTranscoder();
        return this.createImage((ImageTranscoder)t);
    }

    private byte[] createImage(ImageTranscoder t) throws Exception {
        SVGDocument doc = this.getSvgDoc();
        Element root = doc.getDocumentElement();
        this.getRoot(root);
        TranscoderInput input = new TranscoderInput((Document)doc);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        ostream.flush();
        ostream.close();
        return ostream.toByteArray();
    }
}

