/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.preference.MSGlycanAnnotationReportViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.MSGlycanAnnotationReportTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.dmtranslate.DMExtGlycanFeature;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.dmtranslate.DMExtPeak;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.dmtranslate.DMInterval;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanAnnotation;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTableDataChangedMessage;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.merge.action.ExtractRequiredData;
import org.grits.toolbox.merge.om.data.ExperimentAnnotation;
import org.grits.toolbox.merge.om.data.ExtGlycanFeature;
import org.grits.toolbox.merge.om.data.ExtPeak;
import org.grits.toolbox.merge.om.data.Interval;
import org.grits.toolbox.merge.om.data.MergeReport;
import org.grits.toolbox.merge.om.data.MergeSettings;
import org.grits.toolbox.merge.om.data.ReportRow;
import org.grits.toolbox.merge.xml.Deserialize;
import org.grits.toolbox.merge.xml.Serializer;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.utils.image.ImageCreationException;
import org.grits.toolbox.widgets.progress.IProgressListener;

public class MSGlycanAnnotationReportTableDataProcessor
extends MSAnnotationTableDataProcessor {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportTableDataProcessor.class);
    protected Deserialize des = null;
    public static final GRITSColumnHeader FIRST_GROUP = new GRITSColumnHeader("MS Annotation File", "ms_annotation_file");

    public MSGlycanAnnotationReportTableDataProcessor(Entry _entry, Property _sourceProperty, int iMinMSLevel) {
        super(_entry, _sourceProperty, iMinMSLevel);
    }

    public MSGlycanAnnotationReportTableDataProcessor(Entry _entry, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_entry, _sourceProperty, _fillType, iMinMSLevel);
    }

    public MSGlycanAnnotationReportTableDataProcessor(TableDataProcessor _parent, Property _sourceProperty, FillTypes _fillType, int iMinMSLevel) {
        super(_parent, _sourceProperty, _fillType, iMinMSLevel);
    }

    protected void loadExternalQuant() {
    }

    public String getArchiveFile() {
        if (this.entry == null) {
            return null;
        }
        String sMSFile = null;
        MSGlycanAnnotationReportProperty msProp = (MSGlycanAnnotationReportProperty)this.getEntry().getProperty();
        sMSFile = msProp.getFullyQualifiedXMLFileName(this.getEntry());
        return sMSFile;
    }

    public MergeSettings getMergeReportSettings() {
        return this.getMergeReportData().getSettings();
    }

    protected MergeReport getMergeReportData() {
        return (MergeReport)this.data;
    }

    public void setData(MergeReport data) {
        this.data = data;
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        TableViewerColumnSettings newSettings = this.getNewTableViewerSettings();
        this.addAnnotationColumns(newSettings);
        return newSettings;
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MSGlycanAnnotationReportViewerPreference();
    }

    public TableViewerPreference initializePreferences() {
        try {
            TableViewerColumnSettings newSettings = this.initializeColumnSettings();
            MSGlycanAnnotationReportViewerPreference newPreferences = (MSGlycanAnnotationReportViewerPreference)this.getNewTableViewerPreferences();
            newPreferences.setPreferenceSettings(newSettings);
            MSGlycanAnnotationReportViewerPreference oldPreferences = (MSGlycanAnnotationReportViewerPreference)this.getSimianTableDataObject().getTablePreferences();
            if (oldPreferences != null) {
                newPreferences.setHideUnannotatedPeaks(oldPreferences.isHideUnannotatedPeaks());
            }
            return newPreferences;
        }
        catch (Exception e) {
            logger.error((Object)"initializePreferences: unable to initialize preferences.", (Throwable)e);
            return null;
        }
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        MSGlycanAnnotationReportTableDataObject mobj = new MSGlycanAnnotationReportTableDataObject(1, this.fillType);
        this.setSimianTableDataObject((MassSpecTableDataObject)mobj);
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MSGlycanAnnotationReportTableDataProcessor.setDefaultColumnViewSettings(tvp.getPreferenceSettings());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    public boolean saveChanges() throws Exception {
        try {
            Serializer ser = new Serializer();
            String sSourceFile = this.getArchiveFile();
            ser.serialize(this.getMergeReportData(), sSourceFile);
            return true;
        }
        catch (Exception e) {
            throw new Exception("Unable to write XML File", e);
        }
    }

    protected int addUnrecognizedHeaders(MassSpecViewerPreference _preference) {
        int iNumCols = 0;
        try {
            if (this.getMergeReportData().getFeatureCustomExtraData() != null) {
                iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_preference.getPreferenceSettings(), (List)this.getMergeReportData().getFeatureCustomExtraData(), (HashMap)_preference.getPreferenceSettings().getUnrecognizedHeaders());
            }
            if (this.getMergeReportData().getAnnotationCustomExtraData() != null) {
                iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_preference.getPreferenceSettings(), (List)this.getMergeReportData().getAnnotationCustomExtraData(), (HashMap)_preference.getPreferenceSettings().getUnrecognizedHeaders());
            }
            if (this.getMergeReportData().getPeakCustomExtraData() != null) {
                iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_preference.getPreferenceSettings(), (List)this.getMergeReportData().getPeakCustomExtraData(), (HashMap)_preference.getPreferenceSettings().getUnrecognizedHeaders());
            }
        }
        catch (Exception e) {
            logger.error((Object)"readDataFromFile: unable to read mzXML.", (Throwable)e);
        }
        return iNumCols;
    }

    public boolean readDataFromFile() {
        try {
            this.des = new Deserialize();
            String sSourceFile = this.getArchiveFile();
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Indeterminant);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading data file...");
            logger.debug((Object)("Reading archive: " + sSourceFile));
            this.data = this.des.deserialize(sSourceFile);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
            return this.data != null;
        }
        catch (Exception e) {
            logger.error((Object)"readDataFromFile: unable to read mzXML.", (Throwable)e);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
            return false;
        }
    }

    public void buildTable() throws Exception {
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table...");
        int iMax = this.getMergeReportData().getRows().size();
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        ArrayList<ArrayList<GRITSColumnHeader>> alHeaders = this.getHeaderLines(this.getTempPreference().getPreferenceSettings());
        this.getSimianTableDataObject().getTableHeader().add(alHeaders.get(0));
        this.getSimianTableDataObject().getTableHeader().add(alHeaders.get(1));
        this.addPeaksTableData();
        if (this.getSimianTableDataObject().getTableData().isEmpty()) {
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
        }
    }

    public static void setDefaultColumnViewSettings(TableViewerColumnSettings tvs) {
        for (GRITSColumnHeader header : tvs.getHeaders()) {
            boolean bVisible = false;
            if (header.getLabel().equals(DMInterval.interval_mz.getLabel())) {
                bVisible = true;
            }
            if (header.getLabel().equals(MSGlycanAnnotationReportViewerPreference.SEL_CARTOON.getLabel())) {
                bVisible = true;
            }
            if (header.getLabel().equals(DMGlycanAnnotation.glycan_annotation_glycancartoon.getLabel())) {
                bVisible = true;
            }
            if (header.getLabel().equals(DMPeak.peak_intensity.getLabel())) {
                bVisible = true;
            }
            if (header.getLabel().equals(DMPeak.peak_relative_intensity.getLabel())) {
                bVisible = true;
            }
            if (header.getLabel().equals(DMPrecursorPeak.precursor_peak_mz.getLabel())) {
                bVisible = true;
            }
            if (bVisible) continue;
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
    }

    private MSGlycanAnnotationReportTableDataObject getMySimianTableDataObject() {
        return (MSGlycanAnnotationReportTableDataObject)this.getSimianTableDataObject();
    }

    private ArrayList<ArrayList<GRITSColumnHeader>> getHeaderLines(TableViewerColumnSettings _columnSettings) throws Exception {
        ArrayList<ArrayList<GRITSColumnHeader>> alHeaders = new ArrayList<ArrayList<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> alHeader = new ArrayList<GRITSColumnHeader>();
        GRITSColumnHeader colHeader = null;
        for (GRITSColumnHeader header : _columnSettings.keySet()) {
            if (header.isGrouped()) continue;
            alHeader.add(FIRST_GROUP);
        }
        for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
            colHeader = new GRITSColumnHeader(expAnnot.getAnnotationShortName(), Integer.toString(expAnnot.getAnnotationEntryId()));
            for (GRITSColumnHeader header : _columnSettings.keySet()) {
                if (!header.isGrouped()) continue;
                alHeader.add(colHeader);
            }
        }
        alHeaders.add(alHeader);
        alHeader = new ArrayList();
        for (GRITSColumnHeader header : _columnSettings.keySet()) {
            if (header.isGrouped()) continue;
            this.addHeaderLine(alHeader.size(), header, alHeader);
        }
        MSGlycanAnnotationReportProperty msProp = (MSGlycanAnnotationReportProperty)this.getEntry().getProperty();
        HashMap<String, ExternalQuantFileToAlias> aliasInfo = msProp.getMsGlycanAnnotReportMetaData().getExpToExternalQuant();
        for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
            ExternalQuantFileToAlias expAliasInfo = null;
            String sExpId = Integer.toString(expAnnot.getAnnotationEntryId());
            if (aliasInfo != null && aliasInfo.containsKey(sExpId)) {
                expAliasInfo = aliasInfo.get(sExpId);
            }
            for (GRITSColumnHeader header : _columnSettings.keySet()) {
                if (!header.isGrouped()) continue;
                GRITSColumnHeader newHeader = header;
                if (expAliasInfo != null && expAliasInfo.getSourceDataFileNameToAlias() != null && expAliasInfo.getSourceDataFileNameToAlias().containsKey(header.getKeyValue())) {
                    newHeader = new GRITSColumnHeader(((ExternalQuantAlias)expAliasInfo.getSourceDataFileNameToAlias().get(header.getKeyValue())).getAlias(), header.getKeyValue());
                }
                this.addHeaderLine(alHeader.size(), newHeader, alHeader);
            }
        }
        alHeaders.add(alHeader);
        return alHeaders;
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getKeyValue().equals(DMGlycanAnnotation.glycan_annotation_glycancartoon.name())) {
            this.getMySimianTableDataObject().addCartoonCol(Integer.valueOf(iPrefColNum));
        } else if (colHeader.getKeyValue().equals(MSGlycanAnnotationReportViewerPreference.SEL_CARTOON.getKeyValue())) {
            this.getMySimianTableDataObject().addCartoonCol(Integer.valueOf(iPrefColNum));
        } else if (colHeader.getKeyValue().equals(DMExtGlycanFeature.ext_glycan_feature_feature_id.name())) {
            this.getMySimianTableDataObject().addFeatureIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMExtGlycanFeature.ext_glycan_feature_sequence.name())) {
            this.getMySimianTableDataObject().addSequenceCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMExtGlycanFeature.ext_glycan_feature_annotation_id.name())) {
            this.getMySimianTableDataObject().addAnnotationIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMExtPeak.ext_peak_peak_id.name())) {
            this.getMySimianTableDataObject().addPeakIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
            this.getMySimianTableDataObject().addMzCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_intensity.name())) {
            this.getSimianTableDataObject().addPeakIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_is_precursor.name())) {
            this.getSimianTableDataObject().addPeakIsPrecursorCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_intensity.name())) {
            this.getSimianTableDataObject().addPrecursorIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMScan.scan_parentScan.name())) {
            this.getMySimianTableDataObject().addParentNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMExtPeak.ext_peak_source_peak_id.name())) {
            this.getMySimianTableDataObject().addSourcePeakIdCol(iPrefColNum);
        }
        alHeader.add(colHeader);
    }

    private HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>> getEntryToPeakIdToFeatures() {
        HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>> htEntryToPeakIdToFeatures = new HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>>();
        for (ReportRow row : this.getMergeReportData().getRows()) {
            for (ExtGlycanFeature extFeature : row.getAnnotations()) {
                Integer iEntryId = extFeature.getExpAnotationId();
                Integer iPeakId = extFeature.getPeakId();
                HashMap<Object, Object> htPeakIdToFeatures = null;
                if (htEntryToPeakIdToFeatures.containsKey(iEntryId)) {
                    htPeakIdToFeatures = htEntryToPeakIdToFeatures.get(iEntryId);
                } else {
                    htPeakIdToFeatures = new HashMap();
                    htEntryToPeakIdToFeatures.put(iEntryId, htPeakIdToFeatures);
                }
                List<ExtGlycanFeature> alFeatures = null;
                if (htPeakIdToFeatures.containsKey(iPeakId)) {
                    alFeatures = (List)htPeakIdToFeatures.get(iPeakId);
                } else {
                    alFeatures = new ArrayList();
                    htPeakIdToFeatures.put(iPeakId, alFeatures);
                }
                alFeatures.add(extFeature);
            }
        }
        return htEntryToPeakIdToFeatures;
    }

    private static ExtPeak getClosestExtPeak(List<ExtPeak> peaks, HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures, int annotId, double dIntervalMz) {
        ExtPeak closestExtPeak = null;
        double dMinDiff = Double.MAX_VALUE;
        for (ExtPeak extPeak : peaks) {
            double dDelta;
            if (!htPeakIdToFeatures.containsKey(extPeak.getExtPeakId()) || extPeak.getExpAnnotationId() != annotId || !((dDelta = Math.abs(extPeak.getMz() - dIntervalMz)) < dMinDiff)) continue;
            dMinDiff = dDelta;
            closestExtPeak = extPeak;
        }
        return closestExtPeak;
    }

    private static int getExternalPeakCnt(List<ExtPeak> peaks, HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures, int annotId) {
        int iPeakCnt = 0;
        for (ExtPeak extPeak : peaks) {
            if (!htPeakIdToFeatures.containsKey(extPeak.getExtPeakId()) || extPeak.getExpAnnotationId() != annotId) continue;
            ++iPeakCnt;
        }
        return iPeakCnt;
    }

    private static List<String> getSelectedFeatureSeqs(List<ExtPeak> peaks, HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures, int annotId, ExtPeak closestExtPeak) {
        ArrayList<String> selSeqs = new ArrayList<String>();
        for (ExtPeak extPeak : peaks) {
            if (!htPeakIdToFeatures.containsKey(extPeak.getExtPeakId()) || extPeak.getExpAnnotationId() != annotId) continue;
            List<ExtGlycanFeature> lFeatures = htPeakIdToFeatures.get(closestExtPeak.getExtPeakId());
            for (ExtGlycanFeature egf : lFeatures) {
                if (!egf.getSelected() || selSeqs.contains(egf.getSequenceGWB())) continue;
                selSeqs.add(egf.getSequenceGWB());
            }
        }
        return selSeqs;
    }

    private static ExtGlycanFeature findExtGlycanFeature(List<ExtPeak> peaks, HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures, int annotId, MSAnnotationTableDataChangedMessage message) {
        for (ExtPeak extPeak : peaks) {
            if (!htPeakIdToFeatures.containsKey(extPeak.getExtPeakId()) || extPeak.getExpAnnotationId() != annotId || extPeak.getSourcePeakId() != message.getPeakId().intValue()) continue;
            List<ExtGlycanFeature> lFeatures = htPeakIdToFeatures.get(extPeak.getExtPeakId());
            for (ExtGlycanFeature egf : lFeatures) {
                if (!egf.getFeatureId().equals(message.getFeature().getId())) continue;
                return egf;
            }
        }
        return null;
    }

    private void fillGRITSDataRow(GRITSListDataRow alRow, int iOffset, String sExpSelectedSequence, HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures, ExtPeak closestExtPeak) {
        if (closestExtPeak != null && htPeakIdToFeatures.containsKey(closestExtPeak.getExtPeakId())) {
            Object objVal;
            List<ExtGlycanFeature> lFeatures = htPeakIdToFeatures.get(closestExtPeak.getExtPeakId());
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtPeakData(closestExtPeak, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureAnnotationId = ExtGlycanFeature.getCombinedData(lFeatures, (String)"AnnotationId", (String)", ");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_annotation_id.name(), extFeatureAnnotationId, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureId = ExtGlycanFeature.getCombinedData(lFeatures, (String)"FeatureId", (String)", ");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_feature_id.name(), extFeatureId, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureGlycanAnnotationId = ExtGlycanFeature.getCombinedData(lFeatures, (String)"StringAnnotationId", (String)", ");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_glycan_annotation_id.name(), extFeatureGlycanAnnotationId, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_sequenceGWB.name(), sExpSelectedSequence, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureSequence = ExtGlycanFeature.getCombinedData(lFeatures, (String)"Sequence", (String)"~|~");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_sequence.name(), extFeatureSequence, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureSequenceFormat = ExtGlycanFeature.getCombinedData(lFeatures, (String)"SequenceFormat", (String)", ");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_sequenceFormat.name(), extFeatureSequenceFormat, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            Object extFeatureCharge = ExtGlycanFeature.getCombinedData(lFeatures, (String)"Charge", (String)", ");
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMExtGlycanFeature.ext_glycan_feature_charge.name(), extFeatureCharge, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            String sCartoonPng = !sExpSelectedSequence.equals("") ? String.valueOf(sExpSelectedSequence) + ".png" : "";
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(DMGlycanAnnotation.glycan_annotation_glycancartoon.name(), sCartoonPng, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            for (CustomExtraData ced : this.getMergeReportData().getFeatureCustomExtraData()) {
                if (ced.getKey().equals("gg.gch")) continue;
                objVal = ExtGlycanFeature.getCombinedData(lFeatures, (CustomExtraData)ced, (String)", ");
                MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(ced.getKey(), objVal, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            }
            for (CustomExtraData ced : this.getMergeReportData().getAnnotationCustomExtraData()) {
                if (ced.getKey().equals("gg.gch")) continue;
                objVal = ExtGlycanFeature.getCombinedData(lFeatures, (CustomExtraData)ced, (String)", ");
                MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(ced.getKey(), objVal, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            }
            for (CustomExtraData ced : this.getMergeReportData().getPeakCustomExtraData()) {
                if (ced.getKey().equals("gg.gch")) continue;
                objVal = null;
                for (String sKey2 : closestExtPeak.getDoubleProp().keySet()) {
                    if (!ced.getKey().equals(sKey2)) continue;
                    Double dOrigVal = (Double)closestExtPeak.getDoubleProp().get(sKey2);
                    if (dOrigVal != null) {
                        Double dFormatVal = new Double(ced.getDoubleFormat().format(dOrigVal));
                        objVal = dFormatVal;
                        break;
                    }
                    objVal = null;
                    break;
                }
                if (objVal == null) {
                    for (String sKey2 : closestExtPeak.getIntegerProp().keySet()) {
                        if (!ced.getKey().equals(sKey2)) continue;
                        objVal = closestExtPeak.getIntegerProp().get(sKey2);
                        break;
                    }
                }
                MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportEntryExtGlycanColumn(ced.getKey(), objVal, iOffset, alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            }
        }
    }

    public boolean toggleFeatureSelection(String sExpAnnotId, int iRowInx, MSAnnotationTableDataChangedMessage message, boolean bCurSelected) {
        HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>> htEntryToPeakIdToFeatures = this.getEntryToPeakIdToFeatures();
        ReportRow reportRow = (ReportRow)this.getMergeReportData().getRows().get(iRowInx);
        GRITSListDataRow natRow = (GRITSListDataRow)this.getSimianTableDataObject().getTableData().get(iRowInx);
        Interval interval = reportRow.getInterval();
        List peaks = interval.getPeaks();
        int iOffset = 0;
        StringBuilder sbSelectedSequence = new StringBuilder();
        int iColCnt = 0;
        for (GRITSColumnHeader header : this.getTempPreference().getPreferenceSettings().keySet()) {
            if (header.isGrouped()) break;
            ++iColCnt;
        }
        boolean bChanged = false;
        for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
            for (GRITSColumnHeader header : this.getTempPreference().getPreferenceSettings().keySet()) {
                if (!header.isGrouped()) continue;
                if (header.getKeyValue() == DMExtPeak.ext_peak_source_peak_id.name()) {
                    natRow.getDataRow().get(iColCnt);
                }
                ++iColCnt;
            }
            HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures = htEntryToPeakIdToFeatures.get(expAnnot.getAnnotationEntryId());
            ExtPeak closestExtPeak = MSGlycanAnnotationReportTableDataProcessor.getClosestExtPeak(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId(), interval.getMz());
            if (closestExtPeak != null && htPeakIdToFeatures.containsKey(closestExtPeak.getExtPeakId())) {
                boolean bChangedThis = false;
                if (expAnnot.getAnnotationEntryId().toString().equals(sExpAnnotId)) {
                    ExtGlycanFeature extGlyFeature = MSGlycanAnnotationReportTableDataProcessor.findExtGlycanFeature(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId(), message);
                    if (extGlyFeature == null) {
                        logger.debug((Object)("Feature not in report: " + message.getFeature().getId() + ". Adding it."));
                        ExtGlycanFeature extGlycanFeature = ExtractRequiredData.getNewExtGlycanFeature((ExtPeak)closestExtPeak, (Annotation)((GlycanAnnotation)message.getAnnotation()), (Feature)message.getFeature());
                        List<ExtGlycanFeature> lFeatures = htPeakIdToFeatures.get(closestExtPeak.getExtPeakId());
                        lFeatures.add(extGlycanFeature);
                        extGlycanFeature.setSelected(bCurSelected);
                        reportRow.getAnnotations().add(extGlycanFeature);
                        bChangedThis = true;
                    } else if (extGlyFeature.getSelected() && !bCurSelected || !extGlyFeature.getSelected() && bCurSelected) {
                        extGlyFeature.setSelected(bCurSelected);
                        bChangedThis = true;
                    }
                }
                List<String> lSelSeqs = MSGlycanAnnotationReportTableDataProcessor.getSelectedFeatureSeqs(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId(), closestExtPeak);
                MSGlycanAnnotationReportTableDataProcessor.appendSequences(sbSelectedSequence, lSelSeqs);
                if (bChangedThis) {
                    StringBuilder sbExpSelectedSequence = new StringBuilder();
                    MSGlycanAnnotationReportTableDataProcessor.appendSequences(sbExpSelectedSequence, lSelSeqs);
                    if (!sbExpSelectedSequence.toString().equals("") && MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sbExpSelectedSequence.toString()) == null) {
                        try {
                            MSGlycanAnnotationTableDataObject.glycanImageProvider.addMergeImageToProvider(sbExpSelectedSequence.toString(), String.valueOf(sbExpSelectedSequence.toString()) + ".png");
                        }
                        catch (ImageCreationException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    this.fillGRITSDataRow(natRow, iOffset, sbExpSelectedSequence.toString(), htPeakIdToFeatures, closestExtPeak);
                    bChanged = bChangedThis;
                }
            }
            iOffset += this.getLastVisibleCol();
        }
        if (bChanged) {
            MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportRowPrefix(interval, sbSelectedSequence.toString(), natRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
            if (!sbSelectedSequence.toString().equals("") && MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sbSelectedSequence.toString()) == null) {
                try {
                    MSGlycanAnnotationTableDataObject.glycanImageProvider.addMergeImageToProvider(sbSelectedSequence.toString(), String.valueOf(sbSelectedSequence.toString()) + ".png");
                }
                catch (ImageCreationException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return bChanged;
    }

    public int findMatchingRow(String sExpAnnoId, Integer iPeakId) {
        int iRowCnt = 0;
        Iterator iterator = this.getMergeReportData().getRows().iterator();
        while (iterator.hasNext()) {
            ReportRow cfr_ignored_0 = (ReportRow)iterator.next();
            GRITSListDataRow alRow = (GRITSListDataRow)this.getSimianTableDataObject().getTableData().get(iRowCnt);
            int iColCnt = 0;
            for (GRITSColumnHeader header : this.getTempPreference().getPreferenceSettings().keySet()) {
                if (header.isGrouped()) break;
                ++iColCnt;
            }
            for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
                if (!expAnnot.getAnnotationEntryId().toString().equals(sExpAnnoId)) {
                    iColCnt += this.getLastVisibleCol();
                    continue;
                }
                Object oPeakId = null;
                for (GRITSColumnHeader header : this.getTempPreference().getPreferenceSettings().keySet()) {
                    if (!header.isGrouped()) continue;
                    if (header.isGrouped() && header.getKeyValue() == DMExtPeak.ext_peak_source_peak_id.name()) {
                        oPeakId = alRow.getDataRow().get(iColCnt);
                        break;
                    }
                    ++iColCnt;
                }
                if (oPeakId == null || !(oPeakId instanceof Integer)) {
                    logger.error((Object)("Peak id not found for key: " + iPeakId + " in experiment: " + expAnnot.getAnnotationDisplayName()));
                    continue;
                }
                if (!iPeakId.toString().equals(oPeakId.toString())) continue;
                return iRowCnt;
            }
            ++iRowCnt;
        }
        logger.error((Object)"Unable to locate desired row to update the data.");
        return -1;
    }

    private static void appendSequences(StringBuilder sbSeqBuilder, List<String> lSelSeqs) {
        for (String selSeq : lSelSeqs) {
            if (sbSeqBuilder.toString().contains(selSeq)) continue;
            if (!sbSeqBuilder.toString().equals("")) {
                sbSeqBuilder.append("~|~");
            }
            sbSeqBuilder.append(selSeq);
        }
    }

    protected void addPeaksTableData() {
        try {
            HashMap<Integer, HashMap<Integer, List<ExtGlycanFeature>>> htEntryToPeakIdToFeatures = this.getEntryToPeakIdToFeatures();
            int iCnt = 1;
            for (ReportRow row : this.getMergeReportData().getRows()) {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table. Row: " + iCnt + " of " + this.getMergeReportData().getRows().size());
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt++);
                if (this.bCancel) {
                    this.setSimianTableDataObject(null);
                    return;
                }
                Interval interval = row.getInterval();
                List peaks = interval.getPeaks();
                int iOffset = 0;
                GRITSListDataRow alRow = TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size());
                StringBuilder sbSelectedSequence = new StringBuilder();
                HashMap<String, String> intervalErrors = new HashMap<String, String>();
                for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
                    if (!htEntryToPeakIdToFeatures.containsKey(expAnnot.getAnnotationEntryId())) {
                        iOffset += this.getLastVisibleCol();
                        continue;
                    }
                    HashMap<Integer, List<ExtGlycanFeature>> htPeakIdToFeatures = htEntryToPeakIdToFeatures.get(expAnnot.getAnnotationEntryId());
                    ExtPeak closestExtPeak = MSGlycanAnnotationReportTableDataProcessor.getClosestExtPeak(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId(), interval.getMz());
                    if (closestExtPeak != null && htPeakIdToFeatures.containsKey(closestExtPeak.getExtPeakId())) {
                        int iPeakCnt = MSGlycanAnnotationReportTableDataProcessor.getExternalPeakCnt(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId());
                        if (iPeakCnt > 1) {
                            String closestMz = MassSpecTableDataProcessorUtil.formatDec4.format(closestExtPeak.getMz());
                            intervalErrors.put(expAnnot.getAnnotationDisplayName(), closestMz);
                        }
                        List<String> lSelSeqs = MSGlycanAnnotationReportTableDataProcessor.getSelectedFeatureSeqs(peaks, htPeakIdToFeatures, expAnnot.getAnnotationEntryId(), closestExtPeak);
                        StringBuilder sbExpSelectedSequence = new StringBuilder();
                        MSGlycanAnnotationReportTableDataProcessor.appendSequences(sbExpSelectedSequence, lSelSeqs);
                        MSGlycanAnnotationReportTableDataProcessor.appendSequences(sbSelectedSequence, lSelSeqs);
                        this.fillGRITSDataRow(alRow, iOffset, sbExpSelectedSequence.toString(), htPeakIdToFeatures, closestExtPeak);
                    }
                    iOffset += this.getLastVisibleCol();
                }
                if (!intervalErrors.isEmpty()) {
                    String intMz = MassSpecTableDataProcessorUtil.formatDec4.format(interval.getMz());
                    this.progressBarDialog.getMinorProgressBarListener(0).setError("Interval: " + intMz);
                    for (ExperimentAnnotation expAnnot : this.getMergeReportSettings().getExperimentList()) {
                        if (!intervalErrors.containsKey(expAnnot.getAnnotationDisplayName())) continue;
                        this.progressBarDialog.getMinorProgressBarListener(0).setError("     " + expAnnot.getAnnotationShortName() + ": " + (String)intervalErrors.get(expAnnot.getAnnotationDisplayName()) + " selected.");
                    }
                }
                if (!sbSelectedSequence.toString().equals("")) {
                    MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportRowPrefix(interval, sbSelectedSequence.toString(), alRow.getDataRow(), this.getTempPreference().getPreferenceSettings());
                }
                this.getSimianTableDataObject().getTableData().add(alRow);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void addAnnotationColumns(TableViewerColumnSettings _settings) {
        int iNumCols = MSGlycanAnnotationReportTableDataProcessorUtil.fillMSGlycanAnnotationReportColumnSettingsGlycanAnnotation(_settings);
        if (this.getMergeReportData().getFeatureCustomExtraData() != null) {
            iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_settings, (List)this.getMergeReportData().getFeatureCustomExtraData(), (HashMap)_settings.getUnrecognizedHeaders());
        }
        if (this.getMergeReportData().getAnnotationCustomExtraData() != null) {
            iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_settings, (List)this.getMergeReportData().getAnnotationCustomExtraData(), (HashMap)_settings.getUnrecognizedHeaders());
        }
        if (this.getMergeReportData().getPeakCustomExtraData() != null) {
            iNumCols += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData((TableViewerColumnSettings)_settings, (List)this.getMergeReportData().getPeakCustomExtraData(), (HashMap)_settings.getUnrecognizedHeaders());
        }
        this.setLastVisibleCol(iNumCols);
    }
}

