/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.datamodel;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class GRITSComparatorChooser<T>
extends AbstractTableComparatorChooser<T> {
    public GRITSComparatorChooser(SortedList<T> sortedList, TableFormat<T> tableFormat) {
        super(sortedList, tableFormat);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (this.getComparatorsForColumn(columnIndex).isEmpty()) {
            return;
        }
        if (!accumulate) {
            this.clearComparator();
        }
        switch (sortDirection) {
            case NONE: {
                this.removeSortingColumnIndex(columnIndex);
                break;
            }
            case ASC: {
                this.removeSortingColumnIndex(columnIndex);
                this.appendComparator(columnIndex, 0, false);
                break;
            }
            case DESC: {
                this.removeSortingColumnIndex(columnIndex);
                this.appendComparator(columnIndex, 0, true);
                break;
            }
        }
    }

    private void removeSortingColumnIndex(int columnIndex) {
        ArrayList<ComparatorInfo> comparatorInfos = new ArrayList<ComparatorInfo>();
        Iterator iterator = this.getSortingColumns().iterator();
        while (iterator.hasNext()) {
            int sortingColumnIndex = (Integer)iterator.next();
            if (sortingColumnIndex == columnIndex) continue;
            boolean reverse = this.isColumnReverse(sortingColumnIndex);
            comparatorInfos.add(new ComparatorInfo(sortingColumnIndex, reverse));
        }
        this.clearComparator();
        for (ComparatorInfo comparatorInfo : comparatorInfos) {
            this.appendComparator(comparatorInfo.columnIndex, 0, comparatorInfo.isReverse);
        }
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getSortingColumns().contains(columnIndex);
    }

    public SortDirectionEnum getSortDirectionForColumnIndex(int columnIndex) {
        boolean sorted = this.getSortingColumns().contains(columnIndex);
        if (!sorted) {
            return SortDirectionEnum.NONE;
        }
        return this.isColumnReverse(columnIndex) ? SortDirectionEnum.DESC : SortDirectionEnum.ASC;
    }

    public int getClickSequence(int columnIndex) {
        return this.getSortingColumns().indexOf(columnIndex);
    }

    private class ComparatorInfo {
        final int columnIndex;
        final boolean isReverse;

        ComparatorInfo(int columnIndex, boolean reverse) {
            this.columnIndex = columnIndex;
            this.isReverse = reverse;
        }
    }
}

