/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.display.control.table.dialog.ColumnChooserDialog;
import org.grits.toolbox.display.control.table.dialog.GRITSColumnEntry;
import org.grits.toolbox.display.control.table.dialog.GRITSTableColumnChooser;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;

public class GRITSTableColumnChooserDialog
extends ColumnChooserDialog {
    protected Composite extraItemComposite = null;
    protected Button replicateButton = null;
    protected Button persistenceButton = null;
    protected GRITSTableColumnChooser colChooser = null;
    protected List<List<Integer>> columnGroups = null;

    public GRITSTableColumnChooserDialog(Shell parentShell, String availableLabel, String selectedLabel, GRITSTableColumnChooser colChooser) {
        super(parentShell, availableLabel, selectedLabel);
        this.colChooser = colChooser;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, Messages.getString((String)"AbstractColumnChooserDialog.doneButton"), true);
    }

    public GRITSTableColumnChooser getParentColChooser() {
        return this.colChooser;
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
    }

    protected Control createDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    protected Point getInitialSize() {
        if (this.getDialogBoundsSettings() == null) {
            return new Point(600, 500);
        }
        Point initialSize = super.getInitialSize();
        return initialSize.x < 600 && initialSize.y < 500 ? new Point(600, 500) : initialSize;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return super.getDialogBoundsSettings();
    }

    protected int getDialogBoundsStrategy() {
        return super.getDialogBoundsStrategy();
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        super.setDialogSettings(dialogSettings);
    }

    @Override
    public void populateDialogArea(Composite parent) {
        super.populateDialogArea(parent);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        this.extraItemComposite = new Composite(parent, 0);
        this.extraItemComposite.setLayoutData((Object)gridData);
        GridLayout gl = new GridLayout(1, false);
        this.extraItemComposite.setLayout((Layout)gl);
        gridData = new GridData();
        this.replicateButton = new Button(this.extraItemComposite, 32);
        this.replicateButton.setText("Replicate column options to all experiments");
        this.replicateButton.setSelection(true);
        this.replicateButton.setLayoutData((Object)gridData);
        this.replicateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (!GRITSTableColumnChooserDialog.this.replicateButton.getSelection()) {
                    ErrorUtils.createSimpleMessageBox((Shell)GRITSTableColumnChooserDialog.this.getShell(), (String)"Message", (String)"NOTE: Changing the order of columns\nbetween experiments is not persistent");
                }
            }
        });
        if (!this.getParentColChooser().hasColumnGroupHeader()) {
            this.replicateButton.setEnabled(false);
        }
        gridData = new GridData();
        this.persistenceButton = new Button(this.extraItemComposite, 32);
        this.persistenceButton.setText("Save column options as default preferences");
        this.persistenceButton.setSelection(GRITSTable.updatePreferencesFromColumnChooser.getUpdate());
        this.persistenceButton.setLayoutData((Object)gridData);
        this.persistenceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GRITSTable.updatePreferencesFromColumnChooser.setUpdate(GRITSTableColumnChooserDialog.this.persistenceButton.getSelection());
            }
        });
    }

    public boolean isPropigateSelected() {
        return this.replicateButton.isEnabled() && this.replicateButton.getSelection();
    }

    private void addAllLeaves(TreeItem[] _tree, List<TreeItem> allLeaves) {
        int i = 0;
        while (i < _tree.length) {
            if (_tree[i].getItemCount() == 0) {
                allLeaves.add(_tree[i]);
            } else {
                this.addAllLeaves(_tree[i].getItems(), allLeaves);
            }
            ++i;
        }
    }

    @Override
    protected List<Integer> getGroupMembers(int iInx) {
        if (this.columnGroups != null) {
            int i = 0;
            while (i < this.columnGroups.size()) {
                List<Integer> groupEntries = this.columnGroups.get(i);
                int j = 0;
                while (j < groupEntries.size()) {
                    Integer iPos = groupEntries.get(j);
                    if (iPos == iInx) {
                        return groupEntries;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    protected boolean isPartOfAGroup(int iInx) {
        if (this.columnGroups != null) {
            int i = 0;
            while (i < this.columnGroups.size()) {
                List<Integer> groupEntries = this.columnGroups.get(i);
                int j = 0;
                while (j < groupEntries.size()) {
                    Integer iPos = groupEntries.get(j);
                    if (iPos == iInx) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    protected void toggleColumnGroupSelection(TreeItem treeItem) {
        if (this.isColumnGroupLeaf(treeItem)) {
            ErrorUtils.createSimpleMessageBox((Shell)this.getShell(), (String)"Message", (String)"Changing order of experiments is not allowed");
            this.getSelectedTree().deselect(treeItem);
        }
    }

    protected void initializeSelectedGroups() {
        ArrayList<TreeItem> allLeaves = new ArrayList<TreeItem>();
        List selTree = ArrayUtil.asList((Object[])super.getSelectedTree().getItems());
        this.columnGroups = new ArrayList<List<Integer>>();
        this.addAllLeaves(super.getSelectedTree().getItems(), allLeaves);
        int iLeafCnt = 0;
        int i = 0;
        while (i < selTree.size()) {
            TreeItem selItem = (TreeItem)selTree.get(i);
            if (selItem.getItemCount() > 0) {
                ArrayList<Integer> groupEntries = new ArrayList<Integer>();
                this.columnGroups.add(groupEntries);
                List groupItems = ArrayUtil.asList((Object[])selItem.getItems());
                int j = 0;
                while (j < groupItems.size()) {
                    groupEntries.add(iLeafCnt++);
                    ++j;
                }
            }
            ++i;
        }
    }

    public TreeItem[] propigateSelectedItems() {
        ArrayList<TreeItem> alNewList = new ArrayList<TreeItem>();
        List selTree = ArrayUtil.asList((Object[])super.getSelectedTree().getSelection());
        ArrayList<TreeItem> allLeaves = new ArrayList<TreeItem>();
        this.addAllLeaves(super.getSelectedTree().getItems(), allLeaves);
        int i = 0;
        while (i < selTree.size()) {
            TreeItem selItem = (TreeItem)selTree.get(i);
            if (selItem.getItemCount() == 0) {
                int j = 0;
                while (j < allLeaves.size()) {
                    TreeItem otherItem = (TreeItem)allLeaves.get(j);
                    if (otherItem.getItemCount() <= 0) {
                        GRITSColumnEntry selEntry = (GRITSColumnEntry)((Object)selItem.getData());
                        GRITSColumnEntry otherEntry = (GRITSColumnEntry)((Object)otherItem.getData());
                        if (selEntry.getKey().equals(otherEntry.getKey())) {
                            alNewList.add(otherItem);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (alNewList.isEmpty()) {
            return null;
        }
        TreeItem[] newTree = new TreeItem[alNewList.size()];
        int i2 = 0;
        while (i2 < alNewList.size()) {
            newTree[i2] = (TreeItem)alNewList.get(i2);
            ++i2;
        }
        return newTree;
    }

    @Override
    protected void moveSelectedUp() {
        this.initializeSelectedGroups();
        if (this.isPropigateSelected()) {
            super.getSelectedTree().getSelection();
            TreeItem[] selList = this.propigateSelectedItems();
            super.getSelectedTree().setSelection(selList);
            super.moveSelectedUp();
        } else {
            super.moveSelectedUp();
        }
    }

    @Override
    protected void moveSelectedDown() {
        this.initializeSelectedGroups();
        if (this.isPropigateSelected()) {
            super.getSelectedTree().getSelection();
            TreeItem[] selList = this.propigateSelectedItems();
            super.getSelectedTree().setSelection(selList);
            super.moveSelectedDown();
        } else {
            super.moveSelectedDown();
        }
    }

    @Override
    void moveSelectedToTop() {
        this.initializeSelectedGroups();
        if (this.isPropigateSelected()) {
            super.getSelectedTree().getSelection();
            TreeItem[] selList = this.propigateSelectedItems();
            super.getSelectedTree().setSelection(selList);
            super.moveSelectedToTop();
        } else {
            super.moveSelectedToTop();
        }
    }

    @Override
    void moveSelectedToBottom() {
        this.initializeSelectedGroups();
        if (this.isPropigateSelected()) {
            super.getSelectedTree().getSelection();
            TreeItem[] selList = this.propigateSelectedItems();
            super.getSelectedTree().setSelection(selList);
            super.moveSelectedToBottom();
        } else {
            super.moveSelectedToBottom();
        }
    }
}

