/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.entry.views.tabbed;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidFeature;
import org.grits.toolbox.ms.om.data.LipidFeature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.tools.gsl.annotation.entry.views.tabbed.MSGlycolipidAnnotationMultiPageViewer;
import org.grits.toolbox.tools.gsl.annotation.entry.views.tabbed.MSGlycolipidAnnotationPeaksView;
import org.grits.toolbox.utils.data.CartoonOptions;

public class MSGlycolipidAnnotationDetailsView
extends MSGlycanAnnotationDetails {
    private static final Logger logger = Logger.getLogger(MSGlycolipidAnnotationDetailsView.class);
    public static final String VIEW_ID = "ms.annotation.glycan.views.MSGlycolipidAnnotationDetails";

    @Inject
    public MSGlycolipidAnnotationDetailsView(MSAnnotationMultiPageViewer parentViewer, Entry entry, Property msEntityProperty, CartoonOptions cartoonOptions, @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(parentViewer, entry, msEntityProperty, cartoonOptions, iMinMSLevel);
    }

    protected MSGlycolipidAnnotationMultiPageViewer getParentMultiPageViewer() {
        return (MSGlycolipidAnnotationMultiPageViewer)super.getParentMultiPageViewer();
    }

    public String toString() {
        return "MSGlycolipidAnnotationDetailsView (" + this.entry + ")";
    }

    protected MSGlycolipidAnnotationPeaksView getNewPeaksView(Entry entry, MSAnnotationEntityProperty msEntityProperty) {
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)msEntityProperty);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        MSGlycolipidAnnotationPeaksView view = (MSGlycolipidAnnotationPeaksView)((Object)ContextInjectionFactory.make(MSGlycolipidAnnotationPeaksView.class, (IEclipseContext)this.getPart().getContext()));
        return view;
    }

    protected HashMap<Feature, Peak> loadFeatures(MSAnnotationEntityProperty msProp) {
        HashMap hmScanFeatures = super.loadFeatures(msProp);
        if (hmScanFeatures == null) {
            return null;
        }
        MSAnnotationTableDataProcessor proc = (MSAnnotationTableDataProcessor)((MassSpecPeaksView)this.parentViewer.getPeaksView().get(0)).getTableDataProcessor();
        for (Feature feature : hmScanFeatures.keySet()) {
            if (!(proc.getAnnotation(feature.getAnnotationId()) instanceof GlycolipidAnnotation)) continue;
            String strConvertedSeq = this.convertFeatureSequence(feature);
            feature.setSequence(strConvertedSeq);
        }
        return hmScanFeatures;
    }

    private String convertFeatureSequence(Feature a_feature) {
        String t_strRedEnd;
        String t_strGWBSeq = a_feature.getSequence();
        if (a_feature instanceof GlycolipidFeature) {
            t_strRedEnd = String.valueOf(((GlycolipidFeature)a_feature).getLipidName()) + "=0.0000u";
            t_strGWBSeq = t_strGWBSeq.replace(",freeEnd", "," + t_strRedEnd);
        }
        if (a_feature instanceof GlycanFeature) {
            t_strGWBSeq = t_strGWBSeq.replace("freeEnd--", "freeEnd/#ccleavage--");
        }
        if (a_feature instanceof LipidFeature) {
            t_strRedEnd = String.valueOf(((LipidFeature)a_feature).getLipidName()) + "=0.0000u";
            t_strGWBSeq = "freeEnd--??1D-Hex,p/#zcleavage$MONO,perMe,0,0," + t_strRedEnd;
        }
        return t_strGWBSeq;
    }
}

