/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.DerivitizedAnnotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.tools.gsl.dango.ScanReader;
import org.grits.toolbox.tools.gsl.structure.IonCombination;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public abstract class MSAnnotatorAbstract
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(MSAnnotatorAbstract.class);
    private static final String COUNTING_SCORE = "counting_score";
    private static final String INTENSITY_SCORE = "intensity_score";
    private static final String ROW_COUNTING_SCORE = "row_counting_score";
    private static final String ROW_INTENSITY_SCORE = "row_intensity_score";
    private boolean m_bFilter = false;
    private boolean m_bIsTrustMzCharge;
    protected boolean m_bIsMonoIsotopic;
    private List<Annotation> m_lCandidateAnnots;
    private Map<BigDecimal, List<Annotation>> m_mapMassToCandidateAnnotations;
    protected Map<Integer, Annotation> m_mapIDToAnnotation;
    private List<IonCombination> m_lIonCombinationsForPrecursor;
    private List<IonCombination> m_lIonCombinationsForFragments;
    private Map<Integer, List<IonCombination>> m_mapMSLevelToIonCombos;
    private List<Peak> m_lAnnotatedPrecursorPeaks;
    private List<IProgressListener> lProgressListeners;
    private boolean bCancel;

    public MSAnnotatorAbstract(boolean a_bTrustMzCharge, boolean a_bIsMonoIsotopic) {
        this.m_bIsTrustMzCharge = a_bTrustMzCharge;
        this.m_bIsMonoIsotopic = a_bIsMonoIsotopic;
        this.m_lCandidateAnnots = new ArrayList<Annotation>();
        this.m_mapMassToCandidateAnnotations = new TreeMap<BigDecimal, List<Annotation>>();
        this.m_mapIDToAnnotation = new HashMap<Integer, Annotation>();
        this.m_lIonCombinationsForPrecursor = new ArrayList<IonCombination>();
        this.m_lIonCombinationsForFragments = new ArrayList<IonCombination>();
        this.m_lAnnotatedPrecursorPeaks = new ArrayList<Peak>();
    }

    public boolean isTrustMzCharge() {
        return this.m_bIsTrustMzCharge;
    }

    public boolean isMonoIsotopic() {
        return this.m_bIsMonoIsotopic;
    }

    public void addCandidateAnnotation(Annotation a_annot) {
        this.m_lCandidateAnnots.add(a_annot);
        this.m_mapIDToAnnotation.put(a_annot.getId(), a_annot);
        Feature t_feature = this.getAnnotationFeature(a_annot);
        if (t_feature == null) {
            logger.warn((Object)("Feature cannot create from " + a_annot));
            return;
        }
        String t_strPerDeriv = ((DerivitizedAnnotation)a_annot).getPerDerivatisationType();
        BigDecimal t_bdMass = this.calculateMass(t_feature, t_strPerDeriv);
        if (t_bdMass == null) {
            logger.warn((Object)("Mass cannot calculate from " + a_annot));
            return;
        }
        if (!this.m_mapMassToCandidateAnnotations.containsKey(t_bdMass)) {
            this.m_mapMassToCandidateAnnotations.put(t_bdMass, new ArrayList());
        }
        this.m_mapMassToCandidateAnnotations.get(t_bdMass).add(a_annot);
    }

    public List<Annotation> getCandidateAnnotations() {
        return this.m_lCandidateAnnots;
    }

    public void setFilterByKeyFeature(boolean a_bDoFilter) {
        this.m_bFilter = a_bDoFilter;
    }

    public void setIonCombinationsPerMSLevel(int a_iMSLevel, List<IonCombination> a_lIonCombo) {
        this.m_mapMSLevelToIonCombos.put(a_iMSLevel, a_lIonCombo);
    }

    public void setIonCombinationsForPrecursor(List<IonCombination> a_lIonCombo) {
        this.m_lIonCombinationsForPrecursor = a_lIonCombo;
    }

    public void setIonCombinationsForFragments(List<IonCombination> a_lIonCombo) {
        this.m_lIonCombinationsForFragments = a_lIonCombo;
    }

    public List<Feature> annotateMSProfile(ScanReader a_scanR) {
        ArrayList<Feature> t_lMatchedFeatures = new ArrayList<Feature>();
        return t_lMatchedFeatures;
    }

    public List<Feature> annotateMS1Structures(ScanReader a_scanRMS2) {
        ArrayList<Feature> t_lMatchedFeatures = new ArrayList<Feature>();
        Peak t_peakPrecursor = a_scanRMS2.getScan().getPrecursor();
        if (t_peakPrecursor == null) {
            return t_lMatchedFeatures;
        }
        HashSet<Peak> t_setAllMatchedPeaks = new HashSet<Peak>();
        for (IonCombination t_ionCombo : this.m_lIonCombinationsForPrecursor) {
            if (this.m_bIsTrustMzCharge) {
                Integer t_iPreCharge = t_peakPrecursor.getPrecursorCharge();
                if (!a_scanRMS2.getScan().getPolarity().booleanValue()) {
                    t_iPreCharge = t_iPreCharge * -1;
                }
                if (t_iPreCharge != null && t_iPreCharge.intValue() != t_ionCombo.calculateCharge()) continue;
            }
            for (BigDecimal t_bdMass : this.m_mapMassToCandidateAnnotations.keySet()) {
                BigDecimal t_bdMz = this.calculateIonizedMz(t_bdMass, t_ionCombo);
                if (!a_scanRMS2.isMatchedToPrecursor(t_bdMz)) continue;
                for (Annotation t_annot : this.m_mapMassToCandidateAnnotations.get(t_bdMass)) {
                    if (this.m_bFilter && !this.findKeyFragments(a_scanRMS2, t_annot, t_ionCombo)) continue;
                    Feature t_feature = this.getAnnotationFeature(t_annot);
                    t_lMatchedFeatures.add(t_feature);
                    this.setParametersToFeature(t_feature, t_peakPrecursor.getId(), a_scanRMS2.getScan().getScanNo(), t_bdMz, a_scanRMS2.calculateDeviation(t_peakPrecursor, t_bdMz), t_ionCombo);
                    Set<Peak> t_setMatchedPeaks = this.annotateFragments(a_scanRMS2, t_feature);
                    t_setAllMatchedPeaks.addAll(t_setMatchedPeaks);
                    double[] t_dScores = this.caluclateScores(a_scanRMS2, t_setMatchedPeaks);
                    t_feature.addDoubleProp(COUNTING_SCORE, Double.valueOf(t_dScores[0]));
                    t_feature.addDoubleProp(INTENSITY_SCORE, Double.valueOf(t_dScores[1]));
                    t_feature.addDoubleProp(ROW_COUNTING_SCORE, Double.valueOf(t_dScores[2]));
                    t_feature.addDoubleProp(ROW_INTENSITY_SCORE, Double.valueOf(t_dScores[3]));
                }
            }
        }
        a_scanRMS2.getScan().setNumAnnotatedPeaks(Integer.valueOf(t_setAllMatchedPeaks.size()));
        return t_lMatchedFeatures;
    }

    public List<Feature> annotateSubScan(ScanReader a_scanRSub) {
        ArrayList<Feature> t_lPrecursorFeatures = new ArrayList<Feature>();
        Peak t_peakPrecursor = a_scanRSub.getScan().getPrecursor();
        if (t_peakPrecursor == null || t_peakPrecursor.getFeatures().isEmpty()) {
            return t_lPrecursorFeatures;
        }
        ArrayList<Integer> t_lFeatureIds = t_peakPrecursor.getFeatures();
        if (this.m_lAnnotatedPrecursorPeaks.contains(t_peakPrecursor)) {
            t_lFeatureIds = new ArrayList<Integer>();
            for (Integer t_iPrecursorFeature : t_peakPrecursor.getFeatures()) {
                Feature t_featureOriginal = FeatureProvider.getFeatures().get(t_iPrecursorFeature - 1);
                if (FeatureProvider.isCopiedFeature(t_featureOriginal)) continue;
                Feature t_featureCopied = this.copyFeature(t_featureOriginal);
                t_lFeatureIds.add(Integer.valueOf(t_featureCopied.getId()));
            }
            if (!t_lFeatureIds.isEmpty()) {
                t_peakPrecursor.getFeatures().addAll(t_lFeatureIds);
            }
        } else {
            this.m_lAnnotatedPrecursorPeaks.add(t_peakPrecursor);
        }
        HashSet<Peak> t_setAllMatchedPeaks = new HashSet<Peak>();
        for (Integer t_iPrecursorFeature : t_lFeatureIds) {
            Feature t_featurePrecursor = FeatureProvider.getFeatures().get(t_iPrecursorFeature - 1);
            t_featurePrecursor.getFeatureSelections().clear();
            FeatureSelection t_fs = new FeatureSelection();
            t_fs.setRowId(Feature.getRowId((Integer)t_peakPrecursor.getId(), (Integer)a_scanRSub.getScan().getScanNo()));
            t_featurePrecursor.getFeatureSelections().add(t_fs);
            t_lPrecursorFeatures.add(t_featurePrecursor);
            Set<Peak> t_setMatchedPeaks = this.annotateFragments(a_scanRSub, t_featurePrecursor);
            double[] t_dScores = this.caluclateScores(a_scanRSub, t_setMatchedPeaks);
            t_featurePrecursor.addDoubleProp(COUNTING_SCORE, Double.valueOf(t_dScores[0]));
            t_featurePrecursor.addDoubleProp(INTENSITY_SCORE, Double.valueOf(t_dScores[1]));
            t_featurePrecursor.addDoubleProp(ROW_COUNTING_SCORE, Double.valueOf(t_dScores[2]));
            t_featurePrecursor.addDoubleProp(ROW_INTENSITY_SCORE, Double.valueOf(t_dScores[3]));
            t_setAllMatchedPeaks.addAll(t_setMatchedPeaks);
        }
        a_scanRSub.getScan().setNumAnnotatedPeaks(Integer.valueOf(t_setAllMatchedPeaks.size()));
        return t_lPrecursorFeatures;
    }

    public Set<Peak> annotateFragments(ScanReader a_scanR, Feature a_featureParent) {
        HashSet<Peak> t_setMatchedPeaks = new HashSet<Peak>();
        ArrayList<Feature> t_lFragFeatures = new ArrayList<Feature>();
        Annotation t_annot = this.m_mapIDToAnnotation.get(a_featureParent.getAnnotationId());
        String t_strPerDeriv = ((DerivitizedAnnotation)t_annot).getPerDerivatisationType();
        List<String[]> t_lFragments = this.getFragments(a_featureParent, t_strPerDeriv, a_scanR.getScan().getMsLevel(), a_scanR.getScan().getActivationMethode());
        if (t_lFragments == null) {
            return t_setMatchedPeaks;
        }
        for (String[] t_strFrag : t_lFragments) {
            for (IonCombination t_ionCombo : this.getIonCombinationsForFragments(t_strFrag)) {
                BigDecimal t_bdFragMz;
                Peak t_peakMatched;
                BigDecimal t_bdMass;
                Feature t_featureFrag;
                if (a_scanR.getScan().getPolarity() != t_ionCombo.calculateCharge() > 0 || Math.abs(t_ionCombo.calculateCharge()) > Math.abs(a_featureParent.getCharge()) || (t_featureFrag = this.getFragmentFeature(a_featureParent.getAnnotationId(), t_strFrag)) == null || (t_bdMass = this.calculateMass(t_featureFrag, t_strPerDeriv)) == null || (t_peakMatched = a_scanR.getMatchedPeak(t_bdFragMz = this.calculateIonizedMz(t_bdMass, t_ionCombo))) == null) continue;
                t_setMatchedPeaks.add(t_peakMatched);
                this.setParametersToFeature(t_featureFrag, t_peakMatched.getId(), null, t_bdFragMz, a_scanR.calculateDeviation(t_peakMatched, t_bdFragMz), t_ionCombo);
                t_peakMatched.getFeatures().add(Integer.valueOf(t_featureFrag.getId()));
                t_lFragFeatures.add(t_featureFrag);
            }
        }
        this.setFragmentFeatures(a_featureParent, t_lFragFeatures);
        return t_setMatchedPeaks;
    }

    protected List<IonCombination> getIonCombinationsForFragments(String[] a_strFrag) {
        return this.m_lIonCombinationsForFragments;
    }

    private double[] caluclateScores(ScanReader a_scanR, Set<Peak> a_setMatchedPeaks) {
        double t_dCountScore = (double)a_setMatchedPeaks.size() / (double)a_scanR.getFilteredPeaks().size();
        double t_dRowCountScore = (double)a_setMatchedPeaks.size() / (double)a_scanR.getScan().getTotalNumPeaks().intValue();
        double t_dSumTotalIntensity = 0.0;
        for (Peak t_peak : a_scanR.getFilteredPeaks()) {
            t_dSumTotalIntensity += t_peak.getIntensity().doubleValue();
        }
        double t_dSumMatchedIntensity = 0.0;
        for (Peak t_peak : a_setMatchedPeaks) {
            t_dSumMatchedIntensity += t_peak.getIntensity().doubleValue();
        }
        double t_dIntensityScore = t_dSumMatchedIntensity / t_dSumTotalIntensity;
        double t_dRowIntensityScore = t_dSumMatchedIntensity / a_scanR.getScan().getTotalIntensity();
        double[] t_dScores = new double[]{t_dCountScore, t_dIntensityScore, t_dRowCountScore, t_dRowIntensityScore};
        return t_dScores;
    }

    private void setParametersToFeature(Feature a_feature, Integer a_iPeakId, Integer a_iScanNo, BigDecimal a_bdMz, BigDecimal a_bdDeviation, IonCombination a_ionCombo) {
        FeatureProvider.addNewFeature(a_feature);
        FeatureSelection t_fSelection = new FeatureSelection();
        t_fSelection.setRowId(Feature.getRowId((Integer)a_iPeakId, (Integer)a_iScanNo));
        a_feature.getFeatureSelections().add(t_fSelection);
        a_feature.setMz(Double.valueOf(a_bdMz.doubleValue()));
        a_feature.setDeviation(Double.valueOf(a_bdDeviation.doubleValue()));
        a_feature.setIons(a_ionCombo.getIonAdducts());
        a_feature.setNeutralexchange(a_ionCombo.getIonExchanges());
        a_feature.setNeutralLoss(a_ionCombo.getNeutralLosses());
        a_feature.setCharge(Integer.valueOf(a_ionCombo.calculateCharge()));
    }

    private Feature copyFeature(Feature a_feature) {
        String[] t_lFragInfo = this.getFeatureFragmentInfo(a_feature);
        Feature t_featureCopied = this.getFragmentFeature(a_feature.getAnnotationId(), t_lFragInfo);
        FeatureProvider.addCopiedFeature(t_featureCopied);
        t_featureCopied.setMz(a_feature.getMz());
        t_featureCopied.setDeviation(a_feature.getDeviation());
        t_featureCopied.setIons(a_feature.getIons());
        t_featureCopied.setNeutralexchange(a_feature.getNeutralexchange());
        t_featureCopied.setNeutralLoss(a_feature.getNeutralLoss());
        t_featureCopied.setCharge(a_feature.getCharge());
        return t_featureCopied;
    }

    protected String[] getFeatureFragmentInfo(Feature a_feature) {
        String[] t_lFragInfo = new String[]{a_feature.getSequence(), a_feature.getType()};
        return t_lFragInfo;
    }

    protected BigDecimal calculateIonizedMz(BigDecimal a_bdAnnalyteMass, IonCombination a_ionCombo) {
        BigDecimal t_bdMzGlycolipid = a_bdAnnalyteMass.add(new BigDecimal(a_ionCombo.calculateMass()));
        return t_bdMzGlycolipid.divide(new BigDecimal(Math.abs(a_ionCombo.calculateCharge())), 10, 4);
    }

    protected abstract BigDecimal calculateMass(Feature var1, String var2);

    protected abstract boolean findKeyFragments(ScanReader var1, Annotation var2, IonCombination var3);

    protected abstract Feature getAnnotationFeature(Annotation var1);

    protected abstract List<String[]> getFragments(Feature var1, String var2, int var3, String var4);

    protected abstract Feature getFragmentFeature(Integer var1, String[] var2);

    protected abstract void setFragmentFeatures(Feature var1, List<Feature> var2);

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.lProgressListeners = lProgressListeners;
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.lProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.lProgressListeners;
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }

    private static class FeatureProvider {
        private static final List<Feature> lFeatures = new ArrayList<Feature>();
        private static final List<Feature> lCopiedFeature = new ArrayList<Feature>();

        private FeatureProvider() {
        }

        public static void addNewFeature(Feature a_feature) {
            lFeatures.add(a_feature);
            a_feature.setId("" + lFeatures.size());
        }

        public static void addCopiedFeature(Feature a_feature) {
            FeatureProvider.addNewFeature(a_feature);
            lCopiedFeature.add(a_feature);
        }

        public static boolean isCopiedFeature(Feature a_feature) {
            return lCopiedFeature.contains(a_feature);
        }

        public static List<Feature> getFeatures() {
            return lFeatures;
        }

        public static Feature getFeatureByID(Integer a_iFeatureID) {
            for (Feature t_feature : lFeatures) {
                if (!t_feature.getId().equals(a_iFeatureID.toString())) continue;
                return t_feature;
            }
            return null;
        }
    }
}

