/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class ScanReader {
    private static final Logger logger = Logger.getLogger(ScanReader.class);
    private static double RELATIVE_INTENSITY_FOR_FILTER = 0.05;
    private Scan m_scan;
    private List<Peak> m_lFilteredPeaks;
    private List<Peak> m_lFilteredPeaksForKeyFragments;
    private double m_dShift;
    private BigDecimal m_dAccuracy;
    private boolean m_bAccuracyPPM;
    private BigDecimal m_dFragAccuracy;
    private boolean m_bFragAccuracyPPM;
    private BigDecimal m_bdMinPeakMz;
    private BigDecimal m_bdMaxPeakMz;

    public ScanReader(Scan a_scan) {
        this.m_scan = a_scan;
        this.m_lFilteredPeaks = new ArrayList<Peak>();
        this.m_lFilteredPeaksForKeyFragments = new ArrayList<Peak>();
        for (Peak t_peak : a_scan.getPeaklist()) {
            this.m_lFilteredPeaks.add(t_peak);
            if (t_peak.getRelativeIntensity() == null) {
                double t_dRelInt = t_peak.getIntensity();
                t_peak.setRelativeIntensity(Double.valueOf(t_dRelInt /= a_scan.getMostAbundantPeak().doubleValue()));
            }
            if (t_peak.getRelativeIntensity() < RELATIVE_INTENSITY_FOR_FILTER) continue;
            this.m_lFilteredPeaksForKeyFragments.add(t_peak);
        }
        this.m_dShift = 0.0;
        this.m_dAccuracy = BigDecimal.ZERO;
        this.m_bAccuracyPPM = false;
        this.m_dFragAccuracy = BigDecimal.ZERO;
        this.m_bFragAccuracyPPM = false;
        this.setPeakMzRange();
    }

    public Scan getScan() {
        return this.m_scan;
    }

    public void setShift(double a_dShift) {
        this.m_dShift = a_dShift;
    }

    public void setAccuracy(double a_dAccuracy, boolean a_bIsPPM) {
        this.m_dAccuracy = new BigDecimal(a_dAccuracy);
        this.m_bAccuracyPPM = a_bIsPPM;
    }

    public void setFragmentAccuracy(double a_dFragAccuracy, boolean a_bIsPPM) {
        this.m_dFragAccuracy = new BigDecimal(a_dFragAccuracy);
        this.m_bFragAccuracyPPM = a_bIsPPM;
    }

    public void setIntencityCutoff(double a_dCutoff, String a_strCutoffType) {
        if (!"Absolute Value".equals(a_strCutoffType) && !"Percentage".equals(a_strCutoffType)) {
            return;
        }
        this.m_lFilteredPeaks = new ArrayList<Peak>();
        for (Peak t_peak : this.m_scan.getPeaklist()) {
            if (t_peak.equals(this.m_scan.getPrecursor()) || "Absolute Value".equals(a_strCutoffType) && t_peak.getIntensity() < a_dCutoff || "Percentage".equals(a_strCutoffType) && t_peak.getRelativeIntensity() * 100.0 < a_dCutoff) continue;
            this.m_lFilteredPeaks.add(t_peak);
        }
    }

    private void setPeakMzRange() {
        double t_dMin = Double.MAX_VALUE;
        double t_dMax = Double.MIN_VALUE;
        for (Peak t_peak : this.m_scan.getPeaklist()) {
            if (t_peak.equals(this.m_scan.getPrecursor())) continue;
            if (t_peak.getMz() + this.m_dShift > t_dMax) {
                t_dMax = t_peak.getMz() + this.m_dShift;
            }
            if (!(t_peak.getMz() + this.m_dShift < t_dMin)) continue;
            t_dMin = t_peak.getMz() + this.m_dShift;
        }
        this.m_bdMinPeakMz = new BigDecimal(t_dMin);
        this.m_bdMaxPeakMz = new BigDecimal(t_dMax);
    }

    public boolean isMatchedToPrecursor(BigDecimal a_bdMz) {
        BigDecimal t_bdAcc = this.calculateAccuracy(a_bdMz, this.m_dAccuracy, this.m_bAccuracyPPM);
        Peak t_peakPrecursor = this.m_scan.getPrecursor();
        if (t_peakPrecursor.getPrecursorMz() != null && t_peakPrecursor.getPrecursorMz() > 0.0) {
            t_peakPrecursor = new Peak();
            t_peakPrecursor.setMz(this.m_scan.getPrecursor().getPrecursorMz());
            t_peakPrecursor.setIntensity(this.m_scan.getPrecursor().getPrecursorIntensity());
        }
        return this.isMatchedPeak(t_peakPrecursor, a_bdMz, t_bdAcc);
    }

    public List<Peak> getFilteredPeaks() {
        return this.m_lFilteredPeaks;
    }

    public Peak getMatchedPeak(BigDecimal a_bdMz) {
        return this.getMatchedPeak(a_bdMz, this.m_lFilteredPeaks);
    }

    public Peak getMatchedPeakForKeyFragment(BigDecimal a_bdMz) {
        return this.getMatchedPeak(a_bdMz, this.m_lFilteredPeaksForKeyFragments);
    }

    private Peak getMatchedPeak(BigDecimal a_bdMz, List<Peak> a_lFilteredPeaks) {
        int i;
        boolean t_bIsMatched;
        BigDecimal t_bdAcc = this.calculateAccuracy(a_bdMz, this.m_dFragAccuracy, this.m_bFragAccuracyPPM);
        if (this.isOutOfRange(a_bdMz, t_bdAcc)) {
            return null;
        }
        int t_nPeaks = a_lFilteredPeaks.size();
        int t_iFirstPeakID = -1;
        Peak t_peak = null;
        int t_nSkip = t_nPeaks;
        BigDecimal t_bdMinMz = a_bdMz.subtract(t_bdAcc);
        while (t_nSkip > 10) {
            int t_iPrePeakID = 0;
            t_bIsMatched = false;
            i = t_iFirstPeakID + (t_nSkip /= 10);
            while (i < t_nPeaks) {
                t_iPrePeakID = i;
                t_peak = a_lFilteredPeaks.get(i);
                if (this.calculateDifference(t_peak, t_bdMinMz).compareTo(BigDecimal.ZERO) >= 0) {
                    t_bIsMatched = true;
                    t_iFirstPeakID = i - t_nSkip;
                    break;
                }
                i += t_nSkip;
            }
            if (t_bIsMatched) continue;
            t_iFirstPeakID = t_iPrePeakID;
        }
        BigDecimal t_bdMaxMz = a_bdMz.add(t_bdAcc);
        t_bIsMatched = false;
        i = t_iFirstPeakID;
        while (i < t_nPeaks) {
            if (i >= 0) {
                t_peak = a_lFilteredPeaks.get(i);
                if (this.calculateDifference(t_peak, t_bdMaxMz).compareTo(BigDecimal.ZERO) > 0) {
                    return null;
                }
                if (this.calculateDifference(t_peak, t_bdMinMz).compareTo(BigDecimal.ZERO) >= 0) {
                    t_bIsMatched = true;
                    t_iFirstPeakID = i;
                    break;
                }
            }
            ++i;
        }
        if (!t_bIsMatched) {
            return null;
        }
        Peak t_peakMax = t_peak;
        int i2 = t_iFirstPeakID + 1;
        while (i2 < t_nPeaks) {
            t_peak = a_lFilteredPeaks.get(i2);
            if (t_peak != null && t_peak.getMz() != null && t_peak.getIntensity() != null) {
                if (this.calculateDifference(t_peak, t_bdMaxMz).compareTo(BigDecimal.ZERO) > 0) break;
                if (t_peakMax.getIntensity() < t_peak.getIntensity()) {
                    t_peakMax = t_peak;
                }
            }
            ++i2;
        }
        t_peakMax.getId().intValue();
        return t_peakMax;
    }

    private boolean isOutOfRange(BigDecimal a_bdMz, BigDecimal a_bdAcc) {
        if (this.m_bdMinPeakMz.compareTo(a_bdMz.add(a_bdAcc)) > 0) {
            return true;
        }
        return this.m_bdMaxPeakMz.compareTo(a_bdMz.subtract(a_bdAcc)) < 0;
    }

    private BigDecimal calculateAccuracy(BigDecimal a_bdMz, BigDecimal a_bdAcc, boolean a_bIsPPM) {
        BigDecimal t_bdAcc = a_bdAcc;
        if (a_bIsPPM) {
            t_bdAcc = a_bdMz.multiply(a_bdAcc).divide(new BigDecimal(1000000));
        }
        return t_bdAcc;
    }

    private boolean isMatchedPeak(Peak a_peak, BigDecimal a_bdMz, BigDecimal a_bdAcc) {
        if (a_peak == null || a_peak.getMz() == null || a_peak.getIntensity() == null) {
            return false;
        }
        return this.calculateDifference(a_peak, a_bdMz).abs().compareTo(a_bdAcc) < 0;
    }

    private BigDecimal calculateDifference(Peak a_peak, BigDecimal a_bdMz) {
        BigDecimal t_bdPeakMz = new BigDecimal(a_peak.getMz() + this.m_dShift);
        return t_bdPeakMz.subtract(a_bdMz);
    }

    public BigDecimal calculatePrecursorDeviation(BigDecimal a_bdMz) {
        return this.calculateDeviation(this.m_scan.getPrecursor(), a_bdMz);
    }

    public BigDecimal calculateDeviation(Peak a_peak, BigDecimal a_bdMz) {
        return this.calculateDifference(a_peak, a_bdMz).abs().divide(a_bdMz, 10, 4).multiply(new BigDecimal(1000000.0));
    }
}

