/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator;

import org.grits.toolbox.tools.gsl.database.lipid.LipidClass;
import org.grits.toolbox.tools.gsl.database.lipid.LipidParameters;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.util.generator.LipidDatabaseGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.generator.LipidParametersIO;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidsGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.generator.structure.SphingosinesGenerator;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.LipidChemicalComposition;

public class SphingosineDatabaseGenerator
extends LipidDatabaseGeneratorAbstract {
    private LipidParametersIO m_paramsImporter;

    public SphingosineDatabaseGenerator() {
        this.setLipidClass(LipidClass.SPHINGOSINE);
        this.m_paramsImporter = new LipidParametersIO();
        this.m_paramsImporter.setLipidClass(LipidClass.SPHINGOSINE);
    }

    public boolean setCarbonLengths(String a_strParams) {
        return this.m_paramsImporter.setCarbonLengths(a_strParams);
    }

    public boolean setNumbersOfHydrxylGroups(String a_strParams) {
        return this.m_paramsImporter.setNumbersOfHydroxylGroups(a_strParams);
    }

    public boolean setNumbersOfOAcetylGroups(String a_strParams) {
        return this.m_paramsImporter.setNumbersOfOAcetylGroups(a_strParams);
    }

    public boolean setNumbersOfUnsaturations(String a_strParams) {
        return this.m_paramsImporter.setNumbersOfUnsaturations(a_strParams);
    }

    public void allowOnlyEvenNumberedCarbonLength(boolean a_bOnlyEven) {
        this.m_paramsImporter.allowOnlyEvenNumberedCarbonLength(a_bOnlyEven);
    }

    @Override
    public void generate() {
        LipidParameters t_params = new LipidParameters();
        t_params.setCarbonLengths(this.m_paramsImporter.printCarbonLengths());
        t_params.setNumberOfHydroxylGroups(this.m_paramsImporter.printNumbersOfHydroxylGroups());
        t_params.setNumberOfOAcetylGroups(this.m_paramsImporter.printNumbersOfOAcetylGroups());
        t_params.setNumberOfDoubleBonds(this.m_paramsImporter.printNumbersOfUnsaturations());
        t_params.setIsAllowedOnlyEvenNumbers(this.m_paramsImporter.isOnlyEvenNumberForCarbonLength());
        this.getLipidGenerationSettings().setSphingosine(t_params);
        super.generate();
    }

    @Override
    protected LipidsGeneratorAbstract getLipidsGenerator() {
        SphingosinesGenerator t_genSph = new SphingosinesGenerator();
        t_genSph.setParameters(this.m_paramsImporter);
        return t_genSph;
    }

    @Override
    protected ChemicalComposition getChemicalComposition(ILipid a_ILip) {
        return new LipidChemicalComposition((Lipid)a_ILip);
    }
}

