/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.mass;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.IMass;
import org.grits.toolbox.tools.gsl.util.mass.QuantumMass;

public class IsotopicDistributionCalculator {
    private static Map<AtomicMass, Map<Integer, Map<BigDecimal, BigDecimal>>> mapAtomToNumToMassesToIntensities = new TreeMap<AtomicMass, Map<Integer, Map<BigDecimal, BigDecimal>>>();
    private ChemicalComposition m_oChemComp;
    private List<String> m_lStrMasses;
    private List<String> m_lStrIntensities;
    private List<String> m_lStrScaledIntensities;
    private String m_strAverageMass;
    private BigDecimal m_dMinAbundance;
    private int m_iCutAbundanceScale;
    private int m_iDecimalScale;

    public IsotopicDistributionCalculator(ChemicalComposition a_oChemComp) {
        this.m_oChemComp = a_oChemComp;
        this.m_lStrMasses = new ArrayList<String>();
        this.m_lStrIntensities = new ArrayList<String>();
        this.m_lStrScaledIntensities = new ArrayList<String>();
        this.m_dMinAbundance = new BigDecimal(0.001);
        this.m_iCutAbundanceScale = 10;
        this.m_iDecimalScale = 5;
    }

    public void setMinimumAbundance(double a_dMinAb) {
        this.m_dMinAbundance = new BigDecimal(a_dMinAb);
    }

    public void setDecimalScale(int a_iScale) {
        if (a_iScale < 0 || a_iScale > 10) {
            return;
        }
        this.m_iDecimalScale = a_iScale;
    }

    public List<String> getMasses() {
        return this.m_lStrMasses;
    }

    public List<String> getIntensities() {
        return this.m_lStrIntensities;
    }

    public List<String> getScaledIntensities() {
        return this.m_lStrScaledIntensities;
    }

    public String getAverageMass() {
        return this.m_strAverageMass;
    }

    public void calculate() {
        HashMap<QuantumMass, Integer> t_mapQMassToNum = new HashMap<QuantumMass, Integer>();
        Map<BigDecimal, BigDecimal> t_mapAtomsMassToIntensity = null;
        for (IMass t_mass : this.m_oChemComp.getNumberOfElements().keySet()) {
            if (!(t_mass instanceof AtomicMass)) {
                if (!(t_mass instanceof QuantumMass)) continue;
                t_mapQMassToNum.put((QuantumMass)t_mass, this.m_oChemComp.getNumberOfElements().get(t_mass));
                continue;
            }
            AtomicMass t_aMass = (AtomicMass)t_mass;
            int t_nAtom = this.m_oChemComp.getNumberOfElements().get(t_mass);
            t_mapAtomsMassToIntensity = t_mapAtomsMassToIntensity == null ? this.multiplyAtom(t_aMass, t_nAtom) : this.combine(t_mapAtomsMassToIntensity, this.multiplyAtom(t_aMass, t_nAtom));
        }
        if (!t_mapQMassToNum.isEmpty()) {
            BigDecimal t_bdQMass = BigDecimal.ZERO;
            int t_iTotalCharge = 0;
            for (QuantumMass t_qMass : t_mapQMassToNum.keySet()) {
                int t_nQMass = (Integer)t_mapQMassToNum.get(t_qMass);
                t_iTotalCharge += t_nQMass * t_qMass.getCharge();
                t_bdQMass = t_bdQMass.add(new BigDecimal(t_qMass.getExactMass()).multiply(new BigDecimal(t_nQMass)));
            }
            if (t_iTotalCharge != 0) {
                t_iTotalCharge = Math.abs(t_iTotalCharge);
                TreeMap t_mapMzToIntencity = new TreeMap();
                for (BigDecimal t_bdMass : t_mapAtomsMassToIntensity.keySet()) {
                    BigDecimal t_bdMz = t_bdMass.add(t_bdQMass);
                    if (t_iTotalCharge > 1) {
                        t_bdMz = t_bdMz.divide(new BigDecimal(t_iTotalCharge));
                    }
                    t_mapMzToIntencity.put(t_bdMz, (BigDecimal)t_mapAtomsMassToIntensity.get(t_bdMass));
                }
                t_mapAtomsMassToIntensity = t_mapMzToIntencity;
            }
        }
        if (this.m_iDecimalScale < 10) {
            TreeMap<BigDecimal, BigDecimal> t_mapAtomsMassToIntensityMerged = new TreeMap<BigDecimal, BigDecimal>();
            for (BigDecimal t_bdMass : t_mapAtomsMassToIntensity.keySet()) {
                BigDecimal t_bdIntensity = t_mapAtomsMassToIntensity.get(t_bdMass);
                BigDecimal t_bdScaledMass = t_bdMass.setScale(this.m_iDecimalScale, RoundingMode.HALF_UP);
                if (t_mapAtomsMassToIntensityMerged.containsKey(t_bdScaledMass)) {
                    t_bdIntensity = t_bdIntensity.add((BigDecimal)t_mapAtomsMassToIntensityMerged.get(t_bdScaledMass));
                }
                t_mapAtomsMassToIntensityMerged.put(t_bdScaledMass, t_bdIntensity);
            }
            t_mapAtomsMassToIntensity = t_mapAtomsMassToIntensityMerged;
        }
        t_mapAtomsMassToIntensity = this.normalize(t_mapAtomsMassToIntensity);
        BigDecimal t_bdMaxInt = BigDecimal.ZERO;
        for (BigDecimal t_bdInt : t_mapAtomsMassToIntensity.values()) {
            if (t_bdInt.compareTo(t_bdMaxInt) <= 0) continue;
            t_bdMaxInt = t_bdInt;
        }
        BigDecimal t_bdAve = BigDecimal.ZERO;
        for (BigDecimal t_bdMass : t_mapAtomsMassToIntensity.keySet()) {
            BigDecimal t_bdInt = (BigDecimal)t_mapAtomsMassToIntensity.get(t_bdMass);
            t_bdAve = t_bdAve.add(t_bdMass.multiply(t_bdInt));
            BigDecimal t_bdScaledInt = t_bdInt.divide(t_bdMaxInt, this.m_iCutAbundanceScale, RoundingMode.HALF_UP);
            if (t_bdScaledInt.compareTo(this.m_dMinAbundance) <= 0) continue;
            this.m_lStrMasses.add(t_bdMass.toPlainString());
            t_bdInt = t_bdInt.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
            this.m_lStrIntensities.add(t_bdInt.toPlainString());
            t_bdScaledInt = t_bdScaledInt.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
            this.m_lStrScaledIntensities.add(t_bdScaledInt.toPlainString());
        }
        this.m_strAverageMass = t_bdAve.toPlainString();
    }

    public Map<BigDecimal, BigDecimal> multiplyAtom(AtomicMass a_massAtom, int a_nAtom) {
        if (!mapAtomToNumToMassesToIntensities.containsKey(a_massAtom)) {
            BigDecimal t_bdInten;
            TreeMap<Integer, TreeMap<BigDecimal, BigDecimal>> t_mapAtomNumToMassToIntensity = null;
            TreeMap<BigDecimal, BigDecimal> t_mapAtomMassToIntensity = new TreeMap<BigDecimal, BigDecimal>();
            BigDecimal t_bdMass = new BigDecimal(a_massAtom.getExactMass());
            t_mapAtomMassToIntensity.put(t_bdMass, BigDecimal.ONE);
            if (a_massAtom.getMassPlus1() != null) {
                t_bdMass = new BigDecimal(a_massAtom.getMassPlus1());
                t_bdInten = new BigDecimal(a_massAtom.getRelativeIntensityPlus1()).multiply(new BigDecimal(0.01));
                t_mapAtomMassToIntensity.put(t_bdMass, t_bdInten);
            }
            if (a_massAtom.getMassPlus2() != null) {
                t_bdMass = new BigDecimal(a_massAtom.getMassPlus2());
                t_bdInten = new BigDecimal(a_massAtom.getRelativeIntensityPlus2()).multiply(new BigDecimal(0.01));
                t_mapAtomMassToIntensity.put(t_bdMass, t_bdInten);
            }
            t_mapAtomNumToMassToIntensity = new TreeMap<Integer, TreeMap<BigDecimal, BigDecimal>>();
            t_mapAtomNumToMassToIntensity.put(0, t_mapAtomMassToIntensity);
            mapAtomToNumToMassesToIntensities.put(a_massAtom, t_mapAtomNumToMassToIntensity);
        }
        if (a_nAtom == 1) {
            return mapAtomToNumToMassesToIntensities.get(a_massAtom).get(0);
        }
        Map<BigDecimal, BigDecimal> t_mapAtomsMassToIntencity = null;
        String bin = Integer.toBinaryString(a_nAtom);
        int i = 0;
        while (i < bin.length()) {
            if (!mapAtomToNumToMassesToIntensities.get(a_massAtom).containsKey(i)) {
                Map<BigDecimal, BigDecimal> t_mapLowerBin = mapAtomToNumToMassesToIntensities.get(a_massAtom).get(i - 1);
                mapAtomToNumToMassesToIntensities.get(a_massAtom).put(i, this.combine(t_mapLowerBin, t_mapLowerBin));
            }
            if (bin.charAt(bin.length() - 1 - i) != '0') {
                t_mapAtomsMassToIntencity = t_mapAtomsMassToIntencity == null ? mapAtomToNumToMassesToIntensities.get(a_massAtom).get(i) : this.combine(t_mapAtomsMassToIntencity, mapAtomToNumToMassesToIntensities.get(a_massAtom).get(i));
            }
            ++i;
        }
        return t_mapAtomsMassToIntencity;
    }

    public Map<BigDecimal, BigDecimal> combine(Map<BigDecimal, BigDecimal> a_map1, Map<BigDecimal, BigDecimal> a_map2) {
        TreeMap<BigDecimal, BigDecimal> t_mapResult = new TreeMap<BigDecimal, BigDecimal>();
        for (BigDecimal t_bd1 : a_map1.keySet()) {
            for (BigDecimal t_bd2 : a_map2.keySet()) {
                BigDecimal t_bdAdd = t_bd1.add(t_bd2);
                BigDecimal t_bdMultIntensity = a_map1.get(t_bd1).multiply(a_map2.get(t_bd2));
                if (t_mapResult.containsKey(t_bdAdd)) {
                    t_bdMultIntensity = t_bdMultIntensity.add((BigDecimal)t_mapResult.get(t_bdAdd));
                }
                t_mapResult.put(t_bdAdd, t_bdMultIntensity);
            }
        }
        TreeMap<BigDecimal, BigDecimal> t_mapResultTrim = new TreeMap<BigDecimal, BigDecimal>();
        for (BigDecimal t_bdMass : t_mapResult.keySet()) {
            BigDecimal t_bdIntensity = ((BigDecimal)t_mapResult.get(t_bdMass)).setScale(this.m_iCutAbundanceScale, RoundingMode.HALF_UP);
            if (t_bdIntensity.compareTo(BigDecimal.ZERO) == 0) continue;
            t_mapResultTrim.put(t_bdMass, t_bdIntensity);
        }
        return t_mapResultTrim;
    }

    private Map<BigDecimal, BigDecimal> normalize(Map<BigDecimal, BigDecimal> a_map) {
        TreeMap<BigDecimal, BigDecimal> t_mapResult = new TreeMap<BigDecimal, BigDecimal>();
        BigDecimal t_bdTotalInt = BigDecimal.ZERO;
        for (BigDecimal t_bdInt : a_map.values()) {
            t_bdTotalInt = t_bdTotalInt.add(t_bdInt);
        }
        for (BigDecimal t_bdMass : a_map.keySet()) {
            BigDecimal t_bdInt = a_map.get(t_bdMass);
            t_bdInt = t_bdInt.divide(t_bdTotalInt, this.m_iCutAbundanceScale, RoundingMode.HALF_UP);
            t_mapResult.put(t_bdMass, t_bdInt);
        }
        return t_mapResult;
    }

    private boolean containsMass(Map<BigDecimal, BigDecimal> a_map, BigDecimal a_bdValue) {
        for (BigDecimal a_bdValue0 : a_map.keySet()) {
            if (a_bdValue0.compareTo(a_bdValue) != 0) continue;
            return true;
        }
        return false;
    }
}

