/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.grits.toolbox.widgets.heatmap.AxisDataSet;
import org.grits.toolbox.widgets.heatmap.gui.GritsAxis;

public class GritsTickLabels
extends Figure {
    private static final String MINUS = "-";
    private static final int TICK_LABEL_GAP = 2;
    AxisDataSet labelData;
    private GritsAxis scale;
    private ArrayList<String> tickLabels;
    private ArrayList<Double> tickLabelValues;
    private ArrayList<Integer> tickLabelPositions;
    private ArrayList<Boolean> tickLabelVisibilities;
    private int gridStepInPixel;
    private int tickLabelMaxHeight;
    private int tickLabelMaxLength;
    private int tickLabelAngle;

    public GritsTickLabels(GritsAxis scale) {
        this.scale = scale;
        this.tickLabels = new ArrayList();
        this.tickLabelValues = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickLabelVisibilities = new ArrayList();
        this.setFont(this.scale.getFont());
        this.setForegroundColor(this.scale.getForegroundColor());
    }

    public void setLabelData(AxisDataSet labelData) {
        this.labelData = labelData;
    }

    public AxisDataSet getLabelData() {
        return this.labelData;
    }

    public int getGridStepInPixel() {
        return this.gridStepInPixel;
    }

    public int getTickLabelMaxHeight() {
        return this.tickLabelMaxHeight;
    }

    public int getTickLabelMaxLength() {
        return this.tickLabelMaxLength;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        return this.tickLabelVisibilities;
    }

    public int getTickLabelAngle() {
        return this.tickLabelAngle;
    }

    public void setTickLabelAngle(int tickLabelAngle) {
        if (tickLabelAngle < 0 || 90 < tickLabelAngle) {
            SWT.error((int)5);
        }
        if (this.tickLabelAngle != tickLabelAngle) {
            this.tickLabelAngle = tickLabelAngle;
            this.scale.layout();
        }
    }

    private void drawXTick(Graphics grahics) {
        grahics.setFont(this.scale.getFont());
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickLabelVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                Dimension textDim = FigureUtilities.getTextExtents((String)text, (Font)this.scale.getFont());
                int textWidth = textDim.width;
                int textHeight = textDim.height;
                if (this.tickLabelAngle == 0) {
                    int x = (int)Math.ceil((double)this.tickLabelPositions.get(i).intValue() - (double)textWidth / 2.0);
                    grahics.drawText(text, x, 0);
                } else {
                    float y;
                    float x;
                    if (this.scale.isOnPrimarySide()) {
                        x = (float)((double)(this.bounds.x + this.tickLabelPositions.get(i)) - (double)textWidth * Math.cos(Math.toRadians(this.tickLabelAngle)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(this.tickLabelAngle)));
                        y = (float)((double)this.bounds.y + (double)textWidth * Math.sin(Math.toRadians(this.tickLabelAngle)));
                    } else {
                        x = (float)((double)(this.bounds.x + this.tickLabelPositions.get(i)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(this.tickLabelAngle)));
                        y = (float)((double)this.bounds.y + (double)this.bounds.height * Math.sin(Math.toRadians(this.tickLabelAngle)));
                    }
                    grahics.translate(x, y);
                    grahics.rotate((float)(360 - this.tickLabelAngle));
                    grahics.drawText(text, 0, 0);
                    grahics.restoreState();
                }
            }
            ++i;
        }
    }

    private void drawYTick(Graphics grahpics) {
        grahpics.setFont(this.scale.getFont());
        int fontHeight = this.tickLabelMaxHeight;
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickLabelVisibilities.isEmpty() || this.tickLabels.isEmpty()) break;
            if (this.tickLabelVisibilities.get(i).booleanValue()) {
                String label = this.tickLabels.get(i);
                int x = 0;
                if (this.tickLabels.get(0).startsWith(MINUS) && !label.startsWith(MINUS)) {
                    x += FigureUtilities.getTextExtents((String)MINUS, (Font)this.getFont()).width;
                }
                int y = (int)Math.ceil((double)(this.scale.getLength() - this.tickLabelPositions.get(i)) - (double)fontHeight / 2.0);
                grahpics.drawText(label, x, y);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double getGridStep(int lengthInPixels, double min, double max) {
        block25: {
            if ((int)this.scale.getMajorGridStep() != 0) {
                return this.scale.getMajorGridStep();
            }
            if (lengthInPixels <= 0) {
                lengthInPixels = 1;
            }
            minBigger = false;
            if (min >= max) {
                if (max == min) {
                    max += 1.0;
                } else {
                    minBigger = true;
                    swap = min;
                    min = max;
                    max = swap;
                }
            }
            length = Math.abs(max - min);
            majorTickMarkStepHint = this.scale.getMajorTickMarkStepHint();
            if (majorTickMarkStepHint > (double)lengthInPixels) {
                majorTickMarkStepHint = lengthInPixels;
            }
            gridStepHint = length / (double)lengthInPixels * majorTickMarkStepHint;
            if (this.scale.isDateEnabled()) {
                timeStep = max - min < 1000.0 ? 10L : (max - min < 60000.0 ? 1000L : (max - min < 600000.0 ? 10000L : (max - min < 6400000.0 ? 60000L : (max - min < 4.32E7 ? 600000L : (max - min < 8.64E7 ? 1800000L : (max - min < 6.048E8 ? 3600000L : 86400000L))))));
                if (this.scale.getTimeUnit() == 13) {
                    timeStep = 1000L;
                } else if (this.scale.getTimeUnit() == 12) {
                    timeStep = 60000L;
                } else if (this.scale.getTimeUnit() == 11) {
                    timeStep = 3600000L;
                } else if (this.scale.getTimeUnit() == 5) {
                    timeStep = 86400000L;
                } else if (this.scale.getTimeUnit() == 2) {
                    timeStep = 2592000000L;
                } else if (this.scale.getTimeUnit() == 1) {
                    timeStep = 31536000000L;
                }
                temp = gridStepHint + ((double)timeStep - gridStepHint % (double)timeStep);
                if (minBigger) {
                    temp = -temp;
                }
                return temp;
            }
            mantissa = gridStepHint;
            exp = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl53
            if (mantissa == 0.0) break block25;
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exp;
            }
            break block25;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exp;
lbl53:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? 10.0 * Math.pow(10.0, exp) : (mantissa > 3.5 ? 5.0 * Math.pow(10.0, exp) : (mantissa > 1.5 ? 2.0 * Math.pow(10.0, exp) : Math.pow(10.0, exp)));
        if (minBigger) {
            gridStep = -gridStep;
        }
        return gridStep;
    }

    private boolean hasSpaceToDraw(int previousPosition, int tickLabelPosition, String previousTickLabel, String tickLabel) {
        Dimension tickLabelSize = FigureUtilities.getTextExtents((String)tickLabel, (Font)this.scale.getFont());
        Dimension previousTickLabelSize = FigureUtilities.getTextExtents((String)previousTickLabel, (Font)this.scale.getFont());
        int interval = tickLabelPosition - previousPosition;
        int textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)previousTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
        boolean noLapOnPrevoius = true;
        boolean noLapOnEnd = true;
        if (tickLabelPosition != this.tickLabelPositions.get(this.tickLabelPositions.size() - 1)) {
            noLapOnPrevoius = interval > textLength + 2;
            Dimension endTickLabelSize = FigureUtilities.getTextExtents((String)this.tickLabels.get(this.tickLabels.size() - 1), (Font)this.scale.getFont());
            interval = this.tickLabelPositions.get(this.tickLabelPositions.size() - 1) - tickLabelPosition;
            textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)endTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
            boolean bl = noLapOnEnd = interval > textLength + 2;
        }
        return noLapOnPrevoius && noLapOnEnd;
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.scale.isLogScaleEnabled()) {
            return true;
        }
        double log10 = Math.log10(tickValue);
        return log10 == Math.rint(log10);
    }

    private void updateTickLabelForLinearScale(int length) {
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        double gridStep = this.getGridStep(length, min, max);
        this.gridStepInPixel = (int)((double)length * gridStep / (max - min));
        this.updateTickLabelForLinearScale(length, gridStep);
    }

    private void updateTickLabelForLinearScale(int length, double tickStep) {
        double zeroOclock;
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        boolean minBigger = max < min;
        double firstPosition = min % tickStep <= 0.0 ? min - min % tickStep : min - min % tickStep + tickStep;
        if (this.scale.isDateEnabled() && min < (zeroOclock = firstPosition - 3600000.0)) {
            firstPosition = zeroOclock;
        }
        boolean minDateAdded = false;
        if (min > firstPosition == minBigger) {
            this.tickLabelValues.add(min);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)min);
                this.tickLabels.add(this.scale.format(date, true));
                minDateAdded = true;
            } else {
                this.tickLabels.add(this.labelData.getLabel(min));
            }
            this.tickLabelPositions.add(this.scale.getMargin() + this.gridStepInPixel / 2);
        }
        int i = 1;
        double b = firstPosition;
        while (!(max >= min ? !(b < max) : !(b > max))) {
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)b);
                this.tickLabels.add(this.scale.format(date, b == firstPosition && !minDateAdded));
            } else {
                this.tickLabels.add(this.labelData.getLabel(b));
            }
            this.tickLabelValues.add(b);
            int tickLabelPosition = (int)((b - min) / (max - min) * (double)length) + this.scale.getMargin() + this.gridStepInPixel / 2;
            this.tickLabelPositions.add(tickLabelPosition);
            b = firstPosition + (double)i++ * tickStep;
        }
        this.tickLabelValues.add(max);
        if (this.scale.isDateEnabled()) {
            Date date = new Date((long)max);
            this.tickLabels.add(this.scale.format(date, true));
        } else {
            this.tickLabels.add(this.labelData.getLabel(max));
        }
        this.tickLabelPositions.add(this.scale.getMargin() + length + this.gridStepInPixel / 2);
    }

    private void updateTickLabelMaxLengthAndHeight() {
        int maxLength = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickLabelVisibilities.size() > i && this.tickLabelVisibilities.get(i).booleanValue()) {
                Dimension p = FigureUtilities.getTextExtents((String)this.tickLabels.get(i), (Font)this.scale.getFont());
                if (this.tickLabels.get(0).startsWith(MINUS) && !this.tickLabels.get(i).startsWith(MINUS)) {
                    p.width += FigureUtilities.getTextExtents((String)MINUS, (Font)this.getFont()).width;
                }
                if (p.width > maxLength) {
                    maxLength = p.width;
                }
                if (p.height > maxHeight) {
                    maxHeight = p.height;
                }
            }
            ++i;
        }
        this.tickLabelMaxLength = maxLength;
        this.tickLabelMaxHeight = maxHeight;
    }

    private void updateTickVisibility() {
        this.tickLabelVisibilities.clear();
        if (this.tickLabelPositions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickLabelVisibilities.add(Boolean.TRUE);
            ++i;
        }
        int previousPosition = 0;
        String previousLabel = null;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            boolean hasSpaceToDraw = true;
            String currentLabel = this.tickLabels.get(i2);
            int currentPosition = this.tickLabelPositions.get(i2);
            if (i2 != 0) {
                hasSpaceToDraw = this.hasSpaceToDraw(previousPosition, currentPosition, previousLabel, currentLabel);
            }
            boolean isRepeatSameTickAndNotEnd = currentLabel.equals(previousLabel) && i2 != 0 && i2 != this.tickLabelPositions.size() - 1;
            boolean isMajorTickOrEnd = true;
            if (this.scale.isLogScaleEnabled()) {
                boolean bl = isMajorTickOrEnd = this.isMajorTick(this.tickLabelValues.get(i2)) || i2 == 0 || i2 == this.tickLabelPositions.size() - 1;
            }
            if (!hasSpaceToDraw || isRepeatSameTickAndNotEnd || !isMajorTickOrEnd) {
                this.tickLabelVisibilities.set(i2, Boolean.FALSE);
            } else {
                previousPosition = currentPosition;
                previousLabel = currentLabel;
            }
            ++i2;
        }
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        if (this.scale.isHorizontal()) {
            this.drawXTick(graphics);
        } else {
            this.drawYTick(graphics);
        }
        super.paintClientArea(graphics);
    }

    protected void update(int length) {
        this.tickLabels.clear();
        this.tickLabelValues.clear();
        this.tickLabelPositions.clear();
        this.updateTickLabelForLinearScale(length);
        this.updateTickVisibility();
        this.updateTickLabelMaxLengthAndHeight();
    }
}

