/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.qrtpcr.dialogs.PlateLayoutDialog;
import org.grits.toolbox.entry.qrtpcr.dialogs.PlateLayoutToolInfoPage;
import org.grits.toolbox.entry.qrtpcr.model.Plate;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class PlateLayoutToolWizard
extends Wizard {
    private static Logger logger = Logger.getLogger(PlateLayoutToolWizard.class);
    private PlateLayoutToolInfoPage page;
    PlateLayout layout;
    boolean existing = false;

    public PlateLayoutToolWizard(PlateLayout layout) {
        this.layout = layout;
    }

    public PlateLayoutToolWizard() {
    }

    public String getWindowTitle() {
        return "Plate Layout Tool";
    }

    public PlateLayout getLayout() {
        return this.layout;
    }

    public void addPages() {
        if (this.layout != null) {
            this.existing = true;
            this.page = new PlateLayoutToolInfoPage("info page", this.layout);
            this.addPage((IWizardPage)this.page);
            if (this.layout.getPlates() != null) {
                int i = 1;
                for (Plate plate : this.layout.getPlates()) {
                    PlateLayoutDialog platePage = new PlateLayoutDialog("Plate Page " + i, plate.getPlateId(), null);
                    platePage.setLayout(this.layout);
                    platePage.setPlate(plate);
                    this.addPage((IWizardPage)platePage);
                    ++i;
                }
            } else {
                this.setForcePreviousAndNextButtons(true);
            }
        } else {
            this.setForcePreviousAndNextButtons(true);
            this.page = new PlateLayoutToolInfoPage("info page");
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean performFinish() {
        this.layout = this.page.getLayout();
        if (!this.existing) {
            String name = this.layout.getName();
            if (FileUtils.getAllPlateLayoutNames().contains(name)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Duplicate", (String)"A plate layout with this name already exists. Please choose a different one");
                logger.warn((Object)"A plate layout with this name already exists. Please choose a different one");
                return false;
            }
        }
        IWizardPage[] pages = this.getPages();
        ArrayList<Plate> plates = new ArrayList<Plate>();
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage iWizardPage = iWizardPageArray[n2];
            if (iWizardPage instanceof PlateLayoutDialog) {
                Plate plate = ((PlateLayoutDialog)iWizardPage).convertInputDataIntoPlate();
                plates.add(plate);
            }
            ++n2;
        }
        this.layout.setPlates(plates);
        try {
            FileUtils.savePlateLayoutFile(this.layout);
        }
        catch (IOException | JAXBException e) {
            logger.error((Object)"Error saving plate layout", e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Save", (String)("Error saving plate layout. Reason: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        boolean finish = true;
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage iWizardPage = iWizardPageArray[n2];
            finish &= iWizardPage.isPageComplete();
            ++n2;
        }
        return finish;
    }

    public XSSFWorkbook createWorkbookFromTable() {
        IWizardPage[] pages;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.getIndex());
        headerStyle.setFillPattern((short)1);
        headerStyle.setBorderTop((short)1);
        headerStyle.setBorderBottom((short)1);
        headerStyle.setBorderLeft((short)1);
        headerStyle.setBorderRight((short)1);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage iWizardPage = iWizardPageArray[n2];
            if (iWizardPage instanceof PlateLayoutDialog) {
                GridTableViewer tableViewer = ((PlateLayoutDialog)iWizardPage).getTableViewer();
                XSSFSheet sheet = wb.createSheet(iWizardPage.getTitle());
                if (tableViewer != null) {
                    GridItem[] items;
                    Grid table = tableViewer.getGrid();
                    GridColumn[] columns = table.getColumns();
                    int rowIndex = 0;
                    int cellIndex = 1;
                    XSSFRow header = sheet.createRow((int)((short)rowIndex++));
                    XSSFCell cell = header.createCell(0);
                    cell.setCellValue("");
                    GridColumn[] gridColumnArray = columns;
                    int n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GridColumn column = gridColumnArray[n4];
                        cell = header.createCell(cellIndex++);
                        cell.setCellValue(column.getText());
                        cell.setCellStyle((CellStyle)headerStyle);
                        ++n4;
                    }
                    Character letter = Character.valueOf('A');
                    GridItem[] gridItemArray = items = tableViewer.getGrid().getItems();
                    int n5 = items.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        GridItem item = gridItemArray[n6];
                        XSSFRow row = sheet.createRow((int)((short)rowIndex++));
                        cellIndex = 0;
                        cell = row.createCell(cellIndex++);
                        cell.setCellValue(String.valueOf(letter));
                        cell.setCellStyle((CellStyle)headerStyle);
                        letter = Character.valueOf((char)(letter.charValue() + '\u0001'));
                        int i = 0;
                        while (i < columns.length) {
                            cell = row.createCell(cellIndex++);
                            cell.setCellStyle((CellStyle)cellStyle);
                            String text = item.getText(i);
                            cell.setCellValue(text);
                            ++i;
                        }
                        ++n6;
                    }
                    int i = 0;
                    while (i < columns.length) {
                        sheet.autoSizeColumn((int)((short)i));
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return wb;
    }
}

