/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;

public class MasterTableBase {
    Double lowerThreshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;
    List<Gene> geneList;
    private QrtPCRTableEditor editor;

    public MasterTableBase(QrtPCRTableEditor editor) {
        this.editor = editor;
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    public void setGeneList(List<Gene> geneList) {
        this.geneList = geneList;
    }

    public Control createControl(Composite parent) {
        ArrayList<List<GRITSColumnHeader>> columnList = new ArrayList<List<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> firstLevelColumns = new ArrayList<GRITSColumnHeader>();
        this.addColumns(firstLevelColumns);
        columnList.add(firstLevelColumns);
        ArrayList<TableData> allData = new ArrayList<TableData>();
        for (Gene gene : this.geneList) {
            if (gene.getIsCommon().booleanValue() || gene.getIsControl().booleanValue()) continue;
            allData.add(gene);
        }
        QrtPCRNatTable natTable = new QrtPCRNatTable(parent, this.editor, columnList);
        natTable.setMasterTable(true);
        natTable.setTableData(allData);
        natTable.setLowerThreshold(this.lowerThreshold);
        natTable.setStDevCutOff(this.stDevCutOff);
        natTable.setRawData(false);
        natTable.initializeComponents();
        return natTable;
    }

    private void addColumns(List<GRITSColumnHeader> columnList) {
        GRITSColumnHeader header = new GRITSColumnHeader("Gene Identifier", "Gene Identifier");
        columnList.add(header);
        header = new GRITSColumnHeader("Gene Symbol", "Gene Symbol");
        columnList.add(header);
        header = new GRITSColumnHeader("Average", "Average");
        columnList.add(header);
        header = new GRITSColumnHeader("St Dev - Adjusted", "St Dev - Adjusted");
        columnList.add(header);
    }
}

