/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.view.GeneView;
import org.grits.toolbox.entry.qrtpcr.table.CellPopupMenuAction;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerNatTable;

public class ChangeMenuConfiguration
extends AbstractUiBindingConfiguration {
    private Menu bodyMenu;
    private GeneListManagerEditor editor;
    GeneList data;
    protected DataLayer bodyLayer;

    public ChangeMenuConfiguration(GeneListManagerEditor editor, GeneList data, NatTable natTable, DataLayer bodyLayer) {
        this.editor = editor;
        this.data = data;
        this.bodyLayer = bodyLayer;
        this.bodyMenu = this.createBodyMenu(natTable).build();
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChangeMenuConfiguration.this.bodyMenu.dispose();
            }
        });
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        MouseEventMatcher matcher = new MouseEventMatcher(0, "BODY", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                if (super.matches(natTable, event, regionLabels)) {
                    int columnPosition = natTable.getColumnPositionByX(event.x);
                    if (natTable instanceof ManagerNatTable) {
                        int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)ChangeMenuConfiguration.this.bodyLayer);
                        String column = ((ManagerNatTable)natTable).getColumnPropertyAccessor().getColumnProperty(columnIndex);
                        int rowPosition = natTable.getRowPositionByY(event.y);
                        int bodyRowPos = LayerUtil.convertRowPosition((ILayer)natTable, (int)rowPosition, (IUniqueIndexLayer)ChangeMenuConfiguration.this.bodyLayer);
                        TableData tableData = (TableData)((ListDataProvider)ChangeMenuConfiguration.this.bodyLayer.getDataProvider()).getRowObject(bodyRowPos);
                        if (tableData instanceof GeneView && ((GeneView)tableData).isUpdated() && (column.equals("Name") && ((GeneView)tableData).getUpdatedFields().contains("Name") || column.equals("Aliases") && ((GeneView)tableData).getUpdatedFields().contains("Aliases") || column.equals("Genomic Location") && ((GeneView)tableData).getUpdatedFields().contains("Genomic Location") || column.equals("RefSeq") && ((GeneView)tableData).getUpdatedFields().contains("RefSeq") || column.equals("Gene Symbol") && ((GeneView)tableData).getUpdatedFields().contains("Gene Symbol") || column.equals("Protein RefSeq") && ((GeneView)tableData).getUpdatedFields().contains("Protein RefSeq"))) {
                            ChangeMenuConfiguration.this.bodyMenu.getItems()[0].setData((Object)tableData);
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)matcher, (IMouseAction)new CellPopupMenuAction(this.bodyMenu));
    }

    private PopupMenuBuilder createBodyMenu(final NatTable natTable) {
        final Menu menu = new Menu((Control)natTable);
        final MenuItem item1 = new MenuItem(menu, 8);
        item1.setText("Accept Change");
        item1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneView geneView = (GeneView)item1.getData();
                Integer columnPosition = (Integer)menu.getData("columnIndex");
                int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)ChangeMenuConfiguration.this.bodyLayer);
                String column = ((ManagerNatTable)natTable).getColumnPropertyAccessor().getColumnProperty(columnIndex);
                geneView.removeUpdatedField(column);
                List dataFromTable = ((ManagerNatTable)natTable).getTreeList().subList(0, ((ManagerNatTable)natTable).getTreeList().size());
                ArrayList<Gene> geneList = new ArrayList<Gene>();
                for (TableData td : dataFromTable) {
                    geneList.add((Gene)td);
                }
                ListIterator<GeneView> listIterator = geneList.listIterator();
                while (listIterator.hasNext()) {
                    Gene gene2 = (Gene)listIterator.next();
                    if (!gene2.getGeneIdentifier().equals(geneView.getGeneIdentifier())) continue;
                    listIterator.set(geneView);
                    ChangeMenuConfiguration.this.updateInGeneList(geneView);
                    break;
                }
                ChangeMenuConfiguration.this.editor.refreshGeneListPage(geneList);
                ChangeMenuConfiguration.this.editor.markDirty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem item2 = new MenuItem(menu, 8);
        item2.setText("Reject Change");
        item2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneView geneView = (GeneView)item1.getData();
                Integer columnPosition = (Integer)menu.getData("columnIndex");
                int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)ChangeMenuConfiguration.this.bodyLayer);
                String column = ((ManagerNatTable)natTable).getColumnPropertyAccessor().getColumnProperty(columnIndex);
                geneView.removeUpdatedField(column);
                Gene original = ChangeMenuConfiguration.this.findInGeneList(geneView);
                if (original == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Cannot revert back to the original.");
                    return;
                }
                switch (column) {
                    case "Name": {
                        geneView.setFullName(original.getFullName());
                        break;
                    }
                    case "Aliases": {
                        geneView.setAliases(original.getAliases());
                        break;
                    }
                    case "Genomic Location": {
                        geneView.setLocations(original.getLocations());
                        break;
                    }
                    case "Gene Symbol": {
                        geneView.setGeneSymbol(original.getGeneSymbol());
                        break;
                    }
                    case "RefSeq": {
                        geneView.setRefSeq(original.getRefSeq());
                        break;
                    }
                    case "Protein RefSeq": {
                        geneView.setSecondaryRefSeq(original.getSecondaryRefSeq());
                    }
                }
                List dataFromTable = ((ManagerNatTable)natTable).getTreeList().subList(0, ((ManagerNatTable)natTable).getTreeList().size());
                ArrayList<Gene> geneList = new ArrayList<Gene>();
                for (TableData td : dataFromTable) {
                    geneList.add((Gene)td);
                }
                ListIterator<GeneView> listIterator = geneList.listIterator();
                while (listIterator.hasNext()) {
                    Gene gene2 = (Gene)listIterator.next();
                    if (!gene2.getGeneIdentifier().equals(geneView.getGeneIdentifier())) continue;
                    listIterator.set(geneView);
                    break;
                }
                ChangeMenuConfiguration.this.editor.refreshGeneListPage(geneList);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem item3 = new MenuItem(menu, 8);
        item3.setText("Accept All Changes");
        item3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (natTable instanceof ManagerNatTable) {
                    TreeList<TableData> treeList = ((ManagerNatTable)natTable).getTreeList();
                    ArrayList<Gene> geneList = new ArrayList<Gene>();
                    for (TableData tableData : treeList) {
                        geneList.add((Gene)tableData);
                        if (!(tableData instanceof GeneView)) continue;
                        GeneView geneView = (GeneView)tableData;
                        geneView.setUpdated(false);
                    }
                    ChangeMenuConfiguration.this.data.setGenes(geneList);
                    ChangeMenuConfiguration.this.editor.refreshGeneListPage(geneList);
                    ChangeMenuConfiguration.this.editor.markDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new PopupMenuBuilder(natTable, menu);
    }

    private void updateInGeneList(GeneView geneView) {
        if (this.data != null) {
            ListIterator<Gene> listIterator = this.data.getGenes().listIterator();
            while (listIterator.hasNext()) {
                Gene gene2 = listIterator.next();
                if (!gene2.getGeneIdentifier().equals(geneView.getGeneIdentifier())) continue;
                listIterator.set(geneView);
                break;
            }
        }
    }

    Gene findInGeneList(Gene gene) {
        if (this.data != null) {
            for (Gene g : this.data.getGenes()) {
                if (!g.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
                return g;
            }
        }
        return null;
    }
}

