/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.property;

import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;

public class MSAnnotationEntityProperty
extends MassSpecEntityProperty {
    public static final String TYPE = MSAnnotationEntityProperty.class.getName();
    protected Integer annotationId = null;
    protected String featureId = null;
    protected String parentFeatureId = null;
    private MSAnnotationProperty parentProperty = null;

    public MSAnnotationEntityProperty(MassSpecProperty msParentProperty, MSAnnotationProperty annotParentProperty) {
        super(msParentProperty);
        this.parentProperty = annotParentProperty;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MSAnnotationEntityProperty)) {
            return false;
        }
        MSAnnotationEntityProperty castObj = (MSAnnotationEntityProperty)((Object)obj);
        boolean bRes = this.getAnnotationId() != null && this.getAnnotationId().equals(castObj.getAnnotationId());
        bRes &= this.getFeatureId() != null && this.getFeatureId().equals(castObj.getFeatureId());
        return (bRes &= this.getParentFeatureId() != null && this.getParentFeatureId().equals(castObj.getParentFeatureId())) && super.equals((Object)castObj);
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    public MSAnnotationProperty getMSAnnotationParentProperty() {
        return this.parentProperty;
    }

    public void setMSAnnotationParentProperty(MSAnnotationProperty parentProperty) {
        this.parentProperty = parentProperty;
    }

    public String getParentFeatureId() {
        return this.parentFeatureId;
    }

    public void setParentFeatureId(String parentFeatureId) {
        this.parentFeatureId = parentFeatureId;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public Integer getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(Integer annotationId) {
        this.annotationId = annotationId;
    }

    public static Entry getTableCompatibleEntry(Entry parentEntry) {
        Entry newEntry = MassSpecEntityProperty.getTableCompatibleEntry((Entry)parentEntry);
        Entry msAnnotEntry = MSAnnotationProperty.getFirstAnnotEntry(parentEntry);
        MSAnnotationProperty msAnnotProp = null;
        MSAnnotationEntityProperty msAnnotEntityProp = null;
        if (msAnnotEntry != null) {
            msAnnotProp = (MSAnnotationProperty)msAnnotEntry.getProperty();
            MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
            msAnnotEntityProp = new MSAnnotationEntityProperty(msEntityProp.getMassSpecParentProperty(), msAnnotProp);
            newEntry.setProperty((Property)msAnnotEntityProp);
            newEntry.setDisplayName(parentEntry.getDisplayName());
        }
        return newEntry;
    }

    public Object clone() {
        MSAnnotationEntityProperty newProp = new MSAnnotationEntityProperty(this.getMassSpecParentProperty(), this.getMSAnnotationParentProperty());
        newProp.setDescription(this.getDescription());
        newProp.setId(this.getId());
        newProp.setAnnotationId(this.getAnnotationId());
        newProp.setScanNum(this.getScanNum());
        newProp.setMsLevel(this.getMsLevel());
        newProp.setParentScanNum(this.getParentScanNum());
        newProp.setFeatureId(this.getFeatureId());
        newProp.setParentFeatureId(this.parentFeatureId);
        return newProp;
    }

    public String getType() {
        return TYPE;
    }

    public MassSpecUISettings getMassSpecUISettings() {
        return this.getMSAnnotationParentProperty().getMSAnnotationMetaData();
    }
}

