/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.ms.annotation.gelato.GlycanMatcher;
import org.grits.toolbox.ms.annotation.structure.GelatoGlycan;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerException;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerJarFile;
import org.grits.toolbox.ms.annotation.sugar.GlycanExtraInfo;
import org.grits.toolbox.ms.file.FileReaderUtils;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.ReducingEnd;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterOperator;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.INotifyingProcess;
import org.grits.toolbox.widgets.tools.NotifyingProcessUtil;

public abstract class GlycanStructureAnnotation
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotation.class);
    protected Method method = null;
    protected DataHeader dataHeader = null;
    protected List<List<GlycanStructure>> structures = null;
    protected Data data;
    protected GlycanScansAnnotation glycanScanAnnotations = null;
    protected AnnotationWriter writer = new AnnotationWriter();
    protected List<String> glycanIds = new ArrayList<String>();
    public static final CustomExtraData countingScoreData = new CustomExtraData("counting_score", "Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.00");
    public static final CustomExtraData intensityScoreData = new CustomExtraData("intensity_score", "Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.00");
    public static final CustomExtraData rawCountingScoreData = new CustomExtraData("raw_counting_score", "Raw Counting Score", "Generic Method", CustomExtraData.Type.Double, "0.0000");
    public static final CustomExtraData rawIntensityScoreData = new CustomExtraData("raw_intensity_score", "Raw Intensity Score", "Second Method", CustomExtraData.Type.Double, "0.0000");
    public static final HashMap<String, GelatoGlycan> hmGelatoGlycansByStructureId = new HashMap();
    public static final HashMap<String, GlycanAnnotation> hmCachedExtraSettings = new HashMap();
    protected String m_tempFilePath = null;
    protected String m_preArchive = null;
    protected String m_finalArchive = null;
    protected List<Integer> scansToProcess;
    protected int iTotalSize;
    protected MSFile msFile;
    public static int iAnnotationIDCount;
    protected int iCurProgressValue;
    protected String sCurProgressMsg = null;
    protected int iCurScanNum;
    List<List<IonSettings>> lPosModeSettingsToAnalyze = null;
    List<List<Integer>> lPosModeSettingsToAnalyzeCounts = null;
    List<List<IonSettings>> lNegModeSettingsToAnalyze = null;
    List<List<Integer>> lNegModeSettingsToAnalyzeCounts = null;
    List<List<IonSettings>> lExchangesoAnalyze = null;
    List<List<Integer>> lExchangesToAnalyzeCounts = null;
    List<List<MoleculeSettings>> lNeutralLossesToAnalyze = null;
    List<List<Integer>> lNeutralLossesToAnalyzeCounts = null;
    protected List<IProgressListener> myProgressListeners = null;
    protected List<IProgressListener> matcherProgressListeners = null;
    protected CancelableThread cpCurrentProcess;
    protected boolean bCancel = false;
    private GlycanMatcher curGlycanMatcher = null;

    protected abstract HashMap<Integer, Scan> getScans(MSFile var1, int var2, double var3, String var5, double var6, String var8);

    public abstract List<Integer> determineScanBounds();

    public abstract String getFinalArchiveName();

    public abstract boolean needsOverview();

    public abstract String getOverviewFileName();

    protected abstract GlycanMatcher getNewGlycanMatcher();

    protected abstract void cleanAfterCancel();

    protected abstract void setArchiveFilePaths();

    public GlycanStructureAnnotation(Data data, String path, String archiveName, MSFile msFile) {
        BuilderWorkspace bw = new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        this.data = data;
        this.dataHeader = data.getDataHeader();
        this.method = this.dataHeader.getMethod();
        this.m_tempFilePath = path;
        this.m_preArchive = archiveName;
        this.addFeatureCustomExtraData();
        this.addAnnotationCustomExtraData();
        this.iTotalSize = -1;
        iAnnotationIDCount = 1;
        this.msFile = msFile;
    }

    protected void initializeStructures() {
        List<GlycanStructure> settingStructures1;
        int i;
        this.structures = new ArrayList<List<GlycanStructure>>();
        for (AnalyteSettings settings : this.method.getAnalyteSettings()) {
            List<GlycanStructure> settingStructures = GlycanStructureAnnotation.getGlycanStructures(settings.getGlycanSettings().getFilter());
            if (this.structures == null) continue;
            this.structures.add(settingStructures);
        }
        for (i = 0; i < this.method.getAnalyteSettings().size(); ++i) {
            settingStructures1 = this.structures.get(i);
            HashMap<String, Boolean> mMatched = new HashMap<String, Boolean>();
            for (int iStruc1 = 0; iStruc1 < settingStructures1.size(); ++iStruc1) {
                GlycanStructure struc1 = settingStructures1.get(iStruc1);
                if (mMatched.containsKey(struc1.getId())) continue;
                int iMatchCnt = 0;
                for (int iStruc2 = iStruc1 + 1; iStruc2 < settingStructures1.size(); ++iStruc2) {
                    GlycanStructure struc2 = settingStructures1.get(iStruc2);
                    if (!struc1.getId().equals(struc2.getId())) continue;
                    String sNewId = struc2.getId() + "." + (++iMatchCnt + 1);
                    struc2.setId(sNewId);
                    mMatched.put(sNewId, Boolean.TRUE);
                }
                if (iMatchCnt <= 0) continue;
                logger.warn((Object)("Duplicate id in database: " + struc1.getId()));
                String sNewId = struc1.getId() + ".1";
                struc1.setId(sNewId);
                mMatched.put(sNewId, Boolean.TRUE);
            }
        }
        for (i = 0; i < this.method.getAnalyteSettings().size(); ++i) {
            settingStructures1 = this.structures.get(i);
            for (GlycanStructure struc1 : settingStructures1) {
                block6: for (int j = i + 1; j < this.method.getAnalyteSettings().size(); ++j) {
                    List<GlycanStructure> settingStructures2 = this.structures.get(j);
                    for (GlycanStructure struc2 : settingStructures2) {
                        if (!struc1.getId().equals(struc2.getId())) continue;
                        if (!struc1.getId().startsWith("(DB")) {
                            struc1.setId("(DB" + (i + 1) + ") " + struc1.getId());
                        }
                        if (struc2.getId().startsWith("(DB")) continue block6;
                        struc2.setId("(DB" + (j + 1) + ") " + struc2.getId());
                        continue block6;
                    }
                }
            }
        }
    }

    private static List<GlycanStructure> getGlycanStructures(GlycanFilter gf) {
        List<GlycanStructure> structures = null;
        try {
            StructureHandlerJarFile fj = new StructureHandlerJarFile();
            structures = fj.getStructures(gf);
        }
        catch (StructureHandlerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return structures;
    }

    public static int getNumListenersNeeded() {
        return 1;
    }

    public void setMatcherProgressListener(List<IProgressListener> matcherProgressListeners) {
        this.matcherProgressListeners = matcherProgressListeners;
    }

    public List<IProgressListener> getMatcherProgressListener() {
        return this.matcherProgressListeners;
    }

    public int getTotal() {
        return this.iTotalSize;
    }

    public static void determineIonSettingSets(Boolean bIsPositive, Object lSettingsToConsider, int iMaxTotalCount, Object lSettingsToAnalyze, List<List<Integer>> lSettingsToAnalyzeCounts) {
        try {
            if (lSettingsToConsider == null || ((List)lSettingsToConsider).isEmpty()) {
                return;
            }
            boolean bDone = false;
            int iStartLevel = 0;
            int[] iCurChargeCnts = new int[((List)lSettingsToConsider).size()];
            ArrayList<String> sProcessed = new ArrayList<String>();
            while (!bDone) {
                ArrayList<Molecule> lCurSet = new ArrayList<Molecule>();
                ArrayList<Integer> lCurCounts = new ArrayList<Integer>();
                int iTotalCount = 0;
                int iLevelCnt = 0;
                String sCombo = "";
                for (iLevelCnt = 0; iLevelCnt <= iStartLevel; ++iLevelCnt) {
                    Molecule curSetting = (Molecule)((List)lSettingsToConsider).get(iLevelCnt);
                    int iCurCount = iCurChargeCnts[iLevelCnt] + 1;
                    if (curSetting instanceof IonSettings) {
                        if (bIsPositive != null && (((IonSettings)curSetting).getPolarity().booleanValue() && !bIsPositive.booleanValue() || !((IonSettings)curSetting).getPolarity().booleanValue() && bIsPositive.booleanValue())) continue;
                        iCurCount *= ((IonSettings)curSetting).getCharge().intValue();
                    }
                    if (iMaxTotalCount >= 0 && iTotalCount + iCurCount > iMaxTotalCount) continue;
                    iTotalCount += iCurCount;
                    sCombo = sCombo + "[" + iLevelCnt + ", " + iCurCount + "+]";
                    lCurSet.add(curSetting);
                    lCurCounts.add(iCurChargeCnts[iLevelCnt] + 1);
                }
                if (!(iMaxTotalCount >= 0 && iTotalCount > iMaxTotalCount || sProcessed.contains(sCombo))) {
                    ((List)lSettingsToAnalyze).add(lCurSet);
                    lSettingsToAnalyzeCounts.add(lCurCounts);
                    sProcessed.add(sCombo);
                }
                if (++iStartLevel == iCurChargeCnts.length) {
                    for (int j = iCurChargeCnts.length - 1; j >= 0 && iStartLevel == iCurChargeCnts.length; --j) {
                        Molecule curSetting = (Molecule)((List)lSettingsToConsider).get(j);
                        int iCurCnt = iCurChargeCnts[j] + 1;
                        int iMaxCnt = -1;
                        iMaxCnt = curSetting instanceof IonSettings ? ((Integer)((IonSettings)curSetting).getCounts().get(0)).intValue() : ((MoleculeSettings)curSetting).getCount().intValue();
                        if (iCurCnt < iMaxCnt) {
                            int n = j;
                            iCurChargeCnts[n] = iCurChargeCnts[n] + 1;
                            iStartLevel = j;
                            continue;
                        }
                        iCurChargeCnts[j] = 0;
                    }
                }
                bDone = iStartLevel == iCurChargeCnts.length;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in determineIonSettingSets", (Throwable)e);
        }
    }

    protected void addAnnotation(GlycanAnnotation annotation) {
        this.data.getAnnotation().add(annotation);
    }

    public void initialize() {
        this.setProgressType(IProgressListener.ProgressType.Indeterminant);
        this.scansToProcess = this.determineScanBounds();
        this.setArchiveFilePaths();
        this.iTotalSize = 0;
        int iNumScans = this.scansToProcess.size();
        this.initializeStructures();
        for (int i = 0; i < this.structures.size(); ++i) {
            List<GlycanStructure> settingStructures = this.structures.get(i);
            this.iTotalSize += iNumScans * settingStructures.size();
        }
        ScanFeatures.usesComplexRowID = true;
        this.setProgressType(IProgressListener.ProgressType.Determinant);
    }

    public int processScans() {
        try {
            boolean bRes = true;
            this.setMaxValue(this.getTotal());
            this.iCurProgressValue = 0;
            this.updateListeners("Processing", 0);
            for (int iInx = 0; iInx < this.scansToProcess.size(); ++iInx) {
                this.sCurProgressMsg = "Scan # " + this.scansToProcess.get(iInx);
                if (this.isCanceled()) {
                    return GRITSProcessStatus.CANCEL;
                }
                bRes = this.processScan(this.method, iInx);
            }
            this.updateListeners("Done!", this.getTotal());
            if (!bRes) {
                if (this.isCanceled()) {
                    return GRITSProcessStatus.CANCEL;
                }
                return GRITSProcessStatus.ERROR;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processScans", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected boolean processScan(Method method, int iInx) {
        if (this.isCanceled()) {
            return false;
        }
        Double dCutoffVal = method.getIntensityCutoff();
        String sCutoffType = method.getIntensityCutoffType();
        Double dPrecursorCutoffVal = method.getPrecursorIntensityCutoff();
        String sPrecursoCutoffType = method.getPrecursorIntensityCutoffType();
        this.iCurScanNum = this.scansToProcess.get(iInx);
        this.data.getScanFeatures().clear();
        this.data.getScans().clear();
        this.glycanIds.clear();
        this.data.getAnnotation().clear();
        this.data.getAnnotatedScan().clear();
        logger.debug((Object)("Processing scan #: " + this.iCurScanNum));
        this.data.setScans(this.getScans(this.msFile, this.iCurScanNum, dCutoffVal, sCutoffType, dPrecursorCutoffVal, sPrecursoCutoffType));
        return this.processAnalyteSettings();
    }

    protected boolean processAnalyteSettings() {
        try {
            String prevProgMsg = this.sCurProgressMsg;
            boolean bRes = false;
            for (int analyteSettingsInx = 0; analyteSettingsInx < this.method.getAnalyteSettings().size(); ++analyteSettingsInx) {
                if (this.isCanceled()) {
                    return false;
                }
                AnalyteSettings analyteSettings = (AnalyteSettings)this.method.getAnalyteSettings().get(analyteSettingsInx);
                List<GlycanStructure> glycanStructures = this.structures.get(analyteSettingsInx);
                this.initializeAdductsAndExchanges(analyteSettings);
                this.sCurProgressMsg = prevProgMsg + ", analyte settings " + (analyteSettingsInx + 1) + " of " + this.method.getAnalyteSettings().size();
                bRes |= this.processAnalyteSetting(analyteSettings, glycanStructures);
            }
            if (bRes) {
                return this.writeScanFeaturesToArchive();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
        }
        return false;
    }

    protected boolean writeScanFeaturesToArchive() {
        try {
            ++iAnnotationIDCount;
            this.populateScanFeatureData(this.m_tempFilePath);
            this.writer.generateScansAnnotationFiles(this.m_tempFilePath, this.data, this.getFinalArchiveName(), !this.needsOverview(), !this.needsOverview(), true, true);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    protected void initializeAdductsAndExchanges(AnalyteSettings _analayteSettings) {
        this.lPosModeSettingsToAnalyze = new ArrayList<List<IonSettings>>();
        this.lPosModeSettingsToAnalyzeCounts = new ArrayList<List<Integer>>();
        GlycanStructureAnnotation.determineIonSettingSets(true, this.method.getIons(), this.method.getMaxIonCount(), this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts);
        this.lNegModeSettingsToAnalyze = new ArrayList<List<IonSettings>>();
        this.lNegModeSettingsToAnalyzeCounts = new ArrayList<List<Integer>>();
        GlycanStructureAnnotation.determineIonSettingSets(false, this.method.getIons(), this.method.getMaxIonCount(), this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts);
        this.lExchangesoAnalyze = new ArrayList<List<IonSettings>>();
        this.lExchangesToAnalyzeCounts = new ArrayList<List<Integer>>();
        GlycanStructureAnnotation.determineIonSettingSets(null, this.method.getIonExchanges(), this.method.getMaxIonCount(), this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts);
        this.lNeutralLossesToAnalyze = new ArrayList<List<MoleculeSettings>>();
        this.lNeutralLossesToAnalyzeCounts = new ArrayList<List<Integer>>();
        GlycanStructureAnnotation.determineIonSettingSets(null, this.method.getNeutralLoss(), -1, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts);
    }

    protected boolean processAnalyteSetting(AnalyteSettings _analyteSettings, List<GlycanStructure> _structures) {
        try {
            boolean bRes = this.processStructures(_analyteSettings, _structures);
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAnalyteSettings", (Throwable)e);
            return false;
        }
    }

    protected boolean passesFilters(GlycanStructure structure, AnalyteSettings _analyteSettings) {
        try {
            Glycan glycan = GlycanStructureAnnotation.getGlycan(structure);
            if (_analyteSettings.getGlycanSettings().getFilterSetting() != null) {
                return GlycanFilterOperator.evaluate((Sugar)glycan.toSugar(), (Filter)_analyteSettings.getGlycanSettings().getFilterSetting().getFilter());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception evaluating filters.", (Throwable)e);
        }
        return true;
    }

    protected boolean processStructures(AnalyteSettings _analyteSettings, List<GlycanStructure> structures) {
        try {
            String prevProgMsg = this.sCurProgressMsg;
            boolean bRes = false;
            for (GlycanStructure structure : structures) {
                if (this.isCanceled()) {
                    return false;
                }
                this.sCurProgressMsg = prevProgMsg + ", structure: " + structure.getId();
                GelatoGlycan gelatoGlycan = hmGelatoGlycansByStructureId.get(structure.getId());
                if (gelatoGlycan == null || gelatoGlycan.getGlycanStructure() == null) {
                    throw new Exception("Unable to location glycan structure with id: " + structure.getId());
                }
                bRes |= this.processStructure(_analyteSettings, gelatoGlycan.getGlycanStructure());
                this.updateListeners(this.sCurProgressMsg, ++this.iCurProgressValue);
            }
            return bRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processStructure", (Throwable)e);
            return false;
        }
    }

    protected boolean processStructure(AnalyteSettings _analyteSettings, GlycanStructure structure) {
        try {
            GlycanAnnotation annotation = new GlycanAnnotation();
            annotation.setGlycanId(structure.getId());
            annotation.setSequenceGWB(structure.getGWBSequence().substring(0, structure.getGWBSequence().indexOf("$")));
            annotation.setSequence(structure.getSequence());
            annotation.setSequenceFormat(structure.getSequenceFormat());
            annotation.setPerDerivatisationType(_analyteSettings.getGlycanSettings().getPerDerivatisationType());
            annotation.setReducingEnd(_analyteSettings.getGlycanSettings().getReducingEnd());
            this.glycanScanAnnotations = new GlycanScansAnnotation();
            this.glycanScanAnnotations.setAnnotationId(Integer.valueOf(iAnnotationIDCount));
            this.glycanScanAnnotations.setGlycanId(structure.getId());
            this.glycanIds.add(structure.getId());
            annotation.setId(Integer.valueOf(iAnnotationIDCount++));
            int currentFeatureIndex = this.data.getFeatureIndex();
            Glycan glycan = GlycanStructureAnnotation.getGlycan(structure);
            GlycanStructureAnnotation.populateExtraInfo(annotation, glycan);
            GlycanStructureAnnotation.setGlycanMassOptions(glycan, this.method.getMonoisotopic(), _analyteSettings);
            boolean bRes = false;
            if (_analyteSettings.getGlycanSettings().getFilter().getUseDatabaseStructureMetaInfo().booleanValue()) {
                AnalyteSettings customAnalyteSettings = new AnalyteSettings();
                customAnalyteSettings.setPeptideSettings(_analyteSettings.getPeptideSettings());
                GlycanSettings gSettings = new GlycanSettings();
                gSettings.setAllowInnerFragments(_analyteSettings.getGlycanSettings().getAllowInnerFragments());
                gSettings.setFilter(_analyteSettings.getGlycanSettings().getFilter());
                gSettings.setGlycanFragments(_analyteSettings.getGlycanSettings().getGlycanFragments());
                gSettings.setMaxNumOfCleavages(_analyteSettings.getGlycanSettings().getMaxNumOfCleavages());
                gSettings.setMaxNumOfCrossRingCleavages(_analyteSettings.getGlycanSettings().getMaxNumOfCrossRingCleavages());
                gSettings.setPerActivation(_analyteSettings.getGlycanSettings().getPerActivation());
                gSettings.setPerMsLevel(_analyteSettings.getGlycanSettings().getPerMsLevel());
                gSettings.setPerDerivatisationType(GlycanStructureAnnotation.getGelatoPerDerivatisationType(glycan.getMassOptions().getDerivatization()));
                gSettings.setReducingEnd(GlycanStructureAnnotation.getGelatoReducingEnd(glycan.getMassOptions().getReducingEndTypeString()));
                customAnalyteSettings.setGlycanSettings(gSettings);
                bRes = this.processAllStructureOptions(this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts, this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts, this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts, customAnalyteSettings, structure, annotation, glycan);
            } else {
                bRes = this.processAllStructureOptions(this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts, this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts, this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts, _analyteSettings, structure, annotation, glycan);
            }
            if (bRes) {
                if (!this.glycanScanAnnotations.getScanAnnotations().keySet().isEmpty()) {
                    this.writer.writeAnnotationsPerGlycan(this.glycanScanAnnotations, this.m_tempFilePath);
                }
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processScans", (Throwable)e);
        }
        return false;
    }

    protected boolean processAllStructureOptions(List<List<IonSettings>> lPosModeSettingsToAnalyze, List<List<Integer>> lPosModeSettingsToAnalyzeCounts, List<List<IonSettings>> lNegModeSettingsToAnalyze, List<List<Integer>> lNegModeSettingsToAnalyzeCounts, List<List<IonSettings>> lExchangesToAnalyze, List<List<Integer>> lExchangesToAnalyzeCounts, List<List<MoleculeSettings>> lNeutralLossesToAnalyze, List<List<Integer>> lNeutralLossesToAnalyzeCounts, AnalyteSettings _analyteSettings, GlycanStructure structure, GlycanAnnotation annotation, Glycan glycan) {
        try {
            this.curGlycanMatcher = this.getNewGlycanMatcher();
            int iCnt = 0;
            boolean bRes = false;
            for (int polCnt = 0; polCnt < 2; ++polCnt) {
                List<List<Integer>> lSettingsToAnalyzeCounts;
                if (this.isCanceled()) {
                    return false;
                }
                boolean bPolarity = polCnt == 0;
                List<List<IonSettings>> lSettingsToAnalyze = bPolarity ? lPosModeSettingsToAnalyze : lNegModeSettingsToAnalyze;
                List<List<Integer>> list = lSettingsToAnalyzeCounts = bPolarity ? lPosModeSettingsToAnalyzeCounts : lNegModeSettingsToAnalyzeCounts;
                if (lSettingsToAnalyze == null || lSettingsToAnalyze.isEmpty()) continue;
                int iNumAdducts = lSettingsToAnalyze.size();
                int iNumExchanges = lExchangesToAnalyze != null ? lExchangesToAnalyze.size() : 0;
                int iNumLosses = lNeutralLossesToAnalyze != null ? lNeutralLossesToAnalyze.size() : 0;
                for (int i = 0; i < iNumAdducts; ++i) {
                    for (int j = -1; j < iNumExchanges; ++j) {
                        for (int k = -1; k < iNumLosses; ++k) {
                            List<IonSettings> lAdducts = null;
                            List<Integer> lAdductCounts = null;
                            if (lSettingsToAnalyze == null || lSettingsToAnalyze.isEmpty() || lSettingsToAnalyzeCounts == null || lSettingsToAnalyzeCounts.isEmpty()) continue;
                            lAdducts = lSettingsToAnalyze.get(i);
                            lAdductCounts = lSettingsToAnalyzeCounts.get(i);
                            if (lAdducts == null || lAdducts.isEmpty() || lAdductCounts == null || lAdductCounts.isEmpty()) continue;
                            List<IonSettings> lExchanges = null;
                            List<Integer> lExchangeCounts = null;
                            if (j > -1) {
                                lExchanges = lExchangesToAnalyze.get(j);
                                lExchangeCounts = lExchangesToAnalyzeCounts.get(j);
                            }
                            List<MoleculeSettings> lNeutralLosses = null;
                            List<Integer> lNeutralLossCounts = null;
                            if (k > -1) {
                                lNeutralLosses = lNeutralLossesToAnalyze.get(k);
                                lNeutralLossCounts = lNeutralLossesToAnalyzeCounts.get(k);
                            }
                            bRes |= this.curGlycanMatcher.matchGlycanStructure(bPolarity, this.data, this.iCurScanNum, this.glycanScanAnnotations, glycan, structure, null, annotation, lAdducts, lAdductCounts, lExchanges, lExchangeCounts, lNeutralLosses, lNeutralLossCounts, _analyteSettings, this.m_tempFilePath, this.writer);
                            ++iCnt;
                        }
                    }
                }
            }
            logger.debug((Object)("Number of options for structure: " + iCnt));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Error in processAdducts", (Throwable)e);
            return false;
        }
    }

    protected void populateScanFeatureData(String glycanFilesPath) {
        AnnotationReader reader = new AnnotationReader();
        GlycanScansAnnotation glycanAnnotation = new GlycanScansAnnotation();
        ScanFeatures scanFeatures = null;
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        for (Integer scanId : this.data.getAnnotatedScan().keySet()) {
            if (this.isCanceled()) {
                return;
            }
            for (String glycanId : (List)this.data.getAnnotatedScan().get(scanId)) {
                if (seen.containsKey(glycanId)) continue;
                glycanAnnotation = reader.readglycanAnnotation(glycanFilesPath, glycanId);
                if (glycanAnnotation != null) {
                    for (Integer scanId2 : glycanAnnotation.getScanAnnotations().keySet()) {
                        if (this.isCanceled()) {
                            return;
                        }
                        if (this.data.getScanFeatures().containsKey(scanId2)) {
                            scanFeatures = (ScanFeatures)this.data.getScanFeatures().get(scanId2);
                        } else {
                            scanFeatures = new ScanFeatures();
                            scanFeatures.setScanId(scanId2.intValue());
                            scanFeatures.setComplexRowId(Boolean.valueOf(true));
                            scanFeatures.setScanPeaks(new HashSet(((Scan)this.data.getScans().get(scanId2)).getPeaklist()));
                            this.data.getScanFeatures().put(scanId2, scanFeatures);
                        }
                        if (glycanAnnotation.getScanAnnotations().get(scanId2) == null) continue;
                        List lF = (List)glycanAnnotation.getScanAnnotations().get(scanId2);
                        for (GlycanFeature f : (List)glycanAnnotation.getScanAnnotations().get(scanId2)) {
                            if (scanFeatures.getFeatures().contains(f)) continue;
                            scanFeatures.getFeatures().add(f);
                        }
                    }
                }
                seen.put(glycanId, 1);
            }
        }
    }

    protected void addFeatureCustomExtraData() {
        this.dataHeader.getFeatureCustomExtraData().add(countingScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(intensityScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(rawCountingScoreData);
        this.dataHeader.getFeatureCustomExtraData().add(rawIntensityScoreData);
    }

    protected void addAnnotationCustomExtraData() {
        List<CustomExtraData> lCED = GlycanExtraInfo.getColumns();
        for (CustomExtraData ced : lCED) {
            this.dataHeader.getAnnotationCustomExtraData().add(ced);
        }
    }

    private String correctSequence(String _sStructureSequence) {
        Pattern p1 = Pattern.compile("(\\()(\\-1)(\\+)");
        Pattern p2 = Pattern.compile("(\\+)(\\-1)(\\))");
        Matcher m1 = p1.matcher(_sStructureSequence);
        if (m1.find()) {
            StringBuffer sb = new StringBuffer(_sStructureSequence.length());
            m1.reset();
            while (m1.find()) {
                String match1 = m1.group(1);
                String match2 = m1.group(2);
                String match3 = m1.group(3);
                match2 = match2.replace("-1", "1");
                String sNew = match1 + Matcher.quoteReplacement(match2) + match3;
                m1.appendReplacement(sb, sNew);
            }
            m1.appendTail(sb);
            return sb.toString().trim();
        }
        Matcher m2 = p2.matcher(_sStructureSequence);
        if (m2.find()) {
            StringBuffer sb = new StringBuffer(_sStructureSequence.length());
            m2.reset();
            while (m2.find()) {
                String match1 = m2.group(1);
                String match2 = m2.group(2);
                String match3 = m2.group(3);
                match2 = match2.replace("-1", "1");
                String sNew = match1 + Matcher.quoteReplacement(match2) + match3;
                m2.appendReplacement(sb, sNew);
            }
            m2.appendTail(sb);
            return sb.toString().trim();
        }
        return _sStructureSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateGlycanObjects() {
        int iProgress = 0;
        int iTotalStructures = 0;
        for (List<GlycanStructure> lStructures : this.structures) {
            iTotalStructures += lStructures.size();
        }
        this.setMaxValue(iTotalStructures);
        for (List<GlycanStructure> lStructures : this.structures) {
            for (GlycanStructure structure : lStructures) {
                try {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.updateListeners("Structure: " + structure.getId(), iProgress++);
                    Glycan glycan = null;
                    GelatoGlycan gelatoGlycan = null;
                    Sugar t_sugar = null;
                    if (hmGelatoGlycansByStructureId.containsKey(structure.getId())) continue;
                    gelatoGlycan = new GelatoGlycan();
                    if (structure.getGWBSequence() != null && !structure.getGWBSequence().equals("")) {
                        glycan = Glycan.fromString((String)structure.getGWBSequence());
                        if (structure.getSequenceFormat() == null || !structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                            structure.setSequence(glycan.toGlycoCTCondensed());
                        }
                    } else {
                        if (structure.getSequence() == null || structure.getSequence().equals("")) throw new Exception("Sequence not specfied for structure: " + structure.getId());
                        if (structure.getSequenceFormat() == null || structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYDEII)) {
                            t_sugar = GlycanExtraInfo.glydeToSugar(structure.getSequence());
                            String t_glycoCT = GlycanExtraInfo.sugarToGlycoCT(t_sugar);
                            glycan = Glycan.fromGlycoCTCondensed((String)t_glycoCT);
                            structure.setSequence(glycan.toGlycoCTCondensed());
                        } else if (structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                            glycan = Glycan.fromGlycoCTCondensed((String)structure.getSequence());
                        } else {
                            if (!structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_XML)) throw new Exception("Unsupported sequence type (" + structure.getSequenceFormat() + ") for structure: " + structure.getId());
                            glycan = Glycan.fromGlycoCT((String)structure.getSequence());
                            structure.setSequence(glycan.toGlycoCTCondensed());
                        }
                    }
                    String sCorrectedSeq = this.correctSequence(structure.getSequence());
                    while (!sCorrectedSeq.equals(structure.getSequence())) {
                        structure.setSequence(sCorrectedSeq);
                        sCorrectedSeq = this.correctSequence(sCorrectedSeq);
                    }
                    structure.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
                    if (glycan != null && structure.getGWBSequence() == null) {
                        structure.setGWBSequence(glycan.toString());
                    }
                    gelatoGlycan.setGlycan(glycan);
                    gelatoGlycan.setGlycanStructure(structure);
                    hmGelatoGlycansByStructureId.put(structure.getId(), gelatoGlycan);
                }
                catch (GlycoVisitorException e) {
                    logger.error((Object)e.getMessage());
                }
                catch (SugarImporterException e) {
                    logger.error((Object)e.getMessage());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        this.updateListeners("Done!", this.structures.size());
    }

    public void applyFilters() {
        ArrayList<List<GlycanStructure>> filteredStructures = new ArrayList<List<GlycanStructure>>();
        int iProgress = 0;
        int iTotalStructures = 0;
        for (List<GlycanStructure> lStructures : this.structures) {
            iTotalStructures += lStructures.size();
        }
        this.setMaxValue(iTotalStructures);
        int i = 0;
        for (AnalyteSettings settings : this.method.getAnalyteSettings()) {
            if (settings.getGlycanSettings().getFilterSetting() != null) {
                ArrayList<GlycanStructure> filtered = new ArrayList<GlycanStructure>();
                for (GlycanStructure structure : this.structures.get(i)) {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.updateListeners("Structure: " + structure.getId(), iProgress++);
                    if (!this.passesFilters(structure, settings)) continue;
                    filtered.add(structure);
                }
                filteredStructures.add(filtered);
            } else {
                filteredStructures.add(this.structures.get(i));
            }
            ++i;
        }
        this.updateListeners("Done!", this.structures.size());
        this.structures = filteredStructures;
    }

    public static double calculateMass(Glycan glycan) {
        return glycan.computeMass();
    }

    public static Glycan getGlycan(GlycanStructure structure) {
        try {
            if (!hmGelatoGlycansByStructureId.containsKey(structure.getId())) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            GelatoGlycan gelatoGlycan = hmGelatoGlycansByStructureId.get(structure.getId());
            if (gelatoGlycan == null || gelatoGlycan.getGlycan() == null) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            return gelatoGlycan.getGlycan();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void setGlycanMassOptions(Glycan _glycan, boolean _bIsMono, AnalyteSettings _analyteSettings) {
        try {
            if (!_analyteSettings.getGlycanSettings().getFilter().getUseDatabaseStructureMetaInfo().booleanValue()) {
                _glycan.setMassOptions(GlycanStructureAnnotation.collectMassOptions(_bIsMono, _analyteSettings));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void populateExtraInfo(GlycanAnnotation annotation, Glycan glycan) {
        try {
            String sKey = glycan.toString();
            if (!hmCachedExtraSettings.containsKey(sKey)) {
                glycan.setReducingEndType(ResidueType.createFreeReducingEnd());
                GlycanExtraInfo.populateGlycanExtraInformation(annotation, glycan.toSugar());
                hmCachedExtraSettings.put(sKey, annotation);
            } else {
                logger.debug((Object)("Cloning extra info for: " + sKey));
                GlycanAnnotation sourceAnnotation = hmCachedExtraSettings.get(sKey);
                GlycanExtraInfo.cloneGlycanExtraInformation(sourceAnnotation, annotation);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected AnalyteSettings getGlycanSpecificAnalyteSettings(Glycan glycan) {
        return null;
    }

    public static ReducingEnd getGelatoReducingEnd(String _gwbReducingEnd) {
        ReducingEnd re = new ReducingEnd();
        re.setLabel(_gwbReducingEnd);
        if (_gwbReducingEnd.contains("=")) {
            String[] sToks = _gwbReducingEnd.split("=");
            re.setLabel(sToks[0]);
            sToks[1] = sToks[1].replace("u", "");
            re.setMass(Double.valueOf(Double.parseDouble(sToks[1])));
        } else {
            ResidueType type = ResidueDictionary.findResidueType((String)_gwbReducingEnd);
            re.setLabel(type.getName());
            re.setMass(Double.valueOf(type.getMass()));
        }
        re.setType(_gwbReducingEnd);
        return re;
    }

    public static String getGelatoPerDerivatisationType(String _gwbDerivatisationType) {
        if (_gwbDerivatisationType.equals("perMe")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED;
        }
        if (_gwbDerivatisationType.equals("perMe(C^13)")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION;
        }
        if (_gwbDerivatisationType.equals("perDMe")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED;
        }
        if (_gwbDerivatisationType.equals("perAc")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED;
        }
        if (_gwbDerivatisationType.equals("perDAc")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED;
        }
        if (_gwbDerivatisationType.equals("Und")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_NO_DERIVATIZATION;
        }
        return GlycanPreDefinedOptions.DERIVITIZATION_NO_DERIVATIZATION;
    }

    public static MassOptions collectMassOptions(boolean _isMono, AnalyteSettings _analyteSettings) {
        MassOptions t_massOptions = new MassOptions();
        if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED)) {
            t_massOptions.setDerivatization("perMe");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION)) {
            t_massOptions.setDerivatization("perMe(C^13)");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED)) {
            t_massOptions.setDerivatization("perDMe");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED)) {
            t_massOptions.setDerivatization("perAc");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED)) {
            t_massOptions.setDerivatization("perDAc");
        } else {
            t_massOptions.setDerivatization("Und");
        }
        if (_isMono) {
            t_massOptions.setIsotope("MONO");
        } else {
            t_massOptions.setIsotope("AVG");
        }
        ResidueType gwbRT = GlycanStructureAnnotation.getResidueTypeForReducingEnd(_analyteSettings.getGlycanSettings().getReducingEnd());
        t_massOptions.setReducingEndType(gwbRT);
        return t_massOptions;
    }

    public static ResidueType getResidueTypeForReducingEnd(ReducingEnd _reducingEnd) {
        ResidueType gwbRT = null;
        if (_reducingEnd.getType().equals(GlycanPreDefinedOptions.OTHER)) {
            gwbRT = ResidueType.createOtherReducingEnd((String)_reducingEnd.getLabel(), (double)_reducingEnd.getMass());
        } else {
            gwbRT = ResidueDictionary.findResidueType((String)_reducingEnd.getType());
            if (gwbRT == null) {
                logger.warn((Object)("Unable to look-up reducing end \"" + _reducingEnd.getLabel() + "\""));
                _reducingEnd.setType(GlycanPreDefinedOptions.OTHER);
                return GlycanStructureAnnotation.getResidueTypeForReducingEnd(_reducingEnd);
            }
        }
        return gwbRT;
    }

    public static double getOtherReducingEnd(AnalyteSettings settings) {
        try {
            double changeValue = 0.0;
            if (settings.getGlycanSettings().getReducingEnd().getType().equals(GlycanPreDefinedOptions.OTHER)) {
                return changeValue += settings.getGlycanSettings().getReducingEnd().getMass().doubleValue();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return 0.0;
    }

    public static double getAdductMass(IonSettings adduct) {
        return adduct.getMass();
    }

    public static double getChargeFromAdducts(int count, IonSettings adduct) {
        return (double)adduct.getCharge().intValue() * (double)count;
    }

    public static double getIonExchange(IonSettings ionExchange, int count) {
        return ionExchange.getMass() * (double)count - (double)count;
    }

    public static double getNeutralLoss(MoleculeSettings nuetralLoss, int count) {
        return nuetralLoss.getMass() * (double)count;
    }

    public static double getGlycanStructureMz(double mass, double z, double dAdductMass) {
        if (z == 0.0) {
            z = 1.0;
        }
        return (mass + dAdductMass) / z;
    }

    public static double[] getGlycanMzAndCharge(Glycan glycan, AnalyteSettings _analyteSettings, List<IonSettings> lAdductsToAnalyze, List<Integer> lAdductsToAnalyzeCounts, List<IonSettings> lExchangesToAnalyze, List<Integer> lExchangesToAnalyzeCounts, List<MoleculeSettings> lNeutralLossesToAnalyze, List<Integer> lNeutralLossesToAnalyzeCounts) {
        double dMass = 0.0;
        try {
            dMass = glycan.computeMass();
        }
        catch (Exception e) {
            dMass = glycan.computeMass();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        double dSumExchanges = 0.0;
        if (lExchangesToAnalyze != null) {
            for (int i = 0; i < lExchangesToAnalyze.size(); ++i) {
                IonSettings ionExchange = lExchangesToAnalyze.get(i);
                int iCnt = lExchangesToAnalyzeCounts.get(i);
                double dMassChange = GlycanStructureAnnotation.getIonExchange(ionExchange, iCnt);
                dMass += dMassChange;
                dSumExchanges += (double)iCnt;
            }
        }
        double dSumLosses = 0.0;
        if (lNeutralLossesToAnalyze != null) {
            for (int i = 0; i < lNeutralLossesToAnalyze.size(); ++i) {
                MoleculeSettings neutralLoss = lNeutralLossesToAnalyze.get(i);
                int iCnt = lNeutralLossesToAnalyzeCounts.get(i);
                double dMassChange = GlycanStructureAnnotation.getNeutralLoss(neutralLoss, iCnt);
                dMass += dMassChange;
                dSumLosses += (double)iCnt;
            }
        }
        double dSumCharge = 0.0;
        double dSumMass = 0.0;
        for (int i = 0; i < lAdductsToAnalyze.size(); ++i) {
            IonSettings adduct = lAdductsToAnalyze.get(i);
            int iCnt = lAdductsToAnalyzeCounts.get(i);
            double z = GlycanStructureAnnotation.getChargeFromAdducts(iCnt, adduct);
            dSumCharge += z;
            dSumMass += (double)iCnt * adduct.getMass();
        }
        double dGlycanMz = GlycanStructureAnnotation.getGlycanStructureMz(dMass, dSumCharge, dSumMass);
        return new double[]{dGlycanMz, dSumCharge, dSumExchanges, dSumLosses};
    }

    protected HashMap<Integer, Scan> listToHashMap(List<Scan> scans, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        HashMap scanHash = null;
        String sFragType = sFragCutoffType != null ? sFragCutoffType : "Absolute Value";
        double dFragVal = sFragCutoffType != null ? dFragCutoff : 0.0;
        String sPreType = sPreCutoffType != null ? sPreCutoffType : "Absolute Value";
        double dPreVal = sPreCutoffType != null ? dPreCutoff : 0.0;
        scanHash = FileReaderUtils.listToFilteredHashMap(scans, (double)dFragVal, (String)sFragType, (double)dPreVal, (String)sPreType);
        return scanHash;
    }

    public MSFile getMsFile() {
        return this.msFile;
    }

    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
        if (bCancel && this.curGlycanMatcher != null) {
            this.curGlycanMatcher.setCanceled(true);
        }
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void updateListeners(String _sMsg, int _iVal) {
        NotifyingProcessUtil.updateListeners(this.getProgressListeners(), (String)_sMsg, (int)_iVal);
    }

    public void updateErrorListener(String _sMsg) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg);
    }

    public void updateErrorListener(String _sMsg, Throwable t) {
        NotifyingProcessUtil.updateErrorListener(this.getProgressListeners(), (String)_sMsg, (Throwable)t);
    }

    public void setMaxValue(int _iVal) {
        NotifyingProcessUtil.setMaxValue(this.getProgressListeners(), (int)_iVal);
    }

    public void addProgressListeners(IProgressListener lProgressListener) {
        this.myProgressListeners.add(lProgressListener);
    }

    public List<IProgressListener> getProgressListeners() {
        return this.myProgressListeners;
    }

    public void setProgressListeners(List<IProgressListener> lProgressListeners) {
        this.myProgressListeners = lProgressListeners;
    }

    public void setProgressType(IProgressListener.ProgressType progressType) {
        NotifyingProcessUtil.setProgressType(this.getProgressListeners(), (IProgressListener.ProgressType)progressType);
    }
}

