/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonWizardDescriptorManager {
    private static final CommonWizardDescriptorManager INSTANCE = new CommonWizardDescriptorManager();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTOR_IDS = new String[0];
    private static final CommonWizardDescriptor[] NO_DESCRIPTORS = new CommonWizardDescriptor[0];
    public static final String WIZARD_TYPE_NEW = "new";
    private Map<String, Set> commonWizardDescriptors = new HashMap<String, Set>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWizardDescriptorManager getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWizardDescriptorManager commonWizardDescriptorManager = INSTANCE;
        synchronized (commonWizardDescriptorManager) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    private void init() {
        new CommonWizardRegistry().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWizardDescriptor(CommonWizardDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        if (aDesc.getWizardId() == null) {
            NavigatorPlugin.logError(0, "A null wizardId was supplied for a commonWizard in " + aDesc.getNamespace(), null);
        }
        Map<String, Set> map = this.commonWizardDescriptors;
        synchronized (map) {
            HashSet<CommonWizardDescriptor> descriptors = this.commonWizardDescriptors.get(aDesc.getType());
            if (descriptors == null) {
                descriptors = new HashSet<CommonWizardDescriptor>();
                this.commonWizardDescriptors.put(aDesc.getType(), descriptors);
            }
            if (!descriptors.contains(aDesc)) {
                descriptors.add(aDesc);
            }
        }
    }

    public String[] getEnabledCommonWizardDescriptorIds(Object anElement, String aType, INavigatorContentService aContentService) {
        Set commonDescriptors = this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTOR_IDS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        for (CommonWizardDescriptor descriptor : commonDescriptors) {
            if (!this.isVisible(aContentService, descriptor) || !descriptor.isEnabledFor(anElement)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    public CommonWizardDescriptor[] getEnabledCommonWizardDescriptors(Object anElement, String aType, INavigatorContentService aContentService) {
        Set commonDescriptors = this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<CommonWizardDescriptor> descriptors = new ArrayList<CommonWizardDescriptor>();
        for (CommonWizardDescriptor descriptor : commonDescriptors) {
            if (!this.isVisible(aContentService, descriptor) || !descriptor.isEnabledFor(anElement)) continue;
            descriptors.add(descriptor);
        }
        CommonWizardDescriptor[] enabledDescriptors = new CommonWizardDescriptor[descriptors.size()];
        return descriptors.toArray(enabledDescriptors);
    }

    private boolean isVisible(INavigatorContentService aContentService, CommonWizardDescriptor descriptor) {
        return !WorkbenchActivityHelper.filterItem((Object)descriptor) && (aContentService == null || descriptor.getId() == null || aContentService.isVisible(descriptor.getId()) && aContentService.isActive(descriptor.getId()));
    }

    private class CommonWizardRegistry
    extends NavigatorContentRegistryReader {
        private CommonWizardRegistry() {
        }

        @Override
        protected boolean readElement(final IConfigurationElement anElement) {
            final boolean[] retValue = new boolean[1];
            if ("commonWizard".equals(anElement.getName())) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(anElement){

                    @Override
                    public void run() throws Exception {
                        CommonWizardDescriptorManager.this.addCommonWizardDescriptor(new CommonWizardDescriptor(anElement));
                        retValue[0] = true;
                    }
                });
                return retValue[0];
            }
            if ("navigatorContent".equals(anElement.getName())) {
                IConfigurationElement[] commonWizards = anElement.getChildren("commonWizard");
                final String contentExtensionId = anElement.getAttribute("id");
                retValue[0] = true;
                int i = 0;
                while (i < commonWizards.length) {
                    final IConfigurationElement element = commonWizards[i];
                    retValue[0] = false;
                    SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(element){

                        @Override
                        public void run() throws Exception {
                            CommonWizardDescriptorManager.this.addCommonWizardDescriptor(new CommonWizardDescriptor(element, contentExtensionId));
                            retValue[0] = true;
                        }
                    });
                    if (!retValue[0]) break;
                    ++i;
                }
                return retValue[0];
            }
            return super.readElement(anElement);
        }
    }
}

